/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.naming.IdentifierNameStringUtils;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentifierNameStringMarker {
    private final AppInfo appInfo;
    private final DexItemFactory dexItemFactory;
    private final Set<DexItem> identifierNameStrings;

    public IdentifierNameStringMarker(Enqueuer.AppInfoWithLiveness appInfo) {
        this.appInfo = appInfo;
        this.dexItemFactory = appInfo.dexItemFactory;
        this.identifierNameStrings = appInfo.identifierNameStrings;
    }

    public void decoupleIdentifierNameStringsInFields() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            clazz.forEachField(this::decoupleIdentifierNameStringInField);
        }
    }

    private void decoupleIdentifierNameStringInField(DexEncodedField encodedField) {
        if (!this.identifierNameStrings.contains(encodedField.field)) {
            return;
        }
        if (!encodedField.accessFlags.isStatic()) {
            return;
        }
        DexValue staticValue = encodedField.getStaticValue();
        if (!(staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = ((DexValue.DexValueString)staticValue).getValue();
        DexItemBasedString itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appInfo, original);
        if (itemBasedString != null) {
            encodedField.setStaticValue(new DexValue.DexValueString(itemBasedString));
        }
    }

    public void decoupleIdentifierNameStringsInMethod(DexEncodedMethod encodedMethod, IRCode code) {
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                InvokeMethod invoke;
                DexMethod invokedMethod;
                DexItemBasedString itemBasedString;
                Instruction instruction = (Instruction)iterator2.next();
                if (instruction.isStaticPut() || instruction.isInstancePut()) {
                    BasicBlock blockWithFieldInstruction;
                    DexString original;
                    Value in2;
                    FieldInstruction fieldPut = instruction.asFieldInstruction();
                    DexField field = fieldPut.getField();
                    if (!this.identifierNameStrings.contains(field) || !(in2 = instruction.isStaticPut() ? instruction.asStaticPut().inValue() : instruction.asInstancePut().value()).isConstString() || (itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appInfo, original = in2.getConstInstruction().asConstString().getValue())) == null) continue;
                    assert (iterator2.peekPrevious() == fieldPut);
                    iterator2.previous();
                    Value newIn = code.createValue(in2.outType(), in2.getLocalInfo());
                    ConstString decoupled = new ConstString(newIn, itemBasedString);
                    decoupled.setPosition(fieldPut.getPosition());
                    BasicBlock basicBlock = blockWithFieldInstruction = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                    if (blockWithFieldInstruction != block) {
                        iterator2 = block.listIterator(block.getInstructions().size());
                        iterator2.previous();
                        iterator2.add(decoupled);
                        iterator2 = blockWithFieldInstruction.listIterator();
                        assert (iterator2.peekNext() == fieldPut);
                        iterator2.next();
                        block = blockWithFieldInstruction;
                    } else {
                        iterator2.add(decoupled);
                        assert (iterator2.peekNext() == fieldPut);
                        iterator2.next();
                    }
                    if (instruction.isStaticPut()) {
                        StaticPut staticPut = instruction.asStaticPut();
                        iterator2.replaceCurrentInstruction(new StaticPut(staticPut.getType(), newIn, field));
                    } else {
                        assert (instruction.isInstancePut());
                        InstancePut instancePut = instruction.asInstancePut();
                        iterator2.replaceCurrentInstruction(new InstancePut(instancePut.getType(), field, instancePut.object(), newIn));
                    }
                    encodedMethod.markUseIdentifierNameString();
                    continue;
                }
                if (!instruction.isInvokeMethod() || !this.identifierNameStrings.contains(invokedMethod = (invoke = instruction.asInvokeMethod()).getInvokedMethod())) continue;
                List<Value> ins = invoke.arguments();
                Value[] changes = new Value[ins.size()];
                if (IdentifierNameStringUtils.isReflectionMethod(this.dexItemFactory, invokedMethod)) {
                    BasicBlock blockWithInvoke;
                    boolean isReferenceFieldUpdater;
                    itemBasedString = IdentifierNameStringUtils.identifyIdentiferNameString(this.appInfo, invoke);
                    if (itemBasedString == null) continue;
                    DexType returnType = invoke.getReturnType();
                    boolean isClassForName = returnType.descriptor == this.dexItemFactory.classDescriptor;
                    boolean bl = isReferenceFieldUpdater = returnType.descriptor == this.dexItemFactory.referenceFieldUpdaterDescriptor;
                    int positionOfIdentifier = isClassForName ? 0 : (isReferenceFieldUpdater ? 2 : 1);
                    Value in3 = invoke.arguments().get(positionOfIdentifier);
                    assert (iterator2.peekPrevious() == invoke);
                    iterator2.previous();
                    Value newIn = code.createValue(in3.outType(), in3.getLocalInfo());
                    ConstString decoupled = new ConstString(newIn, itemBasedString);
                    decoupled.setPosition(invoke.getPosition());
                    changes[positionOfIdentifier] = newIn;
                    BasicBlock basicBlock = blockWithInvoke = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                    if (blockWithInvoke != block) {
                        iterator2 = block.listIterator(block.getInstructions().size());
                        iterator2.previous();
                        iterator2.add(decoupled);
                        iterator2 = blockWithInvoke.listIterator();
                        assert (iterator2.peekNext() == invoke);
                        iterator2.next();
                        block = blockWithInvoke;
                    } else {
                        iterator2.add(decoupled);
                        assert (iterator2.peekNext() == invoke);
                        iterator2.next();
                    }
                } else {
                    for (int i = 0; i < ins.size(); ++i) {
                        BasicBlock blockWithInvoke;
                        DexString original;
                        DexItemBasedString itemBasedString2;
                        Value in4 = ins.get(i);
                        if (!in4.isConstString() || (itemBasedString2 = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appInfo, original = in4.getConstInstruction().asConstString().getValue())) == null) continue;
                        assert (iterator2.peekPrevious() == invoke);
                        iterator2.previous();
                        Value newIn = code.createValue(in4.outType(), in4.getLocalInfo());
                        ConstString decoupled = new ConstString(newIn, itemBasedString2);
                        decoupled.setPosition(invoke.getPosition());
                        changes[i] = newIn;
                        BasicBlock basicBlock = blockWithInvoke = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                        if (blockWithInvoke != block) {
                            iterator2 = block.listIterator(block.getInstructions().size());
                            iterator2.previous();
                            iterator2.add(decoupled);
                            iterator2 = blockWithInvoke.listIterator();
                            assert (iterator2.peekNext() == invoke);
                            iterator2.next();
                            block = blockWithInvoke;
                            continue;
                        }
                        iterator2.add(decoupled);
                        assert (iterator2.peekNext() == invoke);
                        iterator2.next();
                    }
                }
                if (Arrays.stream(changes).allMatch(Objects::isNull)) continue;
                List<Value> newIns = Streams.mapWithIndex(ins.stream(), (in, index) -> changes[(int)index] != null ? changes[(int)index] : in).collect(Collectors.toList());
                iterator2.replaceCurrentInstruction(Invoke.create(invoke.getType(), invokedMethod, invokedMethod.proto, invoke.outValue(), newIns));
                encodedMethod.markUseIdentifierNameString();
            }
        }
    }
}

