/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.optimize.MemberRebindingLense;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MemberRebindingAnalysis {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense lense;
    private final MemberRebindingLense.Builder builder;

    public MemberRebindingAnalysis(Enqueuer.AppInfoWithLiveness appInfo, GraphLense lense) {
        assert (lense.isContextFreeForMethods());
        this.appInfo = appInfo;
        this.lense = lense;
        this.builder = MemberRebindingLense.builder(appInfo);
    }

    private DexMethod validTargetFor(DexMethod target, DexMethod original) {
        DexClass clazz = this.appInfo.definitionFor(target.getHolder());
        assert (clazz != null);
        if (!clazz.isLibraryClass()) {
            return target;
        }
        DexType newHolder = clazz.isInterface() ? this.firstLibraryClassForInterfaceTarget(target, original.getHolder(), DexClass::lookupMethod) : this.firstLibraryClass(target.getHolder(), original.getHolder());
        return this.appInfo.dexItemFactory.createMethod(newHolder, original.proto, original.name);
    }

    private DexField validTargetFor(DexField target, DexField original, BiFunction<DexClass, DexField, DexEncodedField> lookup) {
        DexClass clazz = this.appInfo.definitionFor(target.getHolder());
        assert (clazz != null);
        if (!clazz.isLibraryClass()) {
            return target;
        }
        DexType newHolder = clazz.isInterface() ? this.firstLibraryClassForInterfaceTarget(target, original.getHolder(), lookup) : this.firstLibraryClass(target.getHolder(), original.getHolder());
        return this.appInfo.dexItemFactory.createField(newHolder, original.type, original.name);
    }

    private <T> DexType firstLibraryClassForInterfaceTarget(T target, DexType current, BiFunction<DexClass, T, ?> lookup) {
        DexType matchingSuper;
        DexClass clazz = this.appInfo.definitionFor(current);
        Object potential = lookup.apply(clazz, (DexClass)target);
        if (potential != null) {
            return current;
        }
        if (clazz.superType != null && (matchingSuper = this.firstLibraryClassForInterfaceTarget(target, clazz.superType, lookup)) != null) {
            return clazz.isLibraryClass() ? current : matchingSuper;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexType matchingIface = this.firstLibraryClassForInterfaceTarget(target, iface, lookup);
            if (matchingIface == null) continue;
            return clazz.isLibraryClass() ? current : matchingIface;
        }
        return null;
    }

    private DexType firstLibraryClass(DexType top, DexType bottom) {
        assert (this.appInfo.definitionFor(top).isLibraryClass());
        DexClass searchClass = this.appInfo.definitionFor(bottom);
        while (!searchClass.isLibraryClass()) {
            searchClass = this.appInfo.definitionFor(searchClass.superType);
        }
        return searchClass.type;
    }

    private DexEncodedMethod classLookup(DexMethod method) {
        return this.appInfo.resolveMethodOnClass(method.getHolder(), method).asResultOfResolve();
    }

    private DexEncodedMethod interfaceLookup(DexMethod method) {
        return this.appInfo.resolveMethodOnInterface(method.getHolder(), method).asResultOfResolve();
    }

    private DexEncodedMethod anyLookup(DexMethod method) {
        return this.appInfo.resolveMethod(method.getHolder(), method).asResultOfResolve();
    }

    private void computeMethodRebinding(Set<DexMethod> methods, Function<DexMethod, DexEncodedMethod> lookupTarget) {
        for (DexMethod method : methods) {
            DexEncodedMethod target;
            DexClass originalClass;
            if (!(method = this.lense.lookupMethod(method)).getHolder().isClassType() || (originalClass = this.appInfo.definitionFor(method.holder)) == null || originalClass.isLibraryClass() || (target = lookupTarget.apply(method)) == null || target.method == method) continue;
            DexClass targetClass = this.appInfo.definitionFor(target.method.holder);
            if (!targetClass.accessFlags.isPublic() && target.accessFlags.isPublic()) {
                String packageDescriptor;
                String string = packageDescriptor = originalClass.accessFlags.isPublic() ? null : method.holder.getPackageDescriptor();
                if (packageDescriptor == null || !packageDescriptor.equals(targetClass.type.getPackageDescriptor())) {
                    DexProgramClass bridgeHolder = this.findBridgeMethodHolder(originalClass, targetClass, packageDescriptor);
                    assert (bridgeHolder != null);
                    DexEncodedMethod bridgeMethod = target.toForwardingMethod(bridgeHolder, this.appInfo.dexItemFactory);
                    bridgeHolder.addMethod(bridgeMethod);
                    assert (lookupTarget.apply(method) == bridgeMethod);
                    target = bridgeMethod;
                }
            }
            this.builder.map(method, this.validTargetFor(target.method, method));
        }
    }

    private DexProgramClass findBridgeMethodHolder(DexClass originalClass, DexClass targetClass, String packageDescriptor) {
        if (originalClass == targetClass || originalClass.isLibraryClass()) {
            return null;
        }
        DexProgramClass newHolder = null;
        if (originalClass.superType.isSubtypeOf(targetClass.type, this.appInfo)) {
            DexClass superClass = this.appInfo.definitionFor(originalClass.superType);
            newHolder = this.findBridgeMethodHolder(superClass, targetClass, packageDescriptor);
        } else {
            for (DexType iface : originalClass.interfaces.values) {
                if (!iface.isSubtypeOf(targetClass.type, this.appInfo)) continue;
                DexClass interfaceClass = this.appInfo.definitionFor(iface);
                newHolder = this.findBridgeMethodHolder(interfaceClass, targetClass, packageDescriptor);
            }
        }
        if (newHolder != null) {
            return newHolder;
        }
        if (originalClass.accessFlags.isPublic() || originalClass.type.getPackageDescriptor().equals(packageDescriptor)) {
            return originalClass.asProgramClass();
        }
        return null;
    }

    private void computeFieldRebinding(Map<DexField, Set<DexEncodedMethod>> fields, BiFunction<DexType, DexField, DexEncodedField> lookup, BiFunction<DexClass, DexField, DexEncodedField> lookupTargetOnClass) {
        for (Map.Entry<DexField, Set<DexEncodedMethod>> entry : fields.entrySet()) {
            DexField field = entry.getKey();
            field = this.lense.lookupField(field);
            DexEncodedField target = lookup.apply(field.getHolder(), field);
            Set<DexEncodedMethod> contexts = entry.getValue();
            if (target == null || target.field == field || !contexts.stream().allMatch(context -> this.isVisibleFromOriginalContext(context.method.getHolder(), target))) continue;
            this.builder.map(field, this.validTargetFor(target.field, field, lookupTargetOnClass));
        }
    }

    private boolean isVisibleFromOriginalContext(DexType context, DexEncodedField field) {
        DexType holderType = field.field.getHolder();
        DexClass holder = this.appInfo.definitionFor(holderType);
        if (holder == null) {
            return false;
        }
        Inliner.Constraint classVisibility = Inliner.Constraint.deriveConstraint(context, holderType, holder.accessFlags, this.appInfo);
        if (classVisibility == Inliner.Constraint.NEVER) {
            return false;
        }
        Inliner.Constraint fieldVisibility = Inliner.Constraint.deriveConstraint(context, holderType, field.accessFlags, this.appInfo);
        return fieldVisibility != Inliner.Constraint.NEVER;
    }

    private Map<DexField, Set<DexEncodedMethod>> mergeFieldAccessContexts(Map<DexField, Set<DexEncodedMethod>> reads, Map<DexField, Set<DexEncodedMethod>> writes) {
        IdentityHashMap result = new IdentityHashMap();
        Sets.SetView<DexField> fields = Sets.union(reads.keySet(), writes.keySet());
        for (DexField field : fields) {
            Set contexts = Sets.newIdentityHashSet();
            contexts.addAll(reads.getOrDefault(field, ImmutableSet.of()));
            contexts.addAll(writes.getOrDefault(field, ImmutableSet.of()));
            result.put(field, contexts);
        }
        return Collections.unmodifiableMap(result);
    }

    public GraphLense run() {
        this.computeMethodRebinding(this.appInfo.virtualInvokes, this::classLookup);
        this.computeMethodRebinding(this.appInfo.interfaceInvokes, this::interfaceLookup);
        this.computeMethodRebinding(this.appInfo.superInvokes, this::anyLookup);
        this.computeMethodRebinding(this.appInfo.directInvokes, this::anyLookup);
        this.computeMethodRebinding(this.appInfo.staticInvokes, this::anyLookup);
        this.computeFieldRebinding(this.mergeFieldAccessContexts(this.appInfo.staticFieldReads, this.appInfo.staticFieldWrites), this.appInfo::resolveFieldOn, DexClass::lookupField);
        this.computeFieldRebinding(this.mergeFieldAccessContexts(this.appInfo.instanceFieldReads, this.appInfo.instanceFieldWrites), this.appInfo::resolveFieldOn, DexClass::lookupField);
        return this.builder.build(this.lense);
    }
}

