/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.R8CommandParser;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.origin.StandardOutOrigin;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceBytes;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

@Keep
public final class R8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = R8CommandParser.USAGE_MESSAGE;
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final StringConsumer mainDexListConsumer;
    private final ProguardConfiguration proguardConfiguration;
    private final boolean enableTreeShaking;
    private final boolean enableMinification;
    private final boolean forceProguardCompatibility;
    private final StringConsumer proguardMapConsumer;
    private final Path proguardCompatibilityRulesOutput;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args, Origin origin) {
        return R8CommandParser.parse(args, origin);
    }

    public static Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return R8CommandParser.parse(args, origin, handler);
    }

    private R8Command(AndroidApp inputApp, ProgramConsumer programConsumer2, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, StringConsumer mainDexListConsumer, ProguardConfiguration proguardConfiguration, CompilationMode mode, int minApiLevel, Reporter reporter, boolean enableDesugaring, boolean enableTreeShaking, boolean enableMinification, boolean forceProguardCompatibility, StringConsumer proguardMapConsumer, Path proguardCompatibilityRulesOutput, boolean optimizeMultidexForLinearAlloc) {
        super(inputApp, mode, programConsumer2, minApiLevel, reporter, enableDesugaring, optimizeMultidexForLinearAlloc);
        assert (proguardConfiguration != null);
        assert (mainDexKeepRules != null);
        this.mainDexKeepRules = mainDexKeepRules;
        this.mainDexListConsumer = mainDexListConsumer;
        this.proguardConfiguration = proguardConfiguration;
        this.enableTreeShaking = enableTreeShaking;
        this.enableMinification = enableMinification;
        this.forceProguardCompatibility = forceProguardCompatibility;
        this.proguardMapConsumer = proguardMapConsumer;
        this.proguardCompatibilityRulesOutput = proguardCompatibilityRulesOutput;
    }

    private R8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.mainDexKeepRules = ImmutableList.of();
        this.mainDexListConsumer = null;
        this.proguardConfiguration = null;
        this.enableTreeShaking = false;
        this.enableMinification = false;
        this.forceProguardCompatibility = false;
        this.proguardMapConsumer = null;
        this.proguardCompatibilityRulesOutput = null;
    }

    public boolean getEnableTreeShaking() {
        return this.enableTreeShaking;
    }

    public boolean getEnableMinification() {
        return this.enableMinification;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.proguardConfiguration, this.getReporter());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG || this.forceProguardCompatibility && !this.proguardConfiguration.isObfuscating();
        internal.programConsumer = this.getProgramConsumer();
        internal.minApiLevel = this.getMinApiLevel();
        internal.enableDesugaring = this.getEnableDesugaring();
        assert (internal.enableMinification);
        internal.enableMinification = this.getEnableMinification();
        assert (internal.enableTreeShaking);
        internal.enableTreeShaking = this.getEnableTreeShaking();
        internal.enableLambdaMerging = this.getEnableTreeShaking();
        assert (!internal.ignoreMissingClasses);
        boolean bl = internal.ignoreMissingClasses = this.proguardConfiguration.isIgnoreWarnings() || this.forceProguardCompatibility && !this.proguardConfiguration.isOptimizing() && !internal.enableMinification && !internal.enableTreeShaking;
        assert (!internal.verbose);
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.minimalMainDex = internal.debug;
        internal.mainDexListConsumer = this.mainDexListConsumer;
        InternalOptions.LineNumberOptimization lineNumberOptimization = internal.lineNumberOptimization = internal.debug || this.forceProguardCompatibility && !this.proguardConfiguration.isOptimizing() ? InternalOptions.LineNumberOptimization.OFF : InternalOptions.LineNumberOptimization.ON;
        if (internal.debug) {
            internal.enableInlining = false;
            internal.enableClassInlining = false;
            internal.enableClassStaticizer = false;
            internal.outline.enabled = false;
        }
        if (this.proguardConfiguration.isPrintConfiguration()) {
            StringConsumer stringConsumer = internal.configurationConsumer = this.proguardConfiguration.getPrintConfigurationFile() != null ? new StringConsumer.FileConsumer(this.proguardConfiguration.getPrintConfigurationFile()) : new StringConsumer.StreamConsumer(StandardOutOrigin.instance(), System.out);
        }
        if (this.proguardConfiguration.isPrintUsage()) {
            StringConsumer stringConsumer = internal.usageInformationConsumer = this.proguardConfiguration.getPrintUsageFile() != null ? new StringConsumer.FileConsumer(this.proguardConfiguration.getPrintUsageFile()) : new StringConsumer.StreamConsumer(StandardOutOrigin.instance(), System.out);
        }
        if (this.proguardConfiguration.isPrintSeeds()) {
            StringConsumer stringConsumer = internal.proguardSeedsConsumer = this.proguardConfiguration.getSeedFile() != null ? new StringConsumer.FileConsumer(this.proguardConfiguration.getSeedFile()) : new StringConsumer.StreamConsumer(StandardOutOrigin.instance(), System.out);
        }
        StringConsumer wrappedConsumer = this.proguardConfiguration.isPrintMapping() ? (this.proguardConfiguration.getPrintMappingFile() != null ? new StringConsumer.FileConsumer(this.proguardConfiguration.getPrintMappingFile(), this.proguardMapConsumer) : new StringConsumer.StreamConsumer(StandardOutOrigin.instance(), System.out, this.proguardMapConsumer)) : this.proguardMapConsumer;
        internal.proguardMapConsumer = wrappedConsumer;
        internal.proguardCompatibilityRulesOutput = this.proguardCompatibilityRulesOutput;
        internal.dataResourceConsumer = internal.programConsumer.getDataResourceConsumer();
        assert (internal.disableAssertions);
        if (internal.isGeneratingClassFiles()) {
            internal.disableAssertions = false;
        }
        assert (!internal.forceProguardCompatibility);
        internal.forceProguardCompatibility = this.forceProguardCompatibility;
        internal.enableInheritanceClassInDexDistributor = this.isOptimizeMultidexForLinearAlloc();
        return internal;
    }

    private static class EnsureNonDexProgramResourceProvider
    implements ProgramResourceProvider {
        final ProgramResourceProvider provider;

        public EnsureNonDexProgramResourceProvider(ProgramResourceProvider provider2) {
            this.provider = provider2;
        }

        @Override
        public Collection<ProgramResource> getProgramResources() throws ResourceException {
            Collection<ProgramResource> resources = this.provider.getProgramResources();
            for (ProgramResource resource : resources) {
                if (resource.getKind() != ProgramResource.Kind.DEX) continue;
                throw new ResourceException(resource.getOrigin(), "R8 does not support compiling DEX inputs");
            }
            return resources;
        }

        @Override
        public DataResourceProvider getDataResourceProvider() {
            return this.provider.getDataResourceProvider();
        }
    }

    @Keep
    public static class Builder
    extends BaseCompilerCommand.Builder<R8Command, Builder> {
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();
        private Consumer<ProguardConfiguration.Builder> proguardConfigurationConsumer = null;
        private final List<ProguardConfigurationSource> proguardConfigs = new ArrayList<ProguardConfigurationSource>();
        private boolean disableTreeShaking = false;
        private boolean disableMinification = false;
        private boolean forceProguardCompatibility = false;
        private StringConsumer proguardMapConsumer = null;
        Path proguardCompatibilityRulesOutput = null;
        private boolean allowPartiallyImplementedProguardOptions = false;
        private boolean allowTestProguardOptions = false;
        private StringConsumer mainDexListConsumer = null;

        Builder() {
        }

        Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        private Builder(AndroidApp app) {
            super(app);
        }

        void internalForceProguardCompatibility() {
            this.forceProguardCompatibility = true;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        CompilationMode defaultCompilationMode() {
            return CompilationMode.RELEASE;
        }

        public Builder setDisableTreeShaking(boolean disableTreeShaking) {
            this.disableTreeShaking = disableTreeShaking;
            return this.self();
        }

        public Builder setDisableMinification(boolean disableMinification) {
            this.disableMinification = disableMinification;
            return this.self();
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRulesFiles(Collection<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines, Origin origin) {
            this.guard(() -> this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Builder setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListConsumer = new StringConsumer.FileConsumer(mainDexListOutputPath);
            return this.self();
        }

        public Builder setMainDexListConsumer(StringConsumer mainDexListConsumer) {
            this.mainDexListConsumer = mainDexListConsumer;
            return this.self();
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addProguardConfiguration(List<String> lines, Origin origin) {
            this.guard(() -> this.proguardConfigs.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Builder setProguardMapOutputPath(Path proguardMapOutput) {
            assert (proguardMapOutput != null);
            this.proguardMapConsumer = new StringConsumer.FileConsumer(proguardMapOutput);
            return this.self();
        }

        public Builder setProguardMapConsumer(StringConsumer proguardMapConsumer) {
            this.proguardMapConsumer = proguardMapConsumer;
            return this.self();
        }

        @Override
        public Builder addProgramResourceProvider(ProgramResourceProvider programProvider) {
            return (Builder)super.addProgramResourceProvider(new EnsureNonDexProgramResourceProvider(programProvider));
        }

        @Override
        protected InternalProgramOutputPathConsumer createProgramOutputConsumer(Path path, OutputMode mode, boolean consumeDataResources) {
            return super.createProgramOutputConsumer(path, mode, false);
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                reporter.error("R8 does not support compiling to a single DEX file per Java class file");
            }
            if (this.mainDexListConsumer != null && this.mainDexRules.isEmpty() && !this.getAppBuilder().hasMainDexList()) {
                reporter.error("Option --main-dex-list-output require --main-dex-rules and/or --main-dex-list");
            }
            for (Path file : this.programFiles) {
                if (!FileUtils.isDexFile(file)) continue;
                reporter.error(new StringDiagnostic("R8 does not support compiling DEX inputs", new PathOrigin(file)));
            }
            if (this.getProgramConsumer() instanceof ClassFileConsumer && this.isMinApiLevelSet()) {
                reporter.error("R8 does not support --min-api when compiling to class files");
            }
            super.validate();
        }

        @Override
        R8Command makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new R8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            return this.makeR8Command();
        }

        private R8Command makeR8Command() {
            ProguardConfigurationParser parser;
            ImmutableList<Object> mainDexKeepRules;
            final Reporter reporter = this.getReporter();
            DexItemFactory factory = new DexItemFactory();
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                parser = new ProguardConfigurationParser(factory, reporter);
                parser.parse(this.mainDexRules);
                mainDexKeepRules = parser.getConfig().getRules();
            }
            parser = new ProguardConfigurationParser(factory, reporter, !this.allowPartiallyImplementedProguardOptions, this.allowTestProguardOptions);
            if (!this.proguardConfigs.isEmpty()) {
                parser.parse(this.proguardConfigs);
            }
            ProguardConfiguration.Builder configurationBuilder = parser.getConfigurationBuilder();
            configurationBuilder.setForceProguardCompatibility(this.forceProguardCompatibility);
            if (this.proguardConfigurationConsumer != null) {
                this.proguardConfigurationConsumer.accept(configurationBuilder);
            }
            DataResourceProvider.Visitor embeddedProguardConfigurationVisitor = new DataResourceProvider.Visitor(){

                @Override
                public void visit(DataDirectoryResource directory) {
                }

                @Override
                public void visit(DataEntryResource resource) {
                    if (resource.getName().startsWith("META-INF/proguard/")) {
                        try (InputStream in = resource.getByteStream();){
                            ProguardConfigurationSourceBytes source = new ProguardConfigurationSourceBytes(in, resource.getOrigin());
                            parser.parse(source);
                        }
                        catch (ResourceException e) {
                            reporter.error(new StringDiagnostic("Failed to open input: " + e.getMessage(), resource.getOrigin()));
                        }
                        catch (Exception e) {
                            reporter.error(new ExceptionDiagnostic(e, resource.getOrigin()));
                        }
                    }
                }
            };
            this.getAppBuilder().getProgramResourceProviders().stream().map(ProgramResourceProvider::getDataResourceProvider).filter(Objects::nonNull).forEach(dataResourceProvider -> {
                try {
                    dataResourceProvider.accept(embeddedProguardConfigurationVisitor);
                }
                catch (ResourceException e) {
                    reporter.error(new ExceptionDiagnostic(e));
                }
            });
            if (this.disableTreeShaking) {
                configurationBuilder.disableShrinking();
            }
            if (this.disableMinification) {
                configurationBuilder.disableObfuscation();
            }
            ProguardConfiguration configuration = configurationBuilder.build();
            this.getAppBuilder().addFilteredProgramArchives(configuration.getInjars()).addFilteredLibraryArchives(configuration.getLibraryjars());
            assert (this.getProgramConsumer() != null);
            boolean desugaring = this.getProgramConsumer() instanceof ClassFileConsumer ? false : !this.getDisableDesugaring();
            R8Command command = new R8Command(this.getAppBuilder().build(), this.getProgramConsumer(), mainDexKeepRules, this.mainDexListConsumer, configuration, this.getMode(), this.getMinApiLevel(), reporter, desugaring, configuration.isShrinking(), configuration.isObfuscating(), this.forceProguardCompatibility, this.proguardMapConsumer, this.proguardCompatibilityRulesOutput, this.isOptimizeMultidexForLinearAlloc());
            return command;
        }

        void addProguardConfigurationConsumerForTesting(Consumer<ProguardConfiguration.Builder> c) {
            Consumer<ProguardConfiguration.Builder> oldConsumer = this.proguardConfigurationConsumer;
            this.proguardConfigurationConsumer = builder -> {
                if (oldConsumer != null) {
                    oldConsumer.accept((ProguardConfiguration.Builder)builder);
                }
                c.accept((ProguardConfiguration.Builder)builder);
            };
        }

        void allowPartiallyImplementedProguardOptions() {
            this.allowPartiallyImplementedProguardOptions = true;
        }

        void allowTestProguardOptions() {
            this.allowTestProguardOptions = true;
        }
    }
}

