/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.utils.OrderedMergingIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class DexAnnotationDirectory
extends DexItem {
    private final DexProgramClass clazz;
    private final List<DexEncodedMethod> methodAnnotations;
    private final List<DexEncodedMethod> parameterAnnotations;
    private final List<DexEncodedField> fieldAnnotations;
    private final boolean classHasOnlyInternalizableAnnotations;

    public DexAnnotationDirectory(DexProgramClass clazz) {
        this.clazz = clazz;
        this.classHasOnlyInternalizableAnnotations = clazz.hasOnlyInternalizableAnnotations();
        assert (DexAnnotationDirectory.isSorted(clazz.directMethods()));
        assert (DexAnnotationDirectory.isSorted(clazz.virtualMethods()));
        OrderedMergingIterator methods = new OrderedMergingIterator((KeyedDexItem[])clazz.directMethods(), (KeyedDexItem[])clazz.virtualMethods());
        this.methodAnnotations = new ArrayList<DexEncodedMethod>();
        this.parameterAnnotations = new ArrayList<DexEncodedMethod>();
        while (methods.hasNext()) {
            DexEncodedMethod method = (DexEncodedMethod)methods.next();
            if (!method.annotations.isEmpty()) {
                this.methodAnnotations.add(method);
            }
            if (method.parameterAnnotationsList.isEmpty()) continue;
            this.parameterAnnotations.add(method);
        }
        assert (DexAnnotationDirectory.isSorted(clazz.staticFields()));
        assert (DexAnnotationDirectory.isSorted(clazz.instanceFields()));
        OrderedMergingIterator fields = new OrderedMergingIterator((KeyedDexItem[])clazz.staticFields(), (KeyedDexItem[])clazz.instanceFields());
        this.fieldAnnotations = new ArrayList<DexEncodedField>();
        while (fields.hasNext()) {
            DexEncodedField field = (DexEncodedField)fields.next();
            if (field.annotations.isEmpty()) continue;
            this.fieldAnnotations.add(field);
        }
    }

    public DexAnnotationSet getClazzAnnotations() {
        return this.clazz.annotations;
    }

    public List<DexEncodedMethod> getMethodAnnotations() {
        return this.methodAnnotations;
    }

    public List<DexEncodedMethod> getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public List<DexEncodedField> getFieldAnnotations() {
        return this.fieldAnnotations;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof DexAnnotationDirectory)) {
            return false;
        }
        if (this.classHasOnlyInternalizableAnnotations) {
            DexAnnotationDirectory other = (DexAnnotationDirectory)obj;
            if (!other.clazz.hasOnlyInternalizableAnnotations()) {
                return false;
            }
            return this.clazz.annotations.equals(other.clazz.annotations);
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        if (this.classHasOnlyInternalizableAnnotations) {
            return this.clazz.annotations.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection collection, DexMethod method, int instructionOffset) {
        throw new Unreachable();
    }

    @Override
    public void collectMixedSectionItems(MixedSectionCollection collection) {
        throw new Unreachable();
    }

    private static <T extends PresortedComparable<T>> boolean isSorted(KeyedDexItem<T>[] items) {
        return DexAnnotationDirectory.isSorted(items, KeyedDexItem::getKey);
    }

    private static <S, T extends Comparable<T>> boolean isSorted(S[] items, Function<S, T> getter) {
        Comparable current = null;
        for (S item : items) {
            Comparable next = (Comparable)getter.apply(item);
            if (current != null && current.compareTo(next) >= 0) {
                return false;
            }
            current = next;
        }
        return true;
    }
}

