/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.optimize.PublicizerLense;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public final class ClassAndMemberPublicizer {
    private final DexApplication application;
    private final AppView appView;
    private final RootSetBuilder.RootSet rootSet;
    private final PublicizerLense.PublicizedLenseBuilder lenseBuilder;
    private final Equivalence<DexMethod> equivalence = MethodSignatureEquivalence.get();
    private final MethodPoolCollection methodPoolCollection;

    private ClassAndMemberPublicizer(DexApplication application, AppView appView, RootSetBuilder.RootSet rootSet) {
        this.application = application;
        this.appView = appView;
        this.methodPoolCollection = new MethodPoolCollection(application);
        this.rootSet = rootSet;
        this.lenseBuilder = PublicizerLense.createBuilder();
    }

    public static GraphLense run(ExecutorService executorService, Timing timing, DexApplication application, AppView appView, RootSetBuilder.RootSet rootSet) throws ExecutionException {
        return new ClassAndMemberPublicizer(application, appView, rootSet).run(executorService, timing);
    }

    private GraphLense run(ExecutorService executorService, Timing timing) throws ExecutionException {
        this.methodPoolCollection.buildAll(executorService, timing);
        timing.begin("Phase 2: promoteToPublic");
        DexType.forAllInterfaces(this.appView.getDexItemFactory(), this::publicizeType);
        this.publicizeType(this.appView.getDexItemFactory().objectType);
        timing.end();
        return this.lenseBuilder.build(this.appView);
    }

    private void publicizeType(DexType type) {
        DexClass clazz = this.application.definitionFor(type);
        if (clazz != null && clazz.isProgramClass()) {
            clazz.accessFlags.promoteToPublic();
            clazz.forEachField(field -> field.accessFlags.promoteToPublic());
            LinkedHashSet<DexEncodedMethod> privateInstanceEncodedMethods = new LinkedHashSet<DexEncodedMethod>();
            clazz.forEachMethod(encodedMethod -> {
                if (this.publicizeMethod(clazz, (DexEncodedMethod)encodedMethod)) {
                    privateInstanceEncodedMethods.add((DexEncodedMethod)encodedMethod);
                }
            });
            if (!privateInstanceEncodedMethods.isEmpty()) {
                clazz.virtualizeMethods(privateInstanceEncodedMethods);
            }
        }
        type.forAllExtendsSubtypes(this::publicizeType);
    }

    private boolean publicizeMethod(DexClass holder, DexEncodedMethod encodedMethod) {
        MethodAccessFlags accessFlags = encodedMethod.accessFlags;
        if (accessFlags.isPublic()) {
            return false;
        }
        if (this.appView.getDexItemFactory().isClassConstructor(encodedMethod.method)) {
            return false;
        }
        if (!accessFlags.isPrivate()) {
            accessFlags.unsetProtected();
            accessFlags.setPublic();
            return false;
        }
        assert (accessFlags.isPrivate());
        if (this.appView.getDexItemFactory().isConstructor(encodedMethod.method)) {
            accessFlags.unsetPrivate();
            accessFlags.setPublic();
            return false;
        }
        if (!accessFlags.isStatic()) {
            if (this.rootSet.noShrinking.containsKey(encodedMethod)) {
                return false;
            }
            if (holder.isInterface() || accessFlags.isSynthetic()) {
                return false;
            }
            boolean wasSeen = this.methodPoolCollection.markIfNotSeen(holder, encodedMethod.method);
            if (wasSeen) {
                if (this.rootSet.noObfuscation.contains(encodedMethod)) {
                    return false;
                }
                return false;
            }
            this.lenseBuilder.add(encodedMethod.method);
            accessFlags.unsetPrivate();
            accessFlags.setFinal();
            accessFlags.setPublic();
            encodedMethod.method.setSingleVirtualMethodCache(encodedMethod.method.getHolder(), encodedMethod);
            encodedMethod.markPublicized();
            return true;
        }
        accessFlags.unsetPrivate();
        accessFlags.setPublic();
        return false;
    }
}

