/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.JarSourceCode;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.jar.InliningConstraintVisitor;
import com.android.tools.r8.jar.JarRegisterEffectsVisitor;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.android.tools.r8.org.objectweb.asm.tree.AbstractInsnNode;
import com.android.tools.r8.org.objectweb.asm.tree.LabelNode;
import com.android.tools.r8.org.objectweb.asm.tree.LineNumberNode;
import com.android.tools.r8.org.objectweb.asm.tree.MethodNode;
import com.android.tools.r8.org.objectweb.asm.tree.TryCatchBlockNode;
import com.android.tools.r8.org.objectweb.asm.util.Textifier;
import com.android.tools.r8.org.objectweb.asm.util.TraceMethodVisitor;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ListIterator;

public class JarCode
extends Code {
    private final DexMethod method;
    private final Origin origin;
    private MethodNode node;
    private JarClassFileReader.ReparseContext context;
    private final JarApplicationReader application;

    public void writeTo(MethodVisitor visitor) {
        this.node.accept(visitor);
    }

    public JarCode(DexMethod method, Origin origin, JarClassFileReader.ReparseContext context, JarApplicationReader application) {
        this.method = method;
        this.origin = origin;
        this.context = context;
        this.application = application;
        context.codeList.add(this);
    }

    public MethodNode getNode() {
        this.triggerDelayedParsingIfNeccessary();
        return this.node;
    }

    @Override
    public boolean isJarCode() {
        return true;
    }

    @Override
    public JarCode asJarCode() {
        return this;
    }

    @Override
    protected int computeHashCode() {
        this.triggerDelayedParsingIfNeccessary();
        return this.node.hashCode();
    }

    @Override
    protected boolean computeEquals(Object other) {
        this.triggerDelayedParsingIfNeccessary();
        if (this == other) {
            return true;
        }
        if (other instanceof JarCode) {
            JarCode o = (JarCode)other;
            o.triggerDelayedParsingIfNeccessary();
            return this.node.equals(o.node);
        }
        return false;
    }

    @Override
    public boolean isEmptyVoidMethod() {
        ListIterator<AbstractInsnNode> it = this.getNode().instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (insn.getType() == 177 || insn instanceof LabelNode || insn instanceof LineNumberNode) continue;
            return false;
        }
        return true;
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, Origin origin) {
        assert (this.getOwner() == encodedMethod);
        this.triggerDelayedParsingIfNeccessary();
        return options.debug ? this.internalBuildWithLocals(encodedMethod, appInfo, graphLense, options, null, null) : this.internalBuild(encodedMethod, appInfo, graphLense, options, null, null);
    }

    @Override
    public IRCode buildInliningIR(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator generator, Position callerPosition, Origin origin) {
        assert (this.getOwner() == encodedMethod);
        assert (generator != null);
        this.triggerDelayedParsingIfNeccessary();
        return options.debug ? this.internalBuildWithLocals(encodedMethod, appInfo, graphLense, options, generator, callerPosition) : this.internalBuild(encodedMethod, appInfo, graphLense, options, generator, callerPosition);
    }

    private IRCode internalBuildWithLocals(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) {
        try {
            return this.internalBuild(encodedMethod, appInfo, graphLense, options, generator, callerPosition);
        }
        catch (InvalidDebugInfoException e) {
            options.warningInvalidDebugInfo(encodedMethod, this.origin, e);
            this.node.localVariables.clear();
            return this.internalBuild(encodedMethod, appInfo, graphLense, options, generator, callerPosition);
        }
    }

    private IRCode internalBuild(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) {
        if (!options.debug) {
            this.node.localVariables.clear();
        }
        JarSourceCode source = new JarSourceCode(this.method.getHolder(), this.node, this.application, graphLense.getOriginalMethodSignature(encodedMethod.method), callerPosition);
        return new IRBuilder(encodedMethod, appInfo, source, options, generator).build();
    }

    @Override
    public void registerCodeReferences(UseRegistry registry) {
        this.triggerDelayedParsingIfNeccessary();
        this.node.instructions.accept(new JarRegisterEffectsVisitor(this.method.getHolder(), registry, this.application));
        this.node.tryCatchBlocks.forEach(tryCatchBlockNode -> registry.registerTypeReference(this.application.getTypeFromDescriptor(DescriptorUtils.getDescriptorFromClassBinaryName(tryCatchBlockNode.type))));
    }

    public Inliner.ConstraintWithTarget computeInliningConstraint(DexEncodedMethod encodedMethod, Enqueuer.AppInfoWithLiveness appInfo, GraphLense graphLense, DexType invocationContext) {
        InliningConstraintVisitor visitor = new InliningConstraintVisitor(this.application, appInfo, graphLense, encodedMethod, invocationContext);
        for (AbstractInsnNode insn = this.node.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            insn.accept(visitor);
            if (!visitor.isFinished()) continue;
            return visitor.getConstraint();
        }
        for (TryCatchBlockNode block : this.node.tryCatchBlocks) {
            visitor.accept(block);
            if (!visitor.isFinished()) continue;
            return visitor.getConstraint();
        }
        return visitor.getConstraint();
    }

    @Override
    public String toString() {
        this.triggerDelayedParsingIfNeccessary();
        TraceMethodVisitor visitor = new TraceMethodVisitor(new Textifier());
        this.node.accept(visitor);
        StringWriter writer = new StringWriter();
        visitor.p.print(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return this.toString();
    }

    private void triggerDelayedParsingIfNeccessary() {
        if (this.context != null) {
            JarClassFileReader.ReparseContext context = this.context;
            this.parseCode(context, false);
            if (this.hasJsr(context)) {
                System.out.println("JarCode: JSR encountered; reparse using JSRInlinerAdapter");
                this.parseCode(context, true);
                assert (!this.hasJsr(context));
            }
            assert (JarCode.verifyNoReparseContext(context.owner));
        }
    }

    private void parseCode(JarClassFileReader.ReparseContext context, boolean useJsrInliner) {
        SecondVisitor classVisitor = new SecondVisitor(context, this.application, useJsrInliner);
        new ClassReader(context.classCache).accept(classVisitor, 4);
    }

    private boolean hasJsr(JarClassFileReader.ReparseContext context) {
        for (Code code : context.codeList) {
            if (!this.hasJsr(code.asJarCode().node)) continue;
            return true;
        }
        return false;
    }

    private boolean hasJsr(MethodNode node) {
        ListIterator<AbstractInsnNode> it = node.instructions.iterator();
        while (it.hasNext()) {
            int opcode = ((AbstractInsnNode)it.next()).getOpcode();
            if (opcode != 168 && opcode != 169) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyNoReparseContext(DexProgramClass owner) {
        Code code;
        for (DexEncodedMethod method : owner.virtualMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        for (DexEncodedMethod method : owner.directMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        return true;
    }

    private static class SecondVisitor
    extends ClassVisitor {
        private final JarClassFileReader.ReparseContext context;
        private final JarApplicationReader application;
        private final boolean useJsrInliner;
        private int methodIndex = 0;

        public SecondVisitor(JarClassFileReader.ReparseContext context, JarApplicationReader application, boolean useJsrInliner) {
            super(393216);
            this.context = context;
            this.application = application;
            this.useJsrInliner = useJsrInliner;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodNode node = this.useJsrInliner ? new JSRInlinerAdapter(null, access, name, desc, signature, exceptions) : new MethodNode(393216, access, name, desc, signature, exceptions);
            JarCode code = null;
            MethodAccessFlags flags = JarClassFileReader.createMethodAccessFlags(name, access);
            if (!flags.isAbstract() && !flags.isNative()) {
                code = this.context.codeList.get(this.methodIndex++).asJarCode();
                assert (code.method == this.application.getMethod(this.context.owner.type, name, desc));
            }
            if (code != null) {
                code.context = null;
                code.node = node;
                return node;
            }
            return null;
        }
    }
}

