/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class DirectoryBuilder
implements OutputBuilder {
    private final Path root;
    private final Origin origin;

    public DirectoryBuilder(Path root) {
        this.root = root;
        this.origin = new PathOrigin(root);
    }

    @Override
    public void open() {
    }

    @Override
    public void close(DiagnosticsHandler handler) {
    }

    @Override
    public void addDirectory(String name, DiagnosticsHandler handler) {
        Path target = this.root.resolve(name.replace('/', File.separatorChar));
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            handler.error(new ExceptionDiagnostic(e, new PathOrigin(target)));
        }
    }

    @Override
    public void addFile(String name, DataEntryResource content, DiagnosticsHandler handler) {
        try (InputStream in = content.getByteStream();){
            this.addFile(name, ByteDataView.of(ByteStreams.toByteArray(in)), handler);
        }
        catch (IOException e) {
            handler.error(new ExceptionDiagnostic(e, content.getOrigin()));
        }
        catch (ResourceException e) {
            handler.error(new StringDiagnostic("Failed to open input: " + e.getMessage(), content.getOrigin()));
        }
    }

    @Override
    public synchronized void addFile(String name, ByteDataView content, DiagnosticsHandler handler) {
        Path target = this.root.resolve(name.replace('/', File.separatorChar));
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            FileUtils.writeToFile(target, null, content);
        }
        catch (IOException e) {
            handler.error(new ExceptionDiagnostic(e, new PathOrigin(target)));
        }
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Path getPath() {
        return this.root;
    }
}

