/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AndroidAppConsumers;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class JarSizeCompare {
    private static final String USAGE = "Arguments:\n    [--threshold <threshold>]\n    [--lib <lib.jar>]\n    --input <name1> <input1.jar> [<map1.txt>]\n    --input <name2> <input2.jar> [<map2.txt>] ...\n\nJarSizeCompare outputs the class, method, field sizes of the given JAR files.\nFor each input, a ProGuard map can be passed that is used to resolve minified names.\n";
    private static final ImmutableMap<String, String> R8_RELOCATIONS = ImmutableMap.builder().put("com.android.tools.r8.com.google.common", "com.android.tools.r8.com.google.common").put("com.android.tools.r8.com.google.gson", "com.android.tools.r8.com.google.gson").put("com.android.tools.r8.com.google.thirdparty", "com.android.tools.r8.com.google.thirdparty").put("com.android.tools.r8.joptsimple", "com.android.tools.r8.joptsimple").put("com.android.tools.r8.org.apache.commons", "com.android.tools.r8.org.apache.commons").put("com.android.tools.r8.org.objectweb.asm", "com.android.tools.r8.org.objectweb.asm").put("com.android.tools.r8.it.unimi.dsi.fastutil", "com.android.tools.r8.it.unimi.dsi.fastutil").build();
    private final List<Path> libraries;
    private final List<InputParameter> inputParameters;
    private final int threshold;
    private final InternalOptions options;
    private int pgIndex;
    private int r8Index;

    private JarSizeCompare(List<Path> libraries, List<InputParameter> inputParameters, int threshold) {
        this.libraries = libraries;
        this.inputParameters = inputParameters;
        this.threshold = threshold;
        this.options = new InternalOptions();
        this.options.enableCfFrontend = true;
    }

    public void run() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<InputApplication> inputApplicationList = new ArrayList<InputApplication>();
        Timing timing = new Timing("JarSizeCompare");
        for (InputParameter inputParameter : this.inputParameters) {
            AndroidApp inputApp = inputParameter.getInputApp(this.libraries);
            DexApplication input = inputParameter.getReader(this.options, inputApp, timing);
            AndroidAppConsumers appConsumer = new AndroidAppConsumers();
            D8.run((D8Command)((D8Command.Builder)((D8Command.Builder)D8Command.builder(inputApp).setMinApiLevel(AndroidApiLevel.P.getLevel())).setProgramConsumer(appConsumer.wrapDexIndexedConsumer(null))).build());
            DexApplication d8Input = inputParameter.getReader(this.options, appConsumer.build(), timing);
            InputApplication inputApplication = new InputApplication(input, this.translateClassNames(input, input.classes()));
            InputApplication d8Classes = new InputApplication(input, this.translateClassNames(input, d8Input.classes()));
            names.add(inputParameter.name + "-input");
            inputApplicationList.add(inputApplication);
            names.add(inputParameter.name + "-d8");
            inputApplicationList.add(d8Classes);
        }
        if (this.threshold != 0) {
            this.pgIndex = names.indexOf("pg-d8");
            this.r8Index = names.indexOf("r8-d8");
        }
        HashMap<String, InputClass[]> inputClasses = new HashMap<String, InputClass[]>();
        for (int i = 0; i < names.size(); ++i) {
            InputApplication classes = (InputApplication)inputApplicationList.get(i);
            for (String className : classes.getClasses()) {
                inputClasses.computeIfAbsent((String)className, (Function<String, InputClass[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$run$0(java.util.List java.lang.String ), (Ljava/lang/String;)[Lcom/android/tools/r8/JarSizeCompare$InputClass;)(names))[i] = classes.getInputClass(className);
            }
        }
        for (Map.Entry<String, Map<String, InputClass[]>> library : this.byLibrary(inputClasses)) {
            System.out.println("");
            System.out.println(Strings.repeat("=", 100));
            String commonPrefix = this.getCommonPrefix(library.getValue().keySet());
            if (library.getKey().isEmpty()) {
                System.out.println("PROGRAM (" + commonPrefix + ")");
            } else {
                System.out.println("LIBRARY: " + library.getKey() + " (" + commonPrefix + ")");
            }
            this.printLibrary(library.getValue(), commonPrefix);
        }
    }

    private Map<String, DexProgramClass> translateClassNames(DexApplication input, List<DexProgramClass> classes) {
        HashMap<String, DexProgramClass> result = new HashMap<String, DexProgramClass>();
        ClassNameMapper classNameMapper = input.getProguardMap();
        for (DexProgramClass programClass : classes) {
            ClassNamingForNameMapper classNaming = classNameMapper == null ? null : classNameMapper.getClassNaming(programClass.type);
            String type = classNaming == null ? programClass.type.toSourceString() : classNaming.originalName;
            result.put(type, programClass);
        }
        return result;
    }

    private String getCommonPrefix(Set<String> classes) {
        if (classes.size() <= 1) {
            return "";
        }
        String commonPrefix = null;
        for (String clazz : classes) {
            int i;
            if (clazz.equals("r8.GeneratedOutlineSupport")) continue;
            if (commonPrefix == null) {
                commonPrefix = clazz;
                continue;
            }
            for (i = 0; i < clazz.length() && i < commonPrefix.length() && clazz.charAt(i) == commonPrefix.charAt(i); ++i) {
            }
            commonPrefix = commonPrefix.substring(0, i);
        }
        return commonPrefix;
    }

    private void printLibrary(Map<String, InputClass[]> classMap, String commonPrefix) {
        ArrayList<Map.Entry<String, InputClass[]>> classes = new ArrayList<Map.Entry<String, InputClass[]>>(classMap.entrySet());
        classes.sort(Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : classes) {
            this.printClass(((String)entry.getKey()).substring(commonPrefix.length()), new ClassCompare((InputClass[])entry.getValue()));
        }
    }

    private void printClass(String name, ClassCompare inputClasses) {
        List<MemberNaming.MethodSignature> methods = this.getMethods(inputClasses);
        List<MemberNaming.FieldSignature> fields = this.getFields(inputClasses);
        if (methods.isEmpty() && fields.isEmpty()) {
            return;
        }
        System.out.println(name);
        for (MemberNaming.MethodSignature methodSignature : methods) {
            this.printSignature(this.getMethodString(methodSignature), inputClasses.sizes(methodSignature));
        }
        for (MemberNaming.FieldSignature fieldSignature : fields) {
            this.printSignature(this.getFieldString(fieldSignature), inputClasses.sizes(fieldSignature));
        }
    }

    private String getMethodString(MemberNaming.MethodSignature sig) {
        StringBuilder builder = new StringBuilder().append('(');
        for (int i = 0; i < sig.parameters.length; ++i) {
            builder.append(DescriptorUtils.javaTypeToShorty(sig.parameters[i]));
        }
        builder.append(')').append(DescriptorUtils.javaTypeToShorty(sig.type)).append(' ');
        return builder.append(sig.name).toString();
    }

    private String getFieldString(MemberNaming.FieldSignature sig) {
        return DescriptorUtils.javaTypeToShorty(sig.type) + ' ' + sig.name;
    }

    private void printSignature(String key, int[] sizes) {
        System.out.print(this.padItem(key));
        for (int size : sizes) {
            System.out.print(this.padValue(size));
        }
        System.out.print('\n');
    }

    private List<MemberNaming.MethodSignature> getMethods(ClassCompare inputClasses) {
        ArrayList<MemberNaming.MethodSignature> methods = new ArrayList<MemberNaming.MethodSignature>();
        for (MemberNaming.MethodSignature methodSignature : inputClasses.getMethods()) {
            if (this.threshold != 0 && !this.methodExceedsThreshold(inputClasses, methodSignature)) continue;
            methods.add(methodSignature);
        }
        return methods;
    }

    private boolean methodExceedsThreshold(ClassCompare inputClasses, MemberNaming.MethodSignature methodSignature) {
        assert (this.threshold > 0);
        assert (this.pgIndex != this.r8Index);
        int pgSize = inputClasses.size(methodSignature, this.pgIndex);
        int r8Size = inputClasses.size(methodSignature, this.r8Index);
        return pgSize != -1 && r8Size != -1 && pgSize + this.threshold <= r8Size;
    }

    private List<MemberNaming.FieldSignature> getFields(ClassCompare inputClasses) {
        return this.threshold == 0 ? inputClasses.getFields() : Collections.emptyList();
    }

    private String padItem(String s) {
        return String.format("%-52s", s);
    }

    private String padValue(int v) {
        return String.format("%8s", v == -1 ? "---" : Integer.valueOf(v));
    }

    private List<Map.Entry<String, Map<String, InputClass[]>>> byLibrary(Map<String, InputClass[]> inputClasses) {
        HashMap<String, Map> byLibrary = new HashMap<String, Map>();
        for (Map.Entry<String, InputClass[]> entry : inputClasses.entrySet()) {
            Map library = byLibrary.computeIfAbsent(this.getLibraryName(entry.getKey()), k -> new HashMap());
            library.put(entry.getKey(), entry.getValue());
        }
        ArrayList<Map.Entry<String, Map<String, InputClass[]>>> list = new ArrayList<Map.Entry<String, Map<String, InputClass[]>>>(byLibrary.entrySet());
        list.sort(Comparator.comparing(Map.Entry::getKey));
        return list;
    }

    private String getLibraryName(String className) {
        for (Map.Entry relocation : R8_RELOCATIONS.entrySet()) {
            if (!className.startsWith((String)relocation.getValue())) continue;
            return (String)relocation.getKey();
        }
        return "";
    }

    public static void main(String[] args) throws Exception {
        JarSizeCompare program = JarSizeCompare.parse(args);
        if (program == null) {
            System.out.println(USAGE);
        } else {
            program.run();
        }
    }

    public static JarSizeCompare parse(String[] args) {
        int i = 0;
        int threshold = 0;
        ArrayList<Path> libraries = new ArrayList<Path>();
        ArrayList<InputParameter> inputs = new ArrayList<InputParameter>();
        HashSet<String> names = new HashSet<String>();
        while (i < args.length) {
            if (args[i].equals("--threshold") && i + 1 < args.length) {
                threshold = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equals("--lib") && i + 1 < args.length) {
                libraries.add(Paths.get(args[i + 1], new String[0]));
                i += 2;
                continue;
            }
            if (args[i].equals("--input") && i + 2 < args.length) {
                String name = args[i + 1];
                Path jar = Paths.get(args[i + 2], new String[0]);
                Path map2 = null;
                if (i + 3 < args.length && !args[i + 3].startsWith("-")) {
                    map2 = Paths.get(args[i + 3], new String[0]);
                    i += 4;
                } else {
                    i += 3;
                }
                inputs.add(new InputParameter(name, jar, map2));
                if (names.add(name)) continue;
                System.out.println("Duplicate name: " + name);
                return null;
            }
            return null;
        }
        if (inputs.size() < 2) {
            return null;
        }
        if (!(threshold == 0 || names.contains("r8") && names.contains("pg"))) {
            System.out.println("You must either specify names \"pg\" and \"r8\" for input files or use \"--threshold 0\".");
            return null;
        }
        return new JarSizeCompare(libraries, inputs, threshold);
    }

    private static /* synthetic */ InputClass[] lambda$run$0(List names, String k) {
        return new InputClass[names.size()];
    }

    private static class ClassCompare {
        final Map<MemberNaming.MethodSignature, DexEncodedMethod[]> methods = new HashMap<MemberNaming.MethodSignature, DexEncodedMethod[]>();
        final Map<MemberNaming.FieldSignature, DexEncodedField[]> fields = new HashMap<MemberNaming.FieldSignature, DexEncodedField[]>();
        final int classes;

        ClassCompare(InputClass[] inputs) {
            for (int i = 0; i < inputs.length; ++i) {
                InputClass inputClass = inputs[i];
                int finalI = i;
                if (inputClass == null) continue;
                inputClass.forEachMethod((sig, m) -> {
                    this.methods.computeIfAbsent((MemberNaming.MethodSignature)sig, (Function<MemberNaming.MethodSignature, DexEncodedMethod[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$0(com.android.tools.r8.JarSizeCompare$InputClass[] com.android.tools.r8.naming.MemberNaming$MethodSignature ), (Lcom/android/tools/r8/naming/MemberNaming$MethodSignature;)[Lcom/android/tools/r8/graph/DexEncodedMethod;)((InputClass[])inputs))[finalI] = m;
                });
                inputClass.forEachField((sig, f) -> {
                    this.fields.computeIfAbsent((MemberNaming.FieldSignature)sig, (Function<MemberNaming.FieldSignature, DexEncodedField[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$2(com.android.tools.r8.JarSizeCompare$InputClass[] com.android.tools.r8.naming.MemberNaming$FieldSignature ), (Lcom/android/tools/r8/naming/MemberNaming$FieldSignature;)[Lcom/android/tools/r8/graph/DexEncodedField;)((InputClass[])inputs))[finalI] = f;
                });
            }
            this.classes = inputs.length;
        }

        List<MemberNaming.MethodSignature> getMethods() {
            ArrayList<MemberNaming.MethodSignature> methods = new ArrayList<MemberNaming.MethodSignature>(this.methods.keySet());
            methods.sort(Comparator.comparing(MemberNaming.MethodSignature::toString));
            return methods;
        }

        List<MemberNaming.FieldSignature> getFields() {
            ArrayList<MemberNaming.FieldSignature> fields = new ArrayList<MemberNaming.FieldSignature>(this.fields.keySet());
            fields.sort(Comparator.comparing(MemberNaming.FieldSignature::toString));
            return fields;
        }

        int size(MemberNaming.MethodSignature method, int classIndex) {
            DexEncodedMethod dexEncodedMethod = this.methods.get(method)[classIndex];
            if (dexEncodedMethod == null) {
                return -1;
            }
            Code code = dexEncodedMethod.getCode();
            if (code == null) {
                return 0;
            }
            if (code.isCfCode()) {
                return code.asCfCode().getInstructions().size();
            }
            if (code.isDexCode()) {
                return code.asDexCode().instructions.length;
            }
            throw new Unreachable();
        }

        int[] sizes(MemberNaming.MethodSignature method) {
            int[] result = new int[this.classes];
            for (int i = 0; i < this.classes; ++i) {
                result[i] = this.size(method, i);
            }
            return result;
        }

        int size(MemberNaming.FieldSignature field, int classIndex) {
            return this.fields.get(field)[classIndex] == null ? -1 : 1;
        }

        int[] sizes(MemberNaming.FieldSignature field) {
            int[] result = new int[this.classes];
            for (int i = 0; i < this.classes; ++i) {
                result[i] = this.size(field, i);
            }
            return result;
        }

        private static /* synthetic */ DexEncodedField[] lambda$new$2(InputClass[] inputs, MemberNaming.FieldSignature o) {
            return new DexEncodedField[inputs.length];
        }

        private static /* synthetic */ DexEncodedMethod[] lambda$new$0(InputClass[] inputs, MemberNaming.MethodSignature o) {
            return new DexEncodedMethod[inputs.length];
        }
    }

    static class InputClass {
        private final DexProgramClass programClass;
        private final ClassNameMapper proguardMap;

        InputClass(DexClass dexClass, ClassNameMapper proguardMap) {
            this.programClass = dexClass == null ? null : dexClass.asProgramClass();
            this.proguardMap = proguardMap;
        }

        void forEachMethod(BiConsumer<MemberNaming.MethodSignature, DexEncodedMethod> consumer) {
            if (this.programClass == null) {
                return;
            }
            this.programClass.forEachMethod((DexEncodedMethod dexEncodedMethod) -> {
                MemberNaming.MethodSignature originalSignature = this.proguardMap == null ? null : (MemberNaming.MethodSignature)this.proguardMap.originalSignatureOf(dexEncodedMethod.method);
                MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(dexEncodedMethod.method);
                consumer.accept(originalSignature == null ? signature : originalSignature, (DexEncodedMethod)dexEncodedMethod);
            });
        }

        void forEachField(BiConsumer<MemberNaming.FieldSignature, DexEncodedField> consumer) {
            if (this.programClass == null) {
                return;
            }
            this.programClass.forEachField((DexEncodedField dexEncodedField) -> {
                MemberNaming.FieldSignature originalSignature = this.proguardMap == null ? null : this.proguardMap.originalSignatureOf(dexEncodedField.field);
                MemberNaming.FieldSignature signature = MemberNaming.FieldSignature.fromDexField(dexEncodedField.field);
                consumer.accept(originalSignature == null ? signature : originalSignature, (DexEncodedField)dexEncodedField);
            });
        }
    }

    static class InputApplication {
        private final DexApplication dexApplication;
        private final Map<String, DexProgramClass> classMap;

        private InputApplication(DexApplication dexApplication, Map<String, DexProgramClass> classMap) {
            this.dexApplication = dexApplication;
            this.classMap = classMap;
        }

        public Set<String> getClasses() {
            return this.classMap.keySet();
        }

        private InputClass getInputClass(String type) {
            DexProgramClass inputClass = this.classMap.get(type);
            ClassNameMapper proguardMap = this.dexApplication.getProguardMap();
            return new InputClass(inputClass, proguardMap);
        }
    }

    static class InputParameter {
        private final String name;
        private final Path jar;
        private final Path map;

        InputParameter(String name, Path jar, Path map2) {
            this.name = name;
            this.jar = jar;
            this.map = map2;
        }

        DexApplication getReader(InternalOptions options, AndroidApp inputApp, Timing timing) throws Exception {
            ApplicationReader applicationReader = new ApplicationReader(inputApp, options, timing);
            return applicationReader.read(this.map == null ? null : StringResource.fromFile(this.map)).toDirect();
        }

        AndroidApp getInputApp(List<Path> libraries) throws Exception {
            return AndroidApp.builder().addLibraryFiles(libraries).addProgramFiles(this.jar).build();
        }
    }
}

