/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardKeepAttributes;
import com.android.tools.r8.utils.InternalOptions;

public class AnnotationRemover {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final ProguardKeepAttributes keep;
    private final InternalOptions options;
    private final ProguardConfiguration.Builder compatibility;

    public AnnotationRemover(Enqueuer.AppInfoWithLiveness appInfo, ProguardConfiguration.Builder compatibility, InternalOptions options) {
        this.appInfo = appInfo;
        this.keep = options.proguardConfiguration.getKeepAttributes();
        this.compatibility = compatibility;
        this.options = options;
    }

    private boolean filterAnnotations(DexAnnotation annotation) {
        switch (annotation.visibility) {
            case 2: {
                DexItemFactory factory = this.appInfo.dexItemFactory;
                assert (!DexAnnotation.isInnerClassAnnotation(annotation, factory));
                assert (!DexAnnotation.isMemberClassesAnnotation(annotation, factory));
                assert (!DexAnnotation.isEnclosingMethodAnnotation(annotation, factory));
                assert (!DexAnnotation.isEnclosingClassAnnotation(annotation, factory));
                if (this.keep.exceptions && DexAnnotation.isThrowingAnnotation(annotation, factory)) {
                    return true;
                }
                if (this.keep.signature && DexAnnotation.isSignatureAnnotation(annotation, factory)) {
                    return true;
                }
                if (this.keep.sourceDebugExtension && DexAnnotation.isSourceDebugExtension(annotation, factory)) {
                    return true;
                }
                if (this.options.canUseParameterNameAnnotations() && DexAnnotation.isParameterNameAnnotation(annotation, factory)) {
                    return true;
                }
                return DexAnnotation.isAnnotationDefaultAnnotation(annotation, factory);
            }
            case 1: {
                if (this.keep.runtimeVisibleAnnotations) break;
                return false;
            }
            case 0: {
                if (DexAnnotation.isSynthesizedClassMapAnnotation(annotation, this.appInfo.dexItemFactory)) {
                    return true;
                }
                if (this.keep.runtimeInvisibleAnnotations) break;
                return false;
            }
            default: {
                throw new Unreachable("Unexpected annotation visibility.");
            }
        }
        return this.isAnnotationTypeLive(annotation);
    }

    private boolean isAnnotationTypeLive(DexAnnotation annotation) {
        DexType annotationType = annotation.annotation.type;
        if (annotationType.isArrayType()) {
            annotationType = annotationType.toBaseType(this.appInfo.dexItemFactory);
        }
        DexClass definition = this.appInfo.definitionFor(annotationType);
        if (this.options.enableTreeShaking && definition == null) {
            return false;
        }
        return definition == null || definition.isLibraryClass() || this.appInfo.liveTypes.contains(annotationType);
    }

    private boolean filterParameterAnnotations(DexAnnotation annotation) {
        switch (annotation.visibility) {
            case 2: {
                return false;
            }
            case 1: {
                if (this.keep.runtimeVisibleParameterAnnotations) break;
                return false;
            }
            case 0: {
                if (this.keep.runtimeInvisibleParameterAnnotations) break;
                return false;
            }
            default: {
                throw new Unreachable("Unexpected annotation visibility.");
            }
        }
        return this.isAnnotationTypeLive(annotation);
    }

    public void run() {
        this.keep.ensureValid(this.options.forceProguardCompatibility, this.compatibility);
        for (DexProgramClass clazz : this.appInfo.classes()) {
            this.stripAttributes(clazz);
            clazz.annotations = clazz.annotations.keepIf(this::filterAnnotations);
            clazz.forEachMethod(this::processMethod);
            clazz.forEachField(this::processField);
        }
    }

    private void processMethod(DexEncodedMethod method) {
        method.annotations = method.annotations.keepIf(this::filterAnnotations);
        method.parameterAnnotationsList = method.parameterAnnotationsList.keepIf(this::filterParameterAnnotations);
    }

    private void processField(DexEncodedField field) {
        field.annotations = field.annotations.keepIf(this::filterAnnotations);
    }

    private void stripAttributes(DexProgramClass clazz) {
        if (this.appInfo.isPinned(clazz.type) || this.options.forceProguardCompatibility) {
            if (!this.keep.enclosingMethod) {
                clazz.clearEnclosingMethod();
            }
            if (!this.keep.innerClasses) {
                clazz.clearInnerClasses();
            }
        } else {
            clazz.clearEnclosingMethod();
            clazz.clearInnerClasses();
        }
    }
}

