/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.Reporter;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class DictionaryReader
implements AutoCloseable {
    private final BufferedReader reader;

    public DictionaryReader(Path path) throws IOException {
        this.reader = Files.newBufferedReader(path);
    }

    public String readName() throws IOException {
        int readCharAsInt;
        assert (this.reader != null);
        StringBuilder name = new StringBuilder();
        while ((readCharAsInt = this.reader.read()) != -1) {
            char readChar = (char)readCharAsInt;
            if (name.length() != 0 && Character.isJavaIdentifierPart(readChar) || name.length() == 0 && Character.isJavaIdentifierStart(readChar)) {
                name.append(readChar);
                continue;
            }
            if (readChar == '#') {
                this.reader.readLine();
            }
            if (name.length() == 0) continue;
            return name.toString();
        }
        return name.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static ImmutableList<String> readAllNames(Path path, Reporter reporter) {
        if (path != null) {
            ImmutableList.Builder namesBuilder = new ImmutableList.Builder();
            try (DictionaryReader reader = new DictionaryReader(path);){
                String name = reader.readName();
                while (!name.isEmpty()) {
                    namesBuilder.add(name);
                    name = reader.readName();
                }
            }
            catch (IOException e) {
                reporter.error(new ExceptionDiagnostic(e, new PathOrigin(path)));
            }
            return namesBuilder.build();
        }
        return ImmutableList.of();
    }
}

