/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.cf.FixedLocalValue;
import com.android.tools.r8.com.google.common.collect.HashMultiset;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.com.google.common.collect.Multisets;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.And;
import com.android.tools.r8.ir.code.ArithmeticBinop;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.DebugLocalsChange;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Or;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.LiveIntervalsUse;
import com.android.tools.r8.ir.regalloc.LiveRange;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.ir.regalloc.RegisterPositions;
import com.android.tools.r8.ir.regalloc.SpillMoveSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class LinearScanRegisterAllocator
implements RegisterAllocator {
    public static final int REGISTER_CANDIDATE_NOT_FOUND = -1;
    public static final int MIN_CONSTANT_FREE_FOR_POSITIONS = 5;
    public static final int EXCEPTION_INTERVALS_OVERLAP_CUTOFF = 500;
    private final IRCode code;
    protected final int numberOfArgumentRegisters;
    private final InternalOptions options;
    private Map<BasicBlock, IRCode.LiveAtEntrySets> liveAtEntrySets;
    protected Value firstArgumentValue;
    private Value lastArgumentValue;
    private ArgumentReuseMode mode = ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U4BIT;
    private TreeSet<Integer> freeRegisters = new TreeSet();
    private int maxRegisterNumber = -1;
    private List<LiveIntervals> liveIntervals = new ArrayList<LiveIntervals>();
    private List<LiveIntervals> active = new LinkedList<LiveIntervals>();
    protected List<LiveIntervals> inactive = new LinkedList<LiveIntervals>();
    protected PriorityQueue<LiveIntervals> unhandled = new PriorityQueue();
    private IntList expiredHere = new IntArrayList();
    private List<LiveIntervals> moveExceptionIntervals = new ArrayList<LiveIntervals>();
    private int firstParallelMoveTemporary = Integer.MIN_VALUE;
    private int[] unusedRegisters = null;

    private boolean hasDedicatedMoveExceptionRegister() {
        return !this.moveExceptionIntervals.isEmpty();
    }

    private int getMoveExceptionRegister() {
        assert (this.hasDedicatedMoveExceptionRegister());
        return this.numberOfArgumentRegisters;
    }

    public LinearScanRegisterAllocator(IRCode code, InternalOptions options) {
        this.code = code;
        this.options = options;
        int argumentRegisters = 0;
        for (Instruction instruction : code.blocks.getFirst().getInstructions()) {
            if (!instruction.isArgument()) continue;
            argumentRegisters += instruction.outValue().requiredRegisters();
        }
        this.numberOfArgumentRegisters = argumentRegisters;
    }

    @Override
    public void allocateRegisters(boolean debug) {
        assert (this.noLinkedValues());
        assert (this.code.isConsistentSSA());
        if (this.code.method.accessFlags.isBridge() && LinearScanRegisterAllocator.implementationIsBridge(this.code)) {
            this.transformBridgeMethod();
        }
        this.computeNeedsRegister();
        this.constrainArgumentIntervals();
        this.insertRangeInvokeMoves();
        ImmutableList<BasicBlock> blocks = this.computeLivenessInformation();
        this.performAllocation();
        assert (this.code.isConsistentGraph());
        assert (this.registersUsed() == 0 || this.unusedRegisters != null);
        if (debug) {
            this.computeDebugInfo(blocks);
        }
        this.clearUserInfo();
        this.clearState();
    }

    private static Integer nextInRange(int start, int end, List<Integer> points) {
        while (!points.isEmpty() && points.get(0) < start) {
            points.remove(0);
        }
        if (points.isEmpty()) {
            return null;
        }
        Integer next = points.get(0);
        assert (start <= next);
        if (next < end) {
            points.remove(0);
            return next;
        }
        return null;
    }

    private void computeDebugInfo(ImmutableList<BasicBlock> blocks) {
        LinearScanRegisterAllocator.computeDebugInfo(blocks, this.liveIntervals, this, this.liveAtEntrySets);
    }

    public static void computeDebugInfo(ImmutableList<BasicBlock> blocks, List<LiveIntervals> liveIntervals, RegisterAllocator allocator, Map<BasicBlock, IRCode.LiveAtEntrySets> liveAtEntrySets) {
        ArrayList<LocalRange> ranges = new ArrayList<LocalRange>();
        for (LiveIntervals interval : liveIntervals) {
            Value value = interval.getValue();
            if (!value.hasLocalInfo()) continue;
            ArrayList<LiveRange> liveRanges = new ArrayList<LiveRange>(interval.getRanges());
            for (LiveIntervals child : interval.getSplitChildren()) {
                assert (child.getValue() == value);
                assert (child.getSplitChildren() == null || child.getSplitChildren().isEmpty());
                liveRanges.addAll(child.getRanges());
            }
            liveRanges.sort((r1, r2) -> Integer.compare(r1.start, r2.start));
            for (LiveRange liveRange : liveRanges) {
                int start = liveRange.start;
                int end = liveRange.end;
                ranges.add(new LocalRange(value, allocator.getArgumentOrAllocateRegisterForValue(value, start), start, end));
            }
        }
        if (ranges.isEmpty()) {
            return;
        }
        ranges.sort(LocalRange::compareTo);
        LinkedList<LocalRange> openRanges = new LinkedList<LocalRange>();
        Iterator rangeIterator = ranges.iterator();
        LocalRange nextStartingRange = (LocalRange)rangeIterator.next();
        Int2ReferenceOpenHashMap<DebugLocalInfo> ending = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
        Int2ReferenceOpenHashMap<DebugLocalInfo> starting = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
        boolean isEntryBlock = true;
        block3: for (BasicBlock block : blocks) {
            Object instruction;
            InstructionListIterator instructionIterator = block.listIterator();
            HashSet<Value> liveLocalValues = new HashSet<Value>(liveAtEntrySets.get((Object)block).liveLocalValues);
            if (isEntryBlock) {
                isEntryBlock = false;
                assert (block.getPhis().isEmpty());
                while (instructionIterator.hasNext() && ((Instruction)(instruction = (Instruction)instructionIterator.next())).isArgument()) {
                    if (!((Instruction)instruction).outValue().hasLocalInfo()) continue;
                    liveLocalValues.add(((Instruction)instruction).outValue());
                }
                instructionIterator.previous();
            } else {
                instruction = block.getPhis().iterator();
                while (instruction.hasNext()) {
                    Phi phi = instruction.next();
                    if (!phi.hasLocalInfo()) continue;
                    liveLocalValues.add(phi);
                }
            }
            instructionIterator.nextUntil(i -> !i.isMoveException() && !LinearScanRegisterAllocator.isSpillInstruction(i));
            Instruction firstInstruction = (Instruction)instructionIterator.previous();
            int firstIndex = firstInstruction.getNumber();
            openRanges.removeIf(openRange -> !liveLocalValues.contains(openRange.value) || !LinearScanRegisterAllocator.isLocalLiveAtInstruction(firstInstruction, openRange));
            while (nextStartingRange != null && nextStartingRange.start < firstIndex) {
                if (liveLocalValues.contains(nextStartingRange.value) && LinearScanRegisterAllocator.isLocalLiveAtInstruction(firstInstruction, nextStartingRange)) {
                    openRanges.add(nextStartingRange);
                }
                nextStartingRange = rangeIterator.hasNext() ? (LocalRange)rangeIterator.next() : null;
            }
            Int2ReferenceOpenHashMap<DebugLocalInfo> currentLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>(openRanges.size());
            for (LocalRange localRange : openRanges) {
                if (!liveLocalValues.contains(localRange.value)) continue;
                currentLocals.put(localRange.register, localRange.local);
            }
            LinearScanRegisterAllocator.setLocalsAtEntry(block, instructionIterator, openRanges, currentLocals, allocator);
            while (instructionIterator.hasNext()) {
                DebugLocalsChange change;
                boolean skipChange;
                Instruction instruction2;
                ListIterator it;
                Instruction instruction22 = (Instruction)instructionIterator.next();
                if (!instructionIterator.hasNext()) continue block3;
                if (!instruction22.getDebugValues().isEmpty()) {
                    block9: for (Value endAnnotation : instruction22.getDebugValues()) {
                        it = openRanges.listIterator();
                        while (it.hasNext()) {
                            LocalRange openRange2 = (LocalRange)it.next();
                            if (openRange2.value != endAnnotation) continue;
                            assert (currentLocals.get(openRange2.register) == openRange2.local);
                            currentLocals.remove(openRange2.register);
                            ending.put(openRange2.register, openRange2.local);
                            continue block9;
                        }
                    }
                    instruction22.clearDebugValues();
                    if (instruction22.isDebugLocalRead()) {
                        Instruction instruction3 = (Instruction)instructionIterator.previous();
                        assert (instruction3 == instruction22);
                        instructionIterator.remove();
                    }
                }
                if (LinearScanRegisterAllocator.isSpillInstruction(instruction2 = instructionIterator.peekNext())) continue;
                int index = instruction2.getNumber();
                it = openRanges.listIterator();
                while (it.hasNext()) {
                    LocalRange openRange3 = (LocalRange)it.next();
                    if (LinearScanRegisterAllocator.isLocalLiveAtInstruction(instruction2, openRange3)) continue;
                    it.remove();
                    if (currentLocals.remove(openRange3.register) == null) continue;
                    ending.put(openRange3.register, openRange3.local);
                }
                while (nextStartingRange != null && nextStartingRange.start < index) {
                    if (LinearScanRegisterAllocator.isLocalLiveAtInstruction(instruction2, nextStartingRange)) {
                        openRanges.add(nextStartingRange);
                        assert (!currentLocals.containsKey(nextStartingRange.register));
                        currentLocals.put(nextStartingRange.register, nextStartingRange.local);
                        starting.put(nextStartingRange.register, nextStartingRange.local);
                    }
                    nextStartingRange = rangeIterator.hasNext() ? (LocalRange)rangeIterator.next() : null;
                }
                boolean localsChanged = !ending.isEmpty() || !starting.isEmpty();
                if (!localsChanged) continue;
                boolean bl = skipChange = instruction2 == instruction2.getBlock().exit() && instruction2.isGoto();
                if (!skipChange && (change = LinearScanRegisterAllocator.createLocalsChange(ending, starting)) != null) {
                    instructionIterator.add(change);
                }
                ending = new Int2ReferenceOpenHashMap();
                starting = new Int2ReferenceOpenHashMap();
            }
        }
    }

    private static boolean isLocalLiveAtInstruction(Instruction instruction, LocalRange range) {
        return LinearScanRegisterAllocator.isLocalLiveAtInstruction(instruction, range.start, range.end, range.value);
    }

    private static boolean isLocalLiveAtInstruction(Instruction instruction, int start, int end, Value value) {
        int number = instruction.getNumber();
        assert (start < number);
        return number < end || number == end && LinearScanRegisterAllocator.usesValue(value, instruction);
    }

    private static boolean usesValue(Value usedValue, Instruction instruction) {
        return LinearScanRegisterAllocator.valuesContain(usedValue, instruction.inValues()) || LinearScanRegisterAllocator.valuesContain(usedValue, instruction.getDebugValues());
    }

    private static boolean valuesContain(Value value, Collection<Value> values2) {
        for (Value other : values2) {
            if (value == other) {
                return true;
            }
            if (!value.isPhi() || !(other instanceof FixedLocalValue) || ((FixedLocalValue)other).getPhi() != value) continue;
            return true;
        }
        return false;
    }

    private static void setLocalsAtEntry(BasicBlock block, InstructionListIterator instructionIterator, List<LocalRange> openRanges, Int2ReferenceMap<DebugLocalInfo> finalLocals, RegisterAllocator allocator) {
        if (block.getPredecessors().isEmpty() || block.entry() == instructionIterator.peekNext()) {
            assert (!block.entry().isMoveException());
            assert (!LinearScanRegisterAllocator.isSpillInstruction(block.entry()));
            block.setLocalsAtEntry(new Int2ReferenceOpenHashMap<DebugLocalInfo>(finalLocals));
            return;
        }
        Int2ReferenceOpenHashMap<DebugLocalInfo> initialLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>(openRanges.size());
        int predecessorExitIndex = block.entry().isMoveException() ? block.getPredecessors().get(0).exceptionalExit().getNumber() : block.getPredecessors().get(0).exit().getNumber();
        for (LocalRange open : openRanges) {
            int predecessorRegister = allocator.getArgumentOrAllocateRegisterForValue(open.value, predecessorExitIndex);
            initialLocals.put(predecessorRegister, open.local);
        }
        block.setLocalsAtEntry(initialLocals);
        Int2ReferenceOpenHashMap<DebugLocalInfo> ending = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
        Int2ReferenceOpenHashMap<DebugLocalInfo> starting = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
        for (Int2ReferenceMap.Entry entry : initialLocals.int2ReferenceEntrySet()) {
            if (finalLocals.get(entry.getIntKey()) == entry.getValue()) continue;
            ending.put(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
        for (Int2ReferenceMap.Entry entry : finalLocals.int2ReferenceEntrySet()) {
            if (initialLocals.get(entry.getIntKey()) == entry.getValue()) continue;
            starting.put(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
        DebugLocalsChange change = LinearScanRegisterAllocator.createLocalsChange(ending, starting);
        if (change != null) {
            instructionIterator.add(change);
        }
    }

    private static DebugLocalsChange createLocalsChange(Int2ReferenceMap<DebugLocalInfo> ending, Int2ReferenceMap<DebugLocalInfo> starting) {
        if (ending.isEmpty() && starting.isEmpty()) {
            return null;
        }
        if (ending.isEmpty() || starting.isEmpty()) {
            return new DebugLocalsChange(ending, starting);
        }
        IntArraySet unneeded = new IntArraySet(Math.min(ending.size(), starting.size()));
        for (Int2ReferenceMap.Entry entry : ending.int2ReferenceEntrySet()) {
            if (starting.get(entry.getIntKey()) != entry.getValue()) continue;
            unneeded.add(entry.getIntKey());
        }
        if (unneeded.size() == ending.size() && unneeded.size() == starting.size()) {
            return null;
        }
        IntIterator iterator2 = unneeded.iterator();
        while (iterator2.hasNext()) {
            int n = iterator2.nextInt();
            ending.remove(n);
            starting.remove(n);
        }
        return new DebugLocalsChange(ending, starting);
    }

    private void clearState() {
        this.liveAtEntrySets = null;
        this.liveIntervals = null;
        this.active = null;
        this.inactive = null;
        this.unhandled = null;
        this.freeRegisters = null;
    }

    private boolean computeUnusedRegisters() {
        if (this.registersUsed() == 0) {
            return false;
        }
        HashSet<Integer> usedRegisters = new HashSet<Integer>();
        for (LiveIntervals intervals : this.liveIntervals) {
            this.addRegisterIfUsed(usedRegisters, intervals);
            for (LiveIntervals childIntervals : intervals.getSplitChildren()) {
                this.addRegisterIfUsed(usedRegisters, childIntervals);
            }
        }
        for (int i = this.firstParallelMoveTemporary; i < this.maxRegisterNumber + 1; ++i) {
            usedRegisters.add(this.realRegisterNumberFromAllocated(i));
        }
        int unused = 0;
        int[] computed = new int[this.registersUsed()];
        for (int i = 0; i < this.registersUsed(); ++i) {
            if (!usedRegisters.contains(i)) {
                // empty if block
            }
            computed[i] = ++unused;
        }
        this.unusedRegisters = computed;
        return unused > 0;
    }

    private void addRegisterIfUsed(Set<Integer> used, LiveIntervals intervals) {
        boolean unused = intervals.isSpilledAndRematerializable();
        if (!unused) {
            used.add(this.realRegisterNumberFromAllocated(intervals.getRegister()));
            if (intervals.getType().isWide()) {
                used.add(this.realRegisterNumberFromAllocated(intervals.getRegister() + 1));
            }
        }
    }

    public int highestUsedRegister() {
        return this.registersUsed() - 1;
    }

    @Override
    public int registersUsed() {
        int numberOfRegister = this.maxRegisterNumber + 1;
        if (this.unusedRegisters != null) {
            return numberOfRegister - this.unusedRegisters[this.unusedRegisters.length - 1];
        }
        return numberOfRegister;
    }

    @Override
    public int getRegisterForValue(Value value, int instructionNumber) {
        if (value.isFixedRegisterValue()) {
            return this.realRegisterNumberFromAllocated(value.asFixedRegisterValue().getRegister());
        }
        LiveIntervals intervals = value.getLiveIntervals();
        if (intervals.hasSplits()) {
            intervals = intervals.getSplitCovering(instructionNumber);
        }
        return this.getRegisterForIntervals(intervals);
    }

    @Override
    public int getArgumentOrAllocateRegisterForValue(Value value, int instructionNumber) {
        if (value.isArgument()) {
            return this.getRegisterForIntervals(value.getLiveIntervals());
        }
        return this.getRegisterForValue(value, instructionNumber);
    }

    @Override
    public InternalOptions getOptions() {
        return this.options;
    }

    private ImmutableList<BasicBlock> computeLivenessInformation() {
        ImmutableList<BasicBlock> blocks = this.code.numberInstructions();
        this.liveAtEntrySets = this.code.computeLiveAtEntrySets();
        this.computeLiveRanges();
        return blocks;
    }

    private void performAllocation() {
        this.performAllocation(ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U4BIT, false);
    }

    private ArgumentReuseMode performAllocation(ArgumentReuseMode mode, boolean isRetry) {
        ArgumentReuseMode result = mode;
        this.mode = mode;
        if (isRetry) {
            this.clearRegisterAssignments(mode);
            this.removeSpillAndPhiMoves();
        }
        this.pinArgumentRegisters();
        boolean succeeded = this.performLinearScan(mode);
        if (succeeded) {
            this.insertMoves();
        }
        switch (mode) {
            case ALLOW_ARGUMENT_REUSE_U4BIT: {
                if (!succeeded || this.highestUsedRegister() > 15 || this.options.testing.alwaysUsePessimisticRegisterAllocation) {
                    result = this.performAllocation(ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT, true);
                    break;
                }
                assert (!this.computeUnusedRegisters());
                break;
            }
            case ALLOW_ARGUMENT_REUSE_U8BIT: {
                assert (succeeded);
                if (this.unsplitArguments()) {
                    this.removeSpillAndPhiMoves();
                    this.insertMoves();
                }
                this.computeUnusedRegisters();
                if (this.highestUsedRegister() <= 255 && !this.options.testing.alwaysUsePessimisticRegisterAllocation) break;
                this.unusedRegisters = null;
                result = this.performAllocation(ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U16BIT, true);
                break;
            }
            case ALLOW_ARGUMENT_REUSE_U16BIT: {
                assert (succeeded);
                if (this.unsplitArguments()) {
                    this.removeSpillAndPhiMoves();
                    this.insertMoves();
                }
                this.computeUnusedRegisters();
            }
        }
        assert (result != ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U4BIT || this.highestUsedRegister() <= 15);
        assert (result != ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT || this.highestUsedRegister() <= 255);
        return result;
    }

    private boolean unsplitArguments() {
        boolean argumentRegisterUnsplit = false;
        for (Value current = this.firstArgumentValue; current != null; current = current.getNextConsecutive()) {
            LiveIntervals intervals = current.getLiveIntervals();
            assert (intervals.getRegisterLimit() == 65535);
            boolean canUseArgumentRegister = true;
            boolean couldUseArgumentRegister = true;
            for (LiveIntervals child : intervals.getSplitChildren()) {
                int registerConstraint = child.getRegisterLimit();
                if (registerConstraint >= 65535) continue;
                couldUseArgumentRegister = false;
                if (registerConstraint >= this.highestUsedRegister()) continue;
                canUseArgumentRegister = false;
                break;
            }
            if (!canUseArgumentRegister || couldUseArgumentRegister) continue;
            argumentRegisterUnsplit = true;
            for (LiveIntervals child : intervals.getSplitChildren()) {
                child.clearRegisterAssignment();
                child.setRegister(intervals.getRegister());
                child.setSpilled(false);
            }
        }
        return argumentRegisterUnsplit;
    }

    private void removeSpillAndPhiMoves() {
        for (BasicBlock block : this.code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!LinearScanRegisterAllocator.isSpillInstruction(instruction)) continue;
                it.remove();
            }
        }
    }

    private static boolean isSpillInstruction(Instruction instruction) {
        Value outValue = instruction.outValue();
        if (outValue != null && outValue.isFixedRegisterValue()) {
            assert (instruction.getNumber() == -1);
            assert (instruction.isMove() || instruction.isConstNumber());
            assert (!instruction.isDebugInstruction());
            return true;
        }
        return false;
    }

    private void clearRegisterAssignments(ArgumentReuseMode mode) {
        this.freeRegisters.clear();
        this.maxRegisterNumber = -1;
        this.active.clear();
        this.inactive.clear();
        this.unhandled.clear();
        this.moveExceptionIntervals.clear();
        for (LiveIntervals intervals : this.liveIntervals) {
            if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U16BIT) {
                intervals.undoSplits();
                intervals.setSpilled(false);
            }
            intervals.clearRegisterAssignment();
        }
    }

    private int getRegisterForIntervals(LiveIntervals intervals) {
        int intervalsRegister = intervals.getRegister();
        return this.realRegisterNumberFromAllocated(intervalsRegister);
    }

    int unadjustedRealRegisterFromAllocated(int allocated) {
        assert (allocated != Integer.MIN_VALUE);
        assert (allocated >= 0);
        int register = allocated < this.numberOfArgumentRegisters ? this.maxRegisterNumber - (this.numberOfArgumentRegisters - allocated - 1) : allocated - this.numberOfArgumentRegisters;
        return register;
    }

    int realRegisterNumberFromAllocated(int allocated) {
        int register = this.unadjustedRealRegisterFromAllocated(allocated);
        if (this.unusedRegisters != null) {
            return register - this.unusedRegisters[register];
        }
        return register;
    }

    private boolean performLinearScan(ArgumentReuseMode mode) {
        this.unhandled.addAll(this.liveIntervals);
        for (Value argumentValue = this.firstArgumentValue; argumentValue != null; argumentValue = argumentValue.getNextConsecutive()) {
            Object use2;
            LiveIntervals argumentInterval = argumentValue.getLiveIntervals();
            assert (argumentInterval.getRegister() != Integer.MIN_VALUE);
            this.unhandled.remove(argumentInterval);
            if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U4BIT) {
                this.active.add(argumentInterval);
                continue;
            }
            this.inactive.add(argumentInterval);
            if (argumentInterval.getUses().size() > 1 && (use2 = argumentInterval.firstUseWithConstraint()) != null) {
                LiveIntervals split = argumentInterval.numberOfUsesWithConstraint() == 1 ? argumentInterval.splitBefore(((LiveIntervalsUse)use2).getPosition()) : argumentInterval.splitBefore(argumentInterval.getValue().definition.getNumber() + 1);
                this.unhandled.add(split);
            }
            this.freeOccupiedRegistersForIntervals(argumentInterval);
        }
        if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT || mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U16BIT) {
            boolean overlappingMoveExceptionIntervals = false;
            for (BasicBlock block : this.code.blocks) {
                Instruction instruction = block.entry();
                if (!instruction.isMoveException()) continue;
                LiveIntervals intervals = instruction.outValue().getLiveIntervals();
                this.unhandled.remove(intervals);
                this.moveExceptionIntervals.add(intervals);
                intervals.setRegister(this.getMoveExceptionRegister());
                if (overlappingMoveExceptionIntervals) continue;
                for (LiveIntervals other : this.moveExceptionIntervals) {
                    overlappingMoveExceptionIntervals |= other.overlaps(intervals);
                }
            }
            if (this.hasDedicatedMoveExceptionRegister()) {
                int moveExceptionRegister = this.getMoveExceptionRegister();
                assert (moveExceptionRegister == this.maxRegisterNumber + 1);
                this.increaseCapacity(moveExceptionRegister, true);
            }
            if (overlappingMoveExceptionIntervals) {
                for (LiveIntervals intervals : this.moveExceptionIntervals) {
                    if (intervals.getUses().size() <= 1) continue;
                    LiveIntervals split = intervals.splitBefore(intervals.getFirstUse() + 2);
                    this.unhandled.add(split);
                }
            }
        }
        while (!this.unhandled.isEmpty()) {
            assert (this.invariantsHold(mode));
            this.expiredHere.clear();
            LiveIntervals unhandledInterval = this.unhandled.poll();
            this.setHintForDestRegOfCheckCast(unhandledInterval);
            this.setHintToPromote2AddrInstruction(unhandledInterval);
            this.allocateArgumentIntervalsWithSrc(unhandledInterval, mode);
            if (unhandledInterval.getRegister() != Integer.MIN_VALUE) continue;
            int start = unhandledInterval.getStart();
            Iterator<LiveIntervals> activeIterator = this.active.iterator();
            while (activeIterator.hasNext()) {
                LiveIntervals activeIntervals = activeIterator.next();
                if (start >= activeIntervals.getEnd()) {
                    activeIterator.remove();
                    this.freeOccupiedRegistersForIntervals(activeIntervals);
                    if (start != activeIntervals.getEnd()) continue;
                    this.expiredHere.add(activeIntervals.getRegister());
                    if (!activeIntervals.getType().isWide()) continue;
                    this.expiredHere.add(activeIntervals.getRegister() + 1);
                    continue;
                }
                if (activeIntervals.overlapsPosition(start)) continue;
                activeIterator.remove();
                assert (activeIntervals.getRegister() != Integer.MIN_VALUE);
                this.inactive.add(activeIntervals);
                this.freeOccupiedRegistersForIntervals(activeIntervals);
            }
            Iterator<LiveIntervals> inactiveIterator = this.inactive.iterator();
            while (inactiveIterator.hasNext()) {
                LiveIntervals inactiveIntervals = inactiveIterator.next();
                if (start >= inactiveIntervals.getEnd()) {
                    inactiveIterator.remove();
                    if (start != inactiveIntervals.getEnd()) continue;
                    this.expiredHere.add(inactiveIntervals.getRegister());
                    if (!inactiveIntervals.getType().isWide()) continue;
                    this.expiredHere.add(inactiveIntervals.getRegister() + 1);
                    continue;
                }
                if (!inactiveIntervals.overlapsPosition(start)) continue;
                inactiveIterator.remove();
                assert (inactiveIntervals.getRegister() != Integer.MIN_VALUE);
                this.active.add(inactiveIntervals);
                this.takeFreeRegistersForIntervals(inactiveIntervals);
            }
            if (unhandledInterval.isLinked() && !unhandledInterval.isArgumentInterval()) {
                this.allocateLinkedIntervals(unhandledInterval, false);
                continue;
            }
            if (this.allocateSingleInterval(unhandledInterval, mode)) continue;
            return false;
        }
        return true;
    }

    private boolean invariantsHold(ArgumentReuseMode mode) {
        TreeSet<Integer> computedFreeRegisters = new TreeSet<Integer>();
        for (int register2 = 0; register2 <= this.maxRegisterNumber; ++register2) {
            computedFreeRegisters.add(register2);
        }
        for (LiveIntervals activeIntervals : this.active) {
            assert (this.registersForIntervalsAreTaken(activeIntervals));
            activeIntervals.forEachRegister(register -> {
                assert (computedFreeRegisters.contains(register));
                computedFreeRegisters.remove(register);
            });
        }
        if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT || mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U16BIT) {
            for (LiveIntervals activeIntervals : this.active) {
                LiveIntervals parent;
                if (!activeIntervals.isArgumentInterval() || activeIntervals == activeIntervals.getSplitParent() || (parent = activeIntervals.getSplitParent()).getRegister() == activeIntervals.getRegister()) continue;
                activeIntervals.getSplitParent().forEachRegister(register -> {
                    assert (computedFreeRegisters.contains(register));
                    computedFreeRegisters.remove(register);
                });
            }
        }
        if (this.hasDedicatedMoveExceptionRegister()) {
            this.freeRegisters.remove(this.getMoveExceptionRegister());
            computedFreeRegisters.remove(this.getMoveExceptionRegister());
        }
        assert (this.freeRegisters.equals(computedFreeRegisters));
        return true;
    }

    private boolean freePositionsAreConsistentWithFreeRegisters(RegisterPositions freePositions, int registerConstraint) {
        int n = Math.min(this.maxRegisterNumber, registerConstraint);
        for (int register = 0; register <= n; ++register) {
            boolean isMoveExceptionRegister;
            if (freePositions.get(register) <= 0) continue;
            boolean bl = isMoveExceptionRegister = this.hasDedicatedMoveExceptionRegister() && register == this.getMoveExceptionRegister();
            if (!isMoveExceptionRegister) assert (this.freeRegisters.contains(register));
        }
        return true;
    }

    private boolean registerAssignmentNotConflictingWithArgument(LiveIntervals interval) {
        assert (interval.getRegister() != Integer.MIN_VALUE);
        for (Value argumentValue = this.firstArgumentValue; argumentValue != null; argumentValue = argumentValue.getNextConsecutive()) {
            assert (!interval.hasConflictingRegisters(argumentValue.getLiveIntervals()) || !argumentValue.getLiveIntervals().anySplitOverlaps(interval));
        }
        return true;
    }

    private void setHintForDestRegOfCheckCast(LiveIntervals unhandledInterval) {
        if (unhandledInterval.getHint() == null && unhandledInterval.getValue().definition instanceof CheckCast) {
            CheckCast checkcast = unhandledInterval.getValue().definition.asCheckCast();
            Value checkcastInput = checkcast.inValues().get(0);
            assert (checkcastInput != null);
            if (checkcastInput.getLiveIntervals() != null && !checkcastInput.getLiveIntervals().overlaps(unhandledInterval) && checkcastInput.getLocalInfo() == unhandledInterval.getValue().definition.getLocalInfo()) {
                unhandledInterval.setHint(checkcastInput.getLiveIntervals());
            }
        }
    }

    private void setHintToPromote2AddrInstruction(LiveIntervals unhandledInterval) {
        if (unhandledInterval.getHint() == null && unhandledInterval.getValue().definition instanceof ArithmeticBinop) {
            ArithmeticBinop binOp = unhandledInterval.getValue().definition.asArithmeticBinop();
            Value left = binOp.leftValue();
            assert (left != null);
            if (left.getLiveIntervals() != null && !left.getLiveIntervals().overlaps(unhandledInterval)) {
                unhandledInterval.setHint(left.getLiveIntervals());
            } else {
                Value right = binOp.rightValue();
                assert (right != null);
                if (binOp.isCommutative() && right.getLiveIntervals() != null && !right.getLiveIntervals().overlaps(unhandledInterval)) {
                    unhandledInterval.setHint(right.getLiveIntervals());
                }
            }
        }
    }

    private void allocateArgumentIntervalsWithSrc(LiveIntervals srcInterval, ArgumentReuseMode mode) {
        Value value = srcInterval.getValue();
        for (Instruction instruction : value.uniqueUsers()) {
            Move move;
            Value dest;
            LiveIntervals destIntervals;
            if (!instruction.isMove() || !instruction.asMove().dest().isLinked() || (destIntervals = (dest = (move = instruction.asMove()).dest()).getLiveIntervals()).getRegister() != Integer.MIN_VALUE) continue;
            TreeSet<Integer> savedFreeRegisters = new TreeSet<Integer>((SortedSet<Integer>)this.freeRegisters);
            int savedMaxRegisterNumber = this.maxRegisterNumber;
            LinkedList<LiveIntervals> savedInactive = new LinkedList<LiveIntervals>(this.inactive);
            for (LiveIntervals active : this.active) {
                if (active.isArgumentInterval()) {
                    this.freeOccupiedRegistersForIntervals(active);
                }
                this.inactive.add(active);
            }
            this.unhandled.remove(destIntervals);
            boolean excludeUnhandledOverlappingArgumentIntervals = false;
            if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT || mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U16BIT) {
                excludeUnhandledOverlappingArgumentIntervals = true;
            }
            this.unhandled.add(srcInterval);
            this.allocateLinkedIntervals(destIntervals, excludeUnhandledOverlappingArgumentIntervals);
            this.active.remove(destIntervals);
            this.unhandled.remove(srcInterval);
            this.freeRegisters = savedFreeRegisters;
            for (int i = savedMaxRegisterNumber + 1; i <= this.maxRegisterNumber; ++i) {
                this.freeRegisters.add(i);
            }
            this.inactive = savedInactive;
            for (LiveIntervals current = destIntervals.getStartOfConsecutive(); current != null; current = current.getNextConsecutive()) {
                assert (!this.inactive.contains(current));
                assert (!this.active.contains(current));
                assert (!this.unhandled.contains(current));
                this.inactive.add(current);
            }
        }
    }

    private void allocateLinkedIntervals(LiveIntervals unhandledInterval, boolean excludeUnhandledOverlappingArgumentIntervals) {
        LiveIntervals start = unhandledInterval.getStartOfConsecutive();
        IntArraySet excludedRegisters = new IntArraySet();
        for (LiveIntervals current = start; current != null; current = current.getNextConsecutive()) {
            for (LiveIntervals inactiveIntervals : this.inactive) {
                if (!inactiveIntervals.overlaps(current)) continue;
                this.excludeRegistersForInterval(inactiveIntervals, excludedRegisters);
            }
        }
        if (excludeUnhandledOverlappingArgumentIntervals && this.firstArgumentValue != null) {
            for (LiveIntervals intervals = this.firstArgumentValue.getLiveIntervals(); intervals != null; intervals = intervals.getNextConsecutive()) {
                if (!this.liveIntervalsHasUnhandledSplitOverlappingAnyOf(intervals, start)) continue;
                this.excludeRegistersForInterval(intervals, excludedRegisters);
            }
        }
        if (this.overlapsMoveExceptionInterval(start) && this.freeRegisters.remove(this.getMoveExceptionRegister())) {
            excludedRegisters.add(this.getMoveExceptionRegister());
        }
        int numberOfRegisters = start.numberOfConsecutiveRegisters();
        int nextRegister = this.getFreeConsecutiveRegisters(numberOfRegisters);
        for (LiveIntervals current = start; current != null; current = current.getNextConsecutive()) {
            current.setRegister(nextRegister);
            assert (this.registerAssignmentNotConflictingWithArgument(current));
            Value value = current.getValue();
            if (!value.isPhi() && value.definition.isMove()) {
                Move move = value.definition.asMove();
                LiveIntervals intervals = move.src().getLiveIntervals();
                intervals.setHint(current);
            }
            if (current != unhandledInterval) {
                this.unhandled.remove(current);
                this.inactive.add(current);
            }
            nextRegister += current.requiredRegisters();
        }
        assert (unhandledInterval.getRegister() != Integer.MIN_VALUE);
        this.takeFreeRegistersForIntervals(unhandledInterval);
        this.active.add(unhandledInterval);
        this.freeRegisters.addAll(excludedRegisters);
    }

    private boolean liveIntervalsHasUnhandledSplitOverlappingAnyOf(LiveIntervals intervals, LiveIntervals chain) {
        assert (intervals == intervals.getSplitParent());
        assert (chain == chain.getStartOfConsecutive());
        for (LiveIntervals split : intervals.getSplitChildren()) {
            if (!this.unhandled.contains(split)) continue;
            for (LiveIntervals current = chain; current != null; current = current.getNextConsecutive()) {
                if (!split.overlaps(current)) continue;
                return true;
            }
        }
        return false;
    }

    private int getNewSpillRegister(LiveIntervals intervals) {
        if (intervals.isArgumentInterval()) {
            return intervals.getSplitParent().getRegister();
        }
        int register = this.maxRegisterNumber + 1;
        this.increaseCapacity(this.maxRegisterNumber + intervals.requiredRegisters());
        return register;
    }

    private int getSpillRegister(LiveIntervals intervals, IntList excludedRegisters) {
        if (intervals.isArgumentInterval()) {
            return intervals.getSplitParent().getRegister();
        }
        TreeSet<Integer> previousFreeRegisters = new TreeSet<Integer>((SortedSet<Integer>)this.freeRegisters);
        int previousMaxRegisterNumber = this.maxRegisterNumber;
        this.freeRegisters.removeAll(this.expiredHere);
        if (excludedRegisters != null) {
            this.freeRegisters.removeAll(excludedRegisters);
        }
        int register = -1;
        for (LiveIntervals split : intervals.getSplitParent().getSplitChildren()) {
            int candidate = split.getRegister();
            if (candidate == Integer.MIN_VALUE || !this.registersAreFreeAndConsecutive(candidate, intervals.getType().isWide()) || !this.maySpillLiveIntervalsToRegister(intervals, candidate, previousMaxRegisterNumber)) continue;
            register = candidate;
            break;
        }
        if (register == -1) {
            boolean prioritizeSmallRegisters;
            do {
                boolean bl = prioritizeSmallRegisters = !intervals.getUses().isEmpty() && intervals.getUses().first().getLimit() == 15;
            } while (!this.maySpillLiveIntervalsToRegister(intervals, register = this.getFreeConsecutiveRegisters(intervals.requiredRegisters(), prioritizeSmallRegisters), previousMaxRegisterNumber));
        }
        this.freeRegisters = previousFreeRegisters;
        for (int i = previousMaxRegisterNumber + 1; i <= this.maxRegisterNumber; ++i) {
            this.freeRegisters.add(i);
        }
        assert (this.registersAreFree(register, intervals.getType().isWide()));
        return register;
    }

    private boolean maySpillLiveIntervalsToRegister(LiveIntervals intervals, int register, int previousMaxRegisterNumber) {
        boolean overlapsMoveExceptionInterval;
        if (register > previousMaxRegisterNumber) {
            return true;
        }
        if (register < this.numberOfArgumentRegisters) {
            LiveIntervals argumentLiveIntervals = this.firstArgumentValue.getLiveIntervals();
            while (!argumentLiveIntervals.usesRegister(register, intervals.getType().isWide())) {
                argumentLiveIntervals = argumentLiveIntervals.getNextConsecutive();
                assert (argumentLiveIntervals != null);
            }
            do {
                if (!argumentLiveIntervals.anySplitOverlaps(intervals)) continue;
                this.freeRegisters.remove(register);
                if (register == argumentLiveIntervals.getRegister() && argumentLiveIntervals.getType().isWide()) {
                    this.freeRegisters.remove(register + 1);
                }
                return false;
            } while ((argumentLiveIntervals = argumentLiveIntervals.getNextConsecutive()) != null && argumentLiveIntervals.usesRegister(register, intervals.getType().isWide()));
        }
        LiveIntervals overlapsInactiveIntervals = null;
        for (LiveIntervals inactiveIntervals : this.inactive) {
            if (!inactiveIntervals.usesRegister(register, intervals.getType().isWide()) || !intervals.overlaps(inactiveIntervals)) continue;
            overlapsInactiveIntervals = inactiveIntervals;
            break;
        }
        if (overlapsInactiveIntervals != null) {
            this.freeRegisters.remove(register);
            if (register == overlapsInactiveIntervals.getRegister() && overlapsInactiveIntervals.getType().isWide()) {
                this.freeRegisters.remove(register + 1);
            }
            return false;
        }
        boolean bl = overlapsMoveExceptionInterval = this.hasDedicatedMoveExceptionRegister() && (register == this.getMoveExceptionRegister() || intervals.getType().isWide() && register + 1 == this.getMoveExceptionRegister()) && this.overlapsMoveExceptionInterval(intervals);
        if (overlapsMoveExceptionInterval) {
            this.freeRegisters.remove(register);
            return false;
        }
        return true;
    }

    private int toInstructionPosition(int position) {
        return position % 2 == 0 ? position : position + 1;
    }

    private int toGapPosition(int position) {
        return position % 2 == 1 ? position : position - 1;
    }

    private boolean needsArrayGetWideWorkaround(LiveIntervals intervals) {
        if (this.options.canUseSameArrayAndResultRegisterInArrayGetWide()) {
            return false;
        }
        if (intervals.requiredRegisters() == 1) {
            return false;
        }
        if (intervals.getValue().isPhi()) {
            return false;
        }
        if (intervals.getSplitParent() != intervals) {
            return false;
        }
        Instruction definition = intervals.getValue().definition;
        return definition.isArrayGet() && definition.asArrayGet().outType().isWide();
    }

    private boolean isArrayGetArrayRegister(LiveIntervals intervals, int register) {
        assert (this.needsArrayGetWideWorkaround(intervals));
        Value array = intervals.getValue().definition.asArrayGet().array();
        int arrayReg = array.getLiveIntervals().getSplitCovering(intervals.getStart()).getRegister();
        assert (arrayReg != Integer.MIN_VALUE);
        return arrayReg == register;
    }

    private boolean needsSingleResultOverlappingLongOperandsWorkaround(LiveIntervals intervals) {
        if (!this.options.canHaveCmpLongBug()) {
            return false;
        }
        if (intervals.requiredRegisters() == 2) {
            return false;
        }
        if (intervals.getValue().isPhi()) {
            return false;
        }
        if (intervals.getSplitParent() != intervals) {
            return false;
        }
        Instruction definition = intervals.getValue().definition;
        return definition.isCmp() && definition.asCmp().inValues().get(0).outType().isWide();
    }

    private boolean singleOverlappingLong(int register1, int register2) {
        return register1 == register2 || register1 == register2 + 1;
    }

    private boolean isSingleResultOverlappingLongOperands(LiveIntervals intervals, int register) {
        assert (this.needsSingleResultOverlappingLongOperandsWorkaround(intervals));
        Value left = intervals.getValue().definition.asCmp().leftValue();
        Value right = intervals.getValue().definition.asCmp().rightValue();
        int leftReg = left.getLiveIntervals().getSplitCovering(intervals.getStart()).getRegister();
        int rightReg = right.getLiveIntervals().getSplitCovering(intervals.getStart()).getRegister();
        assert (leftReg != Integer.MIN_VALUE);
        assert (rightReg != Integer.MIN_VALUE);
        return this.singleOverlappingLong(register, leftReg) || this.singleOverlappingLong(register, rightReg);
    }

    private boolean needsLongResultOverlappingLongOperandsWorkaround(LiveIntervals intervals) {
        if (!this.options.canHaveOverlappingLongRegisterBug()) {
            return false;
        }
        if (intervals.requiredRegisters() == 1) {
            return false;
        }
        if (intervals.getValue().isPhi()) {
            return false;
        }
        if (intervals.getSplitParent() != intervals) {
            return false;
        }
        Instruction definition = intervals.getValue().definition;
        if (definition.isArithmeticBinop() && definition.asArithmeticBinop().getNumericType() == NumericType.LONG) {
            return definition instanceof Add || definition instanceof Sub;
        }
        if (definition.isLogicalBinop() && definition.asLogicalBinop().getNumericType() == NumericType.LONG) {
            return definition instanceof Or || definition instanceof Xor || definition instanceof And;
        }
        return false;
    }

    private boolean longHalfOverlappingLong(int register1, int register2) {
        return register1 == register2 + 1 || register1 + 1 == register2;
    }

    private boolean isLongResultOverlappingLongOperands(LiveIntervals unhandledInterval, int register) {
        assert (this.needsLongResultOverlappingLongOperandsWorkaround(unhandledInterval));
        Value left = unhandledInterval.getValue().definition.asBinop().leftValue();
        Value right = unhandledInterval.getValue().definition.asBinop().rightValue();
        int leftReg = left.getLiveIntervals().getSplitCovering(unhandledInterval.getStart()).getRegister();
        int rightReg = right.getLiveIntervals().getSplitCovering(unhandledInterval.getStart()).getRegister();
        assert (leftReg != Integer.MIN_VALUE && rightReg != Integer.MIN_VALUE);
        return this.longHalfOverlappingLong(register, leftReg) || this.longHalfOverlappingLong(register, rightReg);
    }

    private boolean overlapsMoveExceptionInterval(LiveIntervals intervals) {
        if (!this.hasDedicatedMoveExceptionRegister()) {
            return false;
        }
        if (this.moveExceptionIntervals.size() > 500) {
            return true;
        }
        for (LiveIntervals moveExceptionInterval : this.moveExceptionIntervals) {
            if (!intervals.anySplitOverlaps(moveExceptionInterval)) continue;
            return true;
        }
        return false;
    }

    private boolean allocateSingleInterval(LiveIntervals unhandledInterval, ArgumentReuseMode mode) {
        int moveExceptionRegister;
        boolean needsRegisterPair;
        int registerConstraint = unhandledInterval.getRegisterLimit();
        assert (registerConstraint <= 65535);
        assert (unhandledInterval.requiredRegisters() <= 2);
        boolean bl = needsRegisterPair = unhandledInterval.requiredRegisters() == 2;
        if (unhandledInterval.isArgumentInterval() && (registerConstraint == 65535 || mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT && registerConstraint == 255)) {
            int argumentRegister = unhandledInterval.getSplitParent().getRegister();
            this.assignFreeRegisterToUnhandledInterval(unhandledInterval, argumentRegister);
            return true;
        }
        if (registerConstraint < 65535 && (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT || mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U16BIT)) {
            registerConstraint += this.numberOfArgumentRegisters;
        }
        RegisterPositions freePositions = new RegisterPositions(registerConstraint + 1);
        if (this.options.debug && !this.code.method.accessFlags.isStatic()) {
            assert (this.numberOfArgumentRegisters > 0);
            assert (this.firstArgumentValue != null && this.firstArgumentValue.requiredRegisters() == 1);
            freePositions.set(0, 0);
        }
        if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT || mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U16BIT) {
            for (int i = 0; i < this.numberOfArgumentRegisters && i <= registerConstraint; ++i) {
                freePositions.set(i, 0);
            }
        }
        if (this.overlapsMoveExceptionInterval(unhandledInterval) && (moveExceptionRegister = this.getMoveExceptionRegister()) <= registerConstraint) {
            freePositions.set(moveExceptionRegister, 0);
        }
        for (LiveIntervals intervals : this.active) {
            int activeRegister = intervals.getRegister();
            if (activeRegister > registerConstraint) continue;
            for (int i = 0; i < intervals.requiredRegisters(); ++i) {
                if (activeRegister + i > registerConstraint) continue;
                freePositions.set(activeRegister + i, 0);
            }
        }
        for (LiveIntervals intervals : this.inactive) {
            int inactiveRegister = intervals.getRegister();
            if (inactiveRegister > registerConstraint || !unhandledInterval.overlaps(intervals)) continue;
            int nextOverlap = unhandledInterval.nextOverlap(intervals);
            for (int i = 0; i < intervals.requiredRegisters(); ++i) {
                int register = inactiveRegister + i;
                if (register > registerConstraint) continue;
                int unhandledStart = this.toInstructionPosition(unhandledInterval.getStart());
                if (nextOverlap == unhandledStart) {
                    freePositions.set(register, 0);
                    continue;
                }
                if (nextOverlap >= freePositions.get(register)) continue;
                freePositions.set(register, nextOverlap, intervals);
            }
        }
        assert (this.freePositionsAreConsistentWithFreeRegisters(freePositions, registerConstraint));
        if (this.useRegisterHint(unhandledInterval, registerConstraint, freePositions, needsRegisterPair)) {
            return true;
        }
        int candidate = this.getLargestValidCandidate(unhandledInterval, registerConstraint, needsRegisterPair, freePositions, RegisterPositions.Type.ANY);
        int largestFreePosition = 0;
        if (candidate != -1) {
            largestFreePosition = freePositions.get(candidate);
            if (needsRegisterPair) {
                largestFreePosition = Math.min(largestFreePosition, freePositions.get(candidate + 1));
            }
        }
        if (largestFreePosition == 0) {
            if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U4BIT) {
                return false;
            }
            if (!unhandledInterval.getUses().first().hasConstraint()) {
                int nextConstrainedPosition = unhandledInterval.firstUseWithConstraint().getPosition();
                int register = this.getSpillRegister(unhandledInterval, null);
                LiveIntervals split = unhandledInterval.splitBefore(nextConstrainedPosition);
                this.assignFreeRegisterToUnhandledInterval(unhandledInterval, register);
                this.unhandled.add(split);
            } else {
                this.allocateBlockedRegister(unhandledInterval);
            }
        } else {
            int candidateEnd = candidate + unhandledInterval.requiredRegisters() - 1;
            if (candidateEnd > this.maxRegisterNumber) {
                this.increaseCapacity(candidateEnd);
            }
            if (largestFreePosition >= unhandledInterval.getEnd()) {
                this.assignFreeRegisterToUnhandledInterval(unhandledInterval, candidate);
            } else {
                if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U4BIT) {
                    return false;
                }
                LiveIntervals split = unhandledInterval.splitBefore(largestFreePosition);
                assert (split != unhandledInterval);
                this.assignFreeRegisterToUnhandledInterval(unhandledInterval, candidate);
                this.unhandled.add(split);
            }
        }
        return true;
    }

    private boolean useRegisterHint(LiveIntervals unhandledInterval, int registerConstraint, RegisterPositions freePositions, boolean needsRegisterPair) {
        int register;
        LiveIntervals hint = unhandledInterval.getHint();
        if (hint != null && this.tryHint(unhandledInterval, registerConstraint, freePositions, needsRegisterPair, register = hint.getRegister())) {
            return true;
        }
        Value value = unhandledInterval.getValue();
        if (value.isPhi()) {
            Phi phi = value.asPhi();
            HashMultiset<Integer> map2 = HashMultiset.create();
            List<Value> operands = phi.getOperands();
            for (int i = 0; i < operands.size(); ++i) {
                int operandRegister;
                LiveIntervals intervals = operands.get(i).getLiveIntervals();
                if (intervals.hasSplits()) {
                    BasicBlock pred = phi.getBlock().getPredecessors().get(i);
                    intervals = intervals.getSplitCovering(pred.exit().getNumber());
                }
                if ((operandRegister = intervals.getRegister()) == Integer.MIN_VALUE) continue;
                map2.add(operandRegister);
            }
            for (Multiset.Entry entry : Multisets.copyHighestCountFirst(map2).entrySet()) {
                int register2 = (Integer)entry.getElement();
                if (!this.tryHint(unhandledInterval, registerConstraint, freePositions, needsRegisterPair, register2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryHint(LiveIntervals unhandledInterval, int registerConstraint, RegisterPositions freePositions, boolean needsRegisterPair, int register) {
        if (register == Integer.MIN_VALUE) {
            return false;
        }
        if (register + (needsRegisterPair ? 1 : 0) <= registerConstraint) {
            int freePosition = freePositions.get(register);
            if (needsRegisterPair) {
                freePosition = Math.min(freePosition, freePositions.get(register + 1));
            }
            if (freePosition >= unhandledInterval.getEnd()) {
                if (this.needsLongResultOverlappingLongOperandsWorkaround(unhandledInterval) && this.isLongResultOverlappingLongOperands(unhandledInterval, register)) {
                    return false;
                }
                if (this.needsArrayGetWideWorkaround(unhandledInterval) && this.isArrayGetArrayRegister(unhandledInterval, register)) {
                    return false;
                }
                this.assignFreeRegisterToUnhandledInterval(unhandledInterval, register);
                return true;
            }
        }
        return false;
    }

    private void assignRegister(LiveIntervals intervals, int register) {
        assert (register + intervals.requiredRegisters() - 1 <= this.maxRegisterNumber);
        intervals.setRegister(register);
        this.updateRegisterHints(intervals);
    }

    private void updateRegisterHints(LiveIntervals intervals) {
        LiveIntervals operandIntervals;
        Value value = intervals.getValue();
        for (Phi phi : value.uniquePhiUsers()) {
            LiveIntervals phiIntervals = phi.getLiveIntervals();
            if (phiIntervals.getHint() != null) continue;
            for (int i = 0; i < phi.getOperands().size(); ++i) {
                Value operand = phi.getOperand(i);
                operandIntervals = operand.getLiveIntervals();
                BasicBlock pred = phi.getBlock().getPredecessors().get(i);
                if ((operandIntervals = operandIntervals.getSplitCovering(pred.exit().getNumber())).getHint() != null) continue;
                operandIntervals.setHint(intervals);
            }
        }
        if (value.isPhi() && intervals.getSplitParent() == intervals) {
            Phi phi = value.asPhi();
            BasicBlock block = phi.getBlock();
            for (int i = 0; i < phi.getOperands().size(); ++i) {
                Value operand = phi.getOperand(i);
                BasicBlock pred = block.getPredecessors().get(i);
                operandIntervals = operand.getLiveIntervals().getSplitCovering(pred.exit().getNumber());
                operandIntervals.setHint(intervals);
            }
        }
    }

    private void assignFreeRegisterToUnhandledInterval(LiveIntervals unhandledInterval, int register) {
        this.assignRegister(unhandledInterval, register);
        this.takeFreeRegistersForIntervals(unhandledInterval);
        this.active.add(unhandledInterval);
    }

    private int getLargestCandidate(int registerConstraint, RegisterPositions freePositions, boolean needsRegisterPair, RegisterPositions.Type type) {
        int candidate = -1;
        int largest = -1;
        for (int i = 0; i <= registerConstraint; ++i) {
            if (!freePositions.hasType(i, type)) continue;
            int freePosition = freePositions.get(i);
            if (needsRegisterPair) {
                if (i == this.numberOfArgumentRegisters - 1) continue;
                if (i >= registerConstraint) break;
                freePosition = Math.min(freePosition, freePositions.get(i + 1));
            }
            if (freePosition <= largest) continue;
            candidate = i;
            largest = freePosition;
            if (largest == Integer.MAX_VALUE) break;
        }
        return candidate;
    }

    private int handleWorkaround(Predicate<LiveIntervals> workaroundNeeded, BiPredicate<LiveIntervals, Integer> workaroundNeededForCandidate, int candidate, LiveIntervals unhandledInterval, int registerConstraint, boolean needsRegisterPair, RegisterPositions freePositions, RegisterPositions.Type type) {
        if (workaroundNeeded.test(unhandledInterval)) {
            int lastCandidate = candidate;
            while (workaroundNeededForCandidate.test(unhandledInterval, candidate)) {
                freePositions.set(candidate, 0);
                candidate = this.getLargestCandidate(registerConstraint, freePositions, needsRegisterPair, type);
                if (lastCandidate == candidate) {
                    return -1;
                }
                lastCandidate = candidate;
            }
        }
        return candidate;
    }

    private int getLargestValidCandidate(LiveIntervals unhandledInterval, int registerConstraint, boolean needsRegisterPair, RegisterPositions freePositions, RegisterPositions.Type type) {
        int candidate = this.getLargestCandidate(registerConstraint, freePositions, needsRegisterPair, type);
        if (candidate == -1) {
            return candidate;
        }
        candidate = this.handleWorkaround(this::needsLongResultOverlappingLongOperandsWorkaround, this::isLongResultOverlappingLongOperands, candidate, unhandledInterval, registerConstraint, needsRegisterPair, freePositions, type);
        candidate = this.handleWorkaround(this::needsSingleResultOverlappingLongOperandsWorkaround, this::isSingleResultOverlappingLongOperands, candidate, unhandledInterval, registerConstraint, needsRegisterPair, freePositions, type);
        candidate = this.handleWorkaround(this::needsArrayGetWideWorkaround, this::isArrayGetArrayRegister, candidate, unhandledInterval, registerConstraint, needsRegisterPair, freePositions, type);
        return candidate;
    }

    private void allocateBlockedRegister(LiveIntervals unhandledInterval) {
        int i;
        int registerConstraint = unhandledInterval.getRegisterLimit();
        if (registerConstraint < 65535) {
            registerConstraint += this.numberOfArgumentRegisters;
        }
        RegisterPositions usePositions = new RegisterPositions(registerConstraint + 1);
        RegisterPositions blockedPositions = new RegisterPositions(registerConstraint + 1);
        for (LiveIntervals intervals : this.active) {
            int activeRegister = intervals.getRegister();
            if (activeRegister > registerConstraint) continue;
            for (i = 0; i < intervals.requiredRegisters(); ++i) {
                if (activeRegister + i > registerConstraint) continue;
                int unhandledStart = unhandledInterval.getStart();
                usePositions.set(activeRegister + i, intervals.firstUseAfter(unhandledStart), intervals);
            }
        }
        for (LiveIntervals intervals : this.inactive) {
            int inactiveRegister = intervals.getRegister();
            if (inactiveRegister > registerConstraint || !intervals.overlaps(unhandledInterval)) continue;
            for (i = 0; i < intervals.requiredRegisters(); ++i) {
                int firstUse;
                if (inactiveRegister + i > registerConstraint || (firstUse = intervals.firstUseAfter(unhandledInterval.getStart())) >= usePositions.get(inactiveRegister + i)) continue;
                usePositions.set(inactiveRegister + i, firstUse, intervals);
            }
        }
        for (int i2 = 0; i2 < this.numberOfArgumentRegisters; ++i2) {
            usePositions.set(i2, 0);
        }
        if (this.overlapsMoveExceptionInterval(unhandledInterval)) {
            usePositions.set(this.getMoveExceptionRegister(), 0);
        }
        this.blockLinkedRegisters(this.active, unhandledInterval, registerConstraint, usePositions, blockedPositions);
        this.blockLinkedRegisters(this.inactive, unhandledInterval, registerConstraint, usePositions, blockedPositions);
        boolean needsRegisterPair = unhandledInterval.getType().isWide();
        int candidate = this.getLargestValidCandidate(unhandledInterval, registerConstraint, needsRegisterPair, usePositions, RegisterPositions.Type.CONST_NUMBER);
        if (candidate != Integer.MAX_VALUE) {
            int otherCandidate = this.getLargestValidCandidate(unhandledInterval, registerConstraint, needsRegisterPair, usePositions, RegisterPositions.Type.OTHER);
            if (otherCandidate == Integer.MAX_VALUE || candidate == -1) {
                candidate = otherCandidate;
            } else {
                int largestConstUsePosition = this.getLargestPosition(usePositions, candidate, needsRegisterPair);
                if (largestConstUsePosition - 5 < unhandledInterval.getStart()) {
                    candidate = otherCandidate;
                }
            }
            if (candidate == -1) {
                candidate = this.getLargestValidCandidate(unhandledInterval, registerConstraint, needsRegisterPair, usePositions, RegisterPositions.Type.MONITOR);
            }
        }
        int largestUsePosition = this.getLargestPosition(usePositions, candidate, needsRegisterPair);
        int blockedPosition = this.getLargestPosition(blockedPositions, candidate, needsRegisterPair);
        if (largestUsePosition < unhandledInterval.getFirstUse()) {
            int splitPosition = unhandledInterval.getFirstUse();
            LiveIntervals split = unhandledInterval.splitBefore(splitPosition);
            assert (split != unhandledInterval);
            int registerNumber = this.getNewSpillRegister(unhandledInterval);
            this.assignFreeRegisterToUnhandledInterval(unhandledInterval, registerNumber);
            unhandledInterval.setSpilled(true);
            this.unhandled.add(split);
        } else {
            int candidateEnd = candidate + unhandledInterval.requiredRegisters() - 1;
            if (candidateEnd > this.maxRegisterNumber) {
                this.increaseCapacity(candidateEnd);
            }
            if (blockedPosition > unhandledInterval.getEnd()) {
                this.assignRegisterAndSpill(unhandledInterval, candidate, needsRegisterPair);
            } else {
                LiveIntervals splitChild = unhandledInterval.splitBefore(blockedPosition);
                this.unhandled.add(splitChild);
                this.assignRegisterAndSpill(unhandledInterval, candidate, needsRegisterPair);
            }
        }
    }

    private int getLargestPosition(RegisterPositions positions, int register, boolean needsRegisterPair) {
        int position = positions.get(register);
        if (needsRegisterPair) {
            return Math.min(position, positions.get(register + 1));
        }
        return position;
    }

    private void assignRegisterAndSpill(LiveIntervals unhandledInterval, int candidate, boolean candidateIsWide) {
        this.spillOverlappingActiveIntervals(unhandledInterval, candidate, candidateIsWide);
        this.assignRegister(unhandledInterval, candidate);
        this.takeFreeRegistersForIntervals(unhandledInterval);
        this.active.add(unhandledInterval);
        this.splitOverlappingInactiveIntervals(unhandledInterval, candidate, candidateIsWide);
    }

    protected void splitOverlappingInactiveIntervals(LiveIntervals unhandledInterval, int candidate, boolean candidateIsWide) {
        ArrayList<LiveIntervals> newInactive = new ArrayList<LiveIntervals>();
        Iterator<LiveIntervals> inactiveIterator = this.inactive.iterator();
        while (inactiveIterator.hasNext()) {
            int nextUsePosition;
            LiveIntervals intervals = inactiveIterator.next();
            if (!intervals.usesRegister(candidate, candidateIsWide) || !intervals.overlaps(unhandledInterval)) continue;
            if (intervals.isLinked() && !intervals.isArgumentInterval() && (nextUsePosition = intervals.firstUseAfter(unhandledInterval.getStart())) != Integer.MAX_VALUE) {
                LiveIntervals split = intervals.splitBefore(nextUsePosition);
                split.setRegister(intervals.getRegister());
                newInactive.add(split);
            }
            if (intervals.getStart() > unhandledInterval.getStart()) {
                intervals.clearRegisterAssignment();
                inactiveIterator.remove();
                this.unhandled.add(intervals);
                continue;
            }
            LiveIntervals split = intervals.splitBefore(unhandledInterval.getStart());
            this.unhandled.add(split);
        }
        this.inactive.addAll(newInactive);
    }

    private void spillOverlappingActiveIntervals(LiveIntervals unhandledInterval, int candidate, boolean candidateIsWide) {
        assert (unhandledInterval.getRegister() == Integer.MIN_VALUE);
        assert (this.atLeastOneOfRegistersAreTaken(candidate, candidateIsWide));
        IntArrayList excludedRegisters = new IntArrayList(candidateIsWide ? 2 : 1);
        excludedRegisters.add(candidate);
        if (candidateIsWide) {
            excludedRegisters.add(candidate + 1);
        }
        if (unhandledInterval.isArgumentInterval() && unhandledInterval != unhandledInterval.getSplitParent()) {
            unhandledInterval.getSplitParent().forEachRegister(excludedRegisters::add);
        }
        ArrayList<LiveIntervals> newActive = new ArrayList<LiveIntervals>();
        Iterator<LiveIntervals> activeIterator = this.active.iterator();
        while (activeIterator.hasNext()) {
            LiveIntervals intervals = activeIterator.next();
            assert (this.registersForIntervalsAreTaken(intervals));
            if (!intervals.usesRegister(candidate, candidateIsWide)) continue;
            activeIterator.remove();
            int registerNumber = this.getSpillRegister(intervals, excludedRegisters);
            this.freeOccupiedRegistersForIntervals(intervals);
            LiveIntervals splitChild = intervals.splitBefore(unhandledInterval.getStart());
            this.assignRegister(splitChild, registerNumber);
            splitChild.setSpilled(true);
            this.takeFreeRegistersForIntervals(splitChild);
            assert (splitChild.getRegister() != Integer.MIN_VALUE);
            assert (intervals.getRegister() != Integer.MIN_VALUE);
            newActive.add(splitChild);
            if (intervals.getValue().isConstNumber() && intervals.getStart() == intervals.getValue().definition.getNumber() && intervals.getUses().size() == 1) {
                intervals.setSpilled(true);
            }
            if (splitChild.getUses().size() <= 0) continue;
            if (splitChild.isLinked() && !splitChild.isArgumentInterval()) {
                LiveIntervals splitOfSplit = splitChild.splitBefore(splitChild.getFirstUse());
                splitOfSplit.setRegister(intervals.getRegister());
                this.inactive.add(splitOfSplit);
                continue;
            }
            if (intervals.getValue().isConstNumber()) {
                this.splitRangesForSpilledConstant(splitChild, registerNumber);
                continue;
            }
            if (intervals.isArgumentInterval()) {
                this.splitRangesForSpilledArgument(splitChild);
                continue;
            }
            this.splitRangesForSpilledInterval(splitChild, registerNumber);
        }
        this.active.addAll(newActive);
        assert (this.registersAreFree(candidate, candidateIsWide));
    }

    private void splitRangesForSpilledArgument(LiveIntervals spilled) {
        assert (spilled.isSpilled());
        assert (spilled.isArgumentInterval());
        if (!spilled.getUses().isEmpty()) {
            LiveIntervals split = spilled.splitBefore(spilled.getUses().first().getPosition());
            this.unhandled.add(split);
        }
    }

    private void splitRangesForSpilledInterval(LiveIntervals spilled, int registerNumber) {
        boolean isSpillingToArgumentRegister;
        assert (spilled.isSpilled());
        assert (!spilled.getValue().isConstNumber());
        assert (!spilled.isLinked() || spilled.isArgumentInterval());
        boolean bl = isSpillingToArgumentRegister = spilled.isArgumentInterval() || registerNumber < this.numberOfArgumentRegisters;
        if (isSpillingToArgumentRegister) {
            registerNumber = this.mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE_U8BIT ? 255 : 65535;
        }
        LiveIntervalsUse firstUseWithLowerLimit = null;
        boolean hasUsesBeforeFirstUseWithLowerLimit = false;
        for (LiveIntervalsUse use2 : spilled.getUses()) {
            if (registerNumber > use2.getLimit()) {
                firstUseWithLowerLimit = use2;
                break;
            }
            hasUsesBeforeFirstUseWithLowerLimit = true;
        }
        if (hasUsesBeforeFirstUseWithLowerLimit) {
            spilled.setSpilled(false);
        }
        if (firstUseWithLowerLimit != null) {
            LiveIntervals splitOfSplit = spilled.splitBefore(firstUseWithLowerLimit.getPosition());
            this.unhandled.add(splitOfSplit);
        }
    }

    private void splitRangesForSpilledConstant(LiveIntervals spilled, int spillRegister) {
        assert (spilled.isSpilled());
        assert (spilled.getValue().isConstNumber());
        assert (!spilled.isLinked() || spilled.isArgumentInterval());
        int maxGapSize = 22;
        if (!spilled.getUses().isEmpty()) {
            LiveIntervals split = spilled.splitBefore(spilled.getFirstUse());
            this.unhandled.add(split);
            boolean changed = true;
            block0: while (changed) {
                changed = false;
                int previousUse = split.getStart();
                for (LiveIntervalsUse use2 : split.getUses()) {
                    if (use2.getPosition() - previousUse > maxGapSize) {
                        split = split.splitBefore(previousUse + 2);
                        if (this.toGapPosition(use2.getPosition()) > split.getStart()) {
                            this.assignRegister(split, spillRegister);
                            split.setSpilled(true);
                            this.inactive.add(split);
                            split = split.splitBefore(use2.getPosition());
                        }
                        this.unhandled.add(split);
                        changed = true;
                        continue block0;
                    }
                    previousUse = use2.getPosition();
                }
            }
        }
    }

    private void blockLinkedRegisters(List<LiveIntervals> intervalsList, LiveIntervals interval, int registerConstraint, RegisterPositions usePositions, RegisterPositions blockedPositions) {
        for (LiveIntervals other : intervalsList) {
            int register;
            if (!other.isLinked() || (register = other.getRegister()) > registerConstraint || !other.overlaps(interval)) continue;
            for (int i = 0; i < other.requiredRegisters(); ++i) {
                int firstUse;
                if (register + i > registerConstraint || (firstUse = other.firstUseAfter(interval.getStart())) >= blockedPositions.get(register + i)) continue;
                blockedPositions.set(register + i, firstUse, other);
                assert (usePositions.get(register + i) <= blockedPositions.get(register + i));
            }
        }
    }

    private void insertMoves() {
        this.computeRematerializableBits();
        SpillMoveSet spillMoves = new SpillMoveSet(this, this.code);
        for (LiveIntervals intervals : this.liveIntervals) {
            if (!intervals.hasSplits()) continue;
            LiveIntervals current = intervals;
            PriorityQueue<LiveIntervals> sortedChildren = new PriorityQueue<LiveIntervals>();
            sortedChildren.addAll(current.getSplitChildren());
            LiveIntervals split = (LiveIntervals)sortedChildren.poll();
            while (split != null) {
                int position = split.getStart();
                spillMoves.addSpillOrRestoreMove(this.toGapPosition(position), split, current);
                current = split;
                split = (LiveIntervals)sortedChildren.poll();
            }
        }
        this.resolveControlFlow(spillMoves);
        this.firstParallelMoveTemporary = this.maxRegisterNumber + 1;
        this.maxRegisterNumber += spillMoves.scheduleAndInsertMoves(this.maxRegisterNumber + 1);
    }

    private void computeRematerializableBits() {
        for (LiveIntervals liveInterval : this.liveIntervals) {
            liveInterval.computeRematerializable(this);
        }
    }

    private void resolveControlFlow(SpillMoveSet spillMoves) {
        for (BasicBlock block : this.code.blocks) {
            for (BasicBlock successor : block.getSuccessors()) {
                int fromInstruction = block.exit().getNumber();
                boolean isCatch = block.hasCatchSuccessor(successor);
                if (isCatch) {
                    for (Instruction instruction : block.getInstructions()) {
                        if (!instruction.instructionTypeCanThrow()) continue;
                        fromInstruction = instruction.getNumber();
                        break;
                    }
                }
                int toInstruction = successor.entry().getNumber();
                Set<Value> liveAtEntry = this.liveAtEntrySets.get((Object)successor).liveValues;
                for (Value value : liveAtEntry) {
                    LiveIntervals toIntervals;
                    LiveIntervals parentInterval = value.getLiveIntervals();
                    LiveIntervals fromIntervals = parentInterval.getSplitCovering(fromInstruction);
                    if (fromIntervals == (toIntervals = parentInterval.getSplitCovering(toInstruction))) continue;
                    if (block.exit().isGoto() && !isCatch) {
                        spillMoves.addOutResolutionMove(fromInstruction - 1, toIntervals, fromIntervals);
                        continue;
                    }
                    if (successor.entry().isMoveException()) {
                        spillMoves.addInResolutionMove(toInstruction + 1, toIntervals, fromIntervals);
                        continue;
                    }
                    spillMoves.addInResolutionMove(toInstruction - 1, toIntervals, fromIntervals);
                }
                int predIndex = successor.getPredecessors().indexOf(block);
                for (Phi phi : successor.getPhis()) {
                    LiveIntervals toIntervals = phi.getLiveIntervals().getSplitCovering(toInstruction);
                    Value operand = phi.getOperand(predIndex);
                    LiveIntervals fromIntervals = operand.getLiveIntervals().getSplitCovering(fromInstruction);
                    if (fromIntervals == toIntervals || toIntervals.isArgumentInterval()) continue;
                    assert (block.getSuccessors().size() == 1);
                    spillMoves.addPhiMove(fromInstruction - 1, toIntervals, fromIntervals);
                }
            }
        }
    }

    private static void addLiveRange(Value value, BasicBlock block, int end, List<LiveIntervals> liveIntervals, InternalOptions options) {
        int instructionNumber;
        int firstInstructionInBlock = block.entry().getNumber();
        int instructionsSize = block.getInstructions().size() * 2;
        int lastInstructionInBlock = firstInstructionInBlock + instructionsSize - 2;
        if (value.isPhi()) {
            instructionNumber = firstInstructionInBlock;
        } else {
            Instruction instruction = value.definition;
            instructionNumber = instruction.getNumber();
        }
        if (value.getLiveIntervals() == null) {
            Value current = value.getStartOfConsecutive();
            LiveIntervals intervals = new LiveIntervals(current);
            while (true) {
                liveIntervals.add(intervals);
                Value next = current.getNextConsecutive();
                if (next == null) break;
                LiveIntervals nextIntervals = new LiveIntervals(next);
                intervals.link(nextIntervals);
                current = next;
                intervals = nextIntervals;
            }
        }
        LiveIntervals intervals = value.getLiveIntervals();
        if (firstInstructionInBlock <= instructionNumber && instructionNumber <= lastInstructionInBlock) {
            if (value.isPhi()) {
                --instructionNumber;
            }
            intervals.addRange(new LiveRange(instructionNumber, end));
            assert (LinearScanRegisterAllocator.unconstrainedForCf(intervals.getRegisterLimit(), options));
            if (options.isGeneratingDex() && !value.isPhi()) {
                int constraint = value.definition.maxOutValueRegister();
                intervals.addUse(new LiveIntervalsUse(instructionNumber, constraint));
            }
        } else {
            intervals.addRange(new LiveRange(firstInstructionInBlock - 1, end));
        }
    }

    private void computeLiveRanges() {
        LinearScanRegisterAllocator.computeLiveRanges(this.options, this.code, this.liveAtEntrySets, this.liveIntervals);
        if ((this.options.canHaveThisTypeVerifierBug() || this.options.canHaveThisJitCodeDebuggingBug()) && !this.code.method.accessFlags.isStatic()) {
            for (Instruction instruction : this.code.blocks.get(0).getInstructions()) {
                if (!instruction.isArgument() || !instruction.outValue().isThis()) continue;
                Value thisValue = instruction.outValue();
                LiveIntervals thisIntervals = thisValue.getLiveIntervals();
                thisIntervals.getRanges().clear();
                thisIntervals.addRange(new LiveRange(0, this.code.getNextInstructionNumber()));
                for (IRCode.LiveAtEntrySets values2 : this.liveAtEntrySets.values()) {
                    values2.liveValues.add(thisValue);
                }
                return;
            }
        }
    }

    public static void computeLiveRanges(InternalOptions options, IRCode code, Map<BasicBlock, IRCode.LiveAtEntrySets> liveAtEntrySets, List<LiveIntervals> liveIntervals) {
        for (BasicBlock block : code.topologicallySortedBlocks()) {
            HashSet<Value> live = new HashSet<Value>();
            List<BasicBlock> successors = block.getSuccessors();
            HashSet<Value> phiOperands = new HashSet<Value>();
            HashSet<Value> exceptionalPhiOperands = new HashSet<Value>();
            HashSet<Value> liveAtThrowingInstruction = new HashSet<Value>();
            Set<BasicBlock> exceptionalSuccessors = block.getCatchHandlers().getUniqueTargets();
            for (BasicBlock basicBlock : successors) {
                boolean isExceptionalSuccessor = exceptionalSuccessors.contains(basicBlock);
                if (isExceptionalSuccessor && options.isGeneratingDex()) {
                    liveAtThrowingInstruction.addAll(liveAtEntrySets.get((Object)basicBlock).liveValues);
                } else {
                    live.addAll(liveAtEntrySets.get((Object)basicBlock).liveValues);
                }
                for (Phi phi : basicBlock.getPhis()) {
                    live.remove(phi);
                    if (isExceptionalSuccessor && options.isGeneratingDex()) {
                        exceptionalPhiOperands.add(phi.getOperand(basicBlock.getPhis().indexOf(block)));
                        continue;
                    }
                    phiOperands.add(phi.getOperand(basicBlock.getPredecessors().indexOf(block)));
                }
            }
            live.addAll(phiOperands);
            LinkedList<Instruction> instructions = block.getInstructions();
            for (Value value : live) {
                int end = block.entry().getNumber() + instructions.size() * 2;
                if (phiOperands.contains(value)) {
                    --end;
                }
                LinearScanRegisterAllocator.addLiveRange(value, block, end, liveIntervals, options);
            }
            ListIterator<Instruction> listIterator = block.getInstructions().listIterator(block.getInstructions().size());
            while (listIterator.hasPrevious()) {
                Instruction instruction = listIterator.previous();
                Value definition = instruction.outValue();
                if (definition != null) {
                    if (!definition.isUsed()) {
                        LinearScanRegisterAllocator.addLiveRange(definition, block, instruction.getNumber() + 2, liveIntervals, options);
                        assert (!options.isGeneratingClassFiles() || instruction.isArgument()) : "Arguments should be the only potentially unused local in CF";
                    }
                    live.remove(definition);
                }
                for (Value use2 : instruction.inValues()) {
                    if (!use2.needsRegister()) continue;
                    assert (LinearScanRegisterAllocator.unconstrainedForCf(instruction.maxInValueRegister(), options));
                    if (!live.contains(use2)) {
                        live.add(use2);
                        LinearScanRegisterAllocator.addLiveRange(use2, block, instruction.getNumber(), liveIntervals, options);
                    }
                    if (!options.isGeneratingDex()) continue;
                    int inConstraint = instruction.maxInValueRegister();
                    LiveIntervals useIntervals = use2.getLiveIntervals();
                    boolean isUnconstrainedArgumentUse = use2.isArgument() && inConstraint == 65535;
                    if (isUnconstrainedArgumentUse) continue;
                    useIntervals.addUse(new LiveIntervalsUse(instruction.getNumber(), inConstraint));
                }
                if (instruction.instructionTypeCanThrow()) {
                    for (Value use2 : liveAtThrowingInstruction) {
                        if (!use2.needsRegister() || live.contains(use2)) continue;
                        live.add(use2);
                        LinearScanRegisterAllocator.addLiveRange(use2, block, LinearScanRegisterAllocator.getLiveRangeEndOnExceptionalFlow(instruction, use2), liveIntervals, options);
                    }
                    for (Value operand : exceptionalPhiOperands) {
                        if (live.contains(operand)) continue;
                        live.add(operand);
                        LinearScanRegisterAllocator.addLiveRange(operand, block, LinearScanRegisterAllocator.getLiveRangeEndOnExceptionalFlow(instruction, operand), liveIntervals, options);
                    }
                }
                if (!options.debug) continue;
                int number = instruction.getNumber();
                for (Value use3 : instruction.getDebugValues()) {
                    assert (use3.needsRegister());
                    if (live.contains(use3)) continue;
                    live.add(use3);
                    LinearScanRegisterAllocator.addLiveRange(use3, block, number, liveIntervals, options);
                }
            }
        }
    }

    private static int getLiveRangeEndOnExceptionalFlow(Instruction instruction, Value value) {
        int end = instruction.getNumber();
        if (instruction.isCheckCast() && value != instruction.asCheckCast().object()) {
            end += 2;
        }
        return end;
    }

    private static boolean unconstrainedForCf(int constraint, InternalOptions options) {
        return !options.isGeneratingClassFiles() || constraint == 65535;
    }

    private void clearUserInfo() {
        this.code.blocks.forEach(BasicBlock::clearUserInfo);
    }

    private void transformBridgeMethod() {
        assert (LinearScanRegisterAllocator.implementationIsBridge(this.code));
        BasicBlock entry = this.code.blocks.getFirst();
        InstructionListIterator iterator2 = entry.listIterator();
        Reference2IntArrayMap<Value> argumentIndices = new Reference2IntArrayMap<Value>();
        while (iterator2.peekNext().isArgument()) {
            Value argument = ((Instruction)iterator2.next()).asArgument().outValue();
            argumentIndices.put(argument, argumentIndices.size());
        }
        while (!iterator2.peekNext().isInvoke()) {
            iterator2.next();
        }
        Invoke invokeInstruction = iterator2.peekNext().asInvoke();
        int numberOfRequiredRegisters = this.numberOfArgumentRegisters;
        if (invokeInstruction.outValue() != null) {
            numberOfRequiredRegisters += invokeInstruction.outValue().requiredRegisters();
        }
        if (numberOfRequiredRegisters - 1 > 255) {
            return;
        }
        List<Value> arguments = invokeInstruction.arguments();
        if (arguments.size() >= 1) {
            int previousArgumentIndex = -1;
            for (int i = 0; i < arguments.size(); ++i) {
                Value current = arguments.get(i);
                if (!current.isArgument()) {
                    current = current.definition.asCheckCast().object();
                }
                assert (current.isArgument());
                int currentArgumentIndex = argumentIndices.getInt(current);
                if (previousArgumentIndex >= 0 && currentArgumentIndex != previousArgumentIndex + 1) {
                    return;
                }
                previousArgumentIndex = currentArgumentIndex;
            }
        } else {
            return;
        }
        while (iterator2.peekPrevious().isCheckCast()) {
            CheckCast castInstruction = ((Instruction)iterator2.previous()).asCheckCast();
            castInstruction.outValue().replaceUsers(castInstruction.object());
            castInstruction.setOutValue(null);
        }
    }

    private static boolean implementationIsBridge(IRCode code) {
        if (code.blocks.size() > 1) {
            return false;
        }
        InstructionListIterator iterator2 = code.blocks.getFirst().listIterator();
        while (iterator2.hasNext() && iterator2.peekNext().isArgument()) {
            iterator2.next();
        }
        while (iterator2.hasNext() && iterator2.peekNext().isCheckCast() && iterator2.peekNext().asCheckCast().object().isArgument()) {
            iterator2.next();
        }
        if (!iterator2.hasNext() || !((Instruction)iterator2.next()).isInvoke()) {
            return false;
        }
        if (iterator2.hasNext() && iterator2.peekNext().isCheckCast()) {
            iterator2.next();
        }
        return iterator2.hasNext() && ((Instruction)iterator2.next()).isReturn();
    }

    private Value createValue(ValueType type) {
        Value value = this.code.createValue(type, null);
        value.setNeedsRegister(true);
        return value;
    }

    private void replaceArgument(Invoke invoke, int index, Value newArgument) {
        Value argument = invoke.arguments().get(index);
        invoke.arguments().set(index, newArgument);
        argument.removeUser(invoke);
        newArgument.addUser(invoke);
    }

    private void generateArgumentMoves(Invoke invoke, InstructionListIterator insertAt) {
        if (invoke.requiredArgumentRegisters() > 5 && !this.argumentsAreAlreadyLinked(invoke)) {
            List<Value> arguments = invoke.arguments();
            Value previous = null;
            PriorityQueue<Move> insertAtDefinition = null;
            if (invoke.requiredArgumentRegisters() > 16) {
                insertAtDefinition = new PriorityQueue<Move>((x, y) -> x.src().definition.getNumber() - y.src().definition.getNumber());
                BasicBlock block = invoke.getBlock();
                if (block.entry().getNumber() == -1) {
                    block.numberInstructions(0);
                }
            }
            for (int i = 0; i < arguments.size(); ++i) {
                Value argument;
                Value newArgument = argument = arguments.get(i);
                if (argument.definition == null || !argument.definition.isMove() || argument.isLinked() || argument == previous || argument.hasRegisterConstraint()) {
                    boolean argumentIsDefinedInSameBlock;
                    newArgument = this.createValue(argument.outType());
                    Move move = new Move(newArgument, argument);
                    move.setBlock(invoke.getBlock());
                    this.replaceArgument(invoke, i, newArgument);
                    boolean bl = argumentIsDefinedInSameBlock = argument.definition != null && argument.definition.getBlock() == invoke.getBlock();
                    if (invoke.requiredArgumentRegisters() > 16 && argumentIsDefinedInSameBlock) {
                        assert (move.src().definition.getNumber() >= 0);
                        insertAtDefinition.add(move);
                        move.setPosition(argument.definition.getPosition());
                    } else {
                        insertAt.add(move);
                        move.setPosition(invoke.getPosition());
                    }
                }
                if (previous != null) {
                    previous.linkTo(newArgument);
                }
                previous = newArgument;
            }
            if (insertAtDefinition != null && !insertAtDefinition.isEmpty()) {
                this.generateArgumentMovesAtDefinitions(invoke, insertAtDefinition, insertAt);
            }
        }
    }

    private void generateArgumentMovesAtDefinitions(Invoke invoke, PriorityQueue<Move> insertAtDefinition, InstructionListIterator insertAt) {
        Instruction previousDefinition;
        Move move = insertAtDefinition.poll();
        Instruction instruction = previousDefinition = move.src().isArgument() ? this.lastArgumentValue.definition : move.src().definition;
        while (insertAt.peekPrevious() != previousDefinition) {
            insertAt.previous();
        }
        insertAt.add(move);
        while (!insertAtDefinition.isEmpty()) {
            Instruction currentDefinition;
            move = insertAtDefinition.poll();
            Instruction instruction2 = currentDefinition = move.src().isArgument() ? this.lastArgumentValue.definition : move.src().definition;
            assert (currentDefinition.getNumber() >= previousDefinition.getNumber());
            if (currentDefinition.getNumber() > previousDefinition.getNumber()) {
                while (insertAt.peekPrevious() != currentDefinition) {
                    insertAt.next();
                }
            }
            insertAt.add(move);
            previousDefinition = currentDefinition;
        }
        while (insertAt.peekNext() != invoke) {
            insertAt.next();
        }
    }

    private boolean argumentsAreAlreadyLinked(Invoke invoke) {
        Iterator<Value> it = invoke.arguments().iterator();
        Value current = it.next();
        while (it.hasNext()) {
            Value next = it.next();
            if (!current.isLinked() || current.getNextConsecutive() != next) {
                return false;
            }
            current = next;
        }
        return true;
    }

    private void createArgumentLiveIntervals(List<Value> arguments) {
        int index = 0;
        for (Value argument : arguments) {
            LiveIntervals argumentInterval = new LiveIntervals(argument);
            argumentInterval.addRange(new LiveRange(0, index));
            this.liveIntervals.add(argumentInterval);
            index += 2;
        }
    }

    private void linkArgumentValuesAndIntervals(List<Value> arguments) {
        if (!arguments.isEmpty()) {
            Value last = this.firstArgumentValue = arguments.get(0);
            for (int i = 1; i < arguments.size(); ++i) {
                Value next = arguments.get(i);
                last.linkTo(next);
                last.getLiveIntervals().link(next.getLiveIntervals());
                last = next;
            }
            this.lastArgumentValue = last;
        }
    }

    private void constrainArgumentIntervals() {
        List<Value> arguments = this.code.collectArguments();
        this.createArgumentLiveIntervals(arguments);
        this.linkArgumentValuesAndIntervals(arguments);
    }

    private void insertRangeInvokeMoves() {
        for (BasicBlock block : this.code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isInvoke()) continue;
                it.previous();
                this.generateArgumentMoves(instruction.asInvoke(), it);
                it.next();
            }
        }
    }

    private void computeNeedsRegister() {
        for (BasicBlock block : this.code.topologicallySortedBlocks()) {
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.outValue() == null) continue;
                instruction.outValue().computeNeedsRegister();
            }
        }
    }

    private void pinArgumentRegisters() {
        if (this.firstArgumentValue != null) {
            this.increaseCapacity(this.numberOfArgumentRegisters - 1, true);
            int register = 0;
            for (Value current = this.firstArgumentValue; current != null; current = current.getNextConsecutive()) {
                LiveIntervals argumentLiveInterval = current.getLiveIntervals();
                this.assignRegister(argumentLiveInterval, register);
                register += current.requiredRegisters();
            }
        }
    }

    private void increaseCapacity(int newMaxRegisterNumber) {
        this.increaseCapacity(newMaxRegisterNumber, false);
    }

    private void increaseCapacity(int newMaxRegisterNumber, boolean takeRegisters) {
        if (!takeRegisters) {
            for (int register = this.maxRegisterNumber + 1; register <= newMaxRegisterNumber; ++register) {
                this.freeRegisters.add(register);
            }
        }
        this.maxRegisterNumber = newMaxRegisterNumber;
    }

    private int getFreeConsecutiveRegisters(int numberOfRegisters) {
        return this.getFreeConsecutiveRegisters(numberOfRegisters, false);
    }

    private int getFreeConsecutiveRegisters(int numberOfRegisters, boolean prioritizeSmallRegisters) {
        int first;
        int oldMaxRegisterNumber = this.maxRegisterNumber;
        TreeSet<Integer> freeRegistersWithDesiredOrdering = this.freeRegisters;
        if (prioritizeSmallRegisters) {
            freeRegistersWithDesiredOrdering = new TreeSet((x, y) -> {
                boolean yIsArgument;
                boolean xIsArgument = x < this.numberOfArgumentRegisters;
                boolean bl = yIsArgument = y < this.numberOfArgumentRegisters;
                if (xIsArgument && !yIsArgument) {
                    return 1;
                }
                if (!xIsArgument && yIsArgument) {
                    return -1;
                }
                return x - y;
            });
            freeRegistersWithDesiredOrdering.addAll(this.freeRegisters);
        }
        Iterator<Integer> freeRegistersIterator = freeRegistersWithDesiredOrdering.iterator();
        int current = first = this.getNextFreeRegister(freeRegistersIterator);
        block0: while (current - first + 1 != numberOfRegisters) {
            for (int i = 0; i < numberOfRegisters - 1; ++i) {
                int next = this.getNextFreeRegister(freeRegistersIterator);
                if (next != current + 1 || next == this.numberOfArgumentRegisters) {
                    current = first = next;
                    continue block0;
                }
                ++current;
            }
        }
        for (int register = oldMaxRegisterNumber + 1; register <= this.maxRegisterNumber; ++register) {
            boolean wasAdded = this.freeRegisters.add(register);
            assert (wasAdded);
        }
        assert (first < this.numberOfArgumentRegisters && first + numberOfRegisters - 1 < this.numberOfArgumentRegisters || first >= this.numberOfArgumentRegisters && first + numberOfRegisters - 1 >= this.numberOfArgumentRegisters);
        return first;
    }

    private boolean registersAreFreeAndConsecutive(int register, boolean registerIsWide) {
        if (!this.freeRegisters.contains(register)) {
            return false;
        }
        if (registerIsWide) {
            if (!this.freeRegisters.contains(register + 1)) {
                return false;
            }
            if (register == this.numberOfArgumentRegisters - 1) {
                return false;
            }
        }
        return true;
    }

    private int getNextFreeRegister(Iterator<Integer> freeRegistersIterator) {
        if (freeRegistersIterator.hasNext()) {
            return freeRegistersIterator.next();
        }
        return ++this.maxRegisterNumber;
    }

    private void excludeRegistersForInterval(LiveIntervals intervals, IntSet excluded) {
        LiveIntervals parent;
        int register = intervals.getRegister();
        assert (register != Integer.MIN_VALUE);
        for (int i = 0; i < intervals.requiredRegisters(); ++i) {
            if (!this.freeRegisters.remove(register + i)) continue;
            excluded.add(register + i);
        }
        if (intervals.isArgumentInterval() && intervals != intervals.getSplitParent() && (parent = intervals.getSplitParent()).getRegister() != register) {
            this.excludeRegistersForInterval(parent, excluded);
        }
    }

    private void freeOccupiedRegistersForIntervals(LiveIntervals intervals) {
        LiveIntervals parent;
        assert (this.registersForIntervalsAreTaken(intervals));
        int register = intervals.getRegister();
        assert (register + intervals.requiredRegisters() - 1 <= this.maxRegisterNumber);
        this.freeRegisters.add(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.add(register + 1);
        }
        if (intervals.isArgumentInterval() && intervals != intervals.getSplitParent() && (parent = intervals.getSplitParent()).getRegister() != intervals.getRegister()) {
            this.freeOccupiedRegistersForIntervals(intervals.getSplitParent());
        }
    }

    private void takeFreeRegisters(int register, boolean isWide) {
        assert (this.registersAreFree(register, isWide));
        this.freeRegisters.remove(register);
        if (isWide) {
            this.freeRegisters.remove(register + 1);
        }
    }

    private void takeFreeRegistersForIntervals(LiveIntervals intervals) {
        LiveIntervals parent;
        this.takeFreeRegisters(intervals.getRegister(), intervals.getType().isWide());
        if (intervals.isArgumentInterval() && intervals != intervals.getSplitParent() && (parent = intervals.getSplitParent()).getRegister() != intervals.getRegister()) {
            this.takeFreeRegistersForIntervals(parent);
        }
    }

    private boolean registerIsFree(int register) {
        return this.freeRegisters.contains(register) || this.hasDedicatedMoveExceptionRegister() && register == this.getMoveExceptionRegister();
    }

    private boolean registersAreFree(int register, boolean isWide) {
        return this.registerIsFree(register) && (!isWide || this.registerIsFree(register + 1));
    }

    private boolean registersAreTaken(int register, boolean isWide) {
        return !this.freeRegisters.contains(register) && (!isWide || !this.freeRegisters.contains(register + 1));
    }

    private boolean registersForIntervalsAreTaken(LiveIntervals intervals) {
        assert (intervals.getRegister() != Integer.MIN_VALUE);
        return this.registersAreTaken(intervals.getRegister(), intervals.getType().isWide());
    }

    private boolean atLeastOneOfRegistersAreTaken(int register, boolean isWide) {
        return !this.freeRegisters.contains(register) || isWide && !this.freeRegisters.contains(register + 1);
    }

    private boolean noLinkedValues() {
        for (BasicBlock block : this.code.blocks) {
            for (Phi phi : block.getPhis()) {
                assert (phi.getNextConsecutive() == null);
            }
            for (Instruction instruction : block.getInstructions()) {
                for (Value value : instruction.inValues()) {
                    assert (value.getNextConsecutive() == null);
                }
                assert (instruction.outValue() == null || instruction.outValue().getNextConsecutive() == null);
            }
        }
        return true;
    }

    public String toString() {
        Value value;
        StringBuilder builder = new StringBuilder("Live ranges:\n");
        for (LiveIntervals intervals : this.liveIntervals) {
            value = intervals.getValue();
            builder.append(value);
            builder.append(" ");
            builder.append(intervals);
        }
        builder.append("\nLive range ascii art: \n");
        for (LiveIntervals intervals : this.liveIntervals) {
            value = intervals.getValue();
            if (intervals.getRegister() == Integer.MIN_VALUE) {
                StringUtils.appendRightPadded(builder, value + " (no reg): ", 20);
            } else {
                StringUtils.appendRightPadded(builder, value + " r" + intervals.getRegister() + ": ", 20);
            }
            builder.append("|");
            builder.append(intervals.toAscciArtString());
            builder.append("\n");
        }
        return builder.toString();
    }

    private static class LocalRange
    implements Comparable<LocalRange> {
        final Value value;
        final DebugLocalInfo local;
        final int register;
        final int start;
        final int end;

        LocalRange(Value value, int register, int start, int end) {
            assert (value.hasLocalInfo());
            this.value = value;
            this.local = value.getLocalInfo();
            this.register = register;
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(LocalRange o) {
            return this.start != o.start ? Integer.compare(this.start, o.start) : Integer.compare(this.end, o.end);
        }

        public String toString() {
            return this.local + " @ r" + this.register + ": " + new LiveRange(this.start, this.end);
        }
    }

    private static enum ArgumentReuseMode {
        ALLOW_ARGUMENT_REUSE_U4BIT,
        ALLOW_ARGUMENT_REUSE_U8BIT,
        ALLOW_ARGUMENT_REUSE_U16BIT;

    }
}

