/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;

public class StackValue
extends Value {
    private final int height;
    private final DexType objectType;

    private StackValue(DexType objectType, TypeLatticeElement typeLattice, int height) {
        super(-1, typeLattice, null);
        this.height = height;
        this.objectType = objectType;
        assert (height >= 0);
    }

    public static StackValue forObjectType(DexType type, int height) {
        assert (DexItemFactory.nullValueType == type || type.isClassType() || type.isArrayType());
        return new StackValue(type, TypeLatticeElement.fromDexType(type), height);
    }

    public static StackValue forNonObjectType(ValueType valueType, int height) {
        assert (valueType.isPreciseType() && !valueType.isObject());
        return new StackValue(null, valueType.toTypeLattice(), height);
    }

    public int getHeight() {
        return this.height;
    }

    public DexType getObjectType() {
        assert (this.outType().isObject());
        return this.objectType;
    }

    @Override
    public boolean needsRegister() {
        return false;
    }

    @Override
    public void setNeedsRegister(boolean value) {
        assert (!value);
    }

    @Override
    public String toString() {
        return "s" + this.height;
    }
}

