/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.And;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.ArrayLength;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.Cmp;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstMethodHandle;
import com.android.tools.r8.ir.code.ConstMethodType;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DebugLocalRead;
import com.android.tools.r8.ir.code.DebugLocalUninitialized;
import com.android.tools.r8.ir.code.DebugLocalWrite;
import com.android.tools.r8.ir.code.DebugPosition;
import com.android.tools.r8.ir.code.Div;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.Mul;
import com.android.tools.r8.ir.code.Neg;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Not;
import com.android.tools.r8.ir.code.NumberConversion;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Or;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Rem;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Shl;
import com.android.tools.r8.ir.code.Shr;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Ushr;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class IRBuilder {
    private static final TypeLatticeElement INT = TypeLatticeElement.INT;
    private static final TypeLatticeElement FLOAT = TypeLatticeElement.FLOAT;
    private static final TypeLatticeElement LONG = TypeLatticeElement.LONG;
    private static final TypeLatticeElement DOUBLE = TypeLatticeElement.DOUBLE;
    private static final TypeLatticeElement NULL = TypeLatticeElement.NULL;
    public static final int INITIAL_BLOCK_OFFSET = -1;
    private final Int2ReferenceSortedMap<BlockInfo> targets = new Int2ReferenceAVLTreeMap<BlockInfo>();
    private final Reference2IntMap<BasicBlock> offsets = new Reference2IntOpenHashMap<BasicBlock>();
    private final Queue<Integer> traceBlocksWorklist = new LinkedList<Integer>();
    private boolean[] processedInstructions = null;
    private Set<Integer> processedSubroutineInstructions = null;
    private final Queue<WorklistItem> ssaWorklist = new LinkedList<WorklistItem>();
    private final LinkedList<BasicBlock> blocks = new LinkedList();
    private BasicBlock entryBlock = null;
    private BasicBlock currentBlock = null;
    private int currentInstructionOffset = -1;
    private final ValueNumberGenerator valueNumberGenerator;
    private final DexEncodedMethod method;
    private final AppInfo appInfo;
    private final Origin origin;
    private SourceCode source;
    private boolean throwingInstructionInCurrentBlock = false;
    private final InternalOptions options;
    private Value previousLocalValue = null;
    private final List<Value> debugLocalEnds = new ArrayList<Value>();
    private Int2ReferenceMap<List<Value>> uninitializedDebugLocalValues = null;
    private int nextBlockNumber = 0;
    private boolean hasImpreciseInstructionOutValueTypes = false;
    private boolean hasConstString = false;

    public DexItemFactory getFactory() {
        return this.options.itemFactory;
    }

    public IRBuilder(DexEncodedMethod method, AppInfo appInfo, SourceCode source, InternalOptions options, Origin origin) {
        this(method, appInfo, source, options, origin, new ValueNumberGenerator());
    }

    public IRBuilder(DexEncodedMethod method, AppInfo appInfo, SourceCode source, InternalOptions options, Origin origin, ValueNumberGenerator valueNumberGenerator) {
        assert (source != null);
        this.method = method;
        this.appInfo = appInfo;
        this.source = source;
        this.valueNumberGenerator = valueNumberGenerator != null ? valueNumberGenerator : new ValueNumberGenerator();
        this.options = options;
        this.origin = origin;
    }

    public boolean isGeneratingClassFiles() {
        return this.options.isGeneratingClassFiles();
    }

    public boolean isDebugMode() {
        return this.options.debug;
    }

    public Int2ReferenceSortedMap<BlockInfo> getCFG() {
        return this.targets;
    }

    public DexMethod getMethod() {
        return this.method.method;
    }

    private void addToWorklist(BasicBlock block, int firstInstructionIndex) {
        if (!block.isFilled()) {
            this.ssaWorklist.add(new WorklistItem(block, firstInstructionIndex));
        }
    }

    private void setCurrentBlock(BasicBlock block) {
        this.currentBlock = block;
    }

    public IRCode build() {
        assert (this.source != null);
        this.source.setUp();
        BlockInfo initialBlockInfo = new BlockInfo();
        this.targets.put(-1, initialBlockInfo);
        this.offsets.put(initialBlockInfo.block, -1);
        int instCount = this.source.instructionCount();
        this.processedInstructions = new boolean[instCount];
        this.traceBlocksWorklist.add(0);
        block0: while (!this.traceBlocksWorklist.isEmpty()) {
            int startOfBlockOffset = this.traceBlocksWorklist.remove();
            int startOfBlockIndex = this.source.instructionIndex(startOfBlockOffset);
            if (this.isIndexProcessed(startOfBlockIndex)) continue;
            for (int index = startOfBlockIndex; index < instCount; ++index) {
                int n;
                this.markIndexProcessed(index);
                int closedAt = this.source.traceInstruction(index, this);
                if (closedAt != -1) {
                    if (closedAt + 1 >= instCount) continue block0;
                    this.ensureBlockWithoutEnqueuing(this.source.instructionOffset(closedAt + 1));
                    continue block0;
                }
                if (index + 1 >= instCount || this.targets.get(n = this.source.instructionOffset(index + 1)) == null) continue;
                this.ensureNormalSuccessorBlock(startOfBlockOffset, n);
                continue block0;
            }
        }
        this.processedInstructions = null;
        this.setCurrentBlock(((BlockInfo)this.targets.get((int)-1)).block);
        this.entryBlock = this.currentBlock;
        this.source.buildPrelude(this);
        this.addToWorklist(this.currentBlock, 0);
        this.processWorklist();
        assert (this.currentBlock == null);
        assert (this.verifyFilledPredecessors());
        boolean hasDebugPositions = this.insertDebugPositions();
        if (this.uninitializedDebugLocalValues != null) {
            Position position = this.entryBlock.getPosition();
            InstructionListIterator it = this.entryBlock.listIterator();
            it.nextUntil(i -> !i.isArgument());
            it.previous();
            for (List list : this.uninitializedDebugLocalValues.values()) {
                for (Value value : list) {
                    if (!value.isUsed()) continue;
                    DebugLocalUninitialized def = new DebugLocalUninitialized(value);
                    def.setBlock(this.entryBlock);
                    def.setPosition(position);
                    it.add(def);
                }
            }
        }
        for (BasicBlock block : this.blocks) {
            block.clearCurrentDefinitions();
        }
        this.joinPredecessorsWithIdenticalPhis();
        IRCode ir = new IRCode(this.options, this.method, this.blocks, this.valueNumberGenerator, hasDebugPositions, this.hasConstString);
        assert (ir.verifySplitCriticalEdges());
        for (BasicBlock block : this.blocks) {
            block.deduplicatePhis();
        }
        ir.removeAllTrivialPhis();
        if (this.hasImpreciseTypes()) {
            TypeConstraintResolver resolver = new TypeConstraintResolver();
            resolver.resolve(ir, this);
        }
        assert (ir.isConsistentSSA());
        this.source.clear();
        this.source = null;
        return ir;
    }

    public void constrainType(Value value, ValueType constraint) {
        value.constrainType(constraint, this.method.method, this.origin, this.options.reporter);
    }

    private boolean hasImpreciseTypes() {
        if (this.hasImpreciseInstructionOutValueTypes) {
            return true;
        }
        for (BasicBlock block : this.blocks) {
            for (Phi phi : block.getPhis()) {
                if (phi.outType().isPreciseType()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean insertDebugPositions() {
        boolean hasDebugPositions = false;
        if (!this.options.debug) {
            return hasDebugPositions;
        }
        for (BasicBlock block : this.blocks) {
            InstructionListIterator it = block.listIterator();
            Position current = null;
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                Position position = instruction.getPosition();
                if (instruction.isMoveException()) {
                    assert (current == null);
                    current = position;
                    hasDebugPositions = hasDebugPositions || position.isSome();
                    continue;
                }
                if (instruction.isDebugPosition()) {
                    hasDebugPositions = true;
                    if (position.equals(current)) {
                        it.removeOrReplaceByDebugLocalRead();
                        continue;
                    }
                    current = position;
                    continue;
                }
                if (!position.isSome() || position.synthetic || position.equals(current)) continue;
                DebugPosition positionChange = new DebugPosition();
                positionChange.setPosition(position);
                it.previous();
                it.add(positionChange);
                it.next();
                current = position;
            }
        }
        return hasDebugPositions;
    }

    private boolean verifyFilledPredecessors() {
        for (BasicBlock block : this.blocks) {
            assert (this.verifyFilledPredecessors(block));
        }
        return true;
    }

    private boolean verifyFilledPredecessors(BasicBlock block) {
        assert (block.verifyFilledPredecessors());
        for (BlockInfo info : this.targets.values()) {
            if (info == null || info.block != block) continue;
            assert (info.predecessorCount() == block.getPredecessors().size());
            assert (info.normalSuccessors.size() == block.getNormalSuccessors().size());
            if (block.hasCatchHandlers() ? !$assertionsDisabled && info.exceptionalSuccessors.size() != block.getCatchHandlers().getUniqueTargets().size() : !$assertionsDisabled && block.canThrow() && !info.exceptionalSuccessors.isEmpty() && (info.exceptionalSuccessors.size() != 1 || info.exceptionalSuccessors.iterator().nextInt() >= 0)) {
                throw new AssertionError();
            }
            return true;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void processWorklist() {
        item = this.ssaWorklist.poll();
        while (item != null) {
            block7: {
                block8: {
                    if (WorklistItem.access$100(item).isFilled()) break block7;
                    if (!IRBuilder.$assertionsDisabled && !this.debugLocalEnds.isEmpty()) {
                        throw new AssertionError();
                    }
                    this.setCurrentBlock(WorklistItem.access$100(item));
                    this.blocks.add(this.currentBlock);
                    this.currentBlock.setNumber(this.nextBlockNumber++);
                    if (!(item instanceof MoveExceptionWorklistItem)) break block8;
                    this.processMoveExceptionItem((MoveExceptionWorklistItem)item);
                    this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
                    break block7;
                }
                if (!(item instanceof SplitBlockWorklistItem)) ** GOTO lbl24
                splitEdgeItem = (SplitBlockWorklistItem)item;
                this.source.buildBlockTransfer(this, SplitBlockWorklistItem.access$200(splitEdgeItem), SplitBlockWorklistItem.access$300(splitEdgeItem), false);
                if (WorklistItem.access$400(item) == -1) {
                    this.addInstruction(new Goto(), SplitBlockWorklistItem.access$500(splitEdgeItem));
                    this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
                } else {
                    if (!this.debugLocalEnds.isEmpty()) {
                        this.addInstruction(new DebugLocalRead());
                    }
lbl24:
                    // 4 sources

                    instCount = this.source.instructionCount();
                    for (i = WorklistItem.access$400(item); i < instCount && this.currentBlock != null; ++i) {
                        instructionOffset = this.source.instructionOffset(i);
                        info = (BlockInfo)this.targets.get(instructionOffset);
                        if (info != null && info.block != this.currentBlock) {
                            this.addToWorklist(info.block, i);
                            this.closeCurrentBlockWithFallThrough(info.block);
                            break;
                        }
                        this.currentInstructionOffset = instructionOffset;
                        this.source.buildInstruction(this, i, i == WorklistItem.access$400(item));
                    }
                }
            }
            item = this.ssaWorklist.poll();
        }
    }

    private void processMoveExceptionItem(MoveExceptionWorklistItem moveExceptionItem) {
        int targetIndex = this.source.instructionIndex(moveExceptionItem.targetOffset);
        int moveExceptionDest = this.source.getMoveExceptionRegister(targetIndex);
        Position position = this.source.getCanonicalDebugPositionAtOffset(moveExceptionItem.targetOffset);
        if (moveExceptionDest >= 0) {
            Set<DexType> exceptionTypes = MoveException.collectExceptionTypes(this.currentBlock, this.getFactory());
            TypeLatticeElement typeLattice = TypeLatticeElement.join(this.appInfo, exceptionTypes.stream().map(t -> TypeLatticeElement.fromDexType(t, this.appInfo, false)));
            Value out = this.writeRegister(moveExceptionDest, typeLattice, BasicBlock.ThrowingInfo.NO_THROW, null);
            MoveException moveException = new MoveException(out);
            moveException.setPosition(position);
            this.currentBlock.add(moveException);
        }
        boolean isExceptionalEdge = true;
        this.source.buildBlockTransfer(this, moveExceptionItem.sourceOffset, moveExceptionItem.targetOffset, isExceptionalEdge);
        BasicBlock targetBlock = this.getTarget(moveExceptionItem.targetOffset);
        this.currentBlock.link(targetBlock);
        this.addInstruction(new Goto(), position);
        this.addToWorklist(targetBlock, targetIndex);
    }

    public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset) {
        this.source.resolveAndBuildSwitch(value, fallthroughOffset, payloadOffset, this);
    }

    public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset) {
        this.source.resolveAndBuildNewArrayFilledData(arrayRef, payloadOffset, this);
    }

    public void add(Instruction ir) {
        assert (!ir.isJumpInstruction());
        this.hasConstString |= ir.isConstString();
        this.addInstruction(ir);
    }

    public void addThisArgument(int register) {
        DebugLocalInfo local = this.getOutgoingLocal(register);
        TypeLatticeElement receiver = TypeLatticeElement.fromDexType(this.method.method.getHolder(), this.appInfo, false);
        Value value = this.writeRegister(register, receiver, BasicBlock.ThrowingInfo.NO_THROW, local);
        this.addInstruction(new Argument(value));
        value.markAsThis();
    }

    public void addNonThisArgument(int register, TypeLatticeElement typeLattice) {
        DebugLocalInfo local = this.getOutgoingLocal(register);
        Value value = this.writeRegister(register, typeLattice, BasicBlock.ThrowingInfo.NO_THROW, local);
        this.addInstruction(new Argument(value));
    }

    public void addBooleanNonThisArgument(int register) {
        DebugLocalInfo local = this.getOutgoingLocal(register);
        Value value = this.writeRegister(register, INT, BasicBlock.ThrowingInfo.NO_THROW, local);
        value.setKnownToBeBoolean(true);
        this.addInstruction(new Argument(value));
    }

    private static boolean isValidFor(Value value, DebugLocalInfo local) {
        return !value.isUninitializedLocal() && value.getLocalInfo() == local;
    }

    public void addDebugLocalStart(int register, DebugLocalInfo local) {
        assert (local != null);
        if (!this.options.debug) {
            return;
        }
        Value incomingValue = this.readRegisterForDebugLocal(register, local);
        if (incomingValue.getLocalInfo() != local || this.currentBlock.isEmpty() || this.currentBlock.getInstructions().getLast().outValue() != incomingValue) {
            Value out = this.writeRegister(register, incomingValue.getTypeLattice(), BasicBlock.ThrowingInfo.NO_THROW, local);
            DebugLocalWrite write = new DebugLocalWrite(out, incomingValue);
            this.addInstruction(write);
        }
    }

    public void addDebugLocalEnd(int register, DebugLocalInfo local) {
        assert (local != null);
        if (!this.options.debug) {
            return;
        }
        Value value = this.readRegisterForDebugLocal(register, local);
        if (IRBuilder.isValidFor(value, local)) {
            this.debugLocalEnds.add(value);
        }
    }

    public void addDebugPosition(Position position) {
        if (this.options.debug) {
            assert (this.previousLocalValue == null);
            assert (this.source.getCurrentPosition().equals(position));
            if (!this.debugLocalEnds.isEmpty()) {
                if (this.currentBlock.getInstructions().isEmpty()) {
                    this.addInstruction(new DebugLocalRead());
                } else {
                    this.attachLocalValues(this.currentBlock.getInstructions().getLast());
                }
            }
            this.addInstruction(new DebugPosition());
        }
    }

    public void addAdd(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Add instruction = new Add(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAddLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Add instruction = new Add(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAnd(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        And instruction = new And(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAndLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        And instruction = new And(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addArrayGet(MemberType type, int dest, int array, int index) {
        Value in1 = this.readRegister(array, ValueType.OBJECT);
        Value in2 = this.readRegister(index, ValueType.INT);
        Value out = this.writeRegister(dest, TypeLatticeElement.fromMemberType(type), BasicBlock.ThrowingInfo.CAN_THROW);
        out.setKnownToBeBoolean(type == MemberType.BOOLEAN);
        ArrayGet instruction = new ArrayGet(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addArrayLength(int dest, int array) {
        Value in = this.readRegister(array, ValueType.OBJECT);
        Value out = this.writeRegister(dest, INT, BasicBlock.ThrowingInfo.CAN_THROW);
        ArrayLength instruction = new ArrayLength(out, in);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addArrayPut(MemberType type, int value, int array, int index) {
        Value inValue = this.readRegister(value, ValueType.fromMemberType(type));
        Value inArray = this.readRegister(array, ValueType.OBJECT);
        Value inIndex = this.readRegister(index, ValueType.INT);
        ArrayPut instruction = new ArrayPut(type, inArray, inIndex, inValue);
        this.add(instruction);
    }

    public void addCheckCast(int value, DexType type) {
        Value in = this.readRegister(value, ValueType.OBJECT);
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(type, this.appInfo, in.getTypeLattice().isNullable());
        Value out = this.writeRegister(value, castTypeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        CheckCast instruction = new CheckCast(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addCmp(NumericType type, Cmp.Bias bias, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeRegister(dest, INT, BasicBlock.ThrowingInfo.NO_THROW);
        Cmp instruction = new Cmp(type, bias, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addConst(TypeLatticeElement typeLattice, int dest, long value) {
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.NO_THROW);
        ConstNumber instruction = new ConstNumber(out, value);
        assert (!instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addLongConst(int dest, long value) {
        this.add(new ConstNumber(this.writeRegister(dest, LONG, BasicBlock.ThrowingInfo.NO_THROW), value));
    }

    public void addDoubleConst(int dest, long value) {
        this.add(new ConstNumber(this.writeRegister(dest, DOUBLE, BasicBlock.ThrowingInfo.NO_THROW), value));
    }

    public void addIntConst(int dest, long value) {
        this.add(new ConstNumber(this.writeRegister(dest, INT, BasicBlock.ThrowingInfo.NO_THROW), value));
    }

    public void addFloatConst(int dest, long value) {
        this.add(new ConstNumber(this.writeRegister(dest, FLOAT, BasicBlock.ThrowingInfo.NO_THROW), value));
    }

    public void addNullConst(int dest) {
        this.add(new ConstNumber(this.writeRegister(dest, NULL, BasicBlock.ThrowingInfo.NO_THROW), 0L));
    }

    public void addConstClass(int dest, DexType type) {
        TypeLatticeElement typeLattice = TypeLatticeElement.classClassType(this.appInfo);
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstClass instruction = new ConstClass(out, type);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addConstMethodHandle(int dest, DexMethodHandle methodHandle) {
        if (!this.options.canUseConstantMethodHandle()) {
            throw new ApiLevelException(AndroidApiLevel.P, "Const-method-handle", null);
        }
        TypeLatticeElement typeLattice = TypeLatticeElement.fromDexType(this.appInfo.dexItemFactory.methodHandleType, this.appInfo, false);
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstMethodHandle instruction = new ConstMethodHandle(out, methodHandle);
        this.add(instruction);
    }

    public void addConstMethodType(int dest, DexProto methodType) {
        if (!this.options.canUseConstantMethodType()) {
            throw new ApiLevelException(AndroidApiLevel.P, "Const-method-type", null);
        }
        TypeLatticeElement typeLattice = TypeLatticeElement.fromDexType(this.appInfo.dexItemFactory.methodTypeType, this.appInfo, false);
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstMethodType instruction = new ConstMethodType(out, methodType);
        this.add(instruction);
    }

    public void addConstString(int dest, DexString string) {
        TypeLatticeElement typeLattice = TypeLatticeElement.stringClassType(this.appInfo);
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstString instruction = new ConstString(out, string);
        this.add(instruction);
    }

    public void addDiv(NumericType type, int dest, int left, int right) {
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Div instruction = new Div(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.add(instruction);
    }

    public void addDivLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Div instruction = new Div(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.add(instruction);
    }

    public Monitor addMonitor(Monitor.Type type, int monitor) {
        Value in = this.readRegister(monitor, ValueType.OBJECT);
        Monitor monitorEnter = new Monitor(type, in);
        this.add(monitorEnter);
        return monitorEnter;
    }

    public void addMove(ValueType type, int dest, int src) {
        DebugLocalInfo destLocal;
        Value in = this.readRegister(src, type);
        if (this.options.debug && (destLocal = this.getOutgoingLocal(dest)) != null && destLocal != in.getLocalInfo()) {
            Value out = this.writeRegister(dest, in.getTypeLattice(), BasicBlock.ThrowingInfo.NO_THROW);
            this.addInstruction(new DebugLocalWrite(out, in));
            return;
        }
        this.currentBlock.writeCurrentDefinition(dest, in, BasicBlock.ThrowingInfo.NO_THROW);
    }

    public void addMul(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Mul instruction = new Mul(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addMulLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Mul instruction = new Mul(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addRem(NumericType type, int dest, int left, int right) {
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Rem instruction = new Rem(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.addInstruction(instruction);
    }

    public void addRemLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Rem instruction = new Rem(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.addInstruction(instruction);
    }

    public void addGoto(int targetOffset) {
        BasicBlock targetBlock = this.getTarget(targetOffset);
        assert (!this.currentBlock.hasCatchSuccessor(targetBlock));
        this.currentBlock.link(targetBlock);
        this.addToWorklist(targetBlock, this.source.instructionIndex(targetOffset));
        this.closeCurrentBlock(new Goto());
    }

    private void addTrivialIf(int trueTargetOffset, int falseTargetOffset) {
        assert (trueTargetOffset == falseTargetOffset);
        BasicBlock target = this.getTarget(trueTargetOffset);
        target.decrementUnfilledPredecessorCount();
        this.currentBlock.link(target);
        this.addToWorklist(target, this.source.instructionIndex(trueTargetOffset));
        this.closeCurrentBlock(new Goto());
    }

    private void addNonTrivialIf(If instruction, int trueTargetOffset, int falseTargetOffset) {
        BasicBlock trueTarget = this.getTarget(trueTargetOffset);
        BasicBlock falseTarget = this.getTarget(falseTargetOffset);
        this.currentBlock.link(trueTarget);
        this.currentBlock.link(falseTarget);
        this.addToWorklist(falseTarget, this.source.instructionIndex(falseTargetOffset));
        this.addToWorklist(trueTarget, this.source.instructionIndex(trueTargetOffset));
        this.closeCurrentBlock(instruction);
    }

    public void addIf(If.Type type, ValueType operandType, int value1, int value2, int trueTargetOffset, int falseTargetOffset) {
        if (trueTargetOffset == falseTargetOffset) {
            this.addTrivialIf(trueTargetOffset, falseTargetOffset);
        } else {
            ArrayList<Value> values2 = new ArrayList<Value>(2);
            values2.add(this.readRegister(value1, operandType));
            values2.add(this.readRegister(value2, operandType));
            If instruction = new If(type, values2);
            this.addNonTrivialIf(instruction, trueTargetOffset, falseTargetOffset);
        }
    }

    public void addIfZero(If.Type type, ValueType operandType, int value, int trueTargetOffset, int falseTargetOffset) {
        if (trueTargetOffset == falseTargetOffset) {
            this.addTrivialIf(trueTargetOffset, falseTargetOffset);
        } else {
            If instruction = new If(type, this.readRegister(value, operandType));
            this.addNonTrivialIf(instruction, trueTargetOffset, falseTargetOffset);
        }
    }

    public void addInstanceGet(int dest, int object, DexField field) {
        MemberType type = MemberType.fromDexType(field.type);
        Value in = this.readRegister(object, ValueType.OBJECT);
        Value out = this.writeRegister(dest, TypeLatticeElement.fromDexType(field.type, this.appInfo, true), BasicBlock.ThrowingInfo.CAN_THROW);
        out.setKnownToBeBoolean(type == MemberType.BOOLEAN);
        InstanceGet instruction = new InstanceGet(type, out, in, field);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addInstanceOf(int dest, int value, DexType type) {
        Value in = this.readRegister(value, ValueType.OBJECT);
        Value out = this.writeRegister(dest, INT, BasicBlock.ThrowingInfo.CAN_THROW);
        InstanceOf instruction = new InstanceOf(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addInstancePut(int value, int object, DexField field) {
        MemberType type = MemberType.fromDexType(field.type);
        Value objectValue = this.readRegister(object, ValueType.OBJECT);
        Value valueValue = this.readRegister(value, ValueType.fromMemberType(type));
        InstancePut instruction = new InstancePut(type, field, objectValue, valueValue);
        this.add(instruction);
    }

    public void addInvoke(Invoke.Type type, DexItem item, DexProto callSiteProto, List<Value> arguments, boolean itf) {
        if (type == Invoke.Type.POLYMORPHIC) {
            assert (item instanceof DexMethod);
            if (!this.options.canUseInvokePolymorphic()) {
                throw new ApiLevelException(AndroidApiLevel.O, "MethodHandle.invoke and MethodHandle.invokeExact", null);
            }
            if (!this.options.canUseInvokePolymorphicOnVarHandle() && ((DexMethod)item).getHolder() == this.options.itemFactory.varHandleType) {
                throw new ApiLevelException(AndroidApiLevel.P, "Call to polymorphic signature of VarHandle", null);
            }
        }
        if (this.appInfo != null && type == Invoke.Type.VIRTUAL) {
            DexEncodedMethod directTarget;
            DexMethod invocationMethod = (DexMethod)item;
            if (invocationMethod.holder == this.method.method.holder && (directTarget = this.appInfo.lookupDirectTarget(invocationMethod)) != null && invocationMethod.holder == directTarget.method.holder) {
                type = Invoke.Type.DIRECT;
            }
        }
        this.add(Invoke.create(type, item, callSiteProto, null, arguments, itf));
    }

    public void addInvoke(Invoke.Type type, DexItem item, DexProto callSiteProto, List<Value> arguments) {
        this.addInvoke(type, item, callSiteProto, arguments, false);
    }

    public void addInvoke(Invoke.Type type, DexItem item, DexProto callSiteProto, List<ValueType> types, List<Integer> registers) {
        this.addInvoke(type, item, callSiteProto, types, registers, false);
    }

    public void addInvoke(Invoke.Type type, DexItem item, DexProto callSiteProto, List<ValueType> types, List<Integer> registers, boolean itf) {
        assert (types.size() == registers.size());
        ArrayList<Value> arguments = new ArrayList<Value>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            arguments.add(this.readRegister(registers.get(i), types.get(i)));
        }
        this.addInvoke(type, item, callSiteProto, arguments, itf);
    }

    public void addInvokeCustomRegisters(DexCallSite callSite, int argumentRegisterCount, int[] argumentRegisters) {
        int registerIndex = 0;
        DexMethodHandle bootstrapMethod = callSite.bootstrapMethod;
        ArrayList<Value> arguments = new ArrayList<Value>(argumentRegisterCount);
        if (!bootstrapMethod.isStaticHandle()) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], ValueType.OBJECT));
            registerIndex += ValueType.OBJECT.requiredRegisters();
        }
        String shorty = callSite.methodProto.shorty.toString();
        for (int i = 1; i < shorty.length(); ++i) {
            ValueType valueType = ValueType.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(argumentRegisters[registerIndex], valueType));
            registerIndex += valueType.requiredRegisters();
        }
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeCustomRange(DexCallSite callSite, int argumentCount, int firstArgumentRegister) {
        DexMethodHandle bootstrapMethod = callSite.bootstrapMethod;
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount);
        int register = firstArgumentRegister;
        if (!bootstrapMethod.isStaticHandle()) {
            arguments.add(this.readRegister(register, ValueType.OBJECT));
            register += ValueType.OBJECT.requiredRegisters();
        }
        String shorty = callSite.methodProto.shorty.toString();
        for (int i = 1; i < shorty.length(); ++i) {
            ValueType valueType = ValueType.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(register, valueType));
            register += valueType.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeCustom(DexCallSite callSite, List<ValueType> types, List<Integer> registers) {
        assert (types.size() == registers.size());
        ArrayList<Value> arguments = new ArrayList<Value>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            arguments.add(this.readRegister(registers.get(i), types.get(i)));
        }
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeRegisters(Invoke.Type type, DexMethod method, DexProto callSiteProto, int argumentRegisterCount, int[] argumentRegisters) {
        ArrayList<Value> arguments = new ArrayList<Value>(argumentRegisterCount);
        int registerIndex = 0;
        if (type != Invoke.Type.STATIC) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], ValueType.OBJECT));
            registerIndex += ValueType.OBJECT.requiredRegisters();
        }
        DexString methodShorty = type == Invoke.Type.POLYMORPHIC ? callSiteProto.shorty : method.proto.shorty;
        String shorty = methodShorty.toString();
        for (int i = 1; i < methodShorty.size; ++i) {
            ValueType valueType = ValueType.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(argumentRegisters[registerIndex], valueType));
            registerIndex += valueType.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(registerIndex, argumentRegisterCount);
        this.addInvoke(type, method, callSiteProto, arguments);
    }

    public void addInvokeNewArray(DexType type, int argumentCount, int[] argumentRegisters) {
        int registerIndex;
        String descriptor = type.descriptor.toString();
        assert (descriptor.charAt(0) == '[');
        assert (descriptor.length() >= 2);
        ValueType valueType = ValueType.fromTypeDescriptorChar(descriptor.charAt(1));
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount / valueType.requiredRegisters());
        for (registerIndex = 0; registerIndex < argumentCount; registerIndex += valueType.requiredRegisters()) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], valueType));
            if (!valueType.isWide()) continue;
            assert (registerIndex < argumentCount - 1);
            assert (argumentRegisters[registerIndex] == argumentRegisters[registerIndex + 1] + 1);
        }
        this.checkInvokeArgumentRegisters(registerIndex, argumentCount);
        this.addInvoke(Invoke.Type.NEW_ARRAY, type, null, arguments);
    }

    public void addMultiNewArray(DexType type, int dest, int[] dimensions) {
        assert (this.isGeneratingClassFiles());
        ArrayList<Value> arguments = new ArrayList<Value>(dimensions.length);
        for (int dimension : dimensions) {
            arguments.add(this.readRegister(dimension, ValueType.INT));
        }
        this.addInvoke(Invoke.Type.MULTI_NEW_ARRAY, type, null, arguments);
        this.addMoveResult(dest);
    }

    public void addInvokeRange(Invoke.Type type, DexMethod method, DexProto callSiteProto, int argumentCount, int firstArgumentRegister) {
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount);
        int register = firstArgumentRegister;
        if (type != Invoke.Type.STATIC) {
            arguments.add(this.readRegister(register, ValueType.OBJECT));
            register += ValueType.OBJECT.requiredRegisters();
        }
        DexString methodShorty = type == Invoke.Type.POLYMORPHIC ? callSiteProto.shorty : method.proto.shorty;
        String shorty = methodShorty.toString();
        for (int i = 1; i < methodShorty.size; ++i) {
            ValueType valueType = ValueType.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(register, valueType));
            register += valueType.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        this.addInvoke(type, method, callSiteProto, arguments);
    }

    public void addInvokeRangeNewArray(DexType type, int argumentCount, int firstArgumentRegister) {
        int register;
        String descriptor = type.descriptor.toString();
        assert (descriptor.charAt(0) == '[');
        assert (descriptor.length() >= 2);
        ValueType valueType = ValueType.fromTypeDescriptorChar(descriptor.charAt(1));
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount / valueType.requiredRegisters());
        for (register = firstArgumentRegister; register < firstArgumentRegister + argumentCount; register += valueType.requiredRegisters()) {
            arguments.add(this.readRegister(register, valueType));
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        this.addInvoke(Invoke.Type.NEW_ARRAY, type, null, arguments);
    }

    private void checkInvokeArgumentRegisters(int expected, int actual) {
        if (expected != actual) {
            throw new CompilationError("Invalid invoke instruction. Expected use of " + expected + " argument registers, found actual use of " + actual);
        }
    }

    public void addMoveException(int dest) {
        assert (!this.currentBlock.getPredecessors().isEmpty());
        assert (this.currentBlock.getPredecessors().stream().allMatch(b -> b.entry().isMoveException()));
        Value value = this.readRegister(dest, ValueType.OBJECT);
        assert (IRBuilder.verifyValueIsMoveException(value));
    }

    private static boolean verifyValueIsMoveException(Value value) {
        if (value.isPhi()) {
            for (Value operand : value.asPhi().getOperands()) {
                assert (operand.definition.isMoveException());
            }
        } else assert (value.definition.isMoveException());
        return true;
    }

    public void addMoveResult(int dest) {
        LinkedList<Instruction> instructions = this.currentBlock.getInstructions();
        Invoke invoke = ((Instruction)instructions.get(instructions.size() - 1)).asInvoke();
        assert (invoke.outValue() == null);
        assert (invoke.instructionTypeCanThrow());
        DexType outType = invoke.getReturnType();
        Value outValue = this.writeRegister(dest, TypeLatticeElement.fromDexType(outType), BasicBlock.ThrowingInfo.CAN_THROW);
        outValue.setKnownToBeBoolean(outType.isBooleanType());
        invoke.setOutValue(outValue);
    }

    public void addNeg(NumericType type, int dest, int value) {
        Value in = this.readNumericRegister(value, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Neg instruction = new Neg(type, out, in);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNot(NumericType type, int dest, int value) {
        Instruction instruction;
        Value in = this.readNumericRegister(value, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        if (this.options.canUseNotInstruction()) {
            instruction = new Not(type, out, in);
        } else {
            Value minusOne = this.readLiteral(ValueType.fromNumericType(type), -1L);
            instruction = new Xor(type, out, in, minusOne);
        }
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNewArrayEmpty(int dest, int size, DexType type) {
        assert (type.isArrayType());
        Value in = this.readRegister(size, ValueType.INT);
        TypeLatticeElement arrayTypeLattice = TypeLatticeElement.fromDexType(type, this.appInfo, false);
        Value out = this.writeRegister(dest, arrayTypeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        NewArrayEmpty instruction = new NewArrayEmpty(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNewArrayFilledData(int arrayRef, int elementWidth, long size, short[] data) {
        this.add(new NewArrayFilledData(this.readRegister(arrayRef, ValueType.OBJECT), elementWidth, size, data));
    }

    public void addNewInstance(int dest, DexType type) {
        TypeLatticeElement instanceType = TypeLatticeElement.fromDexType(type, this.appInfo, false);
        Value out = this.writeRegister(dest, instanceType, BasicBlock.ThrowingInfo.CAN_THROW);
        NewInstance instruction = new NewInstance(type, out);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addReturn(ValueType type, int value) {
        ValueType returnType = ValueType.fromDexType(this.method.method.proto.returnType);
        assert (returnType.verifyCompatible(type));
        Value in = this.readRegister(value, returnType);
        this.addReturn(new Return(in, returnType));
    }

    public void addReturn() {
        this.addReturn(new Return());
    }

    private void addReturn(Return ret) {
        this.attachLocalValues(ret);
        this.source.buildPostlude(this);
        this.closeCurrentBlock(ret);
    }

    public void addStaticGet(int dest, DexField field) {
        MemberType type = MemberType.fromDexType(field.type);
        Value out = this.writeRegister(dest, TypeLatticeElement.fromDexType(field.type, this.appInfo, true), BasicBlock.ThrowingInfo.CAN_THROW);
        out.setKnownToBeBoolean(type == MemberType.BOOLEAN);
        StaticGet instruction = new StaticGet(type, out, field);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addStaticPut(int value, DexField field) {
        MemberType type = MemberType.fromDexType(field.type);
        Value in = this.readRegister(value, ValueType.fromMemberType(type));
        this.add(new StaticPut(type, in, field));
    }

    public void addSub(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Sub instruction = new Sub(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addRsubLiteral(NumericType type, int dest, int value, int constant) {
        assert (type != NumericType.DOUBLE);
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Sub instruction = new Sub(type, out, in2, in1);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addSwitch(int value, int[] keys2, int fallthroughOffset, int[] labelOffsets) {
        int numberOfTargets = labelOffsets.length;
        assert (keys2.length == 1 || keys2.length == numberOfTargets);
        if (numberOfTargets == 0) {
            this.addGoto(fallthroughOffset);
            return;
        }
        Value switchValue = this.readRegister(value, ValueType.INT);
        IntArrayList nonFallthroughKeys = new IntArrayList(numberOfTargets);
        IntArrayList nonFallthroughOffsets = new IntArrayList(numberOfTargets);
        int numberOfFallthroughs = 0;
        if (keys2.length == 1) {
            int key = keys2[0];
            for (int i = 0; i < numberOfTargets; ++i) {
                if (labelOffsets[i] != fallthroughOffset) {
                    nonFallthroughKeys.add(key);
                    nonFallthroughOffsets.add(labelOffsets[i]);
                } else {
                    ++numberOfFallthroughs;
                }
                ++key;
            }
        } else {
            assert (keys2.length == numberOfTargets);
            for (int i = 0; i < numberOfTargets; ++i) {
                if (labelOffsets[i] != fallthroughOffset) {
                    nonFallthroughKeys.add(keys2[i]);
                    nonFallthroughOffsets.add(labelOffsets[i]);
                    continue;
                }
                ++numberOfFallthroughs;
            }
        }
        ((BlockInfo)this.targets.get((int)fallthroughOffset)).block.decrementUnfilledPredecessorCount(numberOfFallthroughs);
        if (numberOfFallthroughs == numberOfTargets) {
            assert (nonFallthroughKeys.size() == 0);
            this.addGoto(fallthroughOffset);
            return;
        }
        keys2 = nonFallthroughKeys.toIntArray();
        labelOffsets = nonFallthroughOffsets.toIntArray();
        Switch aSwitch = this.createSwitch(switchValue, keys2, fallthroughOffset, labelOffsets);
        this.closeCurrentBlock(aSwitch);
    }

    private Switch createSwitch(Value value, int[] keys2, int fallthroughOffset, int[] targetOffsets) {
        assert (keys2.length == targetOffsets.length);
        int[] targetBlockIndices = new int[targetOffsets.length];
        HashMap<Integer, Integer> offsetToBlockIndex = new HashMap<Integer, Integer>();
        BasicBlock fallthroughBlock = this.getTarget(fallthroughOffset);
        this.currentBlock.link(fallthroughBlock);
        this.addToWorklist(fallthroughBlock, this.source.instructionIndex(fallthroughOffset));
        int fallthroughBlockIndex = this.currentBlock.getSuccessors().size() - 1;
        offsetToBlockIndex.put(fallthroughOffset, fallthroughBlockIndex);
        for (int i = 0; i < targetOffsets.length; ++i) {
            int targetOffset = targetOffsets[i];
            BasicBlock targetBlock = this.getTarget(targetOffset);
            Integer targetBlockIndex = (Integer)offsetToBlockIndex.get(targetOffset);
            if (targetBlockIndex == null) {
                this.currentBlock.link(targetBlock);
                this.addToWorklist(targetBlock, this.source.instructionIndex(targetOffset));
                int successorIndex = this.currentBlock.getSuccessors().size() - 1;
                offsetToBlockIndex.put(targetOffset, successorIndex);
                targetBlockIndices[i] = successorIndex;
                continue;
            }
            targetBlock.decrementUnfilledPredecessorCount();
            targetBlockIndices[i] = targetBlockIndex;
        }
        return new Switch(value, keys2, targetBlockIndices, fallthroughBlockIndex);
    }

    public void addThrow(int value) {
        Value in = this.readRegister(value, ValueType.OBJECT);
        this.addInstruction(new Throw(in));
        this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
    }

    public void addOr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Or instruction = new Or(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addOrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Or instruction = new Or(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShl(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, ValueType.INT);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shl instruction = new Shl(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShlLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shl instruction = new Shl(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, ValueType.INT);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shr instruction = new Shr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shr instruction = new Shr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addUshr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, ValueType.INT);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Ushr instruction = new Ushr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addUshrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Ushr instruction = new Ushr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addXor(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Instruction instruction = this.options.canUseNotInstruction() && in2.isConstNumber() && in2.getConstInstruction().asConstNumber().isIntegerNegativeOne(type) ? new Not(type, out, in1) : new Xor(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addXorLiteral(NumericType type, int dest, int value, int constant) {
        Instruction instruction;
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        if (this.options.canUseNotInstruction() && constant == -1) {
            Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
            instruction = new Not(type, out, in1);
        } else {
            Value in2 = this.readIntLiteral(constant);
            Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
            instruction = new Xor(type, out, in1, in2);
        }
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addConversion(NumericType to, NumericType from, int dest, int source) {
        Value in = this.readNumericRegister(source, from);
        Value out = this.writeNumericRegister(dest, to, BasicBlock.ThrowingInfo.NO_THROW);
        NumberConversion instruction = new NumberConversion(from, to, out, in);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public Value readRegister(int register, ValueType type) {
        DebugLocalInfo local = this.getIncomingLocal(register);
        Value value = this.readRegister(register, type, this.currentBlock, BasicBlock.EdgeType.NON_EDGE, Phi.RegisterReadType.NORMAL);
        if (local != null && value.getLocalInfo() != local && !value.isUninitializedLocal()) {
            throw new InvalidDebugInfoException("Attempt to read local " + local + " but no local information was associated with the value being read.");
        }
        assert (!value.hasLocalInfo() || value.getDebugLocalEnds() != null || this.source.verifyLocalInScope(value.getLocalInfo()));
        this.constrainType(value, type);
        value.markNonDebugLocalRead();
        return value;
    }

    private Value readRegisterForDebugLocal(int register, DebugLocalInfo local) {
        assert (this.options.debug);
        ValueType type = ValueType.fromDexType(local.type);
        return this.readRegister(register, type, this.currentBlock, BasicBlock.EdgeType.NON_EDGE, Phi.RegisterReadType.DEBUG);
    }

    public Value readRegister(int register, ValueType type, BasicBlock block, BasicBlock.EdgeType readingEdge, Phi.RegisterReadType readType) {
        this.checkRegister(register);
        Value value = block.readCurrentDefinition(register, readingEdge);
        return value != null ? value : this.readRegisterRecursive(register, block, readingEdge, type, readType);
    }

    private Value readRegisterRecursive(int register, BasicBlock block, BasicBlock.EdgeType readingEdge, ValueType type, Phi.RegisterReadType readType) {
        Value value = null;
        ArrayList<Pair<BasicBlock, BasicBlock.EdgeType>> stack = null;
        if (block.isSealed() && block.getPredecessors().size() == 1) {
            stack = new ArrayList<Pair<BasicBlock, BasicBlock.EdgeType>>(this.blocks.size());
            do {
                assert (block.verifyFilledPredecessors());
                BasicBlock pred = block.getPredecessors().get(0);
                BasicBlock.EdgeType edgeType = pred.getEdgeType(block);
                this.checkRegister(register);
                value = pred.readCurrentDefinition(register, edgeType);
                if (value != null) break;
                stack.add(new Pair<BasicBlock, BasicBlock.EdgeType>(block, readingEdge));
                block = pred;
                readingEdge = edgeType;
            } while (block.isSealed() && block.getPredecessors().size() == 1);
        }
        if (value == null) {
            if (block == this.entryBlock && readType == Phi.RegisterReadType.DEBUG) {
                assert (block.getPredecessors().isEmpty());
                value = this.getUninitializedDebugLocalValue(register, type);
            } else {
                DebugLocalInfo local = this.getIncomingLocalAtBlock(register, block);
                Phi phi = new Phi(this.valueNumberGenerator.next(), block, type.toTypeLattice(), local, readType);
                if (!block.isSealed()) {
                    block.addIncompletePhi(register, phi, readingEdge);
                    value = phi;
                } else {
                    block.updateCurrentDefinition(register, phi, readingEdge);
                    phi.addOperands(this, register);
                    value = block.readCurrentDefinition(register, readingEdge);
                }
            }
        }
        if (stack != null) {
            for (Pair pair : stack) {
                ((BasicBlock)pair.getFirst()).updateCurrentDefinition(register, value, (BasicBlock.EdgeType)((Object)pair.getSecond()));
            }
        }
        block.updateCurrentDefinition(register, value, readingEdge);
        return value;
    }

    private DebugLocalInfo getIncomingLocalAtBlock(int register, BasicBlock block) {
        if (this.options.debug) {
            int blockOffset = this.offsets.getInt(block);
            return this.source.getIncomingLocalAtBlock(register, blockOffset);
        }
        return null;
    }

    private Value getUninitializedDebugLocalValue(int register, ValueType type) {
        ArrayList<Value> values2;
        if (this.uninitializedDebugLocalValues == null) {
            this.uninitializedDebugLocalValues = new Int2ReferenceOpenHashMap<List<Value>>();
        }
        if ((values2 = (ArrayList<Value>)this.uninitializedDebugLocalValues.get(register)) != null) {
            for (Value value : values2) {
                if (value.outType() != type) continue;
                return value;
            }
        } else {
            values2 = new ArrayList<Value>(2);
            this.uninitializedDebugLocalValues.put(register, (List<Value>)values2);
        }
        Value value = new Value(this.valueNumberGenerator.next(), type.toTypeLattice(), null);
        values2.add(value);
        return value;
    }

    public Value readNumericRegister(int register, NumericType type) {
        return this.readRegister(register, ValueType.fromNumericType(type));
    }

    public Value readLiteral(ValueType type, long constant) {
        if (type == ValueType.INT) {
            return this.readIntLiteral(constant);
        }
        assert (type == ValueType.LONG);
        return this.readLongLiteral(constant);
    }

    public Value readLongLiteral(long constant) {
        Value value = new Value(this.valueNumberGenerator.next(), LONG, null);
        ConstNumber number = new ConstNumber(value, constant);
        this.add(number);
        return number.outValue();
    }

    public Value readIntLiteral(long constant) {
        Value value = new Value(this.valueNumberGenerator.next(), INT, null);
        ConstNumber number = new ConstNumber(value, constant);
        this.add(number);
        return number.outValue();
    }

    private Value writeRegister(int register, TypeLatticeElement typeLattice, BasicBlock.ThrowingInfo throwing, DebugLocalInfo local) {
        this.checkRegister(register);
        Value value = new Value(this.valueNumberGenerator.next(), typeLattice, local);
        this.currentBlock.writeCurrentDefinition(register, value, throwing);
        return value;
    }

    public Value writeRegister(int register, TypeLatticeElement typeLattice, BasicBlock.ThrowingInfo throwing) {
        DebugLocalInfo incomingLocal = this.getIncomingLocal(register);
        DebugLocalInfo outgoingLocal = this.getOutgoingLocal(register);
        this.previousLocalValue = incomingLocal == null || incomingLocal != outgoingLocal ? null : this.readRegisterForDebugLocal(register, incomingLocal);
        return this.writeRegister(register, typeLattice, throwing, outgoingLocal);
    }

    public Value writeNumericRegister(int register, NumericType type, BasicBlock.ThrowingInfo throwing) {
        return this.writeRegister(register, PrimitiveTypeLatticeElement.fromNumericType(type), throwing);
    }

    private DebugLocalInfo getIncomingLocal(int register) {
        return this.options.debug ? this.source.getIncomingLocal(register) : null;
    }

    private DebugLocalInfo getOutgoingLocal(int register) {
        return this.options.debug ? this.source.getOutgoingLocal(register) : null;
    }

    private void checkRegister(int register) {
        if (register < 0) {
            throw new InternalCompilerError("Invalid register");
        }
        if (!this.source.verifyRegister(register)) {
            throw new CompilationError("Invalid use of register " + register);
        }
    }

    void ensureBlockForThrowingInstruction() {
        if (!this.throwingInstructionInCurrentBlock) {
            return;
        }
        int currentBlockOffset = this.getOffset(this.currentBlock);
        BlockInfo currentBlockInfo = this.getBlockInfo(currentBlockOffset);
        BlockInfo info = new BlockInfo();
        BasicBlock block = info.block;
        block.setNumber(this.nextBlockNumber++);
        this.blocks.add(block);
        int freshOffset = -2;
        while (this.targets.containsKey(freshOffset)) {
            --freshOffset;
        }
        this.targets.put(freshOffset, info);
        this.offsets.put(block, freshOffset);
        for (int offset2 : this.source.getCurrentCatchHandlers().getUniqueTargets()) {
            info.addExceptionalSuccessor(offset2);
            BlockInfo target = (BlockInfo)this.targets.get(offset2);
            assert (!target.block.isSealed());
            target.block.incrementUnfilledPredecessorCount();
            target.addExceptionalPredecessor(freshOffset);
        }
        currentBlockInfo.normalSuccessors.forEach(offset -> info.addNormalSuccessor((int)offset));
        currentBlockInfo.normalSuccessors.clear();
        this.addInstruction(new Goto());
        this.currentBlock.link(block);
        block.incrementUnfilledPredecessorCount();
        currentBlockInfo.addNormalSuccessor(freshOffset);
        info.addNormalPredecessor(currentBlockOffset);
        this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
        this.setCurrentBlock(block);
    }

    private void addInstruction(Instruction ir) {
        this.addInstruction(ir, this.source.getCurrentPosition());
    }

    private void addInstruction(Instruction ir, Position position) {
        this.hasImpreciseInstructionOutValueTypes |= ir.outValue() != null && !ir.outType().isPreciseType();
        ir.setPosition(position);
        this.attachLocalValues(ir);
        this.currentBlock.add(ir);
        if (ir.instructionTypeCanThrow()) {
            assert (this.source.verifyCurrentInstructionCanThrow());
            CatchHandlers<Integer> catchHandlers = this.source.getCurrentCatchHandlers();
            if (catchHandlers != null) {
                assert (!this.throwingInstructionInCurrentBlock);
                this.throwingInstructionInCurrentBlock = true;
                ArrayList<BasicBlock> targets = new ArrayList<BasicBlock>(catchHandlers.getAllTargets().size());
                IdentityHashMap<BasicBlock, BasicBlock> moveExceptionHeaders = new IdentityHashMap<BasicBlock, BasicBlock>(catchHandlers.getUniqueTargets().size());
                for (int targetOffset : catchHandlers.getAllTargets()) {
                    BasicBlock target = this.getTarget(targetOffset);
                    BasicBlock header = (BasicBlock)moveExceptionHeaders.get(target);
                    if (header == null) {
                        header = new BasicBlock();
                        header.incrementUnfilledPredecessorCount();
                        moveExceptionHeaders.put(target, header);
                        this.ssaWorklist.add(new MoveExceptionWorklistItem(header, this.currentInstructionOffset, targetOffset));
                    }
                    targets.add(header);
                }
                this.currentBlock.linkCatchSuccessors(catchHandlers.getGuards(), targets);
            }
        }
    }

    private void attachLocalValues(Instruction ir) {
        if (!this.options.debug) {
            assert (this.previousLocalValue == null);
            assert (this.debugLocalEnds.isEmpty());
            return;
        }
        if (this.previousLocalValue != null && this.previousLocalValue.getLocalInfo() == ir.getLocalInfo()) {
            assert (ir.outValue() != null);
            ir.addDebugValue(this.previousLocalValue);
            this.previousLocalValue.addDebugLocalEnd(ir);
        }
        for (Value value : this.debugLocalEnds) {
            ir.addDebugValue(value);
            value.addDebugLocalEnd(ir);
        }
        this.previousLocalValue = null;
        this.debugLocalEnds.clear();
    }

    BlockInfo ensureBlockWithoutEnqueuing(int offset) {
        assert (offset != -1);
        BlockInfo info = (BlockInfo)this.targets.get(offset);
        if (info == null) {
            if (offset >= 0 && this.isOffsetProcessed(offset)) {
                int blockStartOffset = this.getBlockStartOffset(offset);
                BlockInfo existing = (BlockInfo)this.targets.get(blockStartOffset);
                info = existing.split(blockStartOffset, offset, this.targets);
            } else {
                info = new BlockInfo();
            }
            this.targets.put(offset, info);
            this.offsets.put(info.block, offset);
        }
        return info;
    }

    private int getBlockStartOffset(int offset) {
        if (this.targets.containsKey(offset)) {
            return offset;
        }
        return this.targets.headMap(offset).lastIntKey();
    }

    private BlockInfo ensureBlock(int offset) {
        if (offset >= 0 && !this.isOffsetProcessed(offset)) {
            this.traceBlocksWorklist.add(offset);
        }
        return this.ensureBlockWithoutEnqueuing(offset);
    }

    private boolean isOffsetProcessed(int offset) {
        return this.isIndexProcessed(this.source.instructionIndex(offset));
    }

    private boolean isIndexProcessed(int index) {
        if (index < this.processedInstructions.length) {
            return this.processedInstructions[index];
        }
        this.ensureSubroutineProcessedInstructions();
        return this.processedSubroutineInstructions.contains(index);
    }

    private void markIndexProcessed(int index) {
        assert (!this.isIndexProcessed(index));
        if (index < this.processedInstructions.length) {
            this.processedInstructions[index] = true;
            return;
        }
        this.ensureSubroutineProcessedInstructions();
        this.processedSubroutineInstructions.add(index);
    }

    private void ensureSubroutineProcessedInstructions() {
        if (this.processedSubroutineInstructions == null) {
            this.processedSubroutineInstructions = new HashSet<Integer>();
        }
    }

    private void ensureSuccessorBlock(int sourceOffset, int targetOffset, boolean normal) {
        BlockInfo targetInfo = this.ensureBlock(targetOffset);
        int sourceStartOffset = this.getBlockStartOffset(sourceOffset);
        BlockInfo sourceInfo = (BlockInfo)this.targets.get(sourceStartOffset);
        if (normal) {
            sourceInfo.addNormalSuccessor(targetOffset);
            targetInfo.addNormalPredecessor(sourceStartOffset);
        } else {
            sourceInfo.addExceptionalSuccessor(targetOffset);
            targetInfo.addExceptionalPredecessor(sourceStartOffset);
        }
        targetInfo.block.incrementUnfilledPredecessorCount();
    }

    public void ensureNormalSuccessorBlock(int sourceOffset, int targetOffset) {
        this.ensureSuccessorBlock(sourceOffset, targetOffset, true);
    }

    void ensureExceptionalSuccessorBlock(int sourceOffset, int targetOffset) {
        this.ensureSuccessorBlock(sourceOffset, targetOffset, false);
    }

    private BlockInfo getBlockInfo(int offset) {
        return (BlockInfo)this.targets.get(offset);
    }

    private BlockInfo getBlockInfo(BasicBlock block) {
        return this.getBlockInfo(this.getOffset(block));
    }

    private BasicBlock getTarget(int offset) {
        return ((BlockInfo)this.targets.get((int)offset)).block;
    }

    private int getOffset(BasicBlock block) {
        return this.offsets.getInt(block);
    }

    private void closeCurrentBlockGuaranteedNotToNeedEdgeSplitting() {
        assert (this.currentBlock != null);
        this.currentBlock.close(this);
        this.setCurrentBlock(null);
        this.throwingInstructionInCurrentBlock = false;
        this.currentInstructionOffset = -1;
        assert (this.debugLocalEnds.isEmpty());
    }

    private void closeCurrentBlock(JumpInstruction jumpInstruction) {
        assert (!jumpInstruction.instructionTypeCanThrow());
        assert (this.currentBlock != null);
        assert (this.currentBlock.getInstructions().isEmpty() || !this.currentBlock.getInstructions().getLast().isJumpInstruction());
        this.generateSplitEdgeBlocks();
        this.addInstruction(jumpInstruction);
        this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
    }

    private void closeCurrentBlockWithFallThrough(BasicBlock nextBlock) {
        assert (this.currentBlock != null);
        assert (!this.currentBlock.hasCatchSuccessor(nextBlock));
        this.currentBlock.link(nextBlock);
        this.closeCurrentBlock(new Goto());
    }

    private void generateSplitEdgeBlocks() {
        assert (this.currentBlock != null);
        assert (this.currentBlock.isEmpty() || !this.currentBlock.getInstructions().getLast().isJumpInstruction());
        BlockInfo info = this.getBlockInfo(this.currentBlock);
        Position position = this.source.getCurrentPosition();
        if (info.hasMoreThanASingleNormalExit()) {
            IntIterator intIterator = info.normalSuccessors.iterator();
            while (intIterator.hasNext()) {
                int successorOffset = (Integer)intIterator.next();
                BlockInfo successorInfo = this.getBlockInfo(successorOffset);
                if (successorInfo.predecessorCount() == 1) {
                    WorklistItem oldItem = null;
                    for (WorklistItem item : this.ssaWorklist) {
                        if (item.block != successorInfo.block) continue;
                        oldItem = item;
                    }
                    assert (oldItem.firstInstructionIndex == this.source.instructionIndex(successorOffset));
                    this.ssaWorklist.remove(oldItem);
                    this.ssaWorklist.add(new SplitBlockWorklistItem(oldItem.firstInstructionIndex, oldItem.block, position, this.currentInstructionOffset, successorOffset));
                    continue;
                }
                BasicBlock splitBlock = IRBuilder.createSplitEdgeBlock(this.currentBlock, successorInfo.block);
                this.ssaWorklist.add(new SplitBlockWorklistItem(-1, splitBlock, position, this.currentInstructionOffset, successorOffset));
            }
        } else if (info.normalSuccessors.size() == 1) {
            int successorOffset = info.normalSuccessors.iterator().nextInt();
            this.source.buildBlockTransfer(this, this.currentInstructionOffset, successorOffset, false);
        } else assert (info.allSuccessors().isEmpty());
    }

    private static BasicBlock createSplitEdgeBlock(BasicBlock source, BasicBlock target) {
        BasicBlock splitBlock = new BasicBlock();
        splitBlock.incrementUnfilledPredecessorCount();
        splitBlock.getPredecessors().add(source);
        splitBlock.getSuccessors().add(target);
        source.replaceSuccessor(target, splitBlock);
        target.replacePredecessor(source, splitBlock);
        return splitBlock;
    }

    public void joinPredecessorsWithIdenticalPhis() {
        ArrayList<BasicBlock> blocksToAdd = new ArrayList<BasicBlock>();
        for (BasicBlock block : this.blocks) {
            if (block.hasIncompletePhis()) {
                throw new CompilationError("Undefined value encountered during compilation. This is typically caused by invalid dex input that uses a register that is not defined on all control-flow paths leading to the use.");
            }
            if (block.entry() instanceof MoveException) continue;
            ArrayList<Integer> operandsToRemove = new ArrayList<Integer>();
            HashMap<ValueList, Integer> values2 = new HashMap<ValueList, Integer>();
            HashMap<Integer, BasicBlock> joinBlocks = new HashMap<Integer, BasicBlock>();
            if (block.getPhis().size() > 0) {
                Phi phi = block.getPhis().get(0);
                for (int operandIndex = 0; operandIndex < phi.getOperands().size(); ++operandIndex) {
                    ValueList v = ValueList.fromPhis(block.getPhis(), operandIndex);
                    BasicBlock predecessor = block.getPredecessors().get(operandIndex);
                    if (values2.containsKey(v)) {
                        int otherPredecessorIndex = (Integer)values2.get(v);
                        BasicBlock joinBlock = (BasicBlock)joinBlocks.get(otherPredecessorIndex);
                        if (joinBlock == null) {
                            joinBlock = BasicBlock.createGotoBlock(this.blocks.size() + blocksToAdd.size(), block.getPosition(), block);
                            joinBlocks.put(otherPredecessorIndex, joinBlock);
                            blocksToAdd.add(joinBlock);
                            BasicBlock otherPredecessor = block.getPredecessors().get(otherPredecessorIndex);
                            joinBlock.getPredecessors().add(otherPredecessor);
                            otherPredecessor.replaceSuccessor(block, joinBlock);
                            block.getPredecessors().set(otherPredecessorIndex, joinBlock);
                        }
                        joinBlock.getPredecessors().add(predecessor);
                        predecessor.replaceSuccessor(block, joinBlock);
                        operandsToRemove.add(operandIndex);
                        continue;
                    }
                    values2.put(v, operandIndex);
                }
            }
            block.removePredecessorsByIndex(operandsToRemove);
            block.removePhisByIndex(operandsToRemove);
        }
        this.blocks.addAll(blocksToAdd);
    }

    boolean isIntegerType(NumericType type) {
        return type != NumericType.FLOAT && type != NumericType.DOUBLE;
    }

    boolean isNonLongIntegerType(NumericType type) {
        return type != NumericType.FLOAT && type != NumericType.DOUBLE && type != NumericType.LONG;
    }

    public ValueNumberGenerator getValueNumberGenerator() {
        return this.valueNumberGenerator;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("blocks:\n");
        for (BasicBlock block : this.blocks) {
            builder.append(block.toDetailedString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public static class BlockInfo {
        BasicBlock block = new BasicBlock();
        IntSet normalPredecessors = new IntArraySet();
        IntSet normalSuccessors = new IntArraySet();
        IntSet exceptionalPredecessors = new IntArraySet();
        IntSet exceptionalSuccessors = new IntArraySet();

        void addNormalPredecessor(int offset) {
            this.normalPredecessors.add(offset);
        }

        void addNormalSuccessor(int offset) {
            this.normalSuccessors.add(offset);
        }

        void replaceNormalPredecessor(int existing, int replacement) {
            this.normalPredecessors.remove(existing);
            this.normalPredecessors.add(replacement);
        }

        void addExceptionalPredecessor(int offset) {
            this.exceptionalPredecessors.add(offset);
        }

        void addExceptionalSuccessor(int offset) {
            this.exceptionalSuccessors.add(offset);
        }

        int predecessorCount() {
            return this.normalPredecessors.size() + this.exceptionalPredecessors.size();
        }

        IntSet allSuccessors() {
            IntArraySet all = new IntArraySet(this.normalSuccessors.size() + this.exceptionalSuccessors.size());
            all.addAll(this.normalSuccessors);
            all.addAll(this.exceptionalSuccessors);
            return all;
        }

        boolean hasMoreThanASingleNormalExit() {
            return this.normalSuccessors.size() > 1 || this.normalSuccessors.size() == 1 && !this.exceptionalSuccessors.isEmpty();
        }

        BlockInfo split(int blockStartOffset, int fallthroughOffset, Int2ReferenceMap<BlockInfo> targets) {
            BlockInfo fallthroughInfo = new BlockInfo();
            fallthroughInfo.normalPredecessors = new IntArraySet(Collections.singleton(blockStartOffset));
            fallthroughInfo.block.incrementUnfilledPredecessorCount();
            IntIterator normalSuccessorIterator = this.normalSuccessors.iterator();
            while (normalSuccessorIterator.hasNext()) {
                BlockInfo normalSuccessor = (BlockInfo)targets.get(normalSuccessorIterator.nextInt());
                normalSuccessor.replaceNormalPredecessor(blockStartOffset, fallthroughOffset);
            }
            fallthroughInfo.normalSuccessors = this.normalSuccessors;
            this.normalSuccessors = new IntArraySet(Collections.singleton(fallthroughOffset));
            IntIterator exceptionalSuccessorIterator = fallthroughInfo.exceptionalSuccessors.iterator();
            while (exceptionalSuccessorIterator.hasNext()) {
                BlockInfo exceptionalSuccessor = (BlockInfo)targets.get(exceptionalSuccessorIterator.nextInt());
                exceptionalSuccessor.addExceptionalPredecessor(fallthroughOffset);
            }
            fallthroughInfo.exceptionalSuccessors = new IntArraySet(this.exceptionalSuccessors);
            return fallthroughInfo;
        }

        public String toString() {
            int offset;
            StringBuilder stringBuilder = new StringBuilder().append("block ").append(this.block.getNumberAsString()).append(" predecessors: ");
            String sep = "";
            IntIterator intIterator = this.normalPredecessors.iterator();
            while (intIterator.hasNext()) {
                offset = (Integer)intIterator.next();
                stringBuilder.append(sep).append(offset);
                sep = ", ";
            }
            intIterator = this.exceptionalPredecessors.iterator();
            while (intIterator.hasNext()) {
                offset = (Integer)intIterator.next();
                stringBuilder.append(sep).append('*').append(offset);
                sep = ", ";
            }
            stringBuilder.append(" successors: ");
            sep = "";
            intIterator = this.normalSuccessors.iterator();
            while (intIterator.hasNext()) {
                offset = (Integer)intIterator.next();
                stringBuilder.append(sep).append(offset);
                sep = ", ";
            }
            intIterator = this.exceptionalSuccessors.iterator();
            while (intIterator.hasNext()) {
                offset = (Integer)intIterator.next();
                stringBuilder.append(sep).append('*').append(offset);
                sep = ", ";
            }
            return stringBuilder.toString();
        }
    }

    private static class ValueList {
        private final List<Value> values = new ArrayList<Value>();

        private ValueList() {
        }

        public static ValueList fromPhis(List<Phi> phis, int index) {
            ValueList result = new ValueList();
            for (Phi phi : phis) {
                result.values.add(phi.getOperand(index));
            }
            return result;
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ValueList)) {
                return false;
            }
            ValueList o = (ValueList)other;
            if (o.values.size() != this.values.size()) {
                return false;
            }
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.values.get(i) == o.values.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    private static class SplitBlockWorklistItem
    extends WorklistItem {
        private final int sourceOffset;
        private final int targetOffset;
        private final Position position;

        public SplitBlockWorklistItem(int firstInstructionIndex, BasicBlock block, Position position, int sourceOffset, int targetOffset) {
            super(block, firstInstructionIndex);
            this.position = position;
            this.sourceOffset = sourceOffset;
            this.targetOffset = targetOffset;
        }

        static /* synthetic */ int access$200(SplitBlockWorklistItem x0) {
            return x0.sourceOffset;
        }

        static /* synthetic */ int access$300(SplitBlockWorklistItem x0) {
            return x0.targetOffset;
        }

        static /* synthetic */ Position access$500(SplitBlockWorklistItem x0) {
            return x0.position;
        }
    }

    private static class MoveExceptionWorklistItem
    extends WorklistItem {
        private final int sourceOffset;
        private final int targetOffset;

        private MoveExceptionWorklistItem(BasicBlock block, int sourceOffset, int targetOffset) {
            super(block, -1);
            this.sourceOffset = sourceOffset;
            this.targetOffset = targetOffset;
        }
    }

    private static class WorklistItem {
        private final BasicBlock block;
        private final int firstInstructionIndex;

        private WorklistItem(BasicBlock block, int firstInstructionIndex) {
            assert (block != null);
            this.block = block;
            this.firstInstructionIndex = firstInstructionIndex;
        }
    }
}

