/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class DeadCodeRemover {
    private final IRCode code;
    private final CodeRewriter codeRewriter;
    private final GraphLense graphLense;
    private final InternalOptions options;

    public DeadCodeRemover(IRCode code, CodeRewriter codeRewriter, GraphLense graphLense, InternalOptions options) {
        this.code = code;
        this.codeRewriter = codeRewriter;
        this.graphLense = graphLense;
        this.options = options;
    }

    public void run() {
        this.removeUnneededCatchHandlers();
        LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>();
        worklist.addAll(this.code.blocks);
        BasicBlock block = (BasicBlock)worklist.poll();
        while (block != null) {
            DeadCodeRemover.removeDeadInstructions(worklist, this.code, block, this.options);
            DeadCodeRemover.removeDeadPhis(worklist, block, this.options);
            block = (BasicBlock)worklist.poll();
        }
        assert (this.code.isConsistentSSA());
        this.codeRewriter.rewriteMoveResult(this.code);
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Value value) {
        BasicBlock block = null;
        if (value.isPhi()) {
            block = value.asPhi().getBlock();
        } else if (value.definition.hasBlock()) {
            block = value.definition.getBlock();
        }
        if (block != null) {
            worklist.add(block);
        }
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Instruction instruction) {
        for (Value inValue : instruction.inValues()) {
            DeadCodeRemover.updateWorklist(worklist, inValue);
        }
        for (Value debugValue : instruction.getDebugValues()) {
            DeadCodeRemover.updateWorklist(worklist, debugValue);
        }
    }

    private static void removeDeadPhis(Queue<BasicBlock> worklist, BasicBlock block, InternalOptions options) {
        Iterator<Phi> phiIt = block.getPhis().iterator();
        while (phiIt.hasNext()) {
            Phi phi = phiIt.next();
            if (!phi.isDead(options)) continue;
            phiIt.remove();
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
                DeadCodeRemover.updateWorklist(worklist, operand);
            }
        }
    }

    private static void removeDeadInstructions(Queue<BasicBlock> worklist, IRCode code, BasicBlock block, InternalOptions options) {
        InstructionListIterator iterator2 = block.listIterator(block.getInstructions().size());
        while (iterator2.hasPrevious()) {
            Instruction current = (Instruction)iterator2.previous();
            if (current.isInvoke() && current.outValue() != null && !current.outValue().isUsed()) {
                current.setOutValue(null);
            }
            if (!current.canBeDeadCode(code, options)) continue;
            Value outValue = current.outValue();
            assert (outValue != null);
            if (!outValue.isDead(options)) continue;
            DeadCodeRemover.updateWorklist(worklist, current);
            outValue.clearUsers();
            iterator2.removeOrReplaceByDebugLocalRead();
        }
    }

    private void removeUnneededCatchHandlers() {
        for (BasicBlock block : this.code.blocks) {
            if (!block.hasCatchHandlers()) continue;
            if (block.canThrow()) {
                if (!this.options.enableVerticalClassMerging) continue;
                block.renameGuardsInCatchHandlers(this.graphLense);
                this.unlinkDeadCatchHandlers(block);
                continue;
            }
            CatchHandlers<BasicBlock> handlers = block.getCatchHandlers();
            for (BasicBlock target : handlers.getUniqueTargets()) {
                target.unlinkCatchHandler();
            }
        }
        this.code.removeUnreachableBlocks();
    }

    private void unlinkDeadCatchHandlers(BasicBlock block) {
        assert (block.hasCatchHandlers());
        CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
        List<DexType> guards = catchHandlers.getGuards();
        List<BasicBlock> targets = catchHandlers.getAllTargets();
        HashSet<DexType> previouslySeenGuards = new HashSet<DexType>();
        ArrayList<BasicBlock> deadCatchHandlers = new ArrayList<BasicBlock>();
        for (int i = 0; i < guards.size(); ++i) {
            boolean guardSeenBefore;
            DexType guard = this.graphLense.lookupType(guards.get(i));
            boolean bl = guardSeenBefore = !previouslySeenGuards.add(guard);
            if (!guardSeenBefore) continue;
            deadCatchHandlers.add(targets.get(i));
        }
        for (BasicBlock deadCatchHandler : deadCatchHandlers) {
            deadCatchHandler.unlinkCatchHandler();
        }
        assert (block.consistentCatchHandlers());
    }
}

