/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.staticizer;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.staticizer.StaticizingProcessor;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public final class ClassStaticizer {
    final Enqueuer.AppInfoWithLiveness appInfo;
    final DexItemFactory factory;
    final IRConverter converter;
    private Phase phase = Phase.None;
    private BiConsumer<DexEncodedMethod, IRCode> fixupStrategy = null;
    final ConcurrentHashMap<DexType, CandidateInfo> candidates = new ConcurrentHashMap();

    public ClassStaticizer(Enqueuer.AppInfoWithLiveness appInfo, IRConverter converter) {
        this.appInfo = appInfo;
        this.factory = appInfo.dexItemFactory;
        this.converter = converter;
    }

    public final void collectCandidates(DexApplication app) {
        Set notEligible = Sets.newIdentityHashSet();
        HashMap singletonFields = new HashMap();
        app.classes().forEach(cls -> {
            DexEncodedField[] dexEncodedFieldArray = cls.staticFields();
            int n = dexEncodedFieldArray.length;
            for (int i = 0; i < n; ++i) {
                DexEncodedField field;
                DexType type = field.field.type;
                field = dexEncodedFieldArray[i];
                if (singletonFields.put(type, field) == null) continue;
                notEligible.add(type);
            }
            for (DexEncodedField field : cls.instanceFields()) {
                notEligible.add(field.field.type);
            }
            for (DexEncodedMethod method : cls.methods()) {
                DexProto proto = method.method.proto;
                notEligible.add(proto.returnType);
                notEligible.addAll(Arrays.asList(proto.parameters.values));
            }
            if (cls.isInterface() || cls.accessFlags.isAbstract() || cls.instanceFields().length > 0 || cls.superType != this.factory.objectType || cls.type.hasSubtypes() || !cls.interfaces.isEmpty()) {
                notEligible.add(cls.type);
            }
        });
        app.classes().forEach(cls -> {
            DexEncodedField field;
            DexType type = cls.type;
            if (!(notEligible.contains(type) || (field = (DexEncodedField)singletonFields.get(type)) == null || field.accessFlags.isVolatile() || this.isPinned((DexClass)cls, field))) {
                assert (field.accessFlags.isStatic());
                new CandidateInfo((DexProgramClass)cls, field);
            }
        });
        this.phase = Phase.Examine;
    }

    private boolean isPinned(DexClass clazz, DexEncodedField singletonField) {
        if (this.appInfo.isPinned(clazz.type) || this.appInfo.isPinned(singletonField.field)) {
            return true;
        }
        for (DexEncodedMethod method : clazz.methods()) {
            if (method.isStatic() || !this.appInfo.isPinned(method.method)) continue;
            return true;
        }
        return false;
    }

    public final void examineMethodCode(DexEncodedMethod method, IRCode code) {
        if (this.phase != Phase.Examine) {
            return;
        }
        Set<Instruction> alreadyProcessed = Sets.newIdentityHashSet();
        CandidateInfo receiverClassCandidateInfo = this.candidates.get(method.method.holder);
        Value receiverValue = code.getThis();
        if (receiverClassCandidateInfo != null && receiverValue != null) {
            this.analyzeAllValueUsers(receiverClassCandidateInfo, receiverValue, this.factory.isConstructor(method.method));
            if (this.candidates.get(method.method.holder) != null) {
                alreadyProcessed.addAll(receiverValue.uniqueUsers());
            }
        }
        ListIterator<Instruction> iterator2 = Lists.newArrayList(code.instructionIterator()).listIterator();
        while (iterator2.hasNext()) {
            CandidateInfo candidateInfo;
            Instruction instruction = iterator2.next();
            if (alreadyProcessed.contains(instruction)) continue;
            if (instruction.isNewInstance()) {
                NewInstance newInstance = instruction.asNewInstance();
                candidateInfo = this.processInstantiation(method, iterator2, newInstance);
                if (candidateInfo == null) continue;
                while (iterator2.hasNext()) {
                    if (this.isAllowedInHostClassInitializer(method.method.holder, iterator2.next(), code)) continue;
                    candidateInfo.preserveRead.set(true);
                    iterator2.previous();
                    break;
                }
                candidateInfo.referencedFrom.add(method);
                continue;
            }
            if (instruction.isStaticPut()) {
                DexType candidateType = instruction.asStaticPut().getField().type;
                candidateInfo = this.candidates.get(candidateType);
                if (candidateInfo == null) continue;
                candidateInfo.invalidate();
                continue;
            }
            if (instruction.isStaticGet()) {
                CandidateInfo info = this.processStaticFieldRead(instruction.asStaticGet());
                if (info == null) continue;
                info.referencedFrom.add(method);
                Value value = instruction.outValue();
                if (value == null) continue;
                alreadyProcessed.addAll(value.uniqueUsers());
                continue;
            }
            if (instruction.isInvokeMethodWithReceiver()) {
                DexMethod invokedMethod = instruction.asInvokeMethodWithReceiver().getInvokedMethod();
                candidateInfo = this.candidates.get(invokedMethod.holder);
                if (candidateInfo == null) continue;
                candidateInfo.invalidate();
                continue;
            }
            if (instruction.isInvokeCustom()) {
                CallSiteReferencesInvalidator invalidator = new CallSiteReferencesInvalidator(this.factory);
                invalidator.registerCallSite(instruction.asInvokeCustom().getCallSite());
                continue;
            }
            if (!instruction.isInstanceGet() && !instruction.isInstancePut()) continue;
            DexField fieldReferenced = instruction.asFieldInstruction().getField();
            candidateInfo = this.candidates.get(fieldReferenced.clazz);
            if (candidateInfo == null) continue;
            candidateInfo.invalidate();
        }
    }

    private boolean isAllowedInHostClassInitializer(DexType host, Instruction insn, IRCode code) {
        return insn.isStaticPut() && insn.asStaticPut().getField().clazz == host || insn.isConstNumber() || insn.isConstString() || insn.isGoto() && insn.asGoto().isTrivialGotoToTheNextBlock(code) || insn.isReturn();
    }

    private CandidateInfo processInstantiation(DexEncodedMethod method, ListIterator<Instruction> iterator2, NewInstance newInstance) {
        DexType candidateType = newInstance.clazz;
        CandidateInfo candidateInfo = this.candidates.get(candidateType);
        if (candidateInfo == null) {
            return null;
        }
        if (iterator2.previousIndex() != 0) {
            return candidateInfo.invalidate();
        }
        if (!candidateInfo.isHostClassInitializer(method)) {
            return candidateInfo.invalidate();
        }
        if (candidateInfo.instancesCreated.incrementAndGet() > 1) {
            return candidateInfo.invalidate();
        }
        Value candidateValue = newInstance.dest();
        if (candidateValue == null) {
            return candidateInfo.invalidate();
        }
        if (candidateValue.numberOfPhiUsers() > 0) {
            return candidateInfo.invalidate();
        }
        if (candidateValue.numberOfUsers() != 2) {
            return candidateInfo.invalidate();
        }
        while (iterator2.hasNext() && this.isNonThrowingConstInstruction(iterator2.next())) {
        }
        iterator2.previous();
        if (!iterator2.hasNext()) {
            return candidateInfo.invalidate();
        }
        if (!this.isValidInitCall(candidateInfo, iterator2.next(), candidateValue, candidateType)) {
            iterator2.previous();
            return candidateInfo.invalidate();
        }
        if (!iterator2.hasNext()) {
            return candidateInfo.invalidate();
        }
        if (!this.isValidStaticPut(candidateInfo, iterator2.next())) {
            iterator2.previous();
            return candidateInfo.invalidate();
        }
        if (candidateInfo.fieldWrites.incrementAndGet() > 1) {
            return candidateInfo.invalidate();
        }
        return candidateInfo;
    }

    private boolean isNonThrowingConstInstruction(Instruction instruction) {
        return instruction.isConstInstruction() && !instruction.instructionTypeCanThrow();
    }

    private boolean isValidInitCall(CandidateInfo info, Instruction instruction, Value candidateValue, DexType candidateType) {
        if (!instruction.isInvokeDirect()) {
            return false;
        }
        InvokeDirect invoke = instruction.asInvokeDirect();
        DexEncodedMethod methodInvoked = this.appInfo.lookupDirectTarget(invoke.getInvokedMethod());
        List<Value> values2 = invoke.inValues();
        if (values2.lastIndexOf(candidateValue) != 0 || methodInvoked == null || methodInvoked.method.holder != candidateType) {
            return false;
        }
        for (int i = 1; i < values2.size(); ++i) {
            if (values2.get((int)i).definition.isConstInstruction()) continue;
            return false;
        }
        DexEncodedMethod previous = info.constructor.getAndSet(methodInvoked);
        assert (previous == null);
        return true;
    }

    private boolean isValidStaticPut(CandidateInfo info, Instruction instruction) {
        if (!instruction.isStaticPut()) {
            return false;
        }
        StaticPut staticPut = instruction.asStaticPut();
        DexEncodedField fieldAccessed = this.appInfo.lookupStaticTarget(staticPut.getField().clazz, staticPut.getField());
        return fieldAccessed == info.singletonField;
    }

    private CandidateInfo processStaticFieldRead(StaticGet staticGet) {
        DexField field = staticGet.getField();
        DexType candidateType = field.type;
        CandidateInfo candidateInfo = this.candidates.get(candidateType);
        if (candidateInfo == null) {
            return null;
        }
        assert (candidateInfo.singletonField == this.appInfo.lookupStaticTarget(field.clazz, field)) : "Added reference after collectCandidates(...)?";
        Value singletonValue = staticGet.dest();
        if (singletonValue != null) {
            candidateInfo = this.analyzeAllValueUsers(candidateInfo, singletonValue, false);
        }
        return candidateInfo;
    }

    private CandidateInfo analyzeAllValueUsers(CandidateInfo candidateInfo, Value value, boolean ignoreSuperClassInitInvoke) {
        assert (value != null);
        if (value.numberOfPhiUsers() > 0) {
            return candidateInfo.invalidate();
        }
        for (Instruction user : value.uniqueUsers()) {
            if (user.isInvokeVirtual() || user.isInvokeDirect()) {
                DexEncodedMethod methodInvoked;
                InvokeMethodWithReceiver invoke = user.asInvokeMethodWithReceiver();
                DexMethod methodReferenced = invoke.getInvokedMethod();
                if (this.factory.isConstructor(methodReferenced)) {
                    assert (user.isInvokeDirect());
                    if (ignoreSuperClassInitInvoke && invoke.inValues().lastIndexOf(value) == 0 && methodReferenced == this.factory.objectMethods.constructor) continue;
                    return candidateInfo.invalidate();
                }
                DexEncodedMethod dexEncodedMethod = methodInvoked = user.isInvokeDirect() ? this.appInfo.lookupDirectTarget(methodReferenced) : this.appInfo.lookupVirtualTarget(methodReferenced.holder, methodReferenced);
                if (invoke.inValues().lastIndexOf(value) == 0 && methodInvoked != null && methodInvoked.method.holder == candidateInfo.candidate.type) continue;
            }
            return candidateInfo.invalidate();
        }
        return candidateInfo;
    }

    public final void staticizeCandidates(OptimizationFeedback feedback) {
        this.phase = Phase.None;
        new StaticizingProcessor(this).run(feedback);
    }

    public final void fixupMethodCode(DexEncodedMethod method, IRCode code) {
        if (this.phase == Phase.Fixup) {
            assert (this.fixupStrategy != null);
            this.fixupStrategy.accept(method, code);
        }
    }

    void setFixupStrategy(BiConsumer<DexEncodedMethod, IRCode> strategy) {
        assert (this.phase == Phase.None);
        assert (strategy != null);
        this.phase = Phase.Fixup;
        this.fixupStrategy = strategy;
    }

    void cleanFixupStrategy() {
        assert (this.phase == Phase.Fixup);
        assert (this.fixupStrategy != null);
        this.phase = Phase.None;
        this.fixupStrategy = null;
    }

    private class CallSiteReferencesInvalidator
    extends UseRegistry {
        private CallSiteReferencesInvalidator(DexItemFactory factory) {
            super(factory);
        }

        private boolean registerMethod(DexMethod method) {
            this.registerTypeReference(method.holder);
            this.registerProto(method.proto);
            return true;
        }

        private boolean registerField(DexField field) {
            this.registerTypeReference(field.clazz);
            this.registerTypeReference(field.type);
            return true;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.registerField(field);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.registerField(field);
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return this.registerTypeReference(type);
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.registerField(field);
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.registerField(field);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            CandidateInfo candidateInfo = ClassStaticizer.this.candidates.get(type);
            if (candidateInfo != null) {
                candidateInfo.invalidate();
            }
            return true;
        }
    }

    final class CandidateInfo {
        final DexProgramClass candidate;
        final DexEncodedField singletonField;
        final AtomicBoolean preserveRead = new AtomicBoolean(false);
        final AtomicInteger fieldWrites = new AtomicInteger();
        final AtomicInteger instancesCreated = new AtomicInteger();
        final Set<DexEncodedMethod> referencedFrom = Sets.newConcurrentHashSet();
        final AtomicReference<DexEncodedMethod> constructor = new AtomicReference();

        CandidateInfo(DexProgramClass candidate, DexEncodedField singletonField) {
            assert (candidate != null);
            assert (singletonField != null);
            this.candidate = candidate;
            this.singletonField = singletonField;
            ClassStaticizer.this.candidates.put(candidate.type, this);
        }

        boolean isHostClassInitializer(DexEncodedMethod method) {
            return ClassStaticizer.this.factory.isClassConstructor(method.method) && method.method.holder == this.hostType();
        }

        DexType hostType() {
            return this.singletonField.field.clazz;
        }

        DexClass hostClass() {
            DexClass hostClass = ClassStaticizer.this.appInfo.definitionFor(this.hostType());
            assert (hostClass != null);
            return hostClass;
        }

        CandidateInfo invalidate() {
            ClassStaticizer.this.candidates.remove(this.candidate.type);
            return null;
        }
    }

    private static enum Phase {
        None,
        Examine,
        Fixup;

    }
}

