/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8CommandParser;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.errors.DexFileOverflowDiagnostic;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;

@Keep
public final class D8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = D8CommandParser.USAGE_MESSAGE;
    private boolean intermediate = false;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args, Origin origin) {
        return D8CommandParser.parse(args, origin);
    }

    public static Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return D8CommandParser.parse(args, origin, handler);
    }

    private D8Command(AndroidApp inputApp, CompilationMode mode, ProgramConsumer programConsumer2, int minApiLevel, Reporter diagnosticsHandler, boolean enableDesugaring, boolean intermediate, boolean optimizeMultidexForLinearAlloc) {
        super(inputApp, mode, programConsumer2, minApiLevel, diagnosticsHandler, enableDesugaring, optimizeMultidexForLinearAlloc);
        this.intermediate = intermediate;
    }

    private D8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(new DexItemFactory(), this.getReporter());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.programConsumer = this.getProgramConsumer();
        internal.minimalMainDex = internal.debug;
        internal.minApiLevel = this.getMinApiLevel();
        internal.intermediate = this.intermediate;
        assert (internal.enableMinification);
        internal.enableMinification = false;
        assert (internal.enableTreeShaking);
        internal.enableTreeShaking = false;
        assert (!internal.passthroughDexCode);
        internal.passthroughDexCode = true;
        assert (internal.enableInlining);
        internal.enableInlining = false;
        assert (internal.enableClassInlining);
        internal.enableClassInlining = false;
        assert (internal.enableVerticalClassMerging);
        internal.enableVerticalClassMerging = false;
        assert (internal.enableClassStaticizer);
        internal.enableClassStaticizer = false;
        assert (internal.enableSwitchMapRemoval);
        internal.enableSwitchMapRemoval = false;
        assert (internal.outline.enabled);
        internal.outline.enabled = false;
        assert (internal.enableValuePropagation);
        internal.enableValuePropagation = false;
        internal.enableDesugaring = this.getEnableDesugaring();
        internal.enableLambdaMerging = false;
        internal.enableInheritanceClassInDexDistributor = this.isOptimizeMultidexForLinearAlloc();
        return internal;
    }

    @Keep
    public static class Builder
    extends BaseCompilerCommand.Builder<D8Command, Builder> {
        private boolean intermediate = false;

        private Builder() {
            this(new DefaultD8DiagnosticsHandler());
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        private Builder(AndroidApp app) {
            super(app);
        }

        public Builder addDexProgramData(byte[] data, Origin origin) {
            this.guard(() -> this.getAppBuilder().addDexProgramData(data, origin));
            return this.self();
        }

        public Builder addClasspathFiles(Path ... files) {
            this.guard(() -> Arrays.stream(files).forEach(this::addClasspathFile));
            return this.self();
        }

        public Builder addClasspathFiles(Collection<Path> files) {
            this.guard(() -> files.forEach(this::addClasspathFile));
            return this.self();
        }

        private void addClasspathFile(Path file) {
            this.guard(() -> this.getAppBuilder().addClasspathFile(file));
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider2) {
            this.guard(() -> this.getAppBuilder().addClasspathResourceProvider(provider2));
            return this.self();
        }

        public Builder setIntermediate(boolean value) {
            this.intermediate = value;
            return this.self();
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        CompilationMode defaultCompilationMode() {
            return CompilationMode.DEBUG;
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.getProgramConsumer() instanceof ClassFileConsumer) {
                reporter.error("D8 does not support compiling to Java class files");
            }
            if (this.getAppBuilder().hasMainDexList()) {
                if (this.intermediate) {
                    reporter.error("Option --main-dex-list cannot be used with --intermediate");
                }
                if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                    reporter.error("Option --main-dex-list cannot be used with --file-per-class");
                }
            }
            super.validate();
        }

        @Override
        D8Command makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new D8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.intermediate |= this.getProgramConsumer() instanceof DexFilePerClassFileConsumer;
            return new D8Command(this.getAppBuilder().build(), this.getMode(), this.getProgramConsumer(), this.getMinApiLevel(), this.getReporter(), !this.getDisableDesugaring(), this.intermediate, this.isOptimizeMultidexForLinearAlloc());
        }
    }

    private static class DefaultD8DiagnosticsHandler
    implements DiagnosticsHandler {
        private DefaultD8DiagnosticsHandler() {
        }

        @Override
        public void error(Diagnostic error) {
            DexFileOverflowDiagnostic overflowDiagnostic;
            if (error instanceof DexFileOverflowDiagnostic && !(overflowDiagnostic = (DexFileOverflowDiagnostic)error).hasMainDexSpecification()) {
                DiagnosticsHandler.super.error(new StringDiagnostic(overflowDiagnostic.getDiagnosticMessage() + ". Try supplying a main-dex list"));
                return;
            }
            DiagnosticsHandler.super.error(error);
        }
    }

    private static class ClasspathInputOrigin
    extends BaseCommand.InputFileOrigin {
        public ClasspathInputOrigin(Path file) {
            super("classpath input", file);
        }
    }
}

