/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dexsplitter;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DexSplitterHelper;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.FeatureClassMapping;
import com.android.tools.r8.utils.OptionsParsing;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Keep
public final class DexSplitter {
    private static final String DEFAULT_OUTPUT_DIR = "output";
    private static final String DEFAULT_BASE_NAME = "base";
    private static final boolean PRINT_ARGS = false;

    private static FeatureJar parseFeatureJarArgument(String argument) {
        if (argument.contains(":")) {
            String[] parts = argument.split(":");
            if (parts.length > 2) {
                throw new RuntimeException("--feature-jar argument contains more than one :");
            }
            return new FeatureJar(parts[0], parts[1]);
        }
        return new FeatureJar(argument);
    }

    private static Options parseArguments(String[] args) {
        Options options = new Options();
        OptionsParsing.ParseContext context = new OptionsParsing.ParseContext(args);
        while (context.head() != null) {
            List<String> inputs = OptionsParsing.tryParseMulti(context, "--input");
            if (inputs != null) {
                inputs.forEach(options::addInputArchive);
                continue;
            }
            List<String> featureJars = OptionsParsing.tryParseMulti(context, "--feature-jar");
            if (featureJars != null) {
                featureJars.forEach(feature -> options.addFeatureJar(DexSplitter.parseFeatureJarArgument(feature)));
                continue;
            }
            List<String> baseJars = OptionsParsing.tryParseMulti(context, "--base-jar");
            if (baseJars != null) {
                baseJars.forEach(options::addBaseJar);
                continue;
            }
            String output = OptionsParsing.tryParseSingle(context, "--output", "-o");
            if (output != null) {
                options.setOutput(output);
                continue;
            }
            String proguardMap = OptionsParsing.tryParseSingle(context, "--proguard-map", null);
            if (proguardMap != null) {
                options.setProguardMap(proguardMap);
                continue;
            }
            String baseOutputName = OptionsParsing.tryParseSingle(context, "--base-output-name", null);
            if (baseOutputName != null) {
                options.setBaseOutputName(baseOutputName);
                continue;
            }
            String featureSplit = OptionsParsing.tryParseSingle(context, "--feature-splits", null);
            if (featureSplit != null) {
                options.setFeatureSplitMapping(featureSplit);
                continue;
            }
            Boolean b = OptionsParsing.tryParseBoolean(context, "--split-non-class-resources");
            if (b != null) {
                options.setSplitNonClassResources(b);
                continue;
            }
            throw new RuntimeException(String.format("Unknown options: '%s'.", context.head()));
        }
        return options;
    }

    private static FeatureClassMapping createFeatureClassMapping(Options options) throws FeatureClassMapping.FeatureMappingException {
        if (options.getFeatureSplitMapping() != null) {
            return FeatureClassMapping.fromSpecification(Paths.get(options.getFeatureSplitMapping(), new String[0]), options.getDiagnosticsHandler());
        }
        assert (!options.getFeatureJars().isEmpty());
        return FeatureClassMapping.Internal.fromJarFiles(options.getFeatureJars(), options.getBaseJars(), options.getBaseOutputName(), options.getDiagnosticsHandler());
    }

    private static void run(String[] args) throws CompilationFailedException, FeatureClassMapping.FeatureMappingException {
        Options options = DexSplitter.parseArguments(args);
        DexSplitter.run(options);
    }

    public static void run(Options options) throws FeatureClassMapping.FeatureMappingException, CompilationFailedException {
        boolean errors = false;
        if (options.getInputArchives().isEmpty()) {
            errors = true;
            options.error("Need at least one --input");
        }
        if (options.getFeatureSplitMapping() == null && options.getFeatureJars().isEmpty()) {
            errors = true;
            options.error("You must supply a feature split mapping or feature jars");
        }
        if (options.getFeatureSplitMapping() != null && !options.getFeatureJars().isEmpty()) {
            errors = true;
            options.error("You can't supply both a feature split mapping and feature jars");
        }
        if (errors) {
            throw new AbortException();
        }
        D8Command.Builder builder = D8Command.builder();
        for (String s : options.inputArchives) {
            builder.addProgramFiles(Paths.get(s, new String[0]));
        }
        builder.setProgramConsumer(DexIndexedConsumer.emptyConsumer());
        FeatureClassMapping featureClassMapping = DexSplitter.createFeatureClassMapping(options);
        DexSplitterHelper.run((D8Command)builder.build(), featureClassMapping, options.getOutput(), options.getProguardMap());
        if (options.splitNonClassResources) {
            DexSplitter.splitNonClassResources(options, featureClassMapping);
        }
    }

    private static void splitNonClassResources(Options options, FeatureClassMapping featureClassMapping) {
        for (String s : options.inputArchives) {
            try (ZipFile zipFile = new ZipFile(s, StandardCharsets.UTF_8);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (ZipUtils.isDexFile(name) || ZipUtils.isClassFile(name)) continue;
                    String feature = featureClassMapping.featureForNonClass(name);
                    Path outputDir = Paths.get(options.getOutput(), new String[0]).resolve(feature);
                    InputStream stream = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        Path outputFile = outputDir.resolve(name);
                        Path parent = outputFile.getParent();
                        if (parent != null) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        Files.copy(stream, outputFile, new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        DexSplitter.$closeResource(throwable, stream);
                    }
                }
            }
            catch (IOException e) {
                options.getDiagnosticsHandler().error(new ExceptionDiagnostic(e, new ZipFileOrigin(Paths.get(s, new String[0]))));
                throw new AbortException();
            }
        }
    }

    public static void main(String[] args) {
        ExceptionUtils.withMainProgramHandler(() -> {
            try {
                DexSplitter.run(args);
            }
            catch (FeatureClassMapping.FeatureMappingException e) {
                System.err.println("Splitting failed: " + e.getMessage());
                System.exit(1);
            }
        });
    }

    private static void printArgs(String[] args) {
        System.err.printf("r8.DexSplitter", new Object[0]);
        for (String s : args) {
            System.err.printf(" %s", s);
        }
        System.err.println("");
    }

    @Keep
    public static final class Options {
        private final DiagnosticsHandler diagnosticsHandler = new DiagnosticsHandler(){};
        private List<String> inputArchives = new ArrayList<String>();
        private List<FeatureJar> featureJars = new ArrayList<FeatureJar>();
        private List<String> baseJars = new ArrayList<String>();
        private String baseOutputName = "base";
        private String output = "output";
        private String featureSplitMapping;
        private String proguardMap;
        private boolean splitNonClassResources = false;

        public DiagnosticsHandler getDiagnosticsHandler() {
            return this.diagnosticsHandler;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public String getFeatureSplitMapping() {
            return this.featureSplitMapping;
        }

        public void setFeatureSplitMapping(String featureSplitMapping) {
            this.featureSplitMapping = featureSplitMapping;
        }

        public String getProguardMap() {
            return this.proguardMap;
        }

        public void setProguardMap(String proguardMap) {
            this.proguardMap = proguardMap;
        }

        public String getBaseOutputName() {
            return this.baseOutputName;
        }

        public void setBaseOutputName(String baseOutputName) {
            this.baseOutputName = baseOutputName;
        }

        public void addInputArchive(String inputArchive) {
            this.inputArchives.add(inputArchive);
        }

        public void addBaseJar(String baseJar) {
            this.baseJars.add(baseJar);
        }

        private void addFeatureJar(FeatureJar featureJar) {
            this.featureJars.add(featureJar);
        }

        public void addFeatureJar(String jar) {
            this.featureJars.add(new FeatureJar(jar));
        }

        public void addFeatureJar(String jar, String outputName) {
            this.featureJars.add(new FeatureJar(jar, outputName));
        }

        public void setSplitNonClassResources(boolean value) {
            this.splitNonClassResources = value;
        }

        public ImmutableList<String> getInputArchives() {
            return ImmutableList.copyOf(this.inputArchives);
        }

        ImmutableList<FeatureJar> getFeatureJars() {
            return ImmutableList.copyOf(this.featureJars);
        }

        ImmutableList<String> getBaseJars() {
            return ImmutableList.copyOf(this.baseJars);
        }

        public void error(String msg) {
            this.diagnosticsHandler.error(new StringDiagnostic(msg));
        }
    }

    private static class ZipFileOrigin
    extends PathOrigin {
        public ZipFileOrigin(Path path) {
            super(path);
        }

        @Override
        public String part() {
            return "splitting of file '" + super.part() + "'";
        }
    }

    public static class FeatureJar {
        private String jar;
        private String outputName;

        public FeatureJar(String jar, String outputName) {
            this.jar = jar;
            this.outputName = outputName;
        }

        public FeatureJar(String jar) {
            this(jar, FeatureJar.featureNameFromJar(jar));
        }

        public String getJar() {
            return this.jar;
        }

        public String getOutputName() {
            return this.outputName;
        }

        private static String featureNameFromJar(String jar) {
            Path jarPath = Paths.get(jar, new String[0]);
            String featureName = jarPath.getFileName().toString();
            if (featureName.endsWith(".jar") || featureName.endsWith(".zip")) {
                featureName = featureName.substring(0, featureName.length() - 4);
            }
            return featureName;
        }
    }
}

