/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.ir.code.Dup;
import com.android.tools.r8.ir.code.Dup2;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.Match;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import com.android.tools.r8.ir.optimize.peepholes.Point;

public class DupDupDupPeephole
implements BasicBlockPeephole {
    private final Point dup1Exp = new Point(i -> i.isDup() && !i.inValues().get(0).getTypeLattice().isWide());
    private final Point dup2Exp = new Point(i -> i.isDup() && !i.inValues().get(0).getTypeLattice().isWide());
    private final Point dup3Exp = new Point(i -> i.isDup() && !i.inValues().get(0).getTypeLattice().isWide());
    private final PeepholeLayout layout = PeepholeLayout.lookBackward(this.dup1Exp, this.dup2Exp, this.dup3Exp);

    @Override
    public boolean match(InstructionListIterator it) {
        Match match = this.layout.test(it);
        if (match == null) {
            return false;
        }
        Dup dupTop = this.dup3Exp.get(match).asDup();
        Dup dupMiddle = this.dup2Exp.get(match).asDup();
        Dup dupBottom = this.dup1Exp.get(match).asDup();
        StackValue src = (StackValue)dupTop.inValues().get(0);
        StackValue srcMiddle = (StackValue)dupMiddle.inValues().get(0);
        StackValue srcBottom = (StackValue)dupBottom.inValues().get(0);
        StackValues tv = (StackValues)dupTop.outValue();
        StackValues mv = (StackValues)dupMiddle.outValue();
        StackValues bv = (StackValues)dupBottom.outValue();
        StackValue tv0Dup2 = tv.getStackValues().get(0).duplicate(src.getHeight());
        StackValue mv0Dup2 = mv.getStackValues().get(0).duplicate(src.getHeight() + 1);
        StackValue bv0Dup2 = bv.getStackValues().get(0).duplicate(src.getHeight() + 2);
        StackValue bv1Dup2 = bv.getStackValues().get(1).duplicate(src.getHeight() + 3);
        srcMiddle.removeUser(dupMiddle);
        srcBottom.removeUser(dupBottom);
        tv.getStackValues().get(0).replaceUsers(tv0Dup2);
        mv.getStackValues().get(0).replaceUsers(mv0Dup2);
        bv.getStackValues().get(0).replaceUsers(bv0Dup2);
        bv.getStackValues().get(1).replaceUsers(bv1Dup2);
        StackValues dest = new StackValues(ImmutableList.of(tv0Dup2, mv0Dup2, bv0Dup2, bv1Dup2));
        Dup2 dup2 = new Dup2(dest, tv.getStackValues().get(0), tv.getStackValues().get(1));
        it.removeOrReplaceByDebugLocalRead();
        it.previous();
        it.replaceCurrentInstruction(dup2);
        PeepholeHelper.resetPrevious(it, 1);
        return true;
    }
}

