/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Queues;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.naming.IdentifierNameStringUtils;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationUtils;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ReasonPrinter;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.ScopedDexMethodSet;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Enqueuer {
    private final boolean forceProguardCompatibility;
    private boolean tracingMainDex = false;
    private final AppInfoWithSubtyping appInfo;
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final InternalOptions options;
    private RootSetBuilder.RootSet rootSet;
    private final Map<DexType, Set<DexMethod>> virtualInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexMethod>> interfaceInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexMethod>>> superInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexMethod>> directInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexMethod>> staticInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexField>>> instanceFieldsWritten = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexField>>> instanceFieldsRead = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexField>>> staticFieldsRead = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexField>>> staticFieldsWritten = Maps.newIdentityHashMap();
    private final Set<DexCallSite> callSites = Sets.newIdentityHashSet();
    private final Set<DexReference> identifierNameStrings = Sets.newIdentityHashSet();
    private final Set<DexMethod> brokenSuperInvokes = Sets.newIdentityHashSet();
    private final Map<DexType, SetWithReason<DexEncodedMethod>> reachableVirtualMethods = Maps.newIdentityHashMap();
    private final Map<DexEncodedMethod, Set<DexEncodedMethod>> superInvokeDependencies = Maps.newIdentityHashMap();
    private final Map<DexType, SetWithReason<DexEncodedField>> reachableInstanceFields = Maps.newIdentityHashMap();
    private final Set<DexType> liveTypes = Sets.newIdentityHashSet();
    private final SetWithReason<DexType> instantiatedTypes = new SetWithReason();
    private final SetWithReason<DexEncodedMethod> targetedMethods = new SetWithReason();
    private final Set<DexMethod> virtualMethodsTargetedByInvokeDirect = Sets.newIdentityHashSet();
    private final SetWithReason<DexEncodedMethod> liveMethods = new SetWithReason();
    private final SetWithReason<DexEncodedField> liveFields = new SetWithReason();
    private final SetWithReason<DexType> instantiatedLambdas = new SetWithReason();
    private final Queue<Action> workList = Queues.newArrayDeque();
    private final Queue<Action> proguardCompatibilityWorkList = Queues.newArrayDeque();
    private final Set<DexEncodedMethod> pendingReflectiveUses = Sets.newLinkedHashSet();
    private final Set<DexMethod> virtualTargetsMarkedAsReachable = Sets.newIdentityHashSet();
    private final Set<DexReference> reportedMissing = Sets.newIdentityHashSet();
    private final Set<DexDefinition> pinnedItems = Sets.newIdentityHashSet();
    private final Map<DexType, Set<DexAnnotation>> deferredAnnotations = new IdentityHashMap<DexType, Set<DexAnnotation>>();
    private final ProguardConfiguration.Builder compatibility;

    public Enqueuer(AppView<? extends AppInfoWithSubtyping> appView, InternalOptions options) {
        this(appView, options, options.forceProguardCompatibility, null);
    }

    public Enqueuer(AppView<? extends AppInfoWithSubtyping> appView, InternalOptions options, ProguardConfiguration.Builder compatibility) {
        this(appView, options, options.forceProguardCompatibility, compatibility);
    }

    public Enqueuer(AppView<? extends AppInfoWithSubtyping> appView, InternalOptions options, boolean forceProguardCompatibility) {
        this(appView, options, forceProguardCompatibility, null);
    }

    public Enqueuer(AppView<? extends AppInfoWithSubtyping> appView, InternalOptions options, boolean forceProguardCompatibility, ProguardConfiguration.Builder compatibility) {
        this.appInfo = appView.appInfo();
        this.appView = appView;
        this.compatibility = compatibility;
        this.forceProguardCompatibility = forceProguardCompatibility;
        this.options = options;
    }

    private void enqueueRootItems(Map<DexDefinition, ProguardKeepRule> items) {
        items.entrySet().forEach(this::enqueueRootItem);
    }

    private void enqueueRootItem(Map.Entry<DexDefinition, ProguardKeepRule> root) {
        this.enqueueRootItem(root.getKey(), root.getValue());
    }

    private void enqueueRootItem(DexDefinition item, ProguardKeepRule rule) {
        this.enqueueRootItem(item, KeepReason.dueToKeepRule(rule));
    }

    private void enqueueRootItem(DexDefinition item, KeepReason reason) {
        if (item.isDexClass()) {
            DexClass clazz = item.asDexClass();
            this.workList.add(Action.markInstantiated(clazz, reason));
            if (clazz.hasDefaultInitializer()) {
                if (this.forceProguardCompatibility) {
                    ProguardKeepRule compatRule = ProguardConfigurationUtils.buildDefaultInitializerKeepRule(clazz);
                    this.proguardCompatibilityWorkList.add(Action.markMethodLive(clazz.getDefaultInitializer(), KeepReason.dueToProguardCompatibilityKeepRule(compatRule)));
                }
                if (clazz.isExternalizable(this.appInfo)) {
                    this.workList.add(Action.markMethodLive(clazz.getDefaultInitializer(), reason));
                }
            }
        } else if (item.isDexEncodedField()) {
            this.workList.add(Action.markFieldKept(item.asDexEncodedField(), reason));
        } else if (item.isDexEncodedMethod()) {
            this.workList.add(Action.markMethodKept(item.asDexEncodedMethod(), reason));
        } else {
            throw new IllegalArgumentException(item.toString());
        }
        this.pinnedItems.add(item);
    }

    private void enqueueFirstNonSerializableClassInitializer(DexClass clazz, KeepReason reason) {
        assert (clazz.isProgramClass() && clazz.isSerializable(this.appInfo));
        while (clazz != null && clazz.isProgramClass() && clazz.isSerializable(this.appInfo)) {
            clazz = this.appInfo.definitionFor(clazz.superType);
        }
        if (clazz != null && clazz.isProgramClass() && clazz.hasDefaultInitializer()) {
            this.workList.add(Action.markMethodLive(clazz.getDefaultInitializer(), reason));
        }
    }

    private void enqueueHolderIfDependentNonStaticMember(DexClass holder, Map<DexDefinition, ProguardKeepRule> dependentItems) {
        for (Map.Entry<DexDefinition, ProguardKeepRule> entry : dependentItems.entrySet()) {
            DexDefinition dependentItem = entry.getKey();
            if (dependentItem.isDexClass() || dependentItem.isStaticMember()) continue;
            this.enqueueRootItem((DexDefinition)holder, entry.getValue());
            break;
        }
    }

    private <S extends DexItem, T extends Descriptor<S, T>> boolean registerItemWithTarget(Map<DexType, Set<T>> seen, T item) {
        DexType holder = item.getHolder().toBaseType(this.appInfo.dexItemFactory);
        if (!holder.isClassType()) {
            return false;
        }
        this.markTypeAsLive(holder);
        return seen.computeIfAbsent(item.getHolder(), ignore -> Sets.newIdentityHashSet()).add(item);
    }

    private <S extends DexItem, T extends Descriptor<S, T>> boolean registerItemWithTargetAndContext(Map<DexType, Set<TargetWithContext<T>>> seen, T item, DexEncodedMethod context) {
        DexType holder = item.getHolder().toBaseType(this.appInfo.dexItemFactory);
        if (!holder.isClassType()) {
            return false;
        }
        this.markTypeAsLive(holder);
        return seen.computeIfAbsent(item.getHolder(), ignore -> new HashSet()).add(new TargetWithContext(item, context, null));
    }

    private DexMethod getInvokeSuperTarget(DexMethod method, DexEncodedMethod currentMethod) {
        DexClass methodHolderClass = this.appInfo.definitionFor(method.getHolder());
        if (methodHolderClass != null && methodHolderClass.isInterface()) {
            return method;
        }
        DexClass holderClass = this.appInfo.definitionFor(currentMethod.method.getHolder());
        if (holderClass == null || holderClass.superType == null || holderClass.isInterface()) {
            return method;
        }
        return this.appInfo.dexItemFactory.createMethod(holderClass.superType, method.proto, method.name);
    }

    private void markTypeAsLive(DexType type) {
        if (!(type = type.toBaseType(this.appInfo.dexItemFactory)).isClassType()) {
            return;
        }
        if (this.liveTypes.add(type)) {
            Set<DexAnnotation> annotations;
            DexEncodedMethod clinit;
            DexClass holder = this.appInfo.definitionFor(type);
            if (holder == null) {
                this.reportMissingClass(type);
                return;
            }
            for (DexType iface : holder.interfaces.values) {
                this.markTypeAsLive(iface);
            }
            if (holder.superType != null) {
                this.markTypeAsLive(holder.superType);
                if (holder.isLibraryClass()) {
                    this.ensureFromLibraryOrThrow(holder.superType, type);
                    for (DexType iface : holder.interfaces.values) {
                        this.ensureFromLibraryOrThrow(iface, type);
                    }
                }
            }
            if (!holder.annotations.isEmpty()) {
                this.processAnnotations(holder.annotations.annotations);
            }
            KeepReason reason = KeepReason.reachableFromLiveType(type);
            if (!holder.isLibraryClass() && holder.hasNonTrivialClassInitializer() && (clinit = holder.getClassInitializer()) != null) {
                assert (clinit.method.holder == holder.type);
                this.markDirectStaticOrConstructorMethodAsLive(clinit, reason);
            }
            if (holder.isProgramClass() && holder.isSerializable(this.appInfo)) {
                this.enqueueFirstNonSerializableClassInitializer(holder, reason);
            }
            if ((annotations = this.deferredAnnotations.remove(type)) != null) {
                annotations.forEach(this::handleAnnotationOfLiveType);
            }
            Map<DexDefinition, ProguardKeepRule> dependentItems = this.rootSet.getDependentItems(holder);
            this.enqueueHolderIfDependentNonStaticMember(holder, dependentItems);
            this.enqueueRootItems(dependentItems);
        }
    }

    private void handleAnnotationOfLiveType(DexAnnotation annotation) {
        AnnotationReferenceMarker referenceMarker = new AnnotationReferenceMarker(annotation.annotation.type, this.appInfo.dexItemFactory);
        annotation.annotation.collectIndexedItems(referenceMarker);
    }

    private void processAnnotations(DexAnnotation[] annotations) {
        for (DexAnnotation annotation : annotations) {
            this.processAnnotation(annotation);
        }
    }

    private void processAnnotation(DexAnnotation annotation) {
        DexType type = annotation.annotation.type;
        if (this.liveTypes.contains(type)) {
            this.handleAnnotationOfLiveType(annotation);
        } else {
            this.deferredAnnotations.computeIfAbsent(type, ignore -> new HashSet()).add(annotation);
        }
    }

    private void handleInvokeOfStaticTarget(DexMethod method, KeepReason reason) {
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method);
        if (resolutionResult == null) {
            this.reportMissingMethod(method);
            return;
        }
        resolutionResult.forEachTarget(m -> this.markMethodAsTargeted((DexEncodedMethod)m, reason));
        DexEncodedMethod targetMethod = this.appInfo.dispatchStaticInvoke(resolutionResult);
        if (targetMethod != null) {
            this.markDirectStaticOrConstructorMethodAsLive(targetMethod, reason);
        }
    }

    private void handleInvokeOfDirectTarget(DexMethod method, KeepReason reason) {
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method);
        if (resolutionResult == null) {
            this.reportMissingMethod(method);
            return;
        }
        resolutionResult.forEachTarget(m -> this.markMethodAsTargeted((DexEncodedMethod)m, reason));
        DexEncodedMethod target = this.appInfo.dispatchDirectInvoke(resolutionResult);
        if (target != null) {
            this.markDirectStaticOrConstructorMethodAsLive(target, reason);
            if (target.isVirtualMethod()) {
                this.virtualMethodsTargetedByInvokeDirect.add(target.method);
            }
        }
    }

    private void ensureFromLibraryOrThrow(DexType type, DexType context) {
        if (this.tracingMainDex) {
            return;
        }
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder != null && !holder.isLibraryClass()) {
            StringDiagnostic message = new StringDiagnostic("Library class " + context.toSourceString() + (holder.isInterface() ? " implements " : " extends ") + "program class " + type.toSourceString());
            if (this.forceProguardCompatibility) {
                this.options.reporter.warning(message);
            } else {
                this.options.reporter.error(message);
            }
        }
    }

    private void reportMissingClass(DexType clazz) {
    }

    private void reportMissingMethod(DexMethod method) {
    }

    private void reportMissingField(DexField field) {
    }

    private void markMethodAsTargeted(DexEncodedMethod encodedMethod, KeepReason reason) {
        this.markTypeAsLive(encodedMethod.method.holder);
        this.markParameterAndReturnTypesAsLive(encodedMethod);
        this.targetedMethods.add(encodedMethod, reason);
        if (this.forceProguardCompatibility) {
            DexClass clazz = this.appInfo.definitionFor(encodedMethod.method.holder);
            if (!encodedMethod.accessFlags.isAbstract() && clazz.isInterface() && !clazz.isLibraryClass()) {
                this.markMethodAsKeptWithCompatRule(encodedMethod);
            }
        }
    }

    private void processNewlyInstantiatedClass(DexClass clazz, KeepReason reason) {
        if (!this.instantiatedTypes.add(clazz.type, reason)) {
            return;
        }
        this.collectProguardCompatibilityRule(reason);
        this.markTypeAsLive(clazz.type);
        this.transitionMethodsForInstantiatedClass(clazz.type);
        this.transitionFieldsForInstantiatedClass(clazz.type);
        this.enqueueRootItems(this.rootSet.getDependentItems(clazz));
    }

    private void transitionMethodsForInstantiatedClass(DexType instantiatedType) {
        DexClass clazz;
        ScopedDexMethodSet seen = new ScopedDexMethodSet();
        Set<DexType> interfaces = Sets.newIdentityHashSet();
        DexType type = instantiatedType;
        do {
            if ((clazz = this.appInfo.definitionFor(type)) == null) {
                this.reportMissingClass(type);
                break;
            }
            SetWithReason<DexEncodedMethod> reachableMethods = this.reachableVirtualMethods.get(type);
            if (reachableMethods != null) {
                this.transitionNonAbstractMethodsToLiveAndShadow(reachableMethods.getItems(), instantiatedType, seen);
            }
            Collections.addAll(interfaces, clazz.interfaces.values);
        } while ((type = clazz.superType) != null && !this.instantiatedTypes.contains(type));
        for (DexType iface : interfaces) {
            DexClass clazz2 = this.appInfo.definitionFor(iface);
            if (clazz2 == null) {
                this.reportMissingClass(iface);
                break;
            }
            this.transitionDefaultMethodsForInstantiatedClass(iface, instantiatedType, seen);
        }
    }

    private void transitionDefaultMethodsForInstantiatedClass(DexType iface, DexType instantiatedType, ScopedDexMethodSet seen) {
        DexClass clazz = this.appInfo.definitionFor(iface);
        assert (clazz != null) : "Missing class " + iface.toSourceString();
        assert (clazz.accessFlags.isInterface());
        SetWithReason<DexEncodedMethod> reachableMethods = this.reachableVirtualMethods.get(iface);
        if (reachableMethods != null) {
            this.transitionNonAbstractMethodsToLiveAndShadow(reachableMethods.getItems(), instantiatedType, seen.newNestedScope());
        }
        for (DexType subInterface : clazz.interfaces.values) {
            this.transitionDefaultMethodsForInstantiatedClass(subInterface, instantiatedType, seen);
        }
    }

    private void transitionNonAbstractMethodsToLiveAndShadow(Iterable<DexEncodedMethod> reachable, DexType instantiatedType, ScopedDexMethodSet seen) {
        for (DexEncodedMethod encodedMethod : reachable) {
            if (!seen.addMethod(encodedMethod) || encodedMethod.accessFlags.isAbstract()) continue;
            this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(instantiatedType));
        }
    }

    private void transitionFieldsForInstantiatedClass(DexType type) {
        DexClass clazz;
        do {
            if ((clazz = this.appInfo.definitionFor(type)) == null) {
                this.reportMissingClass(type);
                break;
            }
            SetWithReason<DexEncodedField> reachableFields = this.reachableInstanceFields.get(type);
            if (reachableFields == null) continue;
            for (DexEncodedField field : reachableFields.getItems()) {
                this.markInstanceFieldAsLive(field, KeepReason.reachableFromLiveType(type));
            }
        } while ((type = clazz.superType) != null && !this.instantiatedTypes.contains(type));
    }

    private void markStaticFieldAsLive(DexField field, KeepReason reason) {
        this.markTypeAsLive(field.clazz);
        this.markTypeAsLive(field.type);
        DexEncodedField encodedField = this.appInfo.resolveFieldOn(field.clazz, field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return;
        }
        if (encodedField.accessFlags.isStatic()) {
            // empty if block
        }
        this.liveFields.add(encodedField, reason);
        this.collectProguardCompatibilityRule(reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(encodedField));
    }

    private void markInstanceFieldAsLive(DexEncodedField field, KeepReason reason) {
        assert (field != null);
        this.markTypeAsLive(field.field.clazz);
        this.markTypeAsLive(field.field.type);
        this.liveFields.add(field, reason);
        this.collectProguardCompatibilityRule(reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(field));
    }

    private void markInstantiated(DexType type, KeepReason keepReason) {
        if (this.instantiatedTypes.contains(type)) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            this.reportMissingClass(type);
            return;
        }
        this.workList.add(Action.markInstantiated(clazz, keepReason));
    }

    private void markLambdaInstantiated(DexType itf, DexEncodedMethod method) {
        this.instantiatedLambdas.add(itf, KeepReason.instantiatedIn(method));
    }

    private void markDirectStaticOrConstructorMethodAsLive(DexEncodedMethod encodedMethod, KeepReason reason) {
        assert (encodedMethod != null);
        if (!this.liveMethods.contains(encodedMethod)) {
            this.markTypeAsLive(encodedMethod.method.holder);
            this.markMethodAsTargeted(encodedMethod, reason);
            this.workList.add(Action.markMethodLive(encodedMethod, reason));
        }
    }

    private void markVirtualMethodAsLive(DexEncodedMethod method, KeepReason reason) {
        assert (method != null);
        assert (!method.accessFlags.isAbstract());
        if (!this.liveMethods.contains(method)) {
            this.workList.add(Action.markMethodLive(method, reason));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInstantiatedOrHasInstantiatedSubtype(DexType type) {
        if (this.instantiatedTypes.contains(type)) return true;
        if (!this.appInfo.subtypes(type).stream().anyMatch(this.instantiatedTypes::contains)) return false;
        return true;
    }

    private void markInstanceFieldAsReachable(DexField field, KeepReason reason) {
        DexEncodedField encodedField = this.appInfo.resolveFieldOn(field.clazz, field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return;
        }
        if (encodedField.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(encodedField.field, reason);
        } else {
            SetWithReason reachable = this.reachableInstanceFields.computeIfAbsent(encodedField.field.clazz, ignore -> new SetWithReason());
            if (reachable.add(encodedField, reason) && this.isInstantiatedOrHasInstantiatedSubtype(encodedField.field.clazz)) {
                this.markInstanceFieldAsLive(encodedField, reason);
            }
        }
    }

    private void markVirtualMethodAsReachable(DexMethod method, boolean interfaceInvoke, KeepReason reason) {
        DexEncodedMethod topTarget;
        if (!this.virtualTargetsMarkedAsReachable.add(method)) {
            return;
        }
        if (method.holder.isArrayType()) {
            this.markTypeAsLive(method.holder);
            return;
        }
        DexClass holder = this.appInfo.definitionFor(method.holder);
        if (holder == null) {
            this.reportMissingClass(method.holder);
            return;
        }
        DexEncodedMethod dexEncodedMethod = topTarget = interfaceInvoke ? this.appInfo.resolveMethodOnInterface(method.holder, method).asResultOfResolve() : this.appInfo.resolveMethodOnClass(method.holder, method).asResultOfResolve();
        if (topTarget == null) {
            this.reportMissingMethod(method);
            return;
        }
        this.markMethodAsTargeted(topTarget, reason);
        Set<DexEncodedMethod> targets = interfaceInvoke ? this.appInfo.lookupInterfaceTargets(method) : this.appInfo.lookupVirtualTargets(method);
        block0: for (DexEncodedMethod encodedMethod : targets) {
            SetWithReason reachable = this.reachableVirtualMethods.computeIfAbsent(encodedMethod.method.holder, ignore -> new SetWithReason());
            if (!reachable.add(encodedMethod, reason) || encodedMethod.accessFlags.isAbstract() || !this.isInstantiatedOrHasInstantiatedSubtype(encodedMethod.method.holder)) continue;
            if (this.instantiatedTypes.contains(encodedMethod.method.holder)) {
                this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(encodedMethod.method.holder));
                continue;
            }
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            Enqueuer.fillWorkList(worklist, encodedMethod.method.holder);
            while (!worklist.isEmpty()) {
                DexType current = (DexType)worklist.pollFirst();
                DexClass currentHolder = this.appInfo.definitionFor(current);
                if (currentHolder == null || currentHolder.lookupVirtualMethod(encodedMethod.method) != null) continue;
                if (this.instantiatedTypes.contains(current)) {
                    this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(current));
                    continue block0;
                }
                Enqueuer.fillWorkList(worklist, current);
            }
        }
    }

    private DexMethod generatedEnumValuesMethod(DexClass enumClass) {
        DexType arrayOfEnumClass = this.appInfo.dexItemFactory.createType(this.appInfo.dexItemFactory.createString("[" + enumClass.type.toDescriptorString()));
        DexProto proto = this.appInfo.dexItemFactory.createProto(arrayOfEnumClass, new DexType[0]);
        return this.appInfo.dexItemFactory.createMethod(enumClass.type, proto, this.appInfo.dexItemFactory.createString("values"));
    }

    private void markEnumValuesAsReachable(DexClass clazz, KeepReason reason) {
        DexEncodedMethod valuesMethod = clazz.lookupMethod(this.generatedEnumValuesMethod(clazz));
        if (valuesMethod != null) {
            this.enqueueRootItem((DexDefinition)valuesMethod, reason);
            this.rootSet.noObfuscation.add(valuesMethod);
        }
    }

    private static void fillWorkList(Deque<DexType> worklist, DexType type) {
        if (type.isInterface()) {
            type.forAllImplementsSubtypes(worklist::addLast);
            type.forAllExtendsSubtypes(worklist::addLast);
        } else {
            type.forAllExtendsSubtypes(worklist::addLast);
        }
    }

    private void markSuperMethodAsReachable(DexMethod method, DexEncodedMethod from) {
        DexEncodedMethod resolutionTarget = this.appInfo.resolveMethod(method.holder, method).asResultOfResolve();
        if (resolutionTarget == null) {
            this.brokenSuperInvokes.add(method);
            this.reportMissingMethod(method);
            return;
        }
        this.markMethodAsTargeted(resolutionTarget, KeepReason.targetedBySuperFrom(from));
        DexEncodedMethod target = this.appInfo.lookupSuperTarget(method, from.method.holder);
        if (target == null) {
            this.reportMissingMethod(method);
            return;
        }
        if (target.accessFlags.isPrivate()) {
            this.brokenSuperInvokes.add(method);
        }
        if (this.superInvokeDependencies.computeIfAbsent(from, ignore -> Sets.newIdentityHashSet()).add(target) && this.liveMethods.contains(from)) {
            this.markMethodAsTargeted(target, KeepReason.invokedViaSuperFrom(from));
            if (!target.accessFlags.isAbstract()) {
                this.markVirtualMethodAsLive(target, KeepReason.invokedViaSuperFrom(from));
            }
        }
    }

    public ReasonPrinter getReasonPrinter(Set<DexDefinition> queriedItems) {
        if (queriedItems.isEmpty()) {
            return ReasonPrinter.getNoOpPrinter();
        }
        HashMap<DexDefinition, KeepReason> reachability = new HashMap<DexDefinition, KeepReason>();
        for (SetWithReason<DexEncodedMethod> setWithReason : this.reachableVirtualMethods.values()) {
            reachability.putAll(setWithReason.getReasons());
        }
        for (SetWithReason<KeyedDexItem> setWithReason : this.reachableInstanceFields.values()) {
            reachability.putAll(setWithReason.getReasons());
        }
        return new ReasonPrinter(queriedItems, this.liveFields.getReasons(), this.liveMethods.getReasons(), reachability, this.instantiatedTypes.getReasons());
    }

    public AppInfoWithLiveness traceMainDex(RootSetBuilder.RootSet rootSet, ExecutorService executorService, Timing timing) throws ExecutionException {
        this.tracingMainDex = true;
        this.rootSet = rootSet;
        this.enqueueRootItems(rootSet.noShrinking);
        AppInfoWithLiveness appInfo = this.trace(executorService, timing);
        this.options.reporter.failIfPendingErrors();
        return appInfo;
    }

    public AppInfoWithLiveness traceApplication(RootSetBuilder.RootSet rootSet, ExecutorService executorService, Timing timing) throws ExecutionException {
        this.rootSet = rootSet;
        this.enqueueRootItems(rootSet.noShrinking);
        this.appInfo.libraryClasses().forEach(this::markAllLibraryVirtualMethodsReachable);
        AppInfoWithLiveness result = this.trace(executorService, timing);
        this.options.reporter.failIfPendingErrors();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppInfoWithLiveness trace(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Grow the tree.");
        try {
            while (true) {
                long numOfLiveItems = this.liveTypes.size();
                numOfLiveItems += (long)((SetWithReason)this.liveMethods).items.size();
                numOfLiveItems += (long)((SetWithReason)this.liveFields).items.size();
                block14: while (!this.workList.isEmpty()) {
                    Action action = this.workList.poll();
                    switch (action.kind) {
                        case MARK_INSTANTIATED: {
                            this.processNewlyInstantiatedClass((DexClass)action.target, action.reason);
                            continue block14;
                        }
                        case MARK_REACHABLE_FIELD: {
                            this.markInstanceFieldAsReachable((DexField)action.target, action.reason);
                            continue block14;
                        }
                        case MARK_REACHABLE_VIRTUAL: {
                            this.markVirtualMethodAsReachable((DexMethod)action.target, false, action.reason);
                            continue block14;
                        }
                        case MARK_REACHABLE_INTERFACE: {
                            this.markVirtualMethodAsReachable((DexMethod)action.target, true, action.reason);
                            continue block14;
                        }
                        case MARK_REACHABLE_SUPER: {
                            this.markSuperMethodAsReachable((DexMethod)action.target, (DexEncodedMethod)action.context);
                            continue block14;
                        }
                        case MARK_METHOD_KEPT: {
                            this.markMethodAsKept((DexEncodedMethod)action.target, action.reason);
                            continue block14;
                        }
                        case MARK_FIELD_KEPT: {
                            this.markFieldAsKept((DexEncodedField)action.target, action.reason);
                            continue block14;
                        }
                        case MARK_METHOD_LIVE: {
                            this.processNewlyLiveMethod((DexEncodedMethod)action.target, action.reason);
                            continue block14;
                        }
                    }
                    throw new IllegalArgumentException(action.kind.toString());
                }
                long numOfLiveItemsAfterProcessing = this.liveTypes.size();
                numOfLiveItemsAfterProcessing += (long)((SetWithReason)this.liveMethods).items.size();
                if ((numOfLiveItemsAfterProcessing += (long)((SetWithReason)this.liveFields).items.size()) > numOfLiveItems) {
                    RootSetBuilder consequentSetBuilder = new RootSetBuilder(this.appView, this.rootSet.ifRules, this.options);
                    RootSetBuilder.ConsequentRootSet consequentRootSet = consequentSetBuilder.runForIfRules(executorService, this.liveTypes, this.liveMethods.getItems(), this.liveFields.getItems());
                    this.enqueueRootItems(consequentRootSet.noShrinking);
                    this.rootSet.noOptimization.addAll(consequentRootSet.noOptimization);
                    this.rootSet.noObfuscation.addAll(consequentRootSet.noObfuscation);
                    this.rootSet.addDependentItems(consequentRootSet.dependentNoShrinking);
                    consequentRootSet.dependentNoShrinking.forEach((precondition, dependentItems) -> {
                        if (precondition.isDexClass()) {
                            this.enqueueHolderIfDependentNonStaticMember(precondition.asDexClass(), (Map<DexDefinition, ProguardKeepRule>)dependentItems);
                        }
                        this.enqueueRootItems((Map<DexDefinition, ProguardKeepRule>)dependentItems);
                    });
                    if (!this.workList.isEmpty()) continue;
                }
                if (this.proguardCompatibilityWorkList.isEmpty() && this.pendingReflectiveUses.isEmpty()) break;
                this.pendingReflectiveUses.forEach(this::handleReflectiveBehavior);
                this.workList.addAll(this.proguardCompatibilityWorkList);
                this.proguardCompatibilityWorkList.clear();
                this.pendingReflectiveUses.clear();
            }
            assert (this.liveTypes.stream().allMatch(DexType::isClassType));
            assert (this.instantiatedTypes.getItems().stream().allMatch(DexType::isClassType));
        }
        finally {
            timing.end();
        }
        return new AppInfoWithLiveness(this.appInfo, this);
    }

    private void markMethodAsKept(DexEncodedMethod target, KeepReason reason) {
        DexClass holder = this.appInfo.definitionFor(target.method.holder);
        if (holder == null) {
            return;
        }
        if (target.isVirtualMethod()) {
            this.markVirtualMethodAsReachable(target.method, holder.accessFlags.isInterface(), reason);
            if (holder.isInterface() && target.isNonAbstractVirtualMethod()) {
                this.markVirtualMethodAsLive(target, reason);
            }
        } else {
            this.markDirectStaticOrConstructorMethodAsLive(target, reason);
        }
    }

    private void markFieldAsKept(DexEncodedField target, KeepReason reason) {
        if (this.appInfo.definitionFor(target.field.clazz) == null) {
            return;
        }
        if (target.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(target.field, reason);
        } else {
            this.markInstanceFieldAsReachable(target.field, reason);
        }
    }

    private void markAllLibraryVirtualMethodsReachable(DexClass clazz) {
        assert (clazz.isLibraryClass());
        for (DexEncodedMethod encodedMethod : clazz.virtualMethods()) {
            this.markMethodAsTargeted(encodedMethod, KeepReason.isLibraryMethod());
            this.markVirtualMethodAsReachable(encodedMethod.method, clazz.isInterface(), KeepReason.isLibraryMethod());
        }
    }

    private void processNewlyLiveMethod(DexEncodedMethod method, KeepReason reason) {
        if (this.liveMethods.add(method, reason)) {
            this.collectProguardCompatibilityRule(reason);
            DexClass holder = this.appInfo.definitionFor(method.method.holder);
            assert (holder != null);
            if (holder.isLibraryClass()) {
                return;
            }
            Set<DexEncodedMethod> superCallTargets = this.superInvokeDependencies.get(method);
            if (superCallTargets != null) {
                for (DexEncodedMethod superCallTarget : superCallTargets) {
                    this.markMethodAsTargeted(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                    this.markVirtualMethodAsLive(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                }
            }
            this.markParameterAndReturnTypesAsLive(method);
            this.processAnnotations(method.annotations.annotations);
            method.parameterAnnotationsList.forEachAnnotation(this::processAnnotation);
            method.registerCodeReferences(new UseRegistry(this.options.itemFactory, method));
            this.enqueueRootItems(this.rootSet.getDependentItems(method));
        }
    }

    private void markParameterAndReturnTypesAsLive(DexEncodedMethod method) {
        for (DexType parameterType : method.method.proto.parameters.values) {
            this.markTypeAsLive(parameterType);
        }
        this.markTypeAsLive(method.method.proto.returnType);
    }

    private void collectProguardCompatibilityRule(KeepReason reason) {
        if (reason.isDueToProguardCompatibility() && this.compatibility != null) {
            this.compatibility.addRule(reason.getProguardKeepRule());
        }
    }

    private Map<DexField, Set<DexEncodedMethod>> collectFields(Map<DexType, Set<TargetWithContext<DexField>>> map2) {
        IdentityHashMap<DexField, Set<DexEncodedMethod>> result = new IdentityHashMap<DexField, Set<DexEncodedMethod>>();
        for (Map.Entry<DexType, Set<TargetWithContext<DexField>>> entry : map2.entrySet()) {
            for (TargetWithContext<DexField> fieldWithContext : entry.getValue()) {
                DexField field = fieldWithContext.getTarget();
                DexEncodedMethod context = fieldWithContext.getContext();
                result.computeIfAbsent(field, k -> Sets.newIdentityHashSet()).add(context);
            }
        }
        return result;
    }

    Map<DexField, Set<DexEncodedMethod>> collectInstanceFieldsRead() {
        return Collections.unmodifiableMap(this.collectFields(this.instanceFieldsRead));
    }

    Map<DexField, Set<DexEncodedMethod>> collectInstanceFieldsWritten() {
        return Collections.unmodifiableMap(this.collectFields(this.instanceFieldsWritten));
    }

    Map<DexField, Set<DexEncodedMethod>> collectStaticFieldsRead() {
        return Collections.unmodifiableMap(this.collectFields(this.staticFieldsRead));
    }

    Map<DexField, Set<DexEncodedMethod>> collectStaticFieldsWritten() {
        return Collections.unmodifiableMap(this.collectFields(this.staticFieldsWritten));
    }

    private Set<DexField> collectReachedFields(Set<DexField> set, Function<DexField, DexField> lookup) {
        return set.stream().map(lookup).filter(Objects::nonNull).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    private DexField tryLookupInstanceField(DexField field) {
        DexEncodedField target = this.appInfo.lookupInstanceTarget(field.clazz, field);
        return target == null ? null : target.field;
    }

    private DexField tryLookupStaticField(DexField field) {
        DexEncodedField target = this.appInfo.lookupStaticTarget(field.clazz, field);
        return target == null ? null : target.field;
    }

    SortedSet<DexField> mergeFieldAccesses(Set<DexField> instanceFields, Set<DexField> staticFields) {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, Sets.union(this.collectReachedFields(instanceFields, this::tryLookupInstanceField), this.collectReachedFields(staticFields, this::tryLookupStaticField)));
    }

    private void markClassAsInstantiatedWithMethodHandleRule(DexClass clazz) {
        ProguardKeepRule rule = ProguardConfigurationUtils.buildMethodHandleKeepRule(clazz);
        this.proguardCompatibilityWorkList.add(Action.markInstantiated(clazz, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
    }

    private void markClassAsInstantiatedWithCompatRule(DexClass clazz) {
        ProguardKeepRule rule = ProguardConfigurationUtils.buildDefaultInitializerKeepRule(clazz);
        this.proguardCompatibilityWorkList.add(Action.markInstantiated(clazz, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
        if (clazz.hasDefaultInitializer()) {
            this.proguardCompatibilityWorkList.add(Action.markMethodLive(clazz.getDefaultInitializer(), KeepReason.dueToProguardCompatibilityKeepRule(rule)));
        }
    }

    private void markFieldAsKeptWithCompatRule(DexEncodedField field, boolean keepClass) {
        DexClass holderClass = this.appInfo.definitionFor(field.field.getHolder());
        ProguardKeepRule rule = ProguardConfigurationUtils.buildFieldKeepRule(holderClass, field, keepClass);
        if (keepClass) {
            this.proguardCompatibilityWorkList.add(Action.markInstantiated(holderClass, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
        }
        this.proguardCompatibilityWorkList.add(Action.markFieldKept(field, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
    }

    private void markMethodAsKeptWithCompatRule(DexEncodedMethod method) {
        DexClass holderClass = this.appInfo.definitionFor(method.method.getHolder());
        ProguardKeepRule rule = ProguardConfigurationUtils.buildMethodKeepRule(holderClass, method);
        this.proguardCompatibilityWorkList.add(Action.markMethodLive(method, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
    }

    private void handleReflectiveBehavior(DexEncodedMethod method) {
        DexType originHolder = method.method.holder;
        Origin origin = this.appInfo.originFor(originHolder);
        IRCode code = method.buildIR(this.appInfo, this.appView.graphLense(), this.options, origin);
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            Instruction instruction = (Instruction)iterator2.next();
            this.handleReflectiveBehavior(method, instruction);
        }
    }

    private void handleReflectiveBehavior(DexEncodedMethod method, Instruction instruction) {
        if (!instruction.isInvokeMethod()) {
            return;
        }
        InvokeMethod invoke = instruction.asInvokeMethod();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod == this.appInfo.dexItemFactory.enumMethods.valueOf) {
            this.handleJavaLangEnumValueOf(method, invoke);
            return;
        }
        if (!IdentifierNameStringUtils.isReflectionMethod(this.appInfo.dexItemFactory, invokedMethod)) {
            return;
        }
        DexItemBasedString itemBasedString = IdentifierNameStringUtils.identifyIdentiferNameString(this.appInfo, invoke);
        if (itemBasedString == null) {
            return;
        }
        if (itemBasedString.basedOn.isDexType()) {
            DexClass clazz = this.appInfo.definitionFor(itemBasedString.basedOn.asDexType());
            if (clazz != null) {
                this.markClassAsInstantiatedWithCompatRule(clazz);
            }
        } else if (itemBasedString.basedOn.isDexField()) {
            DexEncodedField encodedField = this.appInfo.definitionFor(itemBasedString.basedOn.asDexField());
            if (encodedField != null) {
                boolean keepClass = !encodedField.accessFlags.isStatic() && this.appInfo.dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(invokedMethod);
                this.markFieldAsKeptWithCompatRule(encodedField, keepClass);
            }
        } else {
            assert (itemBasedString.basedOn.isDexMethod());
            DexEncodedMethod encodedMethod = this.appInfo.definitionFor(itemBasedString.basedOn.asDexMethod());
            if (encodedMethod != null) {
                this.markMethodAsKeptWithCompatRule(encodedMethod);
            }
        }
    }

    private void handleJavaLangEnumValueOf(DexEncodedMethod method, InvokeMethod invoke) {
        if (invoke.inValues().get(0).isConstClass()) {
            DexClass clazz = this.appInfo.definitionFor(invoke.inValues().get((int)0).definition.asConstClass().getValue());
            if (clazz.accessFlags.isEnum() && clazz.superType == this.appInfo.dexItemFactory.enumType) {
                this.markEnumValuesAsReachable(clazz, KeepReason.invokedFrom(method));
            }
        }
    }

    private class AnnotationReferenceMarker
    implements IndexedItemCollection {
        private final DexItem annotationHolder;
        private final DexItemFactory dexItemFactory;

        private AnnotationReferenceMarker(DexItem annotationHolder, DexItemFactory dexItemFactory) {
            this.annotationHolder = annotationHolder;
            this.dexItemFactory = dexItemFactory;
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            DexClass holder = Enqueuer.this.appInfo.definitionFor(field.clazz);
            if (holder == null) {
                return false;
            }
            DexEncodedField target = holder.lookupStaticField(field);
            if (target != null) {
                if (target.field == field) {
                    Enqueuer.this.markStaticFieldAsLive(field, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.lookupInstanceField(field);
                if (target != null && target.field != field) {
                    Enqueuer.this.markInstanceFieldAsReachable(field, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            DexClass holder = Enqueuer.this.appInfo.definitionFor(method.holder);
            if (holder == null) {
                return false;
            }
            DexEncodedMethod target = holder.lookupDirectMethod(method);
            if (target != null) {
                if (target.method == method) {
                    Enqueuer.this.markDirectStaticOrConstructorMethodAsLive(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.lookupVirtualMethod(method);
                if (target != null && target.method == method) {
                    Enqueuer.this.markMethodAsTargeted(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return false;
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            if (type != this.dexItemFactory.voidType) {
                Enqueuer.this.markTypeAsLive(type);
            }
            return false;
        }
    }

    private static final class TargetWithContext<T extends Descriptor<?, T>> {
        private final T target;
        private final DexEncodedMethod context;

        private TargetWithContext(T target, DexEncodedMethod context) {
            this.target = target;
            this.context = context;
        }

        public T getTarget() {
            return this.target;
        }

        public DexEncodedMethod getContext() {
            return this.context;
        }

        public int hashCode() {
            return ((CachedHashValueDexItem)this.target).hashCode() * 31 + this.context.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TargetWithContext)) {
                return false;
            }
            TargetWithContext other = (TargetWithContext)obj;
            return this.target == other.target && this.context == other.context;
        }

        /* synthetic */ TargetWithContext(Descriptor x0, DexEncodedMethod x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class SetWithReason<T> {
        private final Set<T> items = Sets.newIdentityHashSet();
        private final Map<T, KeepReason> reasons = Maps.newIdentityHashMap();

        private SetWithReason() {
        }

        boolean add(T item, KeepReason reason) {
            if (this.items.add(item)) {
                this.reasons.put(item, reason);
                return true;
            }
            return false;
        }

        boolean contains(T item) {
            return this.items.contains(item);
        }

        Set<T> getItems() {
            return ImmutableSet.copyOf(this.items);
        }

        Map<T, KeepReason> getReasons() {
            return ImmutableMap.copyOf(this.reasons);
        }
    }

    public static class AppInfoWithLiveness
    extends AppInfoWithSubtyping {
        public final SortedSet<DexType> liveTypes;
        final SortedSet<DexType> instantiatedTypes;
        final SortedSet<DexMethod> targetedMethods;
        final SortedSet<DexMethod> virtualMethodsTargetedByInvokeDirect;
        final SortedSet<DexMethod> liveMethods;
        public final SortedSet<DexField> liveFields;
        public final SortedSet<DexField> fieldsRead;
        public final SortedSet<DexField> fieldsWritten;
        public final Map<DexField, Set<DexEncodedMethod>> instanceFieldReads;
        public final Map<DexField, Set<DexEncodedMethod>> instanceFieldWrites;
        public final Map<DexField, Set<DexEncodedMethod>> staticFieldReads;
        public final Map<DexField, Set<DexEncodedMethod>> staticFieldWrites;
        public final SortedSet<DexMethod> virtualInvokes;
        public final SortedSet<DexMethod> interfaceInvokes;
        public final SortedSet<DexMethod> superInvokes;
        public final SortedSet<DexMethod> directInvokes;
        public final SortedSet<DexMethod> staticInvokes;
        public final Set<DexCallSite> callSites;
        public final SortedSet<DexMethod> brokenSuperInvokes;
        final Set<DexReference> pinnedItems;
        public final Map<DexDefinition, ProguardMemberRule> noSideEffects;
        public final Map<DexDefinition, ProguardMemberRule> assumedValues;
        public final Set<DexMethod> alwaysInline;
        public final Set<DexMethod> forceInline;
        public final Set<DexMethod> neverInline;
        public final Set<DexType> neverMerge;
        public final Object2BooleanMap<DexReference> identifierNameStrings;
        final Set<DexType> prunedTypes;
        final Map<DexField, Int2ReferenceMap<DexField>> switchMaps;
        final Map<DexType, Reference2IntMap<DexField>> ordinalsMaps;
        final ImmutableSortedSet<DexType> instantiatedLambdas;

        private AppInfoWithLiveness(AppInfoWithSubtyping appInfo, Enqueuer enqueuer) {
            super(appInfo);
            this.liveTypes = ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.liveTypes);
            this.instantiatedTypes = ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.instantiatedTypes.getItems());
            this.instantiatedLambdas = ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.instantiatedLambdas.getItems());
            this.targetedMethods = this.toSortedDescriptorSet(enqueuer.targetedMethods.getItems());
            this.virtualMethodsTargetedByInvokeDirect = ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, enqueuer.virtualMethodsTargetedByInvokeDirect);
            this.liveMethods = this.toSortedDescriptorSet(enqueuer.liveMethods.getItems());
            this.liveFields = this.toSortedDescriptorSet(enqueuer.liveFields.getItems());
            this.instanceFieldReads = enqueuer.collectInstanceFieldsRead();
            this.instanceFieldWrites = enqueuer.collectInstanceFieldsWritten();
            this.staticFieldReads = enqueuer.collectStaticFieldsRead();
            this.staticFieldWrites = enqueuer.collectStaticFieldsWritten();
            this.fieldsRead = enqueuer.mergeFieldAccesses(this.instanceFieldReads.keySet(), this.staticFieldReads.keySet());
            this.fieldsWritten = enqueuer.mergeFieldAccesses(this.instanceFieldWrites.keySet(), this.staticFieldWrites.keySet());
            this.pinnedItems = DexDefinition.mapToReference(enqueuer.pinnedItems.stream()).collect(Collectors.toSet());
            this.virtualInvokes = this.joinInvokedMethods(enqueuer.virtualInvokes);
            this.interfaceInvokes = this.joinInvokedMethods(enqueuer.interfaceInvokes);
            this.superInvokes = this.joinInvokedMethods(enqueuer.superInvokes, TargetWithContext::getTarget);
            this.directInvokes = this.joinInvokedMethods(enqueuer.directInvokes);
            this.staticInvokes = this.joinInvokedMethods(enqueuer.staticInvokes);
            this.callSites = enqueuer.callSites;
            this.brokenSuperInvokes = ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, enqueuer.brokenSuperInvokes);
            this.noSideEffects = ((Enqueuer)enqueuer).rootSet.noSideEffects;
            this.assumedValues = ((Enqueuer)enqueuer).rootSet.assumedValues;
            this.alwaysInline = ((Enqueuer)enqueuer).rootSet.alwaysInline;
            this.forceInline = ((Enqueuer)enqueuer).rootSet.forceInline;
            this.neverInline = ((Enqueuer)enqueuer).rootSet.neverInline;
            this.neverMerge = ((Enqueuer)enqueuer).rootSet.neverMerge;
            this.identifierNameStrings = this.joinIdentifierNameStrings(((Enqueuer)enqueuer).rootSet.identifierNameStrings, enqueuer.identifierNameStrings);
            this.prunedTypes = Collections.emptySet();
            this.switchMaps = Collections.emptyMap();
            this.ordinalsMaps = Collections.emptyMap();
            assert (Sets.intersection(this.instanceFieldReads.keySet(), this.staticFieldReads.keySet()).isEmpty());
            assert (Sets.intersection(this.instanceFieldWrites.keySet(), this.staticFieldWrites.keySet()).isEmpty());
        }

        private AppInfoWithLiveness(AppInfoWithLiveness previous, DexApplication application, Collection<DexType> removedClasses) {
            super(application);
            this.liveTypes = previous.liveTypes;
            this.instantiatedTypes = previous.instantiatedTypes;
            this.instantiatedLambdas = previous.instantiatedLambdas;
            this.targetedMethods = previous.targetedMethods;
            this.virtualMethodsTargetedByInvokeDirect = previous.virtualMethodsTargetedByInvokeDirect;
            this.liveMethods = previous.liveMethods;
            this.liveFields = previous.liveFields;
            this.instanceFieldReads = previous.instanceFieldReads;
            this.instanceFieldWrites = previous.instanceFieldWrites;
            this.staticFieldReads = previous.staticFieldReads;
            this.staticFieldWrites = previous.staticFieldWrites;
            this.fieldsRead = previous.fieldsRead;
            this.fieldsWritten = previous.fieldsWritten;
            assert (this.assertNoItemRemoved(previous.pinnedItems, removedClasses));
            this.pinnedItems = previous.pinnedItems;
            this.noSideEffects = previous.noSideEffects;
            this.assumedValues = previous.assumedValues;
            this.virtualInvokes = previous.virtualInvokes;
            this.interfaceInvokes = previous.interfaceInvokes;
            this.superInvokes = previous.superInvokes;
            this.directInvokes = previous.directInvokes;
            this.staticInvokes = previous.staticInvokes;
            this.callSites = previous.callSites;
            this.brokenSuperInvokes = previous.brokenSuperInvokes;
            this.alwaysInline = previous.alwaysInline;
            this.forceInline = previous.forceInline;
            this.neverInline = previous.neverInline;
            this.neverMerge = previous.neverMerge;
            this.identifierNameStrings = previous.identifierNameStrings;
            this.prunedTypes = AppInfoWithLiveness.mergeSets(previous.prunedTypes, removedClasses);
            this.switchMaps = previous.switchMaps;
            this.ordinalsMaps = previous.ordinalsMaps;
            assert (Sets.intersection(this.instanceFieldReads.keySet(), this.staticFieldReads.keySet()).isEmpty());
            assert (Sets.intersection(this.instanceFieldWrites.keySet(), this.staticFieldWrites.keySet()).isEmpty());
        }

        private AppInfoWithLiveness(AppInfoWithLiveness previous, DirectMappedDexApplication application, GraphLense lense) {
            super(application, lense);
            this.liveTypes = AppInfoWithLiveness.rewriteItems(previous.liveTypes, lense::lookupType);
            this.instantiatedTypes = AppInfoWithLiveness.rewriteItems(previous.instantiatedTypes, lense::lookupType);
            this.instantiatedLambdas = AppInfoWithLiveness.rewriteItems(previous.instantiatedLambdas, lense::lookupType);
            this.targetedMethods = lense.rewriteMethodsConservatively(previous.targetedMethods);
            this.virtualMethodsTargetedByInvokeDirect = lense.rewriteMethodsConservatively(previous.virtualMethodsTargetedByInvokeDirect);
            this.liveMethods = lense.rewriteMethodsConservatively(previous.liveMethods);
            this.liveFields = AppInfoWithLiveness.rewriteItems(previous.liveFields, lense::lookupField);
            this.instanceFieldReads = AppInfoWithLiveness.rewriteKeysWhileMergingValues(previous.instanceFieldReads, lense::lookupField);
            this.instanceFieldWrites = AppInfoWithLiveness.rewriteKeysWhileMergingValues(previous.instanceFieldWrites, lense::lookupField);
            this.staticFieldReads = AppInfoWithLiveness.rewriteKeysWhileMergingValues(previous.staticFieldReads, lense::lookupField);
            this.staticFieldWrites = AppInfoWithLiveness.rewriteKeysWhileMergingValues(previous.staticFieldWrites, lense::lookupField);
            this.fieldsRead = AppInfoWithLiveness.rewriteItems(previous.fieldsRead, lense::lookupField);
            this.fieldsWritten = AppInfoWithLiveness.rewriteItems(previous.fieldsWritten, lense::lookupField);
            this.pinnedItems = lense.rewriteReferencesConservatively(previous.pinnedItems);
            this.virtualInvokes = lense.rewriteMethodsConservatively(previous.virtualInvokes);
            this.interfaceInvokes = lense.rewriteMethodsConservatively(previous.interfaceInvokes);
            this.superInvokes = lense.rewriteMethodsConservatively(previous.superInvokes);
            this.directInvokes = lense.rewriteMethodsConservatively(previous.directInvokes);
            this.staticInvokes = lense.rewriteMethodsConservatively(previous.staticInvokes);
            this.callSites = previous.callSites;
            this.brokenSuperInvokes = lense.rewriteMethodsConservatively(previous.brokenSuperInvokes);
            this.prunedTypes = AppInfoWithLiveness.rewriteItems(previous.prunedTypes, lense::lookupType);
            assert (lense.assertDefinitionNotModified(previous.noSideEffects.keySet()));
            this.noSideEffects = previous.noSideEffects;
            assert (lense.assertDefinitionNotModified(previous.assumedValues.keySet()));
            this.assumedValues = previous.assumedValues;
            assert (lense.assertDefinitionNotModified(previous.alwaysInline.stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
            this.alwaysInline = previous.alwaysInline;
            this.forceInline = lense.rewriteMethodsWithRenamedSignature(previous.forceInline);
            this.neverInline = lense.rewriteMethodsWithRenamedSignature(previous.neverInline);
            assert (lense.assertDefinitionNotModified(previous.neverMerge.stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
            this.neverMerge = previous.neverMerge;
            this.identifierNameStrings = lense.rewriteReferencesConservatively(previous.identifierNameStrings);
            assert (lense.assertDefinitionNotModified(previous.switchMaps.keySet().stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
            this.switchMaps = previous.switchMaps;
            this.ordinalsMaps = AppInfoWithLiveness.rewriteKeys(previous.ordinalsMaps, lense::lookupType);
            assert (Sets.intersection(this.instanceFieldReads.keySet(), this.staticFieldReads.keySet()).isEmpty());
            assert (Sets.intersection(this.instanceFieldWrites.keySet(), this.staticFieldWrites.keySet()).isEmpty());
        }

        public AppInfoWithLiveness(AppInfoWithLiveness previous, Map<DexField, Int2ReferenceMap<DexField>> switchMaps, Map<DexType, Reference2IntMap<DexField>> ordinalsMaps) {
            super(previous);
            this.liveTypes = previous.liveTypes;
            this.instantiatedTypes = previous.instantiatedTypes;
            this.instantiatedLambdas = previous.instantiatedLambdas;
            this.targetedMethods = previous.targetedMethods;
            this.virtualMethodsTargetedByInvokeDirect = previous.virtualMethodsTargetedByInvokeDirect;
            this.liveMethods = previous.liveMethods;
            this.liveFields = previous.liveFields;
            this.instanceFieldReads = previous.instanceFieldReads;
            this.instanceFieldWrites = previous.instanceFieldWrites;
            this.staticFieldReads = previous.staticFieldReads;
            this.staticFieldWrites = previous.staticFieldWrites;
            this.fieldsRead = previous.fieldsRead;
            this.fieldsWritten = previous.fieldsWritten;
            this.pinnedItems = previous.pinnedItems;
            this.noSideEffects = previous.noSideEffects;
            this.assumedValues = previous.assumedValues;
            this.virtualInvokes = previous.virtualInvokes;
            this.interfaceInvokes = previous.interfaceInvokes;
            this.superInvokes = previous.superInvokes;
            this.directInvokes = previous.directInvokes;
            this.staticInvokes = previous.staticInvokes;
            this.callSites = previous.callSites;
            this.brokenSuperInvokes = previous.brokenSuperInvokes;
            this.alwaysInline = previous.alwaysInline;
            this.forceInline = previous.forceInline;
            this.neverInline = previous.neverInline;
            this.neverMerge = previous.neverMerge;
            this.identifierNameStrings = previous.identifierNameStrings;
            this.prunedTypes = previous.prunedTypes;
            this.switchMaps = switchMaps;
            this.ordinalsMaps = ordinalsMaps;
        }

        public Reference2IntMap<DexField> getOrdinalsMapFor(DexType enumClass) {
            return this.ordinalsMaps.get(enumClass);
        }

        public Int2ReferenceMap<DexField> getSwitchMapFor(DexField field) {
            return this.switchMaps.get(field);
        }

        private boolean assertNoItemRemoved(Collection<DexReference> items, Collection<DexType> types) {
            ImmutableSet<DexType> typeSet = ImmutableSet.copyOf(types);
            for (DexReference item : items) {
                DexType typeToCheck;
                if (item.isDexType()) {
                    typeToCheck = item.asDexType();
                } else {
                    assert (item.isDescriptor());
                    typeToCheck = item.asDescriptor().getHolder();
                }
                assert (!typeSet.contains(typeToCheck));
            }
            return true;
        }

        private SortedSet<DexMethod> joinInvokedMethods(Map<DexType, Set<DexMethod>> invokes) {
            return this.joinInvokedMethods(invokes, Function.identity());
        }

        private <T> SortedSet<DexMethod> joinInvokedMethods(Map<DexType, Set<T>> invokes, Function<T, DexMethod> getter) {
            return invokes.values().stream().flatMap(Collection::stream).map(getter).collect(ImmutableSortedSet.toImmutableSortedSet(PresortedComparable::slowCompare));
        }

        private Object2BooleanMap<DexReference> joinIdentifierNameStrings(Set<DexReference> explicit, Set<DexReference> implicit) {
            Object2BooleanArrayMap<DexReference> result = new Object2BooleanArrayMap<DexReference>();
            for (DexReference e : explicit) {
                result.putIfAbsent(e, true);
            }
            for (DexReference i : implicit) {
                result.putIfAbsent(i, false);
            }
            return result;
        }

        private <T extends PresortedComparable<T>> SortedSet<T> toSortedDescriptorSet(Set<? extends KeyedDexItem<T>> set) {
            ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompareTo);
            for (KeyedDexItem<T> item : set) {
                builder.add(item.getKey());
            }
            return builder.build();
        }

        private static <T extends PresortedComparable<T>> ImmutableSortedSet<T> rewriteItems(Set<T> original, Function<T, T> rewrite) {
            ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
            for (PresortedComparable item : original) {
                builder.add((PresortedComparable)rewrite.apply(item));
            }
            return builder.build();
        }

        private static <T extends PresortedComparable<T>, S> ImmutableMap<T, S> rewriteKeys(Map<T, S> original, Function<T, T> rewrite) {
            ImmutableMap.Builder<PresortedComparable, S> builder = new ImmutableMap.Builder<PresortedComparable, S>();
            for (PresortedComparable item : original.keySet()) {
                builder.put((PresortedComparable)rewrite.apply(item), original.get(item));
            }
            return builder.build();
        }

        private static <T extends PresortedComparable<T>, S> Map<T, Set<S>> rewriteKeysWhileMergingValues(Map<T, Set<S>> original, Function<T, T> rewrite) {
            IdentityHashMap<PresortedComparable, Set> result = new IdentityHashMap<PresortedComparable, Set>();
            for (PresortedComparable item : original.keySet()) {
                PresortedComparable rewrittenKey = (PresortedComparable)rewrite.apply(item);
                result.computeIfAbsent(rewrittenKey, k -> Sets.newIdentityHashSet()).addAll((Collection)original.get(item));
            }
            return Collections.unmodifiableMap(result);
        }

        @Override
        protected boolean hasAnyInstantiatedLambdas(DexType type) {
            return this.instantiatedLambdas.contains(type);
        }

        private static <T> Set<T> mergeSets(Collection<T> first, Collection<T> second) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(first);
            builder.addAll(second);
            return builder.build();
        }

        @Override
        public boolean hasLiveness() {
            return true;
        }

        @Override
        public AppInfoWithLiveness withLiveness() {
            return this;
        }

        public boolean isPinned(DexReference reference) {
            return this.pinnedItems.contains(reference);
        }

        public Iterable<DexReference> getPinnedItems() {
            return this.pinnedItems;
        }

        public AppInfoWithLiveness prunedCopyFrom(DexApplication application, Collection<DexType> removedClasses) {
            return new AppInfoWithLiveness(this, application, removedClasses);
        }

        public AppInfoWithLiveness rewrittenWithLense(DirectMappedDexApplication application, GraphLense lense) {
            return new AppInfoWithLiveness(this, application, lense);
        }

        public boolean wasPruned(DexType type) {
            return this.prunedTypes.contains(type);
        }

        public DexEncodedMethod lookup(Invoke.Type type, DexMethod target, DexType invocationContext) {
            DexType holder = target.getHolder();
            if (!holder.isClassType()) {
                return null;
            }
            switch (type) {
                case VIRTUAL: {
                    return this.lookupSingleVirtualTarget(target);
                }
                case INTERFACE: {
                    return this.lookupSingleInterfaceTarget(target);
                }
                case DIRECT: {
                    return this.lookupDirectTarget(target);
                }
                case STATIC: {
                    return this.lookupStaticTarget(target);
                }
                case SUPER: {
                    return this.lookupSuperTarget(target, invocationContext);
                }
            }
            return null;
        }

        public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method) {
            return this.lookupSingleVirtualTarget(method, method.holder);
        }

        public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method, DexType refinedReceiverType) {
            DexClass refinedHolder;
            assert (method != null);
            assert (refinedReceiverType.isSubtypeOf(method.holder, this));
            DexClass holder = this.definitionFor(method.holder);
            if (holder == null || holder.isLibraryClass() || holder.isInterface()) {
                return null;
            }
            boolean refinedReceiverIsStrictSubType = refinedReceiverType != method.holder;
            DexClass dexClass = refinedHolder = refinedReceiverIsStrictSubType ? this.definitionFor(refinedReceiverType) : holder;
            assert (refinedHolder != null);
            assert (!refinedHolder.isLibraryClass());
            if (method.isSingleVirtualMethodCached(refinedReceiverType)) {
                return method.getSingleVirtualMethodCache(refinedReceiverType);
            }
            if (this.pinnedItems.contains(method.holder)) {
                method.setSingleVirtualMethodCache(refinedReceiverType, null);
                return null;
            }
            AppInfo.ResolutionResult topMethod = this.resolveMethod(method.holder, method);
            if (!topMethod.hasSingleTarget() || !topMethod.asSingleTarget().isVirtualMethod()) {
                method.setSingleVirtualMethodCache(refinedReceiverType, null);
                return null;
            }
            if (refinedReceiverIsStrictSubType) {
                topMethod = this.resolveMethod(refinedReceiverType, method);
            }
            DexEncodedMethod topSingleTarget = topMethod.asSingleTarget();
            DexClass topHolder = this.definitionFor(topSingleTarget.method.holder);
            boolean topIsFromInterface = topHolder.isInterface();
            DexEncodedMethod result = this.findSingleTargetFromSubtypes(refinedReceiverType, method, topSingleTarget, !refinedHolder.accessFlags.isAbstract(), topIsFromInterface);
            result = result == DexEncodedMethod.SENTINEL ? null : result;
            method.setSingleVirtualMethodCache(refinedReceiverType, result);
            return result;
        }

        private DexEncodedMethod findSingleTargetFromSubtypes(DexType type, DexMethod method, DexEncodedMethod candidate, boolean candidateIsReachable, boolean checkForInterfaceConflicts) {
            DexEncodedMethod result;
            DexEncodedMethod dexEncodedMethod = result = candidateIsReachable ? candidate : null;
            if (this.pinnedItems.contains(type)) {
                return DexEncodedMethod.SENTINEL;
            }
            for (DexType subtype : type.allExtendsSubtypes()) {
                boolean newCandidateIsReachable;
                DexClass clazz = this.definitionFor(subtype);
                DexEncodedMethod target = clazz.lookupVirtualMethod(method);
                if (target != null && !target.isPrivateMethod() && !clazz.accessFlags.isAbstract()) {
                    if (result != null && result != target) {
                        return DexEncodedMethod.SENTINEL;
                    }
                    result = target;
                }
                if (checkForInterfaceConflicts && this.interfacesMayHaveDefaultFor(clazz.interfaces, method)) {
                    return DexEncodedMethod.SENTINEL;
                }
                DexEncodedMethod newCandidate = target == null ? candidate : target;
                DexEncodedMethod subtypeTarget = this.findSingleTargetFromSubtypes(subtype, method, newCandidate, newCandidateIsReachable = !clazz.accessFlags.isAbstract() || target == null && candidateIsReachable, checkForInterfaceConflicts);
                if (subtypeTarget == null) continue;
                if (result != null && result != subtypeTarget) {
                    return DexEncodedMethod.SENTINEL;
                }
                result = subtypeTarget;
            }
            return result;
        }

        private boolean interfacesMayHaveDefaultFor(DexTypeList ifaces, DexMethod method) {
            for (DexType iface : ifaces.values) {
                DexClass clazz = this.definitionFor(iface);
                if (clazz == null || clazz.isLibraryClass()) {
                    return true;
                }
                DexEncodedMethod candidate = clazz.lookupMethod(method);
                if (candidate != null && !candidate.accessFlags.isAbstract()) {
                    return true;
                }
                if (!this.interfacesMayHaveDefaultFor(clazz.interfaces, method)) continue;
                return true;
            }
            return false;
        }

        public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method) {
            return this.lookupSingleInterfaceTarget(method, method.holder);
        }

        public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method, DexType refinedReceiverType) {
            if (this.instantiatedLambdas.contains(method.holder)) {
                return null;
            }
            DexClass holder = this.definitionFor(method.holder);
            if (holder == null || holder.isLibraryClass() || !holder.accessFlags.isInterface()) {
                return null;
            }
            AppInfo.ResolutionResult topTarget = this.resolveMethodOnInterface(method.holder, method);
            if (topTarget.asResultOfResolve() == null) {
                return null;
            }
            if (this.pinnedItems.contains(method.holder)) {
                return null;
            }
            DexEncodedMethod result = null;
            ImmutableSet<DexType> subTypesToExplore = refinedReceiverType == method.holder ? this.subtypes(method.holder) : Iterables.concat(ImmutableList.of(refinedReceiverType), this.subtypes(refinedReceiverType));
            for (DexType type : subTypesToExplore) {
                if (this.pinnedItems.contains(type)) {
                    return null;
                }
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface() || clazz.accessFlags.isAbstract()) continue;
                AppInfo.ResolutionResult resolutionResult = this.resolveMethodOnClass(type, method);
                if (resolutionResult.hasSingleTarget()) {
                    if (result != null && result != resolutionResult.asSingleTarget()) {
                        return null;
                    }
                    result = resolutionResult.asSingleTarget();
                    continue;
                }
                return null;
            }
            return result == null || !result.isVirtualMethod() ? null : result;
        }

        public AppInfoWithLiveness addSwitchMaps(Map<DexField, Int2ReferenceMap<DexField>> switchMaps) {
            assert (this.switchMaps.isEmpty());
            return new AppInfoWithLiveness(this, switchMaps, this.ordinalsMaps);
        }

        public AppInfoWithLiveness addEnumOrdinalMaps(Map<DexType, Reference2IntMap<DexField>> ordinalsMaps) {
            assert (this.ordinalsMaps.isEmpty());
            return new AppInfoWithLiveness(this, this.switchMaps, ordinalsMaps);
        }
    }

    private static class Action {
        final Kind kind;
        final DexItem target;
        final DexItem context;
        final KeepReason reason;

        private Action(Kind kind, DexItem target, DexItem context, KeepReason reason) {
            this.kind = kind;
            this.target = target;
            this.context = context;
            this.reason = reason;
        }

        public static Action markReachableVirtual(DexMethod method, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_VIRTUAL, method, null, reason);
        }

        public static Action markReachableInterface(DexMethod method, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_INTERFACE, method, null, reason);
        }

        public static Action markReachableSuper(DexMethod method, DexEncodedMethod from) {
            return new Action(Kind.MARK_REACHABLE_SUPER, method, from, null);
        }

        public static Action markReachableField(DexField field, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_FIELD, field, null, reason);
        }

        public static Action markInstantiated(DexClass clazz, KeepReason reason) {
            return new Action(Kind.MARK_INSTANTIATED, clazz, null, reason);
        }

        public static Action markMethodLive(DexEncodedMethod method, KeepReason reason) {
            return new Action(Kind.MARK_METHOD_LIVE, method, null, reason);
        }

        public static Action markMethodKept(DexEncodedMethod method, KeepReason reason) {
            return new Action(Kind.MARK_METHOD_KEPT, method, null, reason);
        }

        public static Action markFieldKept(DexEncodedField field, KeepReason reason) {
            return new Action(Kind.MARK_FIELD_KEPT, field, null, reason);
        }

        private static enum Kind {
            MARK_REACHABLE_VIRTUAL,
            MARK_REACHABLE_INTERFACE,
            MARK_REACHABLE_SUPER,
            MARK_REACHABLE_FIELD,
            MARK_INSTANTIATED,
            MARK_METHOD_LIVE,
            MARK_METHOD_KEPT,
            MARK_FIELD_KEPT;

        }
    }

    private class UseRegistry
    extends com.android.tools.r8.graph.UseRegistry {
        private final DexEncodedMethod currentMethod;

        private UseRegistry(DexItemFactory factory, DexEncodedMethod currentMethod) {
            super(factory);
            this.currentMethod = currentMethod;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.registerInvokeVirtual(method, KeepReason.invokedFrom(this.currentMethod));
        }

        boolean registerInvokeVirtual(DexMethod method, KeepReason keepReason) {
            if (((Enqueuer)Enqueuer.this).appInfo.dexItemFactory.classMethods.isReflectiveMemberLookup(method)) {
                Enqueuer.this.identifierNameStrings.add(method);
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            }
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.virtualInvokes, method)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableVirtual(method, keepReason));
            return true;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.registerInvokeDirect(method, KeepReason.invokedFrom(this.currentMethod));
        }

        boolean registerInvokeDirect(DexMethod method, KeepReason keepReason) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.directInvokes, method)) {
                return false;
            }
            Enqueuer.this.handleInvokeOfDirectTarget(method, keepReason);
            return true;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.registerInvokeStatic(method, KeepReason.invokedFrom(this.currentMethod));
        }

        boolean registerInvokeStatic(DexMethod method, KeepReason keepReason) {
            if (method == ((Enqueuer)Enqueuer.this).appInfo.dexItemFactory.classMethods.forName || ((Enqueuer)Enqueuer.this).appInfo.dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(method)) {
                Enqueuer.this.identifierNameStrings.add(method);
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            }
            if (method == ((Enqueuer)Enqueuer.this).appInfo.dexItemFactory.enumMethods.valueOf) {
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            }
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.staticInvokes, method)) {
                return false;
            }
            Enqueuer.this.handleInvokeOfStaticTarget(method, keepReason);
            return true;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerInvokeInterface(method, KeepReason.invokedFrom(this.currentMethod));
        }

        boolean registerInvokeInterface(DexMethod method, KeepReason keepReason) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.interfaceInvokes, method)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableInterface(method, keepReason));
            return true;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            DexMethod actualTarget = Enqueuer.this.getInvokeSuperTarget(method, this.currentMethod);
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.superInvokes, method, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableSuper(method, this.currentMethod));
            return true;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.instanceFieldsWritten, field, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableField(field, KeepReason.fieldReferencedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.instanceFieldsRead, field, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableField(field, KeepReason.fieldReferencedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return this.registerNewInstance(type, KeepReason.instantiatedIn(this.currentMethod));
        }

        public boolean registerNewInstance(DexType type, KeepReason keepReason) {
            Enqueuer.this.markInstantiated(type, keepReason);
            return true;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.staticFieldsRead, field, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.markStaticFieldAsLive(field, KeepReason.fieldReferencedIn(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.staticFieldsWritten, field, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.markStaticFieldAsLive(field, KeepReason.fieldReferencedIn(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerConstClass(DexType type) {
            return this.registerConstClassOrCheckCast(type);
        }

        @Override
        public boolean registerCheckCast(DexType type) {
            return this.registerConstClassOrCheckCast(type);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            Enqueuer.this.markTypeAsLive(type);
            return true;
        }

        @Override
        public void registerMethodHandle(DexMethodHandle methodHandle, UseRegistry.MethodHandleUse use2) {
            DexClass holder;
            super.registerMethodHandle(methodHandle, use2);
            if (methodHandle.isMethodHandle() && use2 != UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY && (holder = Enqueuer.this.appInfo.definitionFor(methodHandle.asMethod().holder)) != null) {
                Enqueuer.this.markClassAsInstantiatedWithMethodHandleRule(holder);
            }
        }

        @Override
        public void registerCallSite(DexCallSite callSite) {
            Enqueuer.this.callSites.add(callSite);
            super.registerCallSite(callSite);
            for (DexEncodedMethod method : Enqueuer.this.appInfo.lookupLambdaImplementedMethods(callSite, ((Enqueuer)Enqueuer.this).options.reporter)) {
                Enqueuer.this.markLambdaInstantiated(method.method.holder, this.currentMethod);
            }
            LambdaDescriptor descriptor = LambdaDescriptor.tryInfer(callSite, Enqueuer.this.appInfo);
            if (descriptor == null) {
                return;
            }
            DexMethodHandle implHandle = descriptor.implHandle;
            assert (implHandle != null);
            switch (implHandle.type) {
                case INVOKE_STATIC: {
                    this.registerInvokeStatic(implHandle.asMethod(), KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                case INVOKE_INTERFACE: {
                    this.registerInvokeInterface(implHandle.asMethod(), KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                case INVOKE_INSTANCE: {
                    this.registerInvokeVirtual(implHandle.asMethod(), KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                case INVOKE_DIRECT: {
                    this.registerInvokeDirect(implHandle.asMethod(), KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                case INVOKE_CONSTRUCTOR: {
                    this.registerNewInstance(implHandle.asMethod().holder, KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
            ScopedDexMethodSet seen = new ScopedDexMethodSet();
            List<DexType> directInterfaces = LambdaDescriptor.getInterfaces(callSite, Enqueuer.this.appInfo);
            if (directInterfaces == null) {
                return;
            }
            HashSet<DexType> allInterfaces = Sets.newHashSet(directInterfaces);
            DexType instantiatedType = ((Enqueuer)Enqueuer.this).appInfo.dexItemFactory.objectType;
            DexClass clazz = Enqueuer.this.appInfo.definitionFor(instantiatedType);
            if (clazz == null) {
                Enqueuer.this.reportMissingClass(instantiatedType);
                return;
            }
            SetWithReason reachableMethods = (SetWithReason)Enqueuer.this.reachableVirtualMethods.get(instantiatedType);
            if (reachableMethods != null) {
                Enqueuer.this.transitionNonAbstractMethodsToLiveAndShadow(reachableMethods.getItems(), instantiatedType, seen);
            }
            Collections.addAll(allInterfaces, clazz.interfaces.values);
            for (DexType iface : allInterfaces) {
                DexClass ifaceClazz = Enqueuer.this.appInfo.definitionFor(iface);
                if (ifaceClazz == null) {
                    Enqueuer.this.reportMissingClass(iface);
                    return;
                }
                Enqueuer.this.transitionDefaultMethodsForInstantiatedClass(iface, instantiatedType, seen);
            }
        }

        private boolean registerConstClassOrCheckCast(DexType type) {
            if (Enqueuer.this.forceProguardCompatibility) {
                DexType baseType = type.toBaseType(((Enqueuer)Enqueuer.this).appInfo.dexItemFactory);
                if (baseType.isClassType()) {
                    DexClass baseClass = Enqueuer.this.appInfo.definitionFor(baseType);
                    if (baseClass != null && baseClass.isProgramClass()) {
                        Enqueuer.this.markClassAsInstantiatedWithCompatRule(baseClass);
                    } else {
                        Enqueuer.this.markTypeAsLive(baseType);
                    }
                    return true;
                }
                return false;
            }
            return this.registerTypeReference(type);
        }
    }
}

