/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.string;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;

public class StringOptimizer {
    public void computeConstStringLength(IRCode code, DexItemFactory factory) {
        if (!code.hasConstString) {
            return;
        }
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            InvokeVirtual invoke;
            DexMethod invokedMethod;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual() || (invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) != factory.stringMethods.length) continue;
            assert (invoke.inValues().size() == 1);
            Value in = invoke.getReceiver();
            if (in.definition == null || !in.definition.isConstString() || !in.definition.outValue().isConstant()) continue;
            ConstString constString = in.definition.asConstString();
            int length = constString.getValue().toString().length();
            ConstNumber constNumber = code.createIntConstant(length);
            it.replaceCurrentInstruction(constNumber);
        }
    }

    public void removeValueOfIfTrivial(IRCode code, AppInfo appInfo) {
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            InvokeStatic invoke;
            DexMethod invokedMethod;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeStatic() || (invokedMethod = (invoke = instr.asInvokeStatic()).getInvokedMethod()) != appInfo.dexItemFactory.stringMethods.valueOf) continue;
            assert (invoke.inValues().size() == 1);
            Value in = invoke.inValues().get(0);
            if (in.hasLocalInfo()) continue;
            TypeLatticeElement inType = in.getTypeLattice();
            if (inType.isNull()) {
                Value nullStringValue = code.createValue(TypeLatticeElement.stringClassType(appInfo), invoke.getLocalInfo());
                ConstString nullString = new ConstString(nullStringValue, appInfo.dexItemFactory.createString("null"));
                it.replaceCurrentInstruction(nullString);
                continue;
            }
            if (!inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(appInfo.dexItemFactory.stringType)) continue;
            CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, invoke.outValue());
        }
        assert (code.isConsistentSSA());
    }
}

