/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.DexItemBasedConstString;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.List;
import java.util.Map;

class IdentifierMinifier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final ProguardClassFilter adaptClassStrings;
    private final NamingLens lens;
    private final Object2BooleanMap<DexReference> identifierNameStrings;

    IdentifierMinifier(Enqueuer.AppInfoWithLiveness appInfo, ProguardClassFilter adaptClassStrings, NamingLens lens) {
        this.appInfo = appInfo;
        this.adaptClassStrings = adaptClassStrings;
        this.lens = lens;
        this.identifierNameStrings = appInfo.identifierNameStrings;
    }

    void run() {
        if (!this.adaptClassStrings.isEmpty()) {
            this.adaptClassStrings();
        }
        if (!this.identifierNameStrings.isEmpty()) {
            this.replaceIdentifierNameString();
        }
    }

    private void adaptClassStrings() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            if (!this.adaptClassStrings.matches(clazz.type)) continue;
            for (DexEncodedField field : clazz.staticFields()) {
                this.adaptClassStringsInStaticField(field);
            }
            clazz.forEachMethod(this::adaptClassStringsInMethod);
        }
    }

    private void adaptClassStringsInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        DexValue staticValue = encodedField.getStaticValue();
        if (staticValue instanceof DexValue.DexValueString) {
            DexString original = (DexString)((DexValue.DexValueString)staticValue).getValue();
            encodedField.setStaticValue(new DexValue.DexValueString(this.getRenamedStringLiteral(original)));
        }
    }

    private void adaptClassStringsInMethod(DexEncodedMethod encodedMethod) {
        if (encodedMethod.shouldNotHaveCode()) {
            return;
        }
        Code code = encodedMethod.getCode();
        if (code == null) {
            return;
        }
        if (code.isDexCode()) {
            for (Instruction instruction : code.asDexCode().instructions) {
                if (!instruction.isConstString()) continue;
                ConstString cnst = instruction.asConstString();
                cnst.BBBB = this.getRenamedStringLiteral(cnst.getString());
            }
        } else {
            assert (code.isCfCode());
            for (CfInstruction instruction : code.asCfCode().getInstructions()) {
                if (!instruction.isConstString()) continue;
                CfConstString cnst = instruction.asConstString();
                cnst.setString(this.getRenamedStringLiteral(cnst.getString()));
            }
        }
    }

    private DexString getRenamedStringLiteral(DexString originalLiteral) {
        DexString renamed;
        String originalString = originalLiteral.toString();
        Map<String, DexType> renamedYetMatchedTypes = this.lens.getRenamedItems(DexType.class, type -> type.toSourceString().equals(originalString), DexType::toSourceString);
        DexType type2 = renamedYetMatchedTypes.get(originalString);
        if (type2 != null && (renamed = this.lens.lookupDescriptor(type2)) != originalLiteral) {
            return this.appInfo.dexItemFactory.createString(DescriptorUtils.descriptorToJavaType(renamed.toString()));
        }
        return originalLiteral;
    }

    private void replaceIdentifierNameString() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            for (DexEncodedField field : clazz.staticFields()) {
                this.replaceIdentifierNameStringInStaticField(field);
            }
            clazz.forEachMethod(this::replaceIdentifierNameStringInMethod);
        }
    }

    private void replaceIdentifierNameStringInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        DexValue staticValue = encodedField.getStaticValue();
        if (staticValue instanceof DexValue.DexItemBasedValueString) {
            DexReference original = (DexReference)((DexValue.DexItemBasedValueString)staticValue).getValue();
            encodedField.setStaticValue(new DexValue.DexValueString(this.lens.lookupName(original, this.appInfo.dexItemFactory)));
        }
    }

    private void replaceIdentifierNameStringInMethod(DexEncodedMethod encodedMethod) {
        if (!encodedMethod.getOptimizationInfo().useIdentifierNameString()) {
            return;
        }
        if (encodedMethod.shouldNotHaveCode()) {
            return;
        }
        Code code = encodedMethod.getCode();
        if (code == null) {
            return;
        }
        if (code.isDexCode()) {
            Instruction[] instructions = code.asDexCode().instructions;
            for (int i = 0; i < instructions.length; ++i) {
                Instruction instruction = instructions[i];
                if (!(instruction instanceof DexItemBasedConstString)) continue;
                DexItemBasedConstString cnst = instruction.asDexItemBasedConstString();
                instructions[i] = new ConstString((int)cnst.AA, this.lens.lookupName(cnst.getItem(), this.appInfo.dexItemFactory));
            }
        } else {
            assert (code.isCfCode());
            List<CfInstruction> instructions = code.asCfCode().instructions;
            for (int i = 0; i < instructions.size(); ++i) {
                CfInstruction instruction = instructions.get(i);
                if (!instruction.isDexItemBasedConstString()) continue;
                CfDexItemBasedConstString cnst = instruction.asDexItemBasedConstString();
                instructions.set(i, new CfConstString(this.lens.lookupName(cnst.getItem(), this.appInfo.dexItemFactory)));
            }
        }
    }
}

