/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.cf.FixedLocalValue;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CfRegisterAllocator
implements RegisterAllocator {
    private final IRCode code;
    private final InternalOptions options;
    private final TypeVerificationHelper typeHelper;
    private Map<BasicBlock, IRCode.LiveAtEntrySets> liveAtEntrySets;
    private final Map<BasicBlock, TypesAtBlockEntry> lazyTypeInfoAtBlockEntry = new HashMap<BasicBlock, TypesAtBlockEntry>();
    private final List<LiveIntervals> liveIntervals = new ArrayList<LiveIntervals>();
    private final List<LiveIntervals> active = new LinkedList<LiveIntervals>();
    private final List<LiveIntervals> inactive = new LinkedList<LiveIntervals>();
    private final PriorityQueue<LiveIntervals> unhandled = new PriorityQueue();
    private NavigableSet<Integer> freeRegisters = new TreeSet<Integer>();
    private int nextUnusedRegisterNumber = 0;
    private int maxRegisterNumber = 0;

    public CfRegisterAllocator(IRCode code, InternalOptions options, TypeVerificationHelper typeHelper) {
        this.code = code;
        this.options = options;
        this.typeHelper = typeHelper;
    }

    @Override
    public int registersUsed() {
        return this.maxRegisterNumber + 1;
    }

    @Override
    public int getRegisterForValue(Value value, int instructionNumber) {
        return this.getRegisterForValue(value);
    }

    public int getRegisterForValue(Value value) {
        if (value instanceof FixedLocalValue) {
            return ((FixedLocalValue)value).getRegister(this);
        }
        assert (!value.getLiveIntervals().hasSplits());
        return value.getLiveIntervals().getRegister();
    }

    @Override
    public int getArgumentOrAllocateRegisterForValue(Value value, int instructionNumber) {
        return this.getRegisterForValue(value);
    }

    @Override
    public InternalOptions getOptions() {
        return this.options;
    }

    @Override
    public void allocateRegisters(boolean debug) {
        assert (this.options.debug == debug);
        this.allocateRegisters();
    }

    public void allocateRegisters() {
        this.computeNeedsRegister();
        ImmutableList<BasicBlock> blocks = this.computeLivenessInformation();
        this.performLinearScan();
        if (this.options.debug) {
            LinearScanRegisterAllocator.computeDebugInfo(blocks, this.liveIntervals, this, this.liveAtEntrySets);
        }
    }

    private void computeNeedsRegister() {
        InstructionIterator it = this.code.instructionIterator();
        while (it.hasNext()) {
            Instruction next = (Instruction)it.next();
            Value outValue = next.outValue();
            if (outValue == null) continue;
            boolean isStackValue = outValue instanceof StackValue || outValue instanceof StackValues;
            outValue.setNeedsRegister(!isStackValue);
        }
    }

    private ImmutableList<BasicBlock> computeLivenessInformation() {
        ImmutableList<BasicBlock> blocks = this.code.numberInstructions();
        this.liveAtEntrySets = this.code.computeLiveAtEntrySets();
        LinearScanRegisterAllocator.computeLiveRanges(this.options, this.code, this.liveAtEntrySets, this.liveIntervals);
        return blocks;
    }

    private void performLinearScan() {
        this.unhandled.addAll(this.liveIntervals);
        while (!this.unhandled.isEmpty() && this.unhandled.peek().getValue().isArgument()) {
            LiveIntervals argument = this.unhandled.poll();
            this.assignRegisterToUnhandledInterval(argument, this.getNextFreeRegister(argument.getType().isWide()));
        }
        while (!this.unhandled.isEmpty()) {
            int register;
            LiveIntervals unhandledInterval = this.unhandled.poll();
            assert (!unhandledInterval.getValue().isArgument());
            int start = unhandledInterval.getStart();
            Iterator<LiveIntervals> it = this.active.iterator();
            while (it.hasNext()) {
                LiveIntervals activeIntervals = it.next();
                if (start >= activeIntervals.getEnd()) {
                    it.remove();
                    this.freeRegistersForIntervals(activeIntervals);
                    continue;
                }
                if (activeIntervals.overlapsPosition(start)) continue;
                assert (activeIntervals.getRegister() != Integer.MIN_VALUE);
                it.remove();
                this.inactive.add(activeIntervals);
                this.freeRegistersForIntervals(activeIntervals);
            }
            it = this.inactive.iterator();
            while (it.hasNext()) {
                LiveIntervals inactiveIntervals = it.next();
                if (start >= inactiveIntervals.getEnd()) {
                    it.remove();
                    continue;
                }
                if (!inactiveIntervals.overlapsPosition(start)) continue;
                it.remove();
                assert (inactiveIntervals.getRegister() != Integer.MIN_VALUE);
                this.active.add(inactiveIntervals);
                this.takeRegistersForIntervals(inactiveIntervals);
            }
            if (this.tryHint(unhandledInterval)) {
                this.assignRegisterToUnhandledInterval(unhandledInterval, unhandledInterval.getHint().getRegister());
                continue;
            }
            boolean wide = unhandledInterval.getType().isWide();
            TreeSet<Integer> previousFreeRegisters = new TreeSet<Integer>((SortedSet<Integer>)this.freeRegisters);
            while (true) {
                register = this.getNextFreeRegister(wide);
                boolean overlapsInactiveInterval = false;
                for (LiveIntervals inactiveIntervals : this.inactive) {
                    if (!inactiveIntervals.usesRegister(register, wide) || !unhandledInterval.overlaps(inactiveIntervals)) continue;
                    overlapsInactiveInterval = true;
                    break;
                }
                if (!overlapsInactiveInterval) break;
                this.freeRegisters.remove(register);
            }
            this.freeRegisters = previousFreeRegisters;
            this.assignRegisterToUnhandledInterval(unhandledInterval, register);
        }
    }

    private int getNextFreeRegister(boolean isWide) {
        if (!this.freeRegisters.isEmpty()) {
            if (isWide) {
                for (Integer register : this.freeRegisters) {
                    if (!this.freeRegisters.contains(register + 1) && this.nextUnusedRegisterNumber != register + 1) continue;
                    return register;
                }
                return this.nextUnusedRegisterNumber;
            }
            return (Integer)this.freeRegisters.first();
        }
        return this.nextUnusedRegisterNumber;
    }

    private void freeRegistersForIntervals(LiveIntervals intervals) {
        int register = intervals.getRegister();
        this.freeRegisters.add(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.add(register + 1);
        }
    }

    private void takeRegistersForIntervals(LiveIntervals intervals) {
        int register = intervals.getRegister();
        this.freeRegisters.remove(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.remove(register + 1);
        }
    }

    private void updateHints(LiveIntervals intervals) {
        for (Phi phi : intervals.getValue().uniquePhiUsers()) {
            phi.getLiveIntervals().setHint(intervals);
            for (Value value : phi.getOperands()) {
                value.getLiveIntervals().setHint(intervals);
            }
        }
    }

    private boolean tryHint(LiveIntervals unhandled) {
        if (unhandled.getHint() == null) {
            return false;
        }
        boolean isWide = unhandled.getType().isWide();
        int hintRegister = unhandled.getHint().getRegister();
        if (this.freeRegisters.contains(hintRegister) && (!isWide || this.freeRegisters.contains(hintRegister + 1))) {
            for (LiveIntervals inactive : this.inactive) {
                if (!inactive.usesRegister(hintRegister, isWide) || !inactive.overlaps(unhandled)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void assignRegisterToUnhandledInterval(LiveIntervals unhandledInterval, int register) {
        this.assignRegister(unhandledInterval, register);
        this.takeRegistersForIntervals(unhandledInterval);
        this.updateRegisterState(register, unhandledInterval.getType().isWide());
        this.updateHints(unhandledInterval);
        this.active.add(unhandledInterval);
    }

    private void updateRegisterState(int register, boolean needsRegisterPair) {
        int maxRegister = register + (needsRegisterPair ? 1 : 0);
        if (maxRegister >= this.nextUnusedRegisterNumber) {
            this.nextUnusedRegisterNumber = maxRegister + 1;
        }
        this.maxRegisterNumber = Math.max(this.maxRegisterNumber, maxRegister);
    }

    private void assignRegister(LiveIntervals intervals, int register) {
        intervals.setRegister(register);
    }

    public void addToLiveAtEntrySet(BasicBlock block, Collection<Phi> phis) {
        this.liveAtEntrySets.get((Object)block).liveValues.addAll(phis);
    }

    public TypesAtBlockEntry getTypesAtBlockEntry(BasicBlock block) {
        return this.lazyTypeInfoAtBlockEntry.computeIfAbsent(block, k -> {
            Set<Value> liveValues = this.liveAtEntrySets.get((Object)k).liveValues;
            Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo> registers = new Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo>(liveValues.size());
            for (Value liveValue : liveValues) {
                registers.put(this.getRegisterForValue(liveValue), this.typeHelper.getTypeInfo(liveValue));
            }
            Deque<StackValue> liveStackValues = this.liveAtEntrySets.get((Object)k).liveStackValues;
            ArrayList<TypeVerificationHelper.TypeInfo> stack = new ArrayList<TypeVerificationHelper.TypeInfo>(liveStackValues.size());
            stack = new ArrayList(liveStackValues.size());
            for (StackValue value : liveStackValues) {
                stack.add(this.typeHelper.getTypeInfo(value));
            }
            return new TypesAtBlockEntry(registers, stack);
        });
    }

    @Override
    public void mergeBlocks(BasicBlock kept, BasicBlock removed) {
        TypesAtBlockEntry typesOfKept = this.getTypesAtBlockEntry(kept);
        TypesAtBlockEntry typesOfRemoved = this.getTypesAtBlockEntry(removed);
        assert (typesOfKept.registers.size() == typesOfRemoved.registers.size());
        for (Int2ReferenceMap.Entry entry : typesOfKept.registers.int2ReferenceEntrySet()) {
            int register = entry.getIntKey();
            TypeVerificationHelper.TypeInfo keptTypeInfo = (TypeVerificationHelper.TypeInfo)entry.getValue();
            TypeVerificationHelper.TypeInfo removedTypeInfo = (TypeVerificationHelper.TypeInfo)typesOfRemoved.registers.get(register);
            assert (removedTypeInfo != null);
            TypeVerificationHelper.TypeInfo joinedTypeInfo = this.typeHelper.join(keptTypeInfo, removedTypeInfo);
            if (joinedTypeInfo == keptTypeInfo) continue;
            typesOfKept.registers.put(register, joinedTypeInfo);
        }
        assert (typesOfKept.stack.size() == typesOfRemoved.stack.size());
        for (int i = 0; i < typesOfKept.stack.size(); ++i) {
            TypeVerificationHelper.TypeInfo typeInfo = typesOfKept.stack.get(i);
            TypeVerificationHelper.TypeInfo joinedTypeInfo = this.typeHelper.join(typeInfo, typesOfRemoved.stack.get(i));
            if (joinedTypeInfo == typeInfo) continue;
            typesOfKept.stack.set(i, joinedTypeInfo);
        }
    }

    public static class TypesAtBlockEntry {
        public final Int2ReferenceMap<TypeVerificationHelper.TypeInfo> registers;
        public final List<TypeVerificationHelper.TypeInfo> stack;

        TypesAtBlockEntry(Int2ReferenceMap<TypeVerificationHelper.TypeInfo> registers, List<TypeVerificationHelper.TypeInfo> stack) {
            this.registers = registers;
            this.stack = stack;
        }
    }
}

