/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfCmp;
import com.android.tools.r8.code.CmpLong;
import com.android.tools.r8.code.CmpgDouble;
import com.android.tools.r8.code.CmpgFloat;
import com.android.tools.r8.code.CmplDouble;
import com.android.tools.r8.code.CmplFloat;
import com.android.tools.r8.code.Format23x;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.ir.analysis.constant.Bottom;
import com.android.tools.r8.ir.analysis.constant.ConstLatticeElement;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.LongInterval;
import com.android.tools.r8.utils.StringUtils;
import java.util.function.Function;

public class Cmp
extends Binop {
    private final Bias bias;

    public Cmp(NumericType type, Bias bias, Value dest, Value left, Value right) {
        super(type, dest, left, right);
        this.bias = bias;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int dest = builder.allocatedRegister(this.outValue, this.getNumber());
        int left = builder.allocatedRegister(this.leftValue(), this.getNumber());
        int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
        switch (this.type) {
            case DOUBLE: {
                assert (this.bias != Bias.NONE);
                if (this.bias == Bias.GT) {
                    instruction = new CmpgDouble(dest, left, right);
                    break;
                }
                assert (this.bias == Bias.LT);
                instruction = new CmplDouble(dest, left, right);
                break;
            }
            case FLOAT: {
                assert (this.bias != Bias.NONE);
                if (this.bias == Bias.GT) {
                    instruction = new CmpgFloat(dest, left, right);
                    break;
                }
                assert (this.bias == Bias.LT);
                instruction = new CmplFloat(dest, left, right);
                break;
            }
            case LONG: {
                assert (this.bias == Bias.NONE);
                instruction = new CmpLong(dest, left, right);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    private String biasToString(Bias bias) {
        switch (bias) {
            case NONE: {
                return "none";
            }
            case GT: {
                return "gt";
            }
            case LT: {
                return "lt";
            }
        }
        throw new Unreachable("Unexpected bias " + (Object)((Object)bias));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" (");
        switch (this.type) {
            case DOUBLE: {
                builder.append("double, ");
                builder.append(this.biasToString(this.bias));
                break;
            }
            case FLOAT: {
                builder.append("float, ");
                builder.append(this.biasToString(this.bias));
                break;
            }
            case LONG: {
                builder.append("long");
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.append(")");
        for (int i = builder.length(); i < 20; ++i) {
            builder.append(" ");
        }
        if (this.outValue != null) {
            builder.append(this.outValue);
            builder.append(" <- ");
        }
        StringUtils.append(builder, this.inValues, ", ", StringUtils.BraceType.NONE);
        return builder.toString();
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isCmp() && other.asCmp().bias == this.bias;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    private boolean nonOverlapingRanges() {
        return this.type == NumericType.LONG && this.leftValue().hasValueRange() && this.rightValue().hasValueRange() && this.leftValue().getValueRange().doesntOverlapWith(this.rightValue().getValueRange());
    }

    @Override
    public boolean canBeFolded() {
        return this.leftValue().isConstNumber() && this.rightValue().isConstNumber() || this.nonOverlapingRanges();
    }

    @Override
    public LatticeElement evaluate(IRCode code, Function<Value, LatticeElement> getLatticeElement) {
        LatticeElement leftLattice = getLatticeElement.apply(this.leftValue());
        LatticeElement rightLattice = getLatticeElement.apply(this.rightValue());
        if (leftLattice.isConst() && rightLattice.isConst()) {
            int result;
            ConstNumber leftConst = leftLattice.asConst().getConstNumber();
            ConstNumber rightConst = rightLattice.asConst().getConstNumber();
            if (this.type == NumericType.LONG) {
                result = Integer.signum(Long.compare(leftConst.getLongValue(), rightConst.getLongValue()));
            } else if (this.type == NumericType.FLOAT) {
                float left = leftConst.getFloatValue();
                float right = rightConst.getFloatValue();
                result = Float.isNaN(left) || Float.isNaN(right) ? (this.bias == Bias.GT ? 1 : -1) : (int)Math.signum(left - right);
            } else {
                assert (this.type == NumericType.DOUBLE);
                double left = leftConst.getDoubleValue();
                double right = rightConst.getDoubleValue();
                result = Double.isNaN(left) || Double.isNaN(right) ? (this.bias == Bias.GT ? 1 : -1) : (int)Math.signum(left - right);
            }
            Value value = code.createValue(TypeLatticeElement.INT, this.getLocalInfo());
            ConstNumber newConst = new ConstNumber(value, result);
            return new ConstLatticeElement(newConst);
        }
        if (leftLattice.isValueRange() && rightLattice.isConst()) {
            Value leftValueRange = leftLattice.asConstRange().getConstRange();
            ConstNumber rightConst = rightLattice.asConst().getConstNumber();
            return this.buildLatticeResult(code, leftValueRange.getValueRange(), rightConst.outValue().getValueRange());
        }
        if (leftLattice.isConst() && rightLattice.isValueRange()) {
            Value rigthValueRange = rightLattice.asConstRange().getConstRange();
            ConstNumber leftConst = leftLattice.asConst().getConstNumber();
            return this.buildLatticeResult(code, leftConst.outValue().getValueRange(), rigthValueRange.getValueRange());
        }
        if (leftLattice.isValueRange() && rightLattice.isValueRange()) {
            Value rigthValueRange = rightLattice.asConstRange().getConstRange();
            Value leftValueRange = leftLattice.asConstRange().getConstRange();
            return this.buildLatticeResult(code, leftValueRange.getValueRange(), rigthValueRange.getValueRange());
        }
        return Bottom.getInstance();
    }

    private LatticeElement buildLatticeResult(IRCode code, LongInterval leftRange, LongInterval rightRange) {
        if (leftRange.overlapsWith(rightRange)) {
            return Bottom.getInstance();
        }
        int result = Integer.signum(Long.compare(leftRange.getMin(), rightRange.getMin()));
        Value value = code.createValue(TypeLatticeElement.INT, this.getLocalInfo());
        ConstNumber newConst = new ConstNumber(value, result);
        return new ConstLatticeElement(newConst);
    }

    @Override
    public boolean isCmp() {
        return true;
    }

    @Override
    public Cmp asCmp() {
        return this;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfCmp(this.bias, this.type));
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return TypeLatticeElement.INT;
    }

    public static enum Bias {
        NONE,
        GT,
        LT;

    }
}

