/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.LinearFlowInstructionIterator;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.DupDupDupPeephole;
import com.android.tools.r8.ir.optimize.peepholes.LoadLoadDupPeephole;
import com.android.tools.r8.ir.optimize.peepholes.MoveLoadUpPeephole;
import com.android.tools.r8.ir.optimize.peepholes.StoreLoadPeephole;
import com.android.tools.r8.ir.optimize.peepholes.StoreSequenceLoadPeephole;
import java.util.List;
import java.util.ListIterator;

public class BasicBlockMuncher {
    private final List<BasicBlockPeephole> nonDestructivePeepholes = ImmutableList.of(new MoveLoadUpPeephole());
    private final List<BasicBlockPeephole> destructivePeepholes = ImmutableList.of(new StoreSequenceLoadPeephole(), new StoreLoadPeephole(), new LoadLoadDupPeephole(), new DupDupDupPeephole());
    private final List<List<BasicBlockPeephole>> allPeepholes = ImmutableList.of(this.nonDestructivePeepholes, this.destructivePeepholes);

    public void optimize(IRCode code) {
        ListIterator<BasicBlock> blocksIterator = code.blocks.listIterator(code.blocks.size());
        while (blocksIterator.hasPrevious()) {
            BasicBlock currentBlock = blocksIterator.previous();
            for (List<BasicBlockPeephole> peepholes : this.allPeepholes) {
                LinearFlowInstructionIterator it = new LinearFlowInstructionIterator(currentBlock, currentBlock.getInstructions().size());
                boolean matched = false;
                while (matched || it.hasPrevious()) {
                    if (!it.hasPrevious()) {
                        matched = false;
                        it = new LinearFlowInstructionIterator(currentBlock, currentBlock.getInstructions().size());
                    }
                    for (BasicBlockPeephole peepHole : peepholes) {
                        matched |= peepHole.match(it);
                    }
                    if (!it.hasPrevious()) continue;
                    it.previous();
                }
            }
        }
    }
}

