/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.LibraryRequest;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BootClasspathBuilder {
    public static ImmutableList<File> computeFullBootClasspath(IAndroidTarget target, File annotationsJar) {
        File jar;
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)annotationsJar);
        ImmutableList.Builder classpath = ImmutableList.builder();
        for (String p : target.getBootClasspath()) {
            classpath.add((Object)new File(p));
        }
        for (IAndroidTarget.OptionalLibrary lib : target.getAdditionalLibraries()) {
            jar = lib.getJar();
            Verify.verify((jar != null ? 1 : 0) != 0, (String)"Jar missing from additional library %s.", (Object)lib.getName());
            classpath.add((Object)jar);
        }
        for (IAndroidTarget.OptionalLibrary lib : target.getOptionalLibraries()) {
            jar = lib.getJar();
            Verify.verify((jar != null ? 1 : 0) != 0, (String)"Jar missing from optional library %s.", (Object)lib.getName());
            classpath.add((Object)jar);
        }
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add((Object)annotationsJar);
        }
        return classpath.build();
    }

    public static ImmutableList<File> computeFilteredClasspath(IAndroidTarget target, List<LibraryRequest> libraryRequests, EvalIssueReporter issueReporter, File annotationsJar) {
        ImmutableList.Builder classpath = ImmutableList.builder();
        for (String p : target.getBootClasspath()) {
            classpath.add((Object)new File(p));
        }
        classpath.addAll(BootClasspathBuilder.computeAdditionalAndRequestedOptionalLibraries(target, libraryRequests, issueReporter));
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add((Object)annotationsJar);
        }
        return classpath.build();
    }

    public static ImmutableList<File> computeAdditionalAndRequestedOptionalLibraries(IAndroidTarget target, List<LibraryRequest> libraryRequestsArg, EvalIssueReporter issueReporter) {
        ImmutableList.Builder classpath = ImmutableList.builder();
        ArrayList libraryRequests = Lists.newArrayList(libraryRequestsArg);
        for (IAndroidTarget.OptionalLibrary lib : target.getAdditionalLibraries()) {
            File jar = lib.getJar();
            Verify.verify((jar != null ? 1 : 0) != 0, (String)"Jar missing from additional library %s.", (Object)lib.getName());
            classpath.add((Object)jar);
            BootClasspathBuilder.findMatchingLib(lib.getName(), libraryRequests).ifPresent(libraryRequests::remove);
        }
        for (IAndroidTarget.OptionalLibrary lib : target.getOptionalLibraries()) {
            Optional<LibraryRequest> requestedLib = BootClasspathBuilder.findMatchingLib(lib.getName(), libraryRequests);
            if (!requestedLib.isPresent()) continue;
            File jar = lib.getJar();
            Verify.verify((jar != null ? 1 : 0) != 0, (String)"Jar missing from optional library %s.", (Object)lib.getName());
            classpath.add((Object)jar);
            libraryRequests.remove(requestedLib.get());
        }
        for (LibraryRequest library : libraryRequests) {
            issueReporter.reportError(EvalIssueReporter.Type.OPTIONAL_LIB_NOT_FOUND, new EvalIssueException("Unable to find optional library: " + library.getName(), library.getName()));
        }
        return classpath.build();
    }

    private static Optional<LibraryRequest> findMatchingLib(String name, List<LibraryRequest> libraries) {
        return libraries.stream().filter(l -> name.equals(l.getName())).findFirst();
    }
}

