/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassTypeLatticeElement
extends ReferenceTypeLatticeElement {
    private Set<DexType> lazyInterfaces;
    private AppInfo appInfoForLazyInterfacesComputation;

    public ClassTypeLatticeElement(DexType classType, boolean isNullable, Set<DexType> interfaces) {
        this(classType, isNullable, interfaces, null);
    }

    public ClassTypeLatticeElement(DexType classType, boolean isNullable, AppInfo appInfo) {
        this(classType, isNullable, null, appInfo);
    }

    private ClassTypeLatticeElement(DexType classType, boolean isNullable, Set<DexType> interfaces, AppInfo appInfo) {
        super(classType, isNullable);
        assert (classType.isClassType());
        this.appInfoForLazyInterfacesComputation = appInfo;
        this.lazyInterfaces = interfaces;
    }

    public DexType getClassType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DexType> getInterfaces() {
        if (this.lazyInterfaces != null) {
            return this.lazyInterfaces;
        }
        ClassTypeLatticeElement classTypeLatticeElement = this;
        synchronized (classTypeLatticeElement) {
            if (this.lazyInterfaces == null) {
                Set<DexType> itfs = this.type.implementedInterfaces(this.appInfoForLazyInterfacesComputation);
                this.lazyInterfaces = TypeLatticeElement.computeLeastUpperBoundOfInterfaces(this.appInfoForLazyInterfacesComputation, itfs, itfs);
                this.appInfoForLazyInterfacesComputation = null;
            }
        }
        return this.lazyInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceTypeLatticeElement getOrCreateDualLattice() {
        if (this.dual != null) {
            return this.dual;
        }
        ClassTypeLatticeElement classTypeLatticeElement = this;
        synchronized (classTypeLatticeElement) {
            if (this.dual == null) {
                ClassTypeLatticeElement dual = new ClassTypeLatticeElement(this.type, !this.isNullable(), this.lazyInterfaces, this.appInfoForLazyInterfacesComputation);
                ClassTypeLatticeElement.linkDualLattice(this, dual);
            }
        }
        return this.dual;
    }

    @Override
    public TypeLatticeElement asNullable() {
        return this.isNullable() ? this : this.getOrCreateDualLattice();
    }

    @Override
    public TypeLatticeElement asNonNullable() {
        return !this.isNullable() ? this : this.getOrCreateDualLattice();
    }

    @Override
    public boolean isBasedOnMissingClass(AppInfo appInfo) {
        return this.getClassType().isMissingOrHasMissingSuperType(appInfo) || this.getInterfaces().stream().anyMatch(type -> type.isMissingOrHasMissingSuperType(appInfo));
    }

    @Override
    public boolean isClassType() {
        return true;
    }

    @Override
    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(" [");
        builder.append(this.getInterfaces().stream().map(DexType::toString).collect(Collectors.joining(", ")));
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return (this.isNullable() ? 1 : -1) * this.type.hashCode();
    }
}

