/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import java.util.Collections;
import java.util.Set;

public class ReferenceTypeLatticeElement
extends TypeLatticeElement {
    private static final ReferenceTypeLatticeElement NULL_INSTANCE = new ReferenceTypeLatticeElement(DexItemFactory.nullValueType, true);
    final DexType type;
    ReferenceTypeLatticeElement dual;

    public ReferenceTypeLatticeElement getOrCreateDualLattice() {
        throw new Unreachable("Should be defined/used by class/array types.");
    }

    static void linkDualLattice(ReferenceTypeLatticeElement t1, ReferenceTypeLatticeElement t2) {
        assert (t1.dual == null && t2.dual == null);
        t1.dual = t2;
        t2.dual = t1;
    }

    ReferenceTypeLatticeElement(DexType type, boolean isNullable) {
        super(isNullable);
        this.type = type;
    }

    static ReferenceTypeLatticeElement getNullTypeLatticeElement() {
        return NULL_INSTANCE;
    }

    public Set<DexType> getInterfaces() {
        return Collections.emptySet();
    }

    @Override
    public boolean isNull() {
        return this.type == DexItemFactory.nullValueType;
    }

    @Override
    public TypeLatticeElement asNullable() {
        assert (this.isNull());
        return this;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public String toString() {
        return this.isNullableString() + this.type.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceTypeLatticeElement)) {
            return false;
        }
        ReferenceTypeLatticeElement other = (ReferenceTypeLatticeElement)o;
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        Set<DexType> thisInterfaces = this.getInterfaces();
        Set<DexType> otherInterfaces = other.getInterfaces();
        if (thisInterfaces.size() != otherInterfaces.size()) {
            return false;
        }
        return thisInterfaces.containsAll(otherInterfaces);
    }

    @Override
    public int hashCode() {
        assert (this.isNull());
        return System.identityHashCode(this);
    }
}

