/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayDeque;
import java.util.Deque;

public class TypeAnalysis {
    private final boolean mayHaveImpreciseTypes;
    private Mode mode = Mode.UNSET;
    private final AppInfo appInfo;
    private final DexEncodedMethod context;
    private final Deque<Value> worklist = new ArrayDeque<Value>();

    public TypeAnalysis(AppInfo appInfo, DexEncodedMethod encodedMethod, boolean mayHaveImpreciseTypes) {
        this.appInfo = appInfo;
        this.context = encodedMethod;
        this.mayHaveImpreciseTypes = mayHaveImpreciseTypes;
    }

    public TypeAnalysis(AppInfo appInfo, DexEncodedMethod encodedMethod) {
        this(appInfo, encodedMethod, false);
    }

    private void analyze() {
        while (!this.worklist.isEmpty()) {
            this.analyzeValue(this.worklist.poll());
        }
    }

    public void widening(DexEncodedMethod encodedMethod, IRCode code) {
        this.mode = Mode.WIDENING;
        assert (this.worklist.isEmpty());
        code.topologicallySortedBlocks().forEach(b -> this.analyzeBasicBlock(encodedMethod, (BasicBlock)b));
        this.analyze();
    }

    public void widening(Iterable<Value> values2) {
        this.mode = Mode.WIDENING;
        assert (this.worklist.isEmpty());
        values2.forEach(this::enqueue);
        this.analyze();
    }

    public void narrowing(Iterable<Value> values2) {
        this.mode = Mode.NARROWING;
        assert (this.worklist.isEmpty());
        values2.forEach(this::enqueue);
        this.analyze();
    }

    private void enqueue(Value v) {
        assert (v != null);
        if (!this.worklist.contains(v)) {
            this.worklist.add(v);
        }
    }

    public void analyzeBasicBlock(DexEncodedMethod encodedMethod, BasicBlock block) {
        int argumentsSeen = encodedMethod.accessFlags.isStatic() ? 0 : -1;
        for (Instruction instruction : block.getInstructions()) {
            TypeLatticeElement derived;
            Value outValue = instruction.outValue();
            if (outValue == null) continue;
            if (instruction.isArgument()) {
                if (argumentsSeen < 0) {
                    derived = TypeLatticeElement.fromDexType(encodedMethod.method.holder, encodedMethod != this.context, this.appInfo);
                } else {
                    DexType argType = encodedMethod.method.proto.parameters.values[argumentsSeen];
                    derived = TypeLatticeElement.fromDexType(argType, true, this.appInfo);
                }
                ++argumentsSeen;
                this.updateTypeOfValue(outValue, derived);
                continue;
            }
            if (instruction.hasInvariantOutType()) {
                derived = instruction.evaluate(this.appInfo);
                this.updateTypeOfValue(outValue, derived);
                continue;
            }
            this.enqueue(outValue);
        }
        for (Phi phi : block.getPhis()) {
            this.enqueue(phi);
        }
    }

    private void analyzeValue(Value value) {
        TypeLatticeElement derived;
        TypeLatticeElement previous = value.getTypeLattice();
        TypeLatticeElement typeLatticeElement = derived = value.isPhi() ? value.asPhi().computePhiType(this.appInfo) : value.definition.evaluate(this.appInfo);
        assert (this.mayHaveImpreciseTypes || derived.isPreciseType());
        assert (!previous.isPreciseType() || derived.isPreciseType());
        this.updateTypeOfValue(value, derived);
    }

    private void updateTypeOfValue(Value value, TypeLatticeElement type) {
        assert (this.mode != Mode.UNSET);
        TypeLatticeElement current = value.getTypeLattice();
        if (current.equals(type)) {
            return;
        }
        if (type.isBottom()) {
            return;
        }
        if (this.mode == Mode.WIDENING) {
            value.widening(this.appInfo, type);
        } else {
            assert (this.mode == Mode.NARROWING);
            value.narrowing(this.appInfo, type);
        }
        for (Instruction instruction : value.uniqueUsers()) {
            Value outValue = instruction.outValue();
            if (outValue == null) continue;
            this.enqueue(outValue);
        }
        for (Phi phi : value.uniquePhiUsers()) {
            this.enqueue(phi);
        }
    }

    public static DexType getRefinedReceiverType(AppInfoWithSubtyping appInfo, InvokeMethodWithReceiver invoke) {
        DexType refinedType;
        DexType receiverType = invoke.getInvokedMethod().getHolder();
        TypeLatticeElement lattice = invoke.getReceiver().getTypeLattice();
        if (lattice.isClassType() && (refinedType = lattice.asClassTypeLatticeElement().getClassType()).isSubtypeOf(receiverType, appInfo)) {
            return refinedType;
        }
        return receiverType;
    }

    private static enum Mode {
        UNSET,
        WIDENING,
        NARROWING;

    }
}

