/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.BottomTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.DoubleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.FloatTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.IntTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.LongTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.NullLatticeElement;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.SingleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TopTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.WideTypeLatticeElement;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.utils.LRUCacheTable;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class TypeLatticeElement {
    public static final BottomTypeLatticeElement BOTTOM = BottomTypeLatticeElement.getInstance();
    public static final TopTypeLatticeElement TOP = TopTypeLatticeElement.getInstance();
    public static final IntTypeLatticeElement INT = IntTypeLatticeElement.getInstance();
    public static final FloatTypeLatticeElement FLOAT = FloatTypeLatticeElement.getInstance();
    public static final SingleTypeLatticeElement SINGLE = SingleTypeLatticeElement.getInstance();
    public static final LongTypeLatticeElement LONG = LongTypeLatticeElement.getInstance();
    public static final DoubleTypeLatticeElement DOUBLE = DoubleTypeLatticeElement.getInstance();
    public static final WideTypeLatticeElement WIDE = WideTypeLatticeElement.getInstance();
    public static final ReferenceTypeLatticeElement NULL = ReferenceTypeLatticeElement.getNullTypeLatticeElement();
    private static final LRUCacheTable<Set<DexType>, Set<DexType>, Set<DexType>> leastUpperBoundOfInterfacesTable = LRUCacheTable.create(8, 8);
    private final boolean isNullable;

    TypeLatticeElement(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public NullLatticeElement nullElement() {
        if (this.isNull()) {
            return NullLatticeElement.definitelyNull();
        }
        if (!this.isNullable()) {
            return NullLatticeElement.definitelyNotNull();
        }
        return NullLatticeElement.maybeNull();
    }

    public abstract TypeLatticeElement asNullable();

    public TypeLatticeElement asNonNullable() {
        return BOTTOM;
    }

    String isNullableString() {
        return this.isNullable() ? "" : "@NonNull ";
    }

    public TypeLatticeElement join(TypeLatticeElement other, AppInfo appInfo) {
        boolean isNullable;
        if (this == other) {
            return this;
        }
        if (this.isBottom()) {
            return other;
        }
        if (other.isBottom()) {
            return this;
        }
        if (this.isTop() || other.isTop()) {
            return TOP;
        }
        if (this.isNull()) {
            return other.asNullable();
        }
        if (other.isNull()) {
            return this.asNullable();
        }
        if (this.isPrimitive()) {
            return other.isPrimitive() ? PrimitiveTypeLatticeElement.join(this.asPrimitiveTypeLatticeElement(), other.asPrimitiveTypeLatticeElement()) : TOP;
        }
        if (other.isPrimitive()) {
            return TOP;
        }
        assert (this.isReference() && other.isReference());
        assert (this.isPreciseType() && other.isPreciseType());
        boolean bl = isNullable = this.isNullable() || other.isNullable();
        if (this.getClass() != other.getClass()) {
            return TypeLatticeElement.objectClassType(appInfo, isNullable);
        }
        if (this.isArrayType()) {
            assert (other.isArrayType());
            ArrayTypeLatticeElement a1 = this.asArrayTypeLatticeElement();
            ArrayTypeLatticeElement a2 = other.asArrayTypeLatticeElement();
            if (a1.getArrayType() == a2.getArrayType()) {
                return a1.isNullable() ? a1 : a2;
            }
            DexType a1BaseReferenceType = a1.getArrayBaseType(appInfo.dexItemFactory);
            int a1Nesting = a1.getNesting();
            if (a1BaseReferenceType.isPrimitiveType()) {
                --a1Nesting;
                a1BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            DexType a2BaseReferenceType = a2.getArrayBaseType(appInfo.dexItemFactory);
            int a2Nesting = a2.getNesting();
            if (a2BaseReferenceType.isPrimitiveType()) {
                --a2Nesting;
                a2BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            assert (a1BaseReferenceType.isClassType() && a2BaseReferenceType.isClassType());
            if (a1Nesting == 0 || a2Nesting == 0) {
                return TypeLatticeElement.objectClassType(appInfo, isNullable);
            }
            if (a1Nesting != a2Nesting) {
                int min = Math.min(a1Nesting, a2Nesting);
                return TypeLatticeElement.objectArrayType(appInfo, min, isNullable);
            }
            DexType baseTypeLub = a1BaseReferenceType.computeLeastUpperBoundOfClasses(appInfo, a2BaseReferenceType);
            DexType arrayTypeLub = appInfo.dexItemFactory.createArrayType(a1Nesting, baseTypeLub);
            return TypeLatticeElement.fromDexType(arrayTypeLub, isNullable, appInfo);
        }
        if (this.isClassType()) {
            assert (other.isClassType());
            ClassTypeLatticeElement c1 = this.asClassTypeLatticeElement();
            ClassTypeLatticeElement c2 = other.asClassTypeLatticeElement();
            DexType lubType = c1.getClassType().computeLeastUpperBoundOfClasses(appInfo, c2.getClassType());
            Set<DexType> c1lubItfs = c1.getInterfaces();
            Set<DexType> c2lubItfs = c2.getInterfaces();
            Set<DexType> lubItfs = null;
            if (c1lubItfs.size() == c2lubItfs.size() && c1lubItfs.containsAll(c2lubItfs)) {
                lubItfs = c1lubItfs;
            }
            if (lubItfs == null) {
                lubItfs = TypeLatticeElement.computeLeastUpperBoundOfInterfaces(appInfo, c1lubItfs, c2lubItfs);
            }
            return new ClassTypeLatticeElement(lubType, isNullable, lubItfs);
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<DexType> computeLeastUpperBoundOfInterfaces(AppInfo appInfo, Set<DexType> s1, Set<DexType> s2) {
        Set<DexType> cached = leastUpperBoundOfInterfacesTable.get(s1, s2);
        if (cached != null) {
            return cached;
        }
        cached = leastUpperBoundOfInterfacesTable.get(s2, s1);
        if (cached != null) {
            return cached;
        }
        IdentityHashMap<DexType, Set> seen = new IdentityHashMap<DexType, Set>();
        ArrayDeque<InterfaceWithMarker> worklist = new ArrayDeque<InterfaceWithMarker>();
        for (DexType itf1 : s1) {
            worklist.add(new InterfaceWithMarker(itf1, InterfaceMarker.LEFT));
        }
        for (DexType itf2 : s2) {
            worklist.add(new InterfaceWithMarker(itf2, InterfaceMarker.RIGHT));
        }
        while (!worklist.isEmpty()) {
            InterfaceWithMarker item = (InterfaceWithMarker)worklist.poll();
            DexType itf = item.itf;
            InterfaceMarker interfaceMarker = item.marker;
            Object markers = seen.computeIfAbsent(itf, k -> new HashSet());
            if (markers.contains((Object)interfaceMarker)) continue;
            if (markers.size() == 1) {
                markers.add(interfaceMarker);
                continue;
            }
            markers.add(interfaceMarker);
            DexClass itfClass = appInfo.definitionFor(itf);
            if (itfClass == null) continue;
            for (DexType superItf : itfClass.interfaces.values) {
                markers = seen.computeIfAbsent(superItf, k -> new HashSet());
                if (markers.contains((Object)interfaceMarker)) continue;
                worklist.add(new InterfaceWithMarker(superItf, interfaceMarker));
            }
        }
        ImmutableSet.Builder commonBuilder = ImmutableSet.builder();
        for (Map.Entry entry : seen.entrySet()) {
            if (((Set)entry.getValue()).size() < 2) continue;
            commonBuilder.add((DexType)entry.getKey());
        }
        ImmutableCollection commonlyVisited = commonBuilder.build();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexType itf : commonlyVisited) {
            boolean notTheLeast = false;
            for (DexType other : commonlyVisited) {
                if (!other.isStrictSubtypeOf(itf, appInfo)) continue;
                notTheLeast = true;
                break;
            }
            if (notTheLeast) continue;
            builder.add(itf);
        }
        ImmutableCollection lub = builder.build();
        if (s1.size() != s2.size() || !s1.containsAll(s2)) {
            LRUCacheTable<Set<DexType>, Set<DexType>, Set<DexType>> lRUCacheTable = leastUpperBoundOfInterfacesTable;
            synchronized (lRUCacheTable) {
                leastUpperBoundOfInterfacesTable.put(s1, s2, (Set<DexType>)((Object)lub));
            }
        }
        return lub;
    }

    public static TypeLatticeElement join(Iterable<TypeLatticeElement> typeLattices, AppInfo appInfo) {
        TypeLatticeElement result = BOTTOM;
        for (TypeLatticeElement other : typeLattices) {
            result = result.join(other, appInfo);
        }
        return result;
    }

    public static TypeLatticeElement joinTypes(Iterable<DexType> types, boolean isNullable, AppInfo appInfo) {
        TypeLatticeElement result = BOTTOM;
        for (DexType type : types) {
            result = result.join(TypeLatticeElement.fromDexType(type, isNullable, appInfo), appInfo);
        }
        return result;
    }

    public boolean strictlyLessThan(TypeLatticeElement other, AppInfo appInfo) {
        if (this.equals(other)) {
            return false;
        }
        TypeLatticeElement lub = this.join(other, appInfo);
        return !this.equals(lub) && other.equals(lub);
    }

    public boolean lessThanOrEqual(TypeLatticeElement other, AppInfo appInfo) {
        return this.equals(other) || this.strictlyLessThan(other, appInfo);
    }

    public boolean isBasedOnMissingClass(AppInfo appInfo) {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return null;
    }

    public boolean isClassType() {
        return false;
    }

    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public PrimitiveTypeLatticeElement asPrimitiveTypeLatticeElement() {
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean isWide() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isPreciseType() {
        return this.isArrayType() || this.isClassType() || this.isNull() || this.isInt() || this.isFloat() || this.isLong() || this.isDouble() || this.isBottom();
    }

    @Deprecated
    public boolean isNull() {
        return false;
    }

    public boolean isConstantNull() {
        return this.isNull();
    }

    public boolean isDefinitelyNull() {
        return this.nullElement().isDefinitelyNull();
    }

    public int requiredRegisters() {
        assert (!this.isBottom() && !this.isTop());
        return this.isWide() ? 2 : 1;
    }

    static TypeLatticeElement objectClassType(AppInfo appInfo, boolean isNullable) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.objectType, isNullable, appInfo);
    }

    static TypeLatticeElement objectArrayType(AppInfo appInfo, int nesting, boolean isNullable) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.createArrayType(nesting, appInfo.dexItemFactory.objectType), isNullable, appInfo);
    }

    public static TypeLatticeElement classClassType(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.classType, false, appInfo);
    }

    public static TypeLatticeElement stringClassType(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.stringType, false, appInfo);
    }

    public static TypeLatticeElement fromDexType(DexType type, boolean isNullable, AppInfo appInfo) {
        if (type == DexItemFactory.nullValueType) {
            return NULL;
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.fromDexType(type);
        }
        return appInfo.dexItemFactory.createReferenceTypeLatticeElement(type, isNullable, appInfo);
    }

    public static TypeLatticeElement fromNumericType(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Unexpected numeric type: " + (Object)((Object)type));
    }

    public boolean isValueTypeCompatible(TypeLatticeElement other) {
        return this.isReference() && other.isReference() || this.isSingle() && other.isSingle() || this.isWide() && other.isWide();
    }

    public static TypeLatticeElement newArray(DexType arrayType, boolean isNullable) {
        return new ArrayTypeLatticeElement(arrayType, isNullable);
    }

    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return BOTTOM;
    }

    public TypeLatticeElement checkCast(AppInfo appInfo, DexType castType) {
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(castType, this.isNullable(), appInfo);
        if (this.lessThanOrEqual(castTypeLattice, appInfo)) {
            return this;
        }
        return castTypeLattice;
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static class InterfaceWithMarker {
        final DexType itf;
        final InterfaceMarker marker;

        InterfaceWithMarker(DexType itf, InterfaceMarker marker) {
            this.itf = itf;
            this.marker = marker;
        }
    }

    private static enum InterfaceMarker {
        LEFT,
        RIGHT;

    }
}

