/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunctionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmLambdaVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.kotlin.NonNullParameterHintCollector;

public final class KotlinSyntheticClass
extends KotlinInfo<KotlinClassMetadata.SyntheticClass> {
    private final Flavour flavour;

    static KotlinSyntheticClass fromKotlinClassMetadata(KotlinClassMetadata kotlinClassMetadata, Kotlin kotlin, DexClass clazz) {
        assert (kotlinClassMetadata instanceof KotlinClassMetadata.SyntheticClass);
        KotlinClassMetadata.SyntheticClass syntheticClass = (KotlinClassMetadata.SyntheticClass)kotlinClassMetadata;
        if (KotlinSyntheticClass.isKotlinStyleLambda(syntheticClass, kotlin, clazz)) {
            return new KotlinSyntheticClass(Flavour.KotlinStyleLambda, syntheticClass);
        }
        if (KotlinSyntheticClass.isJavaStyleLambda(syntheticClass, kotlin, clazz)) {
            return new KotlinSyntheticClass(Flavour.JavaStyleLambda, syntheticClass);
        }
        return new KotlinSyntheticClass(Flavour.Unclassified, syntheticClass);
    }

    private KotlinSyntheticClass(Flavour flavour, KotlinClassMetadata.SyntheticClass metadata) {
        super(metadata);
        this.flavour = flavour;
    }

    @Override
    void processMetadata(KotlinClassMetadata.SyntheticClass metadata) {
        if (metadata.isLambda()) {
            metadata.accept(new LambdaVisitorForNonNullParameterHints());
        }
    }

    public boolean isLambda() {
        return this.isKotlinStyleLambda() || this.isJavaStyleLambda();
    }

    public boolean isKotlinStyleLambda() {
        return this.flavour == Flavour.KotlinStyleLambda;
    }

    public boolean isJavaStyleLambda() {
        return this.flavour == Flavour.JavaStyleLambda;
    }

    @Override
    public final KotlinInfo.Kind getKind() {
        return KotlinInfo.Kind.Synthetic;
    }

    @Override
    public final boolean isSyntheticClass() {
        return true;
    }

    @Override
    public KotlinSyntheticClass asSyntheticClass() {
        return this;
    }

    private static boolean isKotlinStyleLambda(KotlinClassMetadata.SyntheticClass metadata, Kotlin kotlin, DexClass clazz) {
        return metadata.isLambda() && clazz.superType == kotlin.functional.lambdaType;
    }

    private static boolean isJavaStyleLambda(KotlinClassMetadata.SyntheticClass metadata, Kotlin kotlin, DexClass clazz) {
        return metadata.isLambda() && clazz.superType == kotlin.factory.objectType && clazz.interfaces.size() == 1;
    }

    private class LambdaVisitorForNonNullParameterHints
    extends KmLambdaVisitor {
        private LambdaVisitorForNonNullParameterHints() {
        }

        @Override
        public KmFunctionVisitor visitFunction(int functionFlags, String functionName) {
            return new NonNullParameterHintCollector.FunctionVisitor(KotlinSyntheticClass.this.nonNullparamHints);
        }
    }

    public static enum Flavour {
        KotlinStyleLambda,
        JavaStyleLambda,
        Unclassified;

    }
}

