/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfNeg
extends CfInstruction {
    private final NumericType type;

    public CfNeg(NumericType type) {
        this.type = type;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitInsn(this.getAsmOpcode());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public int getAsmOpcode() {
        switch (this.type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return 116;
            }
            case LONG: {
                return 117;
            }
            case FLOAT: {
                return 118;
            }
            case DOUBLE: {
                return 119;
            }
        }
        throw new Unreachable("Invalid type for CfNeg " + (Object)((Object)this.type));
    }

    public static CfNeg fromAsm(int opcode) {
        switch (opcode) {
            case 116: {
                return new CfNeg(NumericType.INT);
            }
            case 117: {
                return new CfNeg(NumericType.LONG);
            }
            case 118: {
                return new CfNeg(NumericType.FLOAT);
            }
            case 119: {
                return new CfNeg(NumericType.DOUBLE);
            }
        }
        throw new Unreachable("Invalid opcode for CfNeg " + opcode);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int value = state.pop().register;
        builder.addNeg(this.type, state.push((ValueType)ValueType.fromNumericType((NumericType)this.type)).register, value);
    }
}

