/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.DexOutputBuffer;
import com.android.tools.r8.dex.FileWriter;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import com.android.tools.r8.org.objectweb.asm.Handle;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.utils.EncodedValueUtils;
import java.util.Arrays;

public abstract class DexValue
extends DexItem {
    public static final UnknownDexValue UNKNOWN = UnknownDexValue.UNKNOWN;
    public static final byte VALUE_BYTE = 0;
    public static final byte VALUE_SHORT = 2;
    public static final byte VALUE_CHAR = 3;
    public static final byte VALUE_INT = 4;
    public static final byte VALUE_LONG = 6;
    public static final byte VALUE_FLOAT = 16;
    public static final byte VALUE_DOUBLE = 17;
    public static final byte VALUE_METHOD_TYPE = 21;
    public static final byte VALUE_METHOD_HANDLE = 22;
    public static final byte VALUE_STRING = 23;
    public static final byte VALUE_TYPE = 24;
    public static final byte VALUE_FIELD = 25;
    public static final byte VALUE_METHOD = 26;
    public static final byte VALUE_ENUM = 27;
    public static final byte VALUE_ARRAY = 28;
    public static final byte VALUE_ANNOTATION = 29;
    public static final byte VALUE_NULL = 30;
    public static final byte VALUE_BOOLEAN = 31;

    public static DexValue fromAsmBootstrapArgument(Object value, JarApplicationReader application, DexType clazz) {
        if (value instanceof Integer) {
            return DexValueInt.create((Integer)value);
        }
        if (value instanceof Long) {
            return DexValueLong.create((Long)value);
        }
        if (value instanceof Float) {
            return DexValueFloat.create(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DexValueDouble.create((Double)value);
        }
        if (value instanceof String) {
            return new DexValueString(application.getString((String)value));
        }
        if (value instanceof Type) {
            Type type = (Type)value;
            switch (type.getSort()) {
                case 10: {
                    return new DexValueType(application.getTypeFromDescriptor(((Type)value).getDescriptor()));
                }
                case 11: {
                    return new DexValueMethodType(application.getProto(((Type)value).getDescriptor()));
                }
            }
            throw new Unreachable("Type sort is not supported: " + type.getSort());
        }
        if (value instanceof Handle) {
            return new DexValueMethodHandle(DexMethodHandle.fromAsmHandle((Handle)value, application, clazz));
        }
        throw new Unreachable("Unsupported bootstrap static argument of type " + value.getClass().getSimpleName());
    }

    private static void writeHeader(byte type, int arg, DexOutputBuffer dest) {
        dest.putByte((byte)(arg << 5 | type));
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        throw new Unreachable();
    }

    public abstract void sort();

    public abstract void writeTo(DexOutputBuffer var1, ObjectToOffsetMapping var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static DexValue defaultForType(DexType type) {
        switch (type.toShorty()) {
            case 'Z': {
                return DexValueBoolean.DEFAULT;
            }
            case 'B': {
                return DexValueByte.DEFAULT;
            }
            case 'C': {
                return DexValueChar.DEFAULT;
            }
            case 'S': {
                return DexValueShort.DEFAULT;
            }
            case 'I': {
                return DexValueInt.DEFAULT;
            }
            case 'J': {
                return DexValueLong.DEFAULT;
            }
            case 'F': {
                return DexValueFloat.DEFAULT;
            }
            case 'D': {
                return DexValueDouble.DEFAULT;
            }
            case 'L': {
                return DexValueNull.NULL;
            }
        }
        throw new Unreachable("No default value for unexpected type " + type);
    }

    public abstract Object getBoxedValue();

    public Instruction asConstInstruction(boolean hasClassInitializer, Value dest) {
        return null;
    }

    public boolean isDefault(DexType type) {
        return this == DexValue.defaultForType(type);
    }

    public boolean mayTriggerAllocation() {
        return true;
    }

    public abstract Object asAsmEncodedObject();

    public static class DexValueMethodHandle
    extends NestedDexValue<DexMethodHandle> {
        public DexValueMethodHandle(DexMethodHandle value) {
            super(value, null);
        }

        @Override
        protected byte getValueKind() {
            return 22;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            ((DexMethodHandle)this.value).collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    public static class DexValueBoolean
    extends SimpleDexValue {
        private static final DexValueBoolean TRUE = new DexValueBoolean(true);
        private static final DexValueBoolean FALSE = new DexValueBoolean(false);
        private static final DexValueBoolean DEFAULT = new DexValueBoolean(false);
        final boolean value;

        private DexValueBoolean(boolean value) {
            this.value = value;
        }

        public static DexValueBoolean create(boolean value) {
            return value ? TRUE : FALSE;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader((byte)31, this.value ? 1 : 0, dest);
        }

        @Override
        public Object asAsmEncodedObject() {
            return this.value ? 1 : 0;
        }

        @Override
        public int hashCode() {
            return this.value ? 1234 : 4321;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueBoolean && ((DexValueBoolean)other).value == this.value;
        }

        @Override
        public String toString() {
            return this.value ? "True" : "False";
        }

        @Override
        public Instruction asConstInstruction(boolean hasClassInitializer, Value dest) {
            return this == DEFAULT && hasClassInitializer ? null : new ConstNumber(dest, this.value ? 1L : 0L);
        }
    }

    public static class DexValueNull
    extends SimpleDexValue {
        public static final DexValue NULL = new DexValueNull();

        private DexValueNull() {
        }

        public Object getValue() {
            return null;
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader((byte)30, 0, dest);
        }

        @Override
        public Object getBoxedValue() {
            return null;
        }

        @Override
        public Object asAsmEncodedObject() {
            return null;
        }

        @Override
        public int hashCode() {
            return 42;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueNull;
        }

        @Override
        public String toString() {
            return "Null";
        }
    }

    public static class DexValueAnnotation
    extends DexValue {
        public final DexEncodedAnnotation value;

        public DexValueAnnotation(DexEncodedAnnotation value) {
            this.value = value;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            this.value.collectIndexedItems(indexedItems, method, instructionOffset);
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader((byte)29, 0, dest);
            FileWriter.writeEncodedAnnotation(this.value, dest, mapping);
        }

        @Override
        public Object getBoxedValue() {
            throw new Unreachable("No boxed value for DexValueAnnotation");
        }

        @Override
        public Object asAsmEncodedObject() {
            throw new Unreachable("No ASM conversion for DexValueAnnotation");
        }

        @Override
        public void sort() {
            this.value.sort();
        }

        @Override
        public int hashCode() {
            return this.value.hashCode() * 7;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof DexValueAnnotation) {
                DexValueAnnotation that = (DexValueAnnotation)other;
                return that.value.equals(this.value);
            }
            return false;
        }

        @Override
        public String toString() {
            return "Annotation " + this.value;
        }
    }

    public static class DexValueArray
    extends DexValue {
        final DexValue[] values;

        public DexValueArray(DexValue[] values2) {
            this.values = values2;
        }

        public DexValue[] getValues() {
            return this.values;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            DexValueArray.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.values);
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader((byte)28, 0, dest);
            dest.putUleb128(this.values.length);
            for (DexValue value : this.values) {
                value.writeTo(dest, mapping);
            }
        }

        @Override
        public Object getBoxedValue() {
            throw new Unreachable("No boxed value for DexValueArray");
        }

        @Override
        public Object asAsmEncodedObject() {
            throw new Unreachable("No ASM conversion for DexValueArray");
        }

        @Override
        public void sort() {
            for (DexValue value : this.values) {
                value.sort();
            }
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.values);
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof DexValueArray) {
                DexValueArray that = (DexValueArray)other;
                return Arrays.equals(that.values, this.values);
            }
            return false;
        }

        @Override
        public String toString() {
            return "Array " + Arrays.toString(this.values);
        }
    }

    public static class DexValueMethodType
    extends NestedDexValue<DexProto> {
        public DexValueMethodType(DexProto value) {
            super(value, null);
        }

        @Override
        protected byte getValueKind() {
            return 21;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            ((DexProto)this.value).collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    public static class DexValueEnum
    extends NestedDexValue<DexField> {
        public DexValueEnum(DexField value) {
            super(value, null);
        }

        @Override
        protected byte getValueKind() {
            return 27;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            ((DexField)this.value).collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    public static class DexValueMethod
    extends NestedDexValue<DexMethod> {
        public DexValueMethod(DexMethod value) {
            super(value, null);
        }

        @Override
        protected byte getValueKind() {
            return 26;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            ((DexMethod)this.value).collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    public static class DexValueField
    extends NestedDexValue<DexField> {
        public DexValueField(DexField value) {
            super(value, null);
        }

        @Override
        protected byte getValueKind() {
            return 25;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            ((DexField)this.value).collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    public static class DexValueType
    extends NestedDexValue<DexType> {
        public DexValueType(DexType value) {
            super(value, null);
        }

        @Override
        protected byte getValueKind() {
            return 24;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            ((DexType)this.value).collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    public static class DexItemBasedValueString
    extends NestedDexValue<DexReference> {
        private final ReflectionOptimizer.ClassNameComputationInfo classNameComputationInfo;

        public DexItemBasedValueString(DexReference value) {
            this(value, ReflectionOptimizer.ClassNameComputationInfo.none());
        }

        public DexItemBasedValueString(DexReference value, ReflectionOptimizer.ClassNameComputationInfo classNameComputationInfo) {
            super(value, null);
            this.classNameComputationInfo = classNameComputationInfo;
        }

        public ReflectionOptimizer.ClassNameComputationInfo getClassNameComputationInfo() {
            return this.classNameComputationInfo;
        }

        @Override
        public Object asAsmEncodedObject() {
            return ((DexReference)this.value).toString();
        }

        @Override
        protected byte getValueKind() {
            return 23;
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            throw new Unreachable("DexItemBasedValueString values should always be rewritten into DexValueString");
        }
    }

    public static class DexValueString
    extends NestedDexValue<DexString> {
        public DexValueString(DexString value) {
            super(value, null);
        }

        @Override
        public Object asAsmEncodedObject() {
            return ((DexString)this.value).toString();
        }

        @Override
        protected byte getValueKind() {
            return 23;
        }
    }

    private static abstract class NestedDexValue<T extends IndexedDexItem>
    extends DexValue {
        public final T value;

        private NestedDexValue(T value) {
            this.value = value;
        }

        protected abstract byte getValueKind();

        public T getValue() {
            return this.value;
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            int offset = ((IndexedDexItem)this.value).getOffset(mapping);
            dest.forward(1);
            int length = dest.putUnsignedEncodedValue(offset, 4);
            dest.rewind(length + 1);
            DexValue.writeHeader(this.getValueKind(), length - 1, dest);
            dest.forward(length);
        }

        @Override
        public Object getBoxedValue() {
            throw new Unreachable("No boxed value for DexValue " + this.getClass().getSimpleName());
        }

        @Override
        public Object asAsmEncodedObject() {
            throw new Unreachable("No ASM conversion for DexValue " + this.getClass().getSimpleName());
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            ((IndexedDexItem)this.value).collectIndexedItems(indexedItems, method, instructionOffset);
        }

        @Override
        public void sort() {
        }

        @Override
        public int hashCode() {
            return ((CachedHashValueDexItem)this.value).hashCode() * 7 + this.getValueKind();
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof NestedDexValue) {
                NestedDexValue that = (NestedDexValue)other;
                return that.getValueKind() == this.getValueKind() && ((CachedHashValueDexItem)that.value).equals(this.value);
            }
            return false;
        }

        @Override
        public String toString() {
            return "Item " + this.getValueKind() + " " + this.value;
        }

        /* synthetic */ NestedDexValue(IndexedDexItem x0, 1 x1) {
            this(x0);
        }
    }

    public static class DexValueDouble
    extends SimpleDexValue {
        public static final DexValueDouble DEFAULT = new DexValueDouble(0.0);
        final double value;

        private DexValueDouble(double value) {
            this.value = value;
        }

        public static DexValueDouble create(double value) {
            return Double.compare(value, DexValueDouble.DEFAULT.value) == 0 ? DEFAULT : new DexValueDouble(value);
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            dest.forward(1);
            int length = EncodedValueUtils.putDouble(dest, this.value);
            dest.rewind(length + 1);
            DexValue.writeHeader((byte)17, length - 1, dest);
            dest.forward(length);
        }

        @Override
        public Object asAsmEncodedObject() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return (int)(this.value * 29.0);
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueDouble && Double.compare(this.value, ((DexValueDouble)other).value) == 0;
        }

        @Override
        public String toString() {
            return "Double " + this.value;
        }
    }

    public static class DexValueFloat
    extends SimpleDexValue {
        public static final DexValueFloat DEFAULT = new DexValueFloat(0.0f);
        final float value;

        private DexValueFloat(float value) {
            this.value = value;
        }

        public static DexValueFloat create(float value) {
            return Float.compare(value, DexValueFloat.DEFAULT.value) == 0 ? DEFAULT : new DexValueFloat(value);
        }

        public float getValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return Float.valueOf(this.getValue());
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            dest.forward(1);
            int length = EncodedValueUtils.putFloat(dest, this.value);
            dest.rewind(length + 1);
            DexValue.writeHeader((byte)16, length - 1, dest);
            dest.forward(length);
        }

        @Override
        public Object asAsmEncodedObject() {
            return Float.valueOf(this.value);
        }

        @Override
        public int hashCode() {
            return (int)(this.value * 19.0f);
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueFloat && Float.compare(this.value, ((DexValueFloat)other).value) == 0;
        }

        @Override
        public String toString() {
            return "Float " + this.value;
        }
    }

    public static class DexValueLong
    extends SimpleDexValue {
        public static final DexValueLong DEFAULT = new DexValueLong(0L);
        final long value;

        private DexValueLong(long value) {
            this.value = value;
        }

        public static DexValueLong create(long value) {
            return value == DexValueLong.DEFAULT.value ? DEFAULT : new DexValueLong(value);
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValueLong.writeIntegerTo((byte)6, this.value, 8, dest);
        }

        @Override
        public Object asAsmEncodedObject() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return (int)this.value * 13;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueLong && this.value == ((DexValueLong)other).value;
        }

        @Override
        public String toString() {
            return "Long " + this.value;
        }

        @Override
        public Instruction asConstInstruction(boolean hasClassInitializer, Value dest) {
            return this == DEFAULT && hasClassInitializer ? null : new ConstNumber(dest, this.value);
        }
    }

    public static class DexValueInt
    extends SimpleDexValue {
        public static final DexValueInt DEFAULT = new DexValueInt(0);
        public final int value;

        private DexValueInt(int value) {
            this.value = value;
        }

        public static DexValueInt create(int value) {
            return value == DexValueInt.DEFAULT.value ? DEFAULT : new DexValueInt(value);
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValueInt.writeIntegerTo((byte)4, this.value, 4, dest);
        }

        @Override
        public Object asAsmEncodedObject() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.value * 11;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueInt && this.value == ((DexValueInt)other).value;
        }

        @Override
        public String toString() {
            return "Int " + this.value;
        }

        @Override
        public Instruction asConstInstruction(boolean hasClassInitializer, Value dest) {
            return this == DEFAULT && hasClassInitializer ? null : new ConstNumber(dest, this.value);
        }
    }

    public static class DexValueChar
    extends SimpleDexValue {
        public static final DexValueChar DEFAULT = new DexValueChar('\u0000');
        final char value;

        private DexValueChar(char value) {
            this.value = value;
        }

        public static DexValueChar create(char value) {
            return value == DexValueChar.DEFAULT.value ? DEFAULT : new DexValueChar(value);
        }

        public char getValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return Character.valueOf(this.getValue());
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            dest.forward(1);
            int length = dest.putUnsignedEncodedValue(this.value, 2);
            dest.rewind(length + 1);
            DexValue.writeHeader((byte)3, length - 1, dest);
            dest.forward(length);
        }

        @Override
        public Object asAsmEncodedObject() {
            return (int)this.value;
        }

        @Override
        public int hashCode() {
            return this.value * 5;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueChar && this.value == ((DexValueChar)other).value;
        }

        @Override
        public String toString() {
            return "Char " + this.value;
        }

        @Override
        public Instruction asConstInstruction(boolean hasClassInitializer, Value dest) {
            return this == DEFAULT && hasClassInitializer ? null : new ConstNumber(dest, this.value);
        }
    }

    public static class DexValueShort
    extends SimpleDexValue {
        public static final DexValueShort DEFAULT = new DexValueShort(0);
        final short value;

        private DexValueShort(short value) {
            this.value = value;
        }

        public static DexValueShort create(short value) {
            return value == DexValueShort.DEFAULT.value ? DEFAULT : new DexValueShort(value);
        }

        public short getValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValueShort.writeIntegerTo((byte)2, this.value, 2, dest);
        }

        @Override
        public Object asAsmEncodedObject() {
            return (int)this.value;
        }

        @Override
        public int hashCode() {
            return this.value * 7;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueShort && this.value == ((DexValueShort)other).value;
        }

        @Override
        public String toString() {
            return "Short " + this.value;
        }

        @Override
        public Instruction asConstInstruction(boolean hasClassInitializer, Value dest) {
            return this == DEFAULT && hasClassInitializer ? null : new ConstNumber(dest, this.value);
        }
    }

    public static class DexValueByte
    extends SimpleDexValue {
        public static final DexValueByte DEFAULT = new DexValueByte(0);
        final byte value;

        private DexValueByte(byte value) {
            this.value = value;
        }

        public static DexValueByte create(byte value) {
            return value == DexValueByte.DEFAULT.value ? DEFAULT : new DexValueByte(value);
        }

        public byte getValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader((byte)0, 0, dest);
            dest.putSignedEncodedValue(this.value, 1);
        }

        @Override
        public Object asAsmEncodedObject() {
            return (int)this.value;
        }

        @Override
        public int hashCode() {
            return this.value * 3;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueByte && this.value == ((DexValueByte)other).value;
        }

        @Override
        public String toString() {
            return "Byte " + this.value;
        }

        @Override
        public Instruction asConstInstruction(boolean hasClassInitializer, Value dest) {
            return this == DEFAULT && hasClassInitializer ? null : new ConstNumber(dest, this.value);
        }
    }

    private static abstract class SimpleDexValue
    extends DexValue {
        private SimpleDexValue() {
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        }

        @Override
        public void sort() {
        }

        @Override
        public boolean mayTriggerAllocation() {
            return false;
        }

        protected static void writeIntegerTo(byte type, long value, int expected, DexOutputBuffer dest) {
            dest.forward(1);
            int length = dest.putSignedEncodedValue(value, expected);
            dest.rewind(length + 1);
            DexValue.writeHeader(type, length - 1, dest);
            dest.forward(length);
        }
    }

    public static class UnknownDexValue
    extends DexValue {
        public static final UnknownDexValue UNKNOWN = new UnknownDexValue();

        private UnknownDexValue() {
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            throw new Unreachable();
        }

        @Override
        public void sort() {
            throw new Unreachable();
        }

        @Override
        public boolean mayTriggerAllocation() {
            return true;
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            throw new Unreachable();
        }

        @Override
        public Object getBoxedValue() {
            throw new Unreachable();
        }

        @Override
        public Object asAsmEncodedObject() {
            throw new Unreachable();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        @Override
        public String toString() {
            return "UNKNOWN";
        }

        @Override
        public Instruction asConstInstruction(boolean hasClassInitializer, Value dest) {
            return null;
        }
    }
}

