/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class GraphLense {
    private static IntList emptyIntList = new IntArrayList();

    public static Builder builder() {
        return new Builder();
    }

    public abstract DexField getOriginalFieldSignature(DexField var1);

    public abstract DexMethod getOriginalMethodSignature(DexMethod var1);

    public abstract DexField getRenamedFieldSignature(DexField var1);

    public abstract DexMethod getRenamedMethodSignature(DexMethod var1);

    public DexEncodedMethod mapDexEncodedMethod(AppInfo appInfo, DexEncodedMethod originalEncodedMethod) {
        DexMethod newMethod = this.getRenamedMethodSignature(originalEncodedMethod.method);
        if (newMethod != originalEncodedMethod.method) {
            DexClass newHolder = appInfo.definitionFor(newMethod.holder);
            assert (newHolder != null);
            DexEncodedMethod newEncodedMethod = newHolder.lookupMethod(newMethod);
            assert (newEncodedMethod != null);
            return newEncodedMethod;
        }
        return originalEncodedMethod;
    }

    public abstract DexType lookupType(DexType var1);

    public DexMethod lookupMethod(DexMethod method) {
        assert (this.isContextFreeForMethod(method));
        return this.lookupMethod(method, null, null).getMethod();
    }

    public abstract GraphLenseLookupResult lookupMethod(DexMethod var1, DexEncodedMethod var2, Invoke.Type var3);

    public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
        assert (this.isContextFreeForMethod(method));
        DexMethod result = this.lookupMethod(method);
        if (result != null) {
            return ImmutableSet.of(result);
        }
        return ImmutableSet.of();
    }

    public abstract DexField lookupField(DexField var1);

    public DexReference lookupReference(DexReference reference) {
        if (reference.isDexType()) {
            return this.lookupType(reference.asDexType());
        }
        if (reference.isDexMethod()) {
            return this.lookupMethod(reference.asDexMethod());
        }
        assert (reference.isDexField());
        return this.lookupField(reference.asDexField());
    }

    public abstract boolean isContextFreeForMethods();

    public boolean isContextFreeForMethod(DexMethod method) {
        return this.isContextFreeForMethods();
    }

    public static GraphLense getIdentityLense() {
        return new IdentityGraphLense();
    }

    public static IntList emptyRemovedArguments() {
        return emptyIntList;
    }

    public final boolean isIdentityLense() {
        return this instanceof IdentityGraphLense;
    }

    public <T extends DexDefinition> boolean assertDefinitionNotModified(Iterable<T> items) {
        for (DexDefinition item : items) {
            boolean isBridge;
            DexReference dexReference = item.toReference();
            DexReference lookupedReference = this.lookupReference(dexReference);
            boolean bl = isBridge = item.isDexEncodedMethod() && item.asDexEncodedMethod().accessFlags.isBridge();
            assert (isBridge || dexReference == lookupedReference);
        }
        return true;
    }

    public ImmutableSet<DexReference> rewriteReferencesConservatively(Set<DexReference> original) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexReference item : original) {
            if (item.isDexMethod()) {
                DexMethod method = item.asDexMethod();
                if (this.isContextFreeForMethod(method)) {
                    builder.add(this.lookupMethod(method));
                    continue;
                }
                builder.addAll(this.lookupMethodInAllContexts(method));
                continue;
            }
            builder.add(this.lookupReference(item));
        }
        return builder.build();
    }

    public Object2BooleanMap<DexReference> rewriteReferencesConservatively(Object2BooleanMap<DexReference> original) {
        Object2BooleanArrayMap<DexReference> result = new Object2BooleanArrayMap<DexReference>();
        for (Object2BooleanMap.Entry entry : original.object2BooleanEntrySet()) {
            DexReference item = (DexReference)entry.getKey();
            if (item.isDexMethod()) {
                DexMethod method = item.asDexMethod();
                if (this.isContextFreeForMethod(method)) {
                    result.put((DexReference)this.lookupMethod(method), entry.getBooleanValue());
                    continue;
                }
                for (DexMethod candidate : this.lookupMethodInAllContexts(method)) {
                    result.put((DexReference)candidate, entry.getBooleanValue());
                }
                continue;
            }
            result.put(this.lookupReference(item), entry.getBooleanValue());
        }
        return result;
    }

    public ImmutableSortedSet<DexMethod> rewriteMethodsWithRenamedSignature(Set<DexMethod> methods) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
        for (DexMethod method : methods) {
            builder.add(this.getRenamedMethodSignature(method));
        }
        return builder.build();
    }

    public ImmutableSortedSet<DexMethod> rewriteMethodsConservatively(Set<DexMethod> original) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
        if (this.isContextFreeForMethods()) {
            for (DexMethod item : original) {
                builder.add(this.lookupMethod(item));
            }
        } else {
            for (DexMethod item : original) {
                if (this.isContextFreeForMethod(item)) {
                    builder.add(this.lookupMethod(item));
                    continue;
                }
                builder.addAll(this.lookupMethodInAllContexts(item));
            }
        }
        return builder.build();
    }

    public static class NestedGraphLense
    extends GraphLense {
        protected final GraphLense previousLense;
        protected final DexItemFactory dexItemFactory;
        protected final Map<DexType, DexType> typeMap;
        private final Map<DexType, DexType> arrayTypeCache = new IdentityHashMap<DexType, DexType>();
        protected final Map<DexMethod, DexMethod> methodMap;
        protected final Map<DexField, DexField> fieldMap;
        private final BiMap<DexField, DexField> originalFieldSignatures;
        private final BiMap<DexMethod, DexMethod> originalMethodSignatures;

        public NestedGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, GraphLense previousLense, DexItemFactory dexItemFactory) {
            this.typeMap = typeMap.isEmpty() ? null : typeMap;
            this.methodMap = methodMap;
            this.fieldMap = fieldMap;
            this.originalFieldSignatures = originalFieldSignatures;
            this.originalMethodSignatures = originalMethodSignatures;
            this.previousLense = previousLense;
            this.dexItemFactory = dexItemFactory;
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            DexField originalField = this.originalFieldSignatures != null ? this.originalFieldSignatures.getOrDefault(field, field) : field;
            return this.previousLense.getOriginalFieldSignature(originalField);
        }

        @Override
        public DexMethod getOriginalMethodSignature(DexMethod method) {
            DexMethod originalMethod = this.originalMethodSignatures != null ? this.originalMethodSignatures.getOrDefault(method, method) : method;
            return this.previousLense.getOriginalMethodSignature(originalMethod);
        }

        @Override
        public DexField getRenamedFieldSignature(DexField originalField) {
            DexField renamedField = this.previousLense.getRenamedFieldSignature(originalField);
            return this.originalFieldSignatures != null ? this.originalFieldSignatures.inverse().getOrDefault(renamedField, renamedField) : renamedField;
        }

        @Override
        public DexMethod getRenamedMethodSignature(DexMethod originalMethod) {
            DexMethod renamedMethod = this.previousLense.getRenamedMethodSignature(originalMethod);
            return this.originalMethodSignatures != null ? this.originalMethodSignatures.inverse().getOrDefault(renamedMethod, renamedMethod) : renamedMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DexType lookupType(DexType type) {
            if (type.isArrayType()) {
                NestedGraphLense nestedGraphLense = this;
                synchronized (nestedGraphLense) {
                    DexType result = this.arrayTypeCache.get(type);
                    if (result == null) {
                        DexType newType;
                        DexType baseType = type.toBaseType(this.dexItemFactory);
                        result = baseType == (newType = this.lookupType(baseType)) ? type : type.replaceBaseType(newType, this.dexItemFactory);
                        this.arrayTypeCache.put(type, result);
                    }
                    return result;
                }
            }
            DexType previous = this.previousLense.lookupType(type);
            return this.typeMap != null ? this.typeMap.getOrDefault(previous, previous) : previous;
        }

        @Override
        public GraphLenseLookupResult lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
            GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, context, type);
            DexMethod newMethod = this.methodMap.get(previous.getMethod());
            if (newMethod == null) {
                return previous;
            }
            return new GraphLenseLookupResult(newMethod, this.mapInvocationType(newMethod, method, context, previous.getType()));
        }

        protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, DexEncodedMethod context, Invoke.Type type) {
            return type;
        }

        protected final Invoke.Type mapVirtualInterfaceInvocationTypes(AppInfo appInfo, DexMethod newMethod, DexMethod originalMethod, DexEncodedMethod context, Invoke.Type type) {
            if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
                DexClass newTargetClass = appInfo.definitionFor(newMethod.holder);
                if (newTargetClass == null) {
                    return type;
                }
                DexClass originalTargetClass = appInfo.definitionFor(originalMethod.holder);
                if (originalTargetClass != null && originalTargetClass.isInterface() ^ type == Invoke.Type.INTERFACE) {
                    return newTargetClass.accessFlags.isInterface() ? Invoke.Type.VIRTUAL : Invoke.Type.INTERFACE;
                }
                return newTargetClass.accessFlags.isInterface() ? Invoke.Type.INTERFACE : Invoke.Type.VIRTUAL;
            }
            return type;
        }

        @Override
        public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
            HashSet<DexMethod> result = new HashSet<DexMethod>();
            for (DexMethod previous : this.previousLense.lookupMethodInAllContexts(method)) {
                result.add(this.methodMap.getOrDefault(previous, previous));
            }
            return result;
        }

        @Override
        public DexField lookupField(DexField field) {
            DexField previous = this.previousLense.lookupField(field);
            return this.fieldMap.getOrDefault(previous, previous);
        }

        @Override
        public boolean isContextFreeForMethods() {
            return this.previousLense.isContextFreeForMethods();
        }

        @Override
        public boolean isContextFreeForMethod(DexMethod method) {
            return this.previousLense.isContextFreeForMethod(method);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<DexType, DexType> entry : this.typeMap.entrySet()) {
                builder.append(entry.getKey().toSourceString()).append(" -> ");
                builder.append(entry.getValue().toSourceString()).append(System.lineSeparator());
            }
            for (Map.Entry<DexReference, DexReference> entry : this.methodMap.entrySet()) {
                builder.append(((DexMethod)entry.getKey()).toSourceString()).append(" -> ");
                builder.append(((DexMethod)entry.getValue()).toSourceString()).append(System.lineSeparator());
            }
            for (Map.Entry<DexReference, DexReference> entry : this.fieldMap.entrySet()) {
                builder.append(((DexField)entry.getKey()).toSourceString()).append(" -> ");
                builder.append(((DexField)entry.getValue()).toSourceString()).append(System.lineSeparator());
            }
            builder.append(this.previousLense.toString());
            return builder.toString();
        }
    }

    private static class IdentityGraphLense
    extends GraphLense {
        private IdentityGraphLense() {
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            return field;
        }

        @Override
        public DexMethod getOriginalMethodSignature(DexMethod method) {
            return method;
        }

        @Override
        public DexField getRenamedFieldSignature(DexField originalField) {
            return originalField;
        }

        @Override
        public DexMethod getRenamedMethodSignature(DexMethod originalMethod) {
            return originalMethod;
        }

        @Override
        public DexType lookupType(DexType type) {
            return type;
        }

        @Override
        public GraphLenseLookupResult lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
            return new GraphLenseLookupResult(method, type);
        }

        @Override
        public DexField lookupField(DexField field) {
            return field;
        }

        @Override
        public boolean isContextFreeForMethods() {
            return true;
        }
    }

    public static class Builder {
        protected final Map<DexType, DexType> typeMap = new IdentityHashMap<DexType, DexType>();
        protected final Map<DexMethod, DexMethod> methodMap = new IdentityHashMap<DexMethod, DexMethod>();
        protected final Map<DexField, DexField> fieldMap = new IdentityHashMap<DexField, DexField>();
        private final BiMap<DexField, DexField> originalFieldSignatures = HashBiMap.create();
        private final BiMap<DexMethod, DexMethod> originalMethodSignatures = HashBiMap.create();

        protected Builder() {
        }

        public void map(DexType from, DexType to) {
            this.typeMap.put(from, to);
        }

        public void map(DexMethod from, DexMethod to) {
            this.methodMap.put(from, to);
        }

        public void map(DexField from, DexField to) {
            this.fieldMap.put(from, to);
        }

        public void move(DexMethod from, DexMethod to) {
            this.map(from, to);
            this.originalMethodSignatures.put(to, from);
        }

        public void move(DexField from, DexField to) {
            this.fieldMap.put(from, to);
            this.originalFieldSignatures.put(to, from);
        }

        public GraphLense build(DexItemFactory dexItemFactory) {
            return this.build(dexItemFactory, new IdentityGraphLense());
        }

        public GraphLense build(DexItemFactory dexItemFactory, GraphLense previousLense) {
            if (this.typeMap.isEmpty() && this.methodMap.isEmpty() && this.fieldMap.isEmpty()) {
                return previousLense;
            }
            return new NestedGraphLense(this.typeMap, this.methodMap, this.fieldMap, this.originalFieldSignatures, this.originalMethodSignatures, previousLense, dexItemFactory);
        }
    }

    public static class GraphLenseLookupResult {
        private final DexMethod method;
        private final Invoke.Type type;
        private final IntList removedArguments;

        public GraphLenseLookupResult(DexMethod method, Invoke.Type type) {
            this.method = method;
            this.type = type;
            this.removedArguments = emptyIntList;
        }

        public GraphLenseLookupResult(DexMethod method, Invoke.Type type, IntList removedArguments) {
            this.method = method;
            this.type = type;
            this.removedArguments = removedArguments;
        }

        public GraphLenseLookupResult withRemovedArguments(IntList removedArguments) {
            assert (removedArguments != null);
            return new GraphLenseLookupResult(this.method, this.type, removedArguments);
        }

        public DexMethod getMethod() {
            return this.method;
        }

        public Invoke.Type getType() {
            return this.type;
        }

        public boolean hasRemovedArguments() {
            return !this.removedArguments.isEmpty();
        }

        public boolean isArgumentRemoved(int i) {
            return this.removedArguments.contains(i);
        }

        public IntList getRemovedArguments() {
            return this.removedArguments;
        }
    }
}

