/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.NumericType;

public abstract class PrimitiveTypeLatticeElement
extends TypeLatticeElement {
    PrimitiveTypeLatticeElement() {
        super(false);
    }

    @Override
    public TypeLatticeElement asNullable() {
        return TypeLatticeElement.TOP;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public PrimitiveTypeLatticeElement asPrimitiveTypeLatticeElement() {
        return this;
    }

    static PrimitiveTypeLatticeElement fromDexType(DexType type, boolean asArrayElementType) {
        assert (type.isPrimitiveType());
        return PrimitiveTypeLatticeElement.fromTypeDescriptorChar((char)type.descriptor.content[0], asArrayElementType);
    }

    DexType toDexType(DexItemFactory factory) {
        if (this.isBoolean()) {
            return factory.booleanType;
        }
        if (this.isByte()) {
            return factory.byteType;
        }
        if (this.isShort()) {
            return factory.shortType;
        }
        if (this.isChar()) {
            return factory.charType;
        }
        if (this.isInt()) {
            return factory.intType;
        }
        if (this.isFloat()) {
            return factory.floatType;
        }
        if (this.isLong()) {
            return factory.longType;
        }
        if (this.isDouble()) {
            return factory.doubleType;
        }
        throw new Unreachable("Imprecise primitive type '" + this.toString() + "'");
    }

    private static PrimitiveTypeLatticeElement fromTypeDescriptorChar(char descriptor, boolean asArrayElementType) {
        switch (descriptor) {
            case 'Z': {
                if (asArrayElementType) {
                    return TypeLatticeElement.BOOLEAN;
                }
            }
            case 'B': {
                if (asArrayElementType) {
                    return TypeLatticeElement.BYTE;
                }
            }
            case 'S': {
                if (asArrayElementType) {
                    return TypeLatticeElement.SHORT;
                }
            }
            case 'C': {
                if (asArrayElementType) {
                    return TypeLatticeElement.CHAR;
                }
            }
            case 'I': {
                return TypeLatticeElement.INT;
            }
            case 'F': {
                return TypeLatticeElement.FLOAT;
            }
            case 'J': {
                return TypeLatticeElement.LONG;
            }
            case 'D': {
                return TypeLatticeElement.DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static PrimitiveTypeLatticeElement fromNumericType(NumericType numericType) {
        switch (numericType) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return TypeLatticeElement.INT;
            }
            case FLOAT: {
                return TypeLatticeElement.FLOAT;
            }
            case LONG: {
                return TypeLatticeElement.LONG;
            }
            case DOUBLE: {
                return TypeLatticeElement.DOUBLE;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)numericType) + "'");
    }

    TypeLatticeElement join(PrimitiveTypeLatticeElement other) {
        if (this == other) {
            return this;
        }
        if (this.isSingle()) {
            if (other.isSingle()) {
                return TypeLatticeElement.SINGLE;
            }
            assert (other.isWide());
            return TypeLatticeElement.TOP;
        }
        assert (this.isWide());
        if (other.isWide()) {
            return TypeLatticeElement.WIDE;
        }
        assert (other.isSingle());
        return TypeLatticeElement.TOP;
    }
}

