/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfSwitch;
import com.android.tools.r8.code.Nop;
import com.android.tools.r8.code.PackedSwitch;
import com.android.tools.r8.code.PackedSwitchPayload;
import com.android.tools.r8.code.SparseSwitch;
import com.android.tools.r8.code.SparseSwitchPayload;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.InternalOutputMode;
import java.util.ArrayList;
import java.util.List;

public class Switch
extends JumpInstruction {
    private final int[] keys;
    private final int[] targetBlockIndices;
    private int fallthroughBlockIndex;

    public Switch(Value value, int[] keys2, int[] targetBlockIndices, int fallthroughBlockIndex) {
        super(null, value);
        this.keys = keys2;
        this.targetBlockIndices = targetBlockIndices;
        this.fallthroughBlockIndex = fallthroughBlockIndex;
        assert (this.valid());
    }

    private boolean valid() {
        assert (this.keys.length <= 65535);
        assert (this.keys.length == this.targetBlockIndices.length);
        for (int i = 1; i < this.keys.length - 1; ++i) {
            assert (this.keys[i - 1] < this.keys[i]);
            assert (this.targetBlockIndices[i] != this.fallthroughBlockIndex);
        }
        assert (this.targetBlockIndices[this.keys.length - 1] != this.fallthroughBlockIndex);
        return true;
    }

    public Value value() {
        return (Value)this.inValues.get(0);
    }

    private static long numberOfTargetsIfPacked(int[] keys2) {
        return (long)keys2[keys2.length - 1] - (long)keys2[0] + 1L;
    }

    public static boolean canBePacked(InternalOutputMode mode, int[] keys2) {
        return Switch.canBePacked(mode, Switch.numberOfTargetsIfPacked(keys2));
    }

    public static boolean canBePacked(InternalOutputMode mode, long numberOfTargets) {
        return numberOfTargets <= (mode.isGeneratingClassFiles() ? 0xFFFFFFFFL : 65535L);
    }

    public static long estimatedSize(InternalOutputMode mode, int[] keys2) {
        long packedPayloadSize;
        long sparseSize = Switch.sparsePayloadSize(mode, keys2) + (long)Switch.baseSparseSize(mode);
        long packedSize = Long.MAX_VALUE;
        if (Switch.canBePacked(mode, keys2) && (packedSize = (packedPayloadSize = Switch.packedPayloadSize(mode, keys2)) + (long)Switch.basePackedSize(mode)) < packedPayloadSize) {
            packedSize = Integer.MAX_VALUE;
        }
        return Math.min(sparseSize, packedSize);
    }

    public static long estimatedSparseSize(InternalOutputMode mode, long keys2) {
        return Switch.sparsePayloadSize(mode, keys2) + (long)Switch.baseSparseSize(mode);
    }

    public static int basePackedSize(InternalOutputMode mode) {
        if (mode.isGeneratingClassFiles()) {
            return 16;
        }
        return 3;
    }

    public static int baseSparseSize(InternalOutputMode mode) {
        if (mode.isGeneratingClassFiles()) {
            return 12;
        }
        return 3;
    }

    public static long packedPayloadSize(InternalOutputMode mode, long numberOfTargets) {
        if (mode.isGeneratingClassFiles()) {
            assert (numberOfTargets <= 0xFFFFFFFFL);
            return numberOfTargets * 4L;
        }
        return numberOfTargets * 2L + 4L;
    }

    public static long packedPayloadSize(InternalOutputMode mode, int[] keys2) {
        assert (Switch.canBePacked(mode, keys2));
        long numberOfTargets = Switch.numberOfTargetsIfPacked(keys2);
        return Switch.packedPayloadSize(mode, numberOfTargets);
    }

    public static long sparsePayloadSize(InternalOutputMode mode, int[] keys2) {
        return Switch.sparsePayloadSize(mode, keys2.length);
    }

    public static long sparsePayloadSize(InternalOutputMode mode, long keys2) {
        if (mode.isGeneratingClassFiles()) {
            return keys2 * 8L;
        }
        return keys2 * 4L + 2L;
    }

    private boolean canBePacked(InternalOutputMode mode) {
        return Switch.canBePacked(mode, this.keys);
    }

    private long packedPayloadSize(InternalOutputMode mode) {
        return Switch.packedPayloadSize(mode, this.keys);
    }

    private long sparsePayloadSize(InternalOutputMode mode) {
        return Switch.sparsePayloadSize(mode, this.keys);
    }

    private boolean emitPacked(InternalOutputMode mode) {
        return this.canBePacked(mode) && this.packedPayloadSize(mode) <= this.sparsePayloadSize(mode);
    }

    public int getFirstKey() {
        return this.keys[0];
    }

    @Override
    public boolean isSwitch() {
        return true;
    }

    @Override
    public Switch asSwitch() {
        return this;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return false;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        if (this.emitPacked(InternalOutputMode.DexIndexed)) {
            builder.addSwitch(this, new PackedSwitch(value));
        } else {
            builder.addSwitch(this, new SparseSwitch(value));
        }
    }

    public int numberOfKeys() {
        return this.keys.length;
    }

    public int getKey(int index) {
        return this.keys[index];
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] targetBlockIndices() {
        return this.targetBlockIndices;
    }

    public Int2ReferenceSortedMap<BasicBlock> getKeyToTargetMap() {
        Int2ReferenceAVLTreeMap<BasicBlock> result = new Int2ReferenceAVLTreeMap<BasicBlock>();
        for (int i = 0; i < this.keys.length; ++i) {
            result.put(this.getKey(i), this.targetBlock(i));
        }
        return result;
    }

    @Override
    public BasicBlock fallthroughBlock() {
        return this.getBlock().getSuccessors().get(this.fallthroughBlockIndex);
    }

    public int getFallthroughBlockIndex() {
        return this.fallthroughBlockIndex;
    }

    public void setFallthroughBlockIndex(int i) {
        this.fallthroughBlockIndex = i;
    }

    public BasicBlock targetBlock(int index) {
        return this.getBlock().getSuccessors().get(this.targetBlockIndices()[index]);
    }

    @Override
    public void setFallthroughBlock(BasicBlock block) {
        this.getBlock().getSuccessors().set(this.fallthroughBlockIndex, block);
    }

    public Nop buildPayload(int[] targets, int fallthroughTarget, InternalOutputMode mode) {
        assert (this.keys.length == targets.length);
        assert (mode.isGeneratingDex());
        if (this.emitPacked(mode)) {
            int targetsCount = (int)Switch.numberOfTargetsIfPacked(this.keys);
            if (targets.length == targetsCount) {
                return new PackedSwitchPayload(this.getFirstKey(), targets);
            }
            int[] packedTargets = new int[targetsCount];
            int originalIndex = 0;
            for (int i = 0; i < targetsCount; ++i) {
                int key = this.getFirstKey() + i;
                if (this.keys[originalIndex] == key) {
                    packedTargets[i] = targets[originalIndex];
                    ++originalIndex;
                    continue;
                }
                packedTargets[i] = fallthroughTarget;
            }
            assert (originalIndex == this.keys.length);
            return new PackedSwitchPayload(this.getFirstKey(), packedTargets);
        }
        assert (this.numberOfKeys() == this.keys.length);
        return new SparseSwitchPayload(this.keys, targets);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString() + "\n");
        for (int i = 0; i < this.numberOfKeys(); ++i) {
            builder.append("          ");
            builder.append(this.getKey(i));
            builder.append(" -> ");
            builder.append(this.targetBlock(i).getNumberAsString());
            builder.append("\n");
        }
        builder.append("          F -> ");
        builder.append(this.fallthroughBlock().getNumber());
        return builder.toString();
    }

    @Override
    public void print(CfgPrinter printer) {
        super.print(printer);
        for (int index : this.targetBlockIndices) {
            BasicBlock target = this.getBlock().getSuccessors().get(index);
            printer.append(" B").append(target.getNumber());
        }
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        CfLabel fallthroughLabel = builder.getLabel(this.fallthroughBlock());
        ArrayList<CfLabel> labels = new ArrayList<CfLabel>(this.numberOfKeys());
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        if (this.emitPacked(InternalOutputMode.ClassFile)) {
            int min = this.keys[0];
            int max = this.keys[this.keys.length - 1];
            int index = 0;
            for (long i = (long)min; i <= (long)max; ++i) {
                if (i == (long)this.keys[index]) {
                    labels.add(builder.getLabel(successors.get(this.targetBlockIndices[index])));
                    ++index;
                    continue;
                }
                labels.add(fallthroughLabel);
            }
            assert (index == this.targetBlockIndices.length);
            builder.add(new CfSwitch(CfSwitch.Kind.TABLE, fallthroughLabel, new int[]{min}, labels));
        } else {
            for (int index : this.targetBlockIndices) {
                labels.add(builder.getLabel(successors.get(index)));
            }
            builder.add(new CfSwitch(CfSwitch.Kind.LOOKUP, fallthroughLabel, this.keys, labels));
        }
    }
}

