/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfSwitch;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.CanonicalPositions;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectSortedMaps;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import com.android.tools.r8.origin.Origin;
import java.util.ArrayList;
import java.util.List;

public class CfSourceCode
implements SourceCode {
    private IRBuilder.BlockInfo currentBlockInfo;
    private boolean hasExitingInstruction = false;
    private CfState state;
    private final CfCode code;
    private final DexEncodedMethod method;
    private final Origin origin;
    private final Reference2IntMap<CfLabel> labelOffsets = new Reference2IntOpenHashMap<CfLabel>();
    private TryHandlerList cachedTryHandlerList;
    private LocalVariableList cachedLocalVariableList;
    private int currentInstructionIndex;
    private boolean inPrelude;
    private Int2ObjectMap<DebugLocalInfo> incomingLocals;
    private Int2ObjectMap<DebugLocalInfo> outgoingLocals;
    private Int2ReferenceMap<CfState.Snapshot> incomingState = new Int2ReferenceOpenHashMap<CfState.Snapshot>();
    private final CanonicalPositions canonicalPositions;

    public CfSourceCode(CfCode code, DexEncodedMethod method, DexMethod originalMethod, Position callerPosition, Origin origin) {
        this.code = code;
        this.method = method;
        this.origin = origin;
        int cfPositionCount = 0;
        for (int i = 0; i < code.getInstructions().size(); ++i) {
            CfInstruction instruction = code.getInstructions().get(i);
            if (instruction instanceof CfLabel) {
                this.labelOffsets.put((CfLabel)instruction, this.instructionOffset(i));
            }
            if (!(instruction instanceof CfPosition)) continue;
            ++cfPositionCount;
        }
        this.state = new CfState(origin);
        this.canonicalPositions = new CanonicalPositions(callerPosition, cfPositionCount, originalMethod);
    }

    @Override
    public int instructionCount() {
        return this.code.getInstructions().size();
    }

    @Override
    public int instructionIndex(int instructionOffset) {
        return instructionOffset;
    }

    @Override
    public int instructionOffset(int instructionIndex) {
        return instructionIndex;
    }

    @Override
    public boolean verifyRegister(int register) {
        return true;
    }

    @Override
    public void setUp() {
    }

    @Override
    public void clear() {
    }

    private boolean canThrowHelper(IRBuilder builder, CfInstruction instruction) {
        if (builder.isGeneratingClassFiles() && instruction.isConstString()) {
            return false;
        }
        return instruction.canThrow();
    }

    @Override
    public int traceInstruction(int instructionIndex, IRBuilder builder) {
        CfInstruction instruction = this.code.getInstructions().get(instructionIndex);
        if (this.canThrowHelper(builder, instruction)) {
            TryHandlerList tryHandlers = this.getTryHandlers(instructionIndex);
            if (!tryHandlers.isEmpty()) {
                builder.ensureBlockWithoutEnqueuing(tryHandlers.startOffset);
                IntOpenHashSet seen = new IntOpenHashSet();
                IntListIterator intListIterator = tryHandlers.offsets.iterator();
                while (intListIterator.hasNext()) {
                    int offset = (Integer)intListIterator.next();
                    if (!seen.add(offset)) continue;
                    builder.ensureExceptionalSuccessorBlock(instructionIndex, offset);
                }
                if (!(instruction instanceof CfThrow)) {
                    builder.ensureNormalSuccessorBlock(instructionIndex, instructionIndex + 1);
                }
                return instructionIndex;
            }
            this.hasExitingInstruction |= instruction instanceof CfThrow;
            return instruction instanceof CfThrow ? instructionIndex : -1;
        }
        if (this.isControlFlow(instruction)) {
            for (int target : this.getTargets(instructionIndex)) {
                builder.ensureNormalSuccessorBlock(instructionIndex, target);
            }
            this.hasExitingInstruction |= instruction.isReturn();
            return instructionIndex;
        }
        return -1;
    }

    private TryHandlerList getTryHandlers(int instructionOffset) {
        if (this.cachedTryHandlerList == null || !this.cachedTryHandlerList.validFor(instructionOffset)) {
            this.cachedTryHandlerList = TryHandlerList.computeTryHandlers(instructionOffset, this.code.getTryCatchRanges(), this.labelOffsets);
        }
        return this.cachedTryHandlerList;
    }

    private LocalVariableList getLocalVariables(int instructionOffset) {
        if (this.cachedLocalVariableList == null || !this.cachedLocalVariableList.validFor(instructionOffset)) {
            this.cachedLocalVariableList = LocalVariableList.compute(instructionOffset, this.code.getLocalVariables(), this.labelOffsets);
        }
        return this.cachedLocalVariableList;
    }

    private int[] getTargets(int instructionIndex) {
        CfInstruction instruction = this.code.getInstructions().get(instructionIndex);
        assert (this.isControlFlow(instruction));
        CfLabel target = instruction.getTarget();
        if (instruction.isReturn() || instruction instanceof CfThrow) {
            assert (target == null);
            return new int[0];
        }
        assert (instruction instanceof CfSwitch || target != null) : "getTargets(): Non-control flow instruction " + instruction.getClass();
        if (instruction instanceof CfSwitch) {
            CfSwitch cfSwitch = (CfSwitch)instruction;
            List<CfLabel> targets = cfSwitch.getSwitchTargets();
            int[] res = new int[targets.size() + 1];
            for (int i = 0; i < targets.size(); ++i) {
                res[i] = this.labelOffsets.getInt(targets.get(i));
            }
            res[targets.size()] = this.labelOffsets.getInt(cfSwitch.getDefaultTarget());
            return res;
        }
        int targetIndex = this.labelOffsets.getInt(target);
        if (instruction instanceof CfGoto) {
            return new int[]{targetIndex};
        }
        assert (instruction.isConditionalJump());
        return new int[]{instructionIndex + 1, targetIndex};
    }

    @Override
    public void buildPrelude(IRBuilder builder) {
        assert (!this.inPrelude);
        this.inPrelude = true;
        this.state.buildPrelude(this.canonicalPositions.getPreamblePosition());
        this.setLocalVariableLists();
        this.buildArgumentInstructions(builder);
        this.recordStateForTarget(0, this.state.getSnapshot());
        this.inPrelude = false;
    }

    private void buildArgumentInstructions(IRBuilder builder) {
        int argumentRegister = 0;
        if (!this.isStatic()) {
            DexType type = this.method.method.holder;
            this.state.write(argumentRegister, type);
            builder.addThisArgument(argumentRegister++);
        }
        for (DexType type : this.method.method.proto.parameters.values) {
            this.state.write(argumentRegister, type);
            if (type.isBooleanType()) {
                builder.addBooleanNonThisArgument(argumentRegister++);
                continue;
            }
            TypeLatticeElement typeLattice = TypeLatticeElement.fromDexType(type, true, builder.getAppInfo());
            builder.addNonThisArgument(argumentRegister, typeLattice);
            argumentRegister += typeLattice.requiredRegisters();
        }
    }

    private boolean isStatic() {
        return this.method.accessFlags.isStatic();
    }

    @Override
    public void buildPostlude(IRBuilder builder) {
    }

    @Override
    public void buildBlockTransfer(IRBuilder builder, int predecessorOffset, int successorOffset, boolean isExceptional) {
        if (predecessorOffset == -1) {
            return;
        }
        this.state.setPosition(this.getCanonicalDebugPositionAtOffset(predecessorOffset));
        Int2ObjectMap<DebugLocalInfo> atSource = this.getLocalVariables((int)predecessorOffset).locals;
        Int2ObjectMap<DebugLocalInfo> atTarget = this.getLocalVariables((int)successorOffset).locals;
        if (!isExceptional) {
            for (Int2ObjectMap.Entry entry : atSource.int2ObjectEntrySet()) {
                if (atTarget.get(entry.getIntKey()) == entry.getValue()) continue;
                builder.addDebugLocalEnd(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            }
        }
        for (Int2ObjectMap.Entry entry : atTarget.int2ObjectEntrySet()) {
            if (atSource.get(entry.getIntKey()) == entry.getValue()) continue;
            builder.addDebugLocalStart(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
        if (!this.hasExitingInstruction && this.code.getInstructions().get(predecessorOffset) instanceof CfGoto) {
            assert (!isExceptional);
            for (Int2ObjectMap.Entry entry : atSource.int2ObjectEntrySet()) {
                if (atTarget.get(entry.getIntKey()) != entry.getValue()) continue;
                builder.addDebugLocalEnd(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            }
        }
    }

    @Override
    public void buildInstruction(IRBuilder builder, int instructionIndex, boolean firstBlockInstruction) {
        boolean hasNextInstructionInCurrentBlock;
        CfInstruction instruction = this.code.getInstructions().get(instructionIndex);
        this.currentInstructionIndex = instructionIndex;
        if (firstBlockInstruction) {
            this.currentBlockInfo = (IRBuilder.BlockInfo)builder.getCFG().get(instructionIndex);
            if (instructionIndex == 0 && this.currentBlockInfo == null) {
                this.currentBlockInfo = (IRBuilder.BlockInfo)builder.getCFG().get(-1);
            }
            this.state.reset((CfState.Snapshot)this.incomingState.get(instructionIndex), instructionIndex == 0);
        }
        assert (this.currentBlockInfo != null);
        this.setLocalVariableLists();
        if (this.canThrowHelper(builder, instruction)) {
            CfState.Snapshot exceptionTransfer = this.state.getSnapshot().exceptionTransfer(builder.getFactory().throwableType);
            IntIterator intIterator = this.currentBlockInfo.exceptionalSuccessors.iterator();
            while (intIterator.hasNext()) {
                int target = (Integer)intIterator.next();
                this.recordStateForTarget(target, exceptionTransfer);
            }
        }
        boolean localsChanged = this.localsChanged();
        boolean bl = hasNextInstructionInCurrentBlock = instructionIndex + 1 != this.instructionCount() && !builder.getCFG().containsKey(instructionIndex + 1);
        if (instruction.isReturn() || instruction instanceof CfThrow) {
            assert (this.currentBlockInfo.normalSuccessors.isEmpty());
            if (this.currentBlockInfo.exceptionalSuccessors.isEmpty()) {
                this.incomingLocals.forEach(builder::addDebugLocalEnd);
            } else if (!this.incomingLocals.isEmpty()) {
                Int2ReferenceOpenHashMap live = new Int2ReferenceOpenHashMap();
                ObjectIterator<Int2ObjectMap.Entry<DebugLocalInfo>> objectIterator = this.currentBlockInfo.exceptionalSuccessors.iterator();
                while (objectIterator.hasNext()) {
                    int n = (Integer)objectIterator.next();
                    live.putAll(this.getLocalVariables((int)n).locals);
                }
                for (Int2ObjectMap.Entry entry : this.incomingLocals.int2ObjectEntrySet()) {
                    if (live.get(entry.getIntKey()) == entry.getValue()) continue;
                    builder.addDebugLocalEnd(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
                }
            }
        } else if (localsChanged && hasNextInstructionInCurrentBlock) {
            this.endLocals(builder);
        }
        this.build(instruction, builder);
        if (!hasNextInstructionInCurrentBlock) {
            CfState.Snapshot stateSnapshot = this.state.getSnapshot();
            if (this.isControlFlow(instruction)) {
                for (ObjectIterator<Int2ObjectMap.Entry<DebugLocalInfo>> target : (ObjectIterator<Int2ObjectMap.Entry<DebugLocalInfo>>)this.getTargets(instructionIndex)) {
                    this.recordStateForTarget((int)target, stateSnapshot);
                }
            } else {
                this.recordStateForTarget(instructionIndex + 1, stateSnapshot);
            }
        } else if (localsChanged) {
            this.startLocals(builder);
        }
    }

    private void build(CfInstruction instruction, IRBuilder builder) {
        instruction.buildIR(builder, this.state, this);
    }

    private void recordStateForTarget(int target, CfState.Snapshot snapshot) {
        CfState.Snapshot existing = (CfState.Snapshot)this.incomingState.get(target);
        CfState.Snapshot merged = CfState.merge(existing, snapshot, this.origin);
        if (merged != existing) {
            this.incomingState.put(target, merged);
        }
    }

    public int getCurrentInstructionIndex() {
        return this.currentInstructionIndex;
    }

    public int getLabelOffset(CfLabel label) {
        assert (this.labelOffsets.containsKey(label));
        return this.labelOffsets.getInt(label);
    }

    public void setStateFromFrame(CfFrame frame) {
        Int2ReferenceSortedMap<CfFrame.FrameType> frameLocals = frame.getLocals();
        DexType[] locals = new DexType[frameLocals.isEmpty() ? 0 : frameLocals.lastIntKey() + 1];
        DexType[] stack = new DexType[frame.getStack().size()];
        for (Int2ReferenceMap.Entry entry : frameLocals.int2ReferenceEntrySet()) {
            locals[entry.getIntKey()] = this.convertUninitialized((CfFrame.FrameType)entry.getValue());
        }
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = this.convertUninitialized(frame.getStack().get(i));
        }
        this.state.setStateFromFrame(locals, stack, this.getCanonicalDebugPositionAtOffset(this.currentInstructionIndex));
    }

    private DexType convertUninitialized(CfFrame.FrameType type) {
        if (type.isInitialized()) {
            return type.getInitializedType();
        }
        if (type.isUninitializedNew()) {
            CfInstruction instruction;
            int insnOffset;
            int labelOffset = this.getLabelOffset(type.getUninitializedLabel());
            for (insnOffset = labelOffset + 1; insnOffset < this.code.getInstructions().size(); ++insnOffset) {
                instruction = this.code.getInstructions().get(insnOffset);
                if (instruction instanceof CfLabel || instruction instanceof CfFrame || instruction instanceof CfPosition) continue;
                assert (instruction instanceof CfNew);
                break;
            }
            instruction = this.code.getInstructions().get(insnOffset);
            assert (instruction instanceof CfNew);
            return ((CfNew)instruction).getType();
        }
        if (type.isUninitializedThis()) {
            return this.method.method.holder;
        }
        assert (type.isTop());
        return null;
    }

    @Override
    public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
    }

    @Override
    public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
    }

    @Override
    public DebugLocalInfo getIncomingLocalAtBlock(int register, int blockOffset) {
        return (DebugLocalInfo)this.getLocalVariables((int)blockOffset).locals.get(register);
    }

    @Override
    public DebugLocalInfo getIncomingLocal(int register) {
        return (DebugLocalInfo)this.incomingLocals.get(register);
    }

    @Override
    public DebugLocalInfo getOutgoingLocal(int register) {
        if (this.inPrelude) {
            return this.getIncomingLocal(register);
        }
        assert (!this.isControlFlow(this.code.getInstructions().get(this.currentInstructionIndex))) : "Outgoing local is undefined for control-flow instructions";
        return (DebugLocalInfo)this.outgoingLocals.get(register);
    }

    private void setLocalVariableLists() {
        this.incomingLocals = this.getLocalVariables((int)this.currentInstructionIndex).locals;
        if (this.inPrelude) {
            this.outgoingLocals = this.incomingLocals;
            return;
        }
        CfInstruction currentInstruction = this.code.getInstructions().get(this.currentInstructionIndex);
        this.outgoingLocals = !this.isControlFlow(currentInstruction) ? this.getLocalVariables((int)(this.currentInstructionIndex + 1)).locals : Int2ObjectSortedMaps.emptyMap();
    }

    private boolean localsChanged() {
        return !this.incomingLocals.equals(this.outgoingLocals);
    }

    private void endLocals(IRBuilder builder) {
        assert (this.localsChanged());
        for (Int2ObjectMap.Entry entry : this.incomingLocals.int2ObjectEntrySet()) {
            if (((DebugLocalInfo)entry.getValue()).equals(this.outgoingLocals.get(entry.getIntKey()))) continue;
            builder.addDebugLocalEnd(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
    }

    private void startLocals(IRBuilder builder) {
        assert (this.localsChanged());
        for (Int2ObjectMap.Entry entry : this.outgoingLocals.int2ObjectEntrySet()) {
            if (((DebugLocalInfo)entry.getValue()).equals(this.incomingLocals.get(entry.getIntKey()))) continue;
            builder.addDebugLocalStart(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
    }

    private boolean isControlFlow(CfInstruction currentInstruction) {
        return currentInstruction.isReturn() || currentInstruction.getTarget() != null || currentInstruction instanceof CfSwitch || currentInstruction instanceof CfThrow;
    }

    @Override
    public CatchHandlers<Integer> getCurrentCatchHandlers() {
        TryHandlerList tryHandlers = this.getTryHandlers(this.instructionOffset(this.currentInstructionIndex));
        if (tryHandlers.isEmpty()) {
            return null;
        }
        return new CatchHandlers<Integer>(tryHandlers.guards, tryHandlers.offsets);
    }

    @Override
    public int getMoveExceptionRegister(int instructionIndex) {
        return 100000;
    }

    @Override
    public boolean verifyCurrentInstructionCanThrow() {
        return this.code.getInstructions().get(this.currentInstructionIndex).canThrow();
    }

    @Override
    public boolean verifyLocalInScope(DebugLocalInfo local) {
        return false;
    }

    @Override
    public Position getCanonicalDebugPositionAtOffset(int offset) {
        CfInstruction insn;
        while (offset + 1 < this.code.getInstructions().size() && ((insn = this.code.getInstructions().get(offset)) instanceof CfLabel || insn instanceof CfFrame)) {
            ++offset;
        }
        while (offset >= 0 && !(this.code.getInstructions().get(offset) instanceof CfPosition)) {
            --offset;
        }
        if (offset < 0) {
            return this.canonicalPositions.getPreamblePosition();
        }
        return this.getCanonicalPosition(((CfPosition)this.code.getInstructions().get(offset)).getPosition());
    }

    @Override
    public Position getCurrentPosition() {
        return this.state.getPosition();
    }

    public Position getCanonicalPosition(Position position) {
        return this.canonicalPositions.getCanonical(new Position(position.line, position.file, position.method, this.canonicalPositions.canonicalizeCallerPosition(position.callerPosition)));
    }

    private static class LocalVariableList {
        public static final LocalVariableList EMPTY = new LocalVariableList(0, 0, Int2ObjectSortedMaps.emptyMap());
        public final int startOffset;
        public final int endOffset;
        public final Int2ObjectMap<DebugLocalInfo> locals;

        private LocalVariableList(int startOffset, int endOffset, Int2ObjectMap<DebugLocalInfo> locals) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.locals = locals;
        }

        static LocalVariableList compute(int instructionOffset, List<CfCode.LocalVariableInfo> locals, Reference2IntMap<CfLabel> labelOffsets) {
            int startOffset = Integer.MIN_VALUE;
            int endOffset = Integer.MAX_VALUE;
            Int2ObjectOpenHashMap<DebugLocalInfo> currentLocals = null;
            for (CfCode.LocalVariableInfo local : locals) {
                int start = labelOffsets.getInt(local.getStart());
                int end = labelOffsets.getInt(local.getEnd());
                if (start > instructionOffset) {
                    endOffset = Math.min(endOffset, start);
                    continue;
                }
                if (instructionOffset >= end) {
                    startOffset = Math.max(startOffset, end);
                    continue;
                }
                if (currentLocals == null) {
                    currentLocals = new Int2ObjectOpenHashMap<DebugLocalInfo>();
                }
                startOffset = Math.max(startOffset, start);
                endOffset = Math.min(endOffset, end);
                currentLocals.put(local.getIndex(), local.getLocal());
            }
            return new LocalVariableList(startOffset, endOffset, currentLocals == null ? Int2ObjectSortedMaps.emptyMap() : currentLocals);
        }

        boolean validFor(int instructionOffset) {
            return this.startOffset <= instructionOffset && instructionOffset < this.endOffset;
        }

        public DebugLocalInfo getLocal(int register) {
            return (DebugLocalInfo)this.locals.get(register);
        }

        public Int2ObjectOpenHashMap<DebugLocalInfo> merge(LocalVariableList other) {
            return LocalVariableList.merge(this, other);
        }

        private static Int2ObjectOpenHashMap<DebugLocalInfo> merge(LocalVariableList a, LocalVariableList b) {
            if (a.locals.size() > b.locals.size()) {
                return LocalVariableList.merge(b, a);
            }
            Int2ObjectOpenHashMap<DebugLocalInfo> result = new Int2ObjectOpenHashMap<DebugLocalInfo>();
            for (Int2ObjectMap.Entry entry : a.locals.int2ObjectEntrySet()) {
                if (!((DebugLocalInfo)entry.getValue()).equals(b.getLocal(entry.getIntKey()))) continue;
                result.put(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            }
            return result;
        }
    }

    private static class TryHandlerList {
        public final int startOffset;
        public final int endOffset;
        public final List<DexType> guards;
        public final IntList offsets;

        TryHandlerList(int startOffset, int endOffset, List<DexType> guards, IntList offsets) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.guards = guards;
            this.offsets = offsets;
        }

        boolean validFor(int instructionOffset) {
            return this.startOffset <= instructionOffset && instructionOffset < this.endOffset;
        }

        boolean isEmpty() {
            assert (this.guards.isEmpty() == this.offsets.isEmpty());
            return this.guards.isEmpty();
        }

        static TryHandlerList computeTryHandlers(int instructionOffset, List<CfTryCatch> tryCatchRanges, Reference2IntMap<CfLabel> labelOffsets) {
            int startOffset = Integer.MIN_VALUE;
            int endOffset = Integer.MAX_VALUE;
            ArrayList<DexType> guards = new ArrayList<DexType>();
            IntArrayList offsets = new IntArrayList();
            ReferenceOpenHashSet seen = new ReferenceOpenHashSet();
            for (CfTryCatch tryCatch : tryCatchRanges) {
                int start = labelOffsets.getInt(tryCatch.start);
                int end = labelOffsets.getInt(tryCatch.end);
                if (start > instructionOffset) {
                    endOffset = Math.min(endOffset, start);
                    continue;
                }
                if (instructionOffset >= end) {
                    startOffset = Math.max(startOffset, end);
                    continue;
                }
                startOffset = Math.max(startOffset, start);
                endOffset = Math.min(endOffset, end);
                boolean seenCatchAll = false;
                for (int i = 0; i < tryCatch.guards.size() && !seenCatchAll; ++i) {
                    DexType guard = tryCatch.guards.get(i);
                    if (!seen.add(guard)) continue;
                    guards.add(guard);
                    offsets.add(labelOffsets.getInt(tryCatch.targets.get(i)));
                    seenCatchAll = guard == DexItemFactory.catchAllType;
                }
                if (!seenCatchAll) continue;
                break;
            }
            return new TryHandlerList(startOffset, endOffset, guards, offsets);
        }
    }
}

