/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class CovariantReturnTypeAnnotationTransformer {
    private final IRConverter converter;
    private final DexItemFactory factory;

    public CovariantReturnTypeAnnotationTransformer(IRConverter converter, DexItemFactory factory) {
        this.converter = converter;
        this.factory = factory;
    }

    public void process(DexApplication.Builder<?> builder) {
        LinkedList<DexEncodedMethod> methodsWithCovariantReturnTypeAnnotation = new LinkedList<DexEncodedMethod>();
        LinkedList<DexEncodedMethod> covariantReturnTypeMethods = new LinkedList<DexEncodedMethod>();
        for (DexClass dexClass : builder.getProgramClasses()) {
            this.buildCovariantReturnTypeMethodsForClass(dexClass, methodsWithCovariantReturnTypeAnnotation, covariantReturnTypeMethods);
            if (covariantReturnTypeMethods.isEmpty()) continue;
            this.updateClass(dexClass, methodsWithCovariantReturnTypeAnnotation, covariantReturnTypeMethods);
            methodsWithCovariantReturnTypeAnnotation.clear();
            covariantReturnTypeMethods.clear();
        }
    }

    private void updateClass(DexClass clazz, List<DexEncodedMethod> methodsWithCovariantReturnTypeAnnotation, List<DexEncodedMethod> covariantReturnTypeMethods) {
        for (DexEncodedMethod syntheticMethod : covariantReturnTypeMethods) {
            if (!CovariantReturnTypeAnnotationTransformer.hasVirtualMethodWithSignature(clazz, syntheticMethod)) continue;
            throw new CompilationError(String.format("Cannot process CovariantReturnType annotation: Class %s already has a method \"%s\"", clazz.getType(), syntheticMethod.toSourceString()));
        }
        for (DexEncodedMethod method : methodsWithCovariantReturnTypeAnnotation) {
            method.annotations = method.annotations.keepIf(x -> !this.isCovariantReturnTypeAnnotation(x.annotation));
        }
        DexEncodedMethod[] oldVirtualMethods = clazz.virtualMethods();
        DexEncodedMethod[] newVirtualMethods = new DexEncodedMethod[oldVirtualMethods.length + covariantReturnTypeMethods.size()];
        System.arraycopy(oldVirtualMethods, 0, newVirtualMethods, 0, oldVirtualMethods.length);
        int i = oldVirtualMethods.length;
        Iterator<DexEncodedMethod> iterator2 = covariantReturnTypeMethods.iterator();
        while (iterator2.hasNext()) {
            DexEncodedMethod syntheticMethod;
            newVirtualMethods[i] = syntheticMethod = iterator2.next();
            ++i;
        }
        clazz.setVirtualMethods(newVirtualMethods);
    }

    private void buildCovariantReturnTypeMethodsForClass(DexClass clazz, List<DexEncodedMethod> methodsWithCovariantReturnTypeAnnotation, List<DexEncodedMethod> covariantReturnTypeMethods) {
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            if (!this.methodHasCovariantReturnTypeAnnotation(method)) continue;
            methodsWithCovariantReturnTypeAnnotation.add(method);
            this.buildCovariantReturnTypeMethodsForMethod(clazz, method, covariantReturnTypeMethods);
        }
    }

    private boolean methodHasCovariantReturnTypeAnnotation(DexEncodedMethod method) {
        for (DexAnnotation annotation : method.annotations.annotations) {
            if (!this.isCovariantReturnTypeAnnotation(annotation.annotation)) continue;
            return true;
        }
        return false;
    }

    private void buildCovariantReturnTypeMethodsForMethod(DexClass clazz, DexEncodedMethod method, List<DexEncodedMethod> covariantReturnTypeMethods) {
        assert (this.methodHasCovariantReturnTypeAnnotation(method));
        for (DexType covariantReturnType : this.getCovariantReturnTypes(clazz, method)) {
            DexEncodedMethod covariantReturnTypeMethod = this.buildCovariantReturnTypeMethod(clazz, method, covariantReturnType);
            covariantReturnTypeMethods.add(covariantReturnTypeMethod);
        }
    }

    private DexEncodedMethod buildCovariantReturnTypeMethod(DexClass clazz, DexEncodedMethod method, DexType covariantReturnType) {
        DexProto newProto = this.factory.createProto(covariantReturnType, method.method.proto.shorty, method.method.proto.parameters);
        MethodAccessFlags newAccessFlags = method.accessFlags.copy();
        newAccessFlags.setBridge();
        newAccessFlags.setSynthetic();
        DexMethod newMethod = this.factory.createMethod(method.method.holder, newProto, method.method.name);
        DexEncodedMethod newVirtualMethod = new DexEncodedMethod(newMethod, newAccessFlags, method.annotations.keepIf(x -> !this.isCovariantReturnTypeAnnotation(x.annotation)), method.parameterAnnotationsList.keepIf(Predicates.alwaysTrue()), new SynthesizedCode(callerPosition -> new ForwardMethodSourceCode(clazz.type, newMethod, newMethod, method.method.holder, method.method, Invoke.Type.VIRTUAL, callerPosition, true)));
        this.converter.optimizeSynthesizedMethod(newVirtualMethod);
        return newVirtualMethod;
    }

    private Set<DexType> getCovariantReturnTypes(DexClass clazz, DexEncodedMethod method) {
        HashSet<DexType> covariantReturnTypes = new HashSet<DexType>();
        for (DexAnnotation annotation : method.annotations.annotations) {
            if (!this.isCovariantReturnTypeAnnotation(annotation.annotation)) continue;
            this.getCovariantReturnTypesFromAnnotation(clazz, method, annotation.annotation, covariantReturnTypes);
        }
        return covariantReturnTypes;
    }

    private void getCovariantReturnTypesFromAnnotation(DexClass clazz, DexEncodedMethod method, DexEncodedAnnotation annotation, Set<DexType> covariantReturnTypes) {
        assert (this.isCovariantReturnTypeAnnotation(annotation));
        boolean hasPresentAfterElement = false;
        for (DexAnnotationElement element : annotation.elements) {
            String name = element.name.toString();
            if (annotation.type == this.factory.annotationCovariantReturnType) {
                if (name.equals("returnType")) {
                    if (!(element.value instanceof DexValue.DexValueType)) {
                        throw new CompilationError(String.format("Expected element \"returnType\" of CovariantReturnType annotation to reference a type (method: \"%s\", was: %s)", method.toSourceString(), element.value.getClass().getCanonicalName()));
                    }
                    DexValue.DexValueType dexValueType = (DexValue.DexValueType)element.value;
                    covariantReturnTypes.add((DexType)dexValueType.value);
                    continue;
                }
                if (!name.equals("presentAfter")) continue;
                hasPresentAfterElement = true;
                continue;
            }
            if (!name.equals("value")) continue;
            if (!(element.value instanceof DexValue.DexValueArray)) {
                throw new CompilationError(String.format("Expected element \"value\" of CovariantReturnTypes annotation to be an array (method: \"%s\", was: %s)", method.toSourceString(), element.value.getClass().getCanonicalName()));
            }
            DexValue.DexValueArray array = (DexValue.DexValueArray)element.value;
            for (DexValue value : array.getValues()) {
                assert (value instanceof DexValue.DexValueAnnotation);
                DexValue.DexValueAnnotation innerAnnotation = (DexValue.DexValueAnnotation)value;
                this.getCovariantReturnTypesFromAnnotation(clazz, method, innerAnnotation.value, covariantReturnTypes);
            }
        }
        if (annotation.type == this.factory.annotationCovariantReturnType && !hasPresentAfterElement) {
            throw new CompilationError(String.format("CovariantReturnType annotation for method \"%s\" is missing mandatory element \"presentAfter\" (class %s)", clazz.getType(), method.toSourceString()));
        }
    }

    private boolean isCovariantReturnTypeAnnotation(DexEncodedAnnotation annotation) {
        return annotation.type == this.factory.annotationCovariantReturnType || annotation.type == this.factory.annotationCovariantReturnTypes;
    }

    private static boolean hasVirtualMethodWithSignature(DexClass clazz, DexEncodedMethod method) {
        for (DexEncodedMethod existingMethod : clazz.virtualMethods()) {
            if (!existingMethod.method.equals(method.method)) continue;
            return true;
        }
        return false;
    }
}

