/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import java.util.BitSet;
import java.util.ListIterator;
import java.util.Set;

public class UninstantiatedTypeOptimization {
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;
    private final InternalOptions options;
    private int numberOfInstanceGetOrInstancePutWithNullReceiver = 0;
    private int numberOfInvokesWithNullArgument = 0;
    private int numberOfInvokesWithNullReceiver = 0;

    public UninstantiatedTypeOptimization(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, InternalOptions options) {
        this.appView = appView;
        this.options = options;
    }

    public void rewrite(DexEncodedMethod method, IRCode code) {
        Set<BasicBlock> blocksToBeRemoved = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (blocksToBeRemoved.contains(block)) continue;
            InstructionListIterator instructionIterator = block.listIterator();
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                if (instruction.isFieldInstruction()) {
                    if (instruction.isInstanceGet() || instruction.isInstancePut()) {
                        this.rewriteInstanceFieldInstruction(instruction.asFieldInstruction(), blockIterator, instructionIterator, code, blocksToBeRemoved);
                        continue;
                    }
                    this.rewriteStaticFieldInstruction(instruction.asFieldInstruction(), blockIterator, instructionIterator, code, blocksToBeRemoved);
                    continue;
                }
                if (!instruction.isInvokeMethod()) continue;
                this.rewriteInvoke(instruction.asInvokeMethod(), blockIterator, instructionIterator, code, blocksToBeRemoved);
            }
        }
        code.removeBlocks(blocksToBeRemoved);
        code.removeAllTrivialPhis();
        code.removeUnreachableBlocks();
        assert (code.isConsistentSSA());
    }

    public void logResults() {
        assert (false);
        Log.info(this.getClass(), "Number of instance-get/instance-put with null receiver: %s", this.numberOfInstanceGetOrInstancePutWithNullReceiver);
        Log.info(this.getClass(), "Number of invokes with null argument: %s", this.numberOfInvokesWithNullArgument);
        Log.info(this.getClass(), "Number of invokes with null receiver: %s", this.numberOfInvokesWithNullReceiver);
    }

    private void rewriteInstanceFieldInstruction(FieldInstruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        assert (instruction.isInstanceGet() || instruction.isInstancePut());
        boolean replacedByThrowNull = false;
        Value receiver = instruction.inValues().get(0);
        if (this.isAlwaysNull(receiver) && !receiver.getTypeLattice().isDefinitelyNull()) {
            this.replaceCurrentInstructionWithThrowNull(instruction, blockIterator, instructionIterator, code, blocksToBeRemoved);
            ++this.numberOfInstanceGetOrInstancePutWithNullReceiver;
            replacedByThrowNull = true;
        }
        if (!replacedByThrowNull) {
            this.rewriteFieldInstruction(instruction, blockIterator, instructionIterator, code, blocksToBeRemoved);
        }
    }

    private void rewriteStaticFieldInstruction(FieldInstruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        assert (instruction.isStaticGet() || instruction.isStaticPut());
        this.rewriteFieldInstruction(instruction, blockIterator, instructionIterator, code, blocksToBeRemoved);
    }

    private void rewriteFieldInstruction(FieldInstruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        DexType fieldType = instruction.getField().type;
        if (this.isAlwaysNull(fieldType)) {
            DexClass enclosingClass;
            DexEncodedField field = this.appView.appInfo().definitionFor(instruction.getField());
            if (field == null) {
                return;
            }
            if (field.field.clazz != code.method.method.holder && ((enclosingClass = this.appView.appInfo().definitionFor(code.method.method.holder)) == null || enclosingClass.classInitializationMayHaveSideEffects(this.appView.appInfo()))) {
                return;
            }
            BasicBlock block = instruction.getBlock();
            if (instruction.isFieldPut()) {
                Value value = instruction.isInstancePut() ? instruction.asInstancePut().value() : instruction.asStaticPut().inValue();
                TypeLatticeElement fieldLatticeType = TypeLatticeElement.fromDexType(fieldType, true, this.appView.appInfo());
                if (!value.getTypeLattice().lessThanOrEqual(fieldLatticeType, this.appView.appInfo())) {
                    assert (this.options.testing.allowTypeErrors);
                    return;
                }
                instructionIterator.removeOrReplaceByDebugLocalRead();
            } else {
                instructionIterator.replaceCurrentInstruction(code.createConstNull());
            }
            if (block.hasCatchHandlers()) {
                block.getCatchHandlers().getUniqueTargets().forEach(BasicBlock::unlinkCatchHandler);
            }
        }
    }

    private void rewriteInvoke(InvokeMethod invoke, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        Value receiver;
        if (invoke.isInvokeMethodWithReceiver() && this.isAlwaysNull(receiver = invoke.asInvokeMethodWithReceiver().getReceiver())) {
            this.replaceCurrentInstructionWithThrowNull(invoke, blockIterator, instructionIterator, code, blocksToBeRemoved);
            ++this.numberOfInvokesWithNullReceiver;
            return;
        }
        DexEncodedMethod target = invoke.lookupSingleTarget(this.appView.appInfo(), code.method.method.holder);
        if (target == null) {
            return;
        }
        BitSet nonNullParamHints = target.getOptimizationInfo().getNonNullParamHints();
        if (nonNullParamHints != null) {
            int argumentIndex = target.isStatic() ? 0 : 1;
            int nonNullParamHintIndex = 0;
            while (argumentIndex < invoke.arguments().size()) {
                Value argument = invoke.arguments().get(argumentIndex);
                if (this.isAlwaysNull(argument) && nonNullParamHints.get(nonNullParamHintIndex)) {
                    this.replaceCurrentInstructionWithThrowNull(invoke, blockIterator, instructionIterator, code, blocksToBeRemoved);
                    ++this.numberOfInvokesWithNullArgument;
                    return;
                }
                ++argumentIndex;
                ++nonNullParamHintIndex;
            }
            assert (argumentIndex == nonNullParamHintIndex + (target.isStatic() ? 0 : 1));
        }
    }

    private void replaceCurrentInstructionWithThrowNull(Instruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        BasicBlock block = instruction.getBlock();
        assert (!blocksToBeRemoved.contains(block));
        BasicBlock normalSuccessorBlock = instructionIterator.split(code, blockIterator);
        instructionIterator.previous();
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        blocksToBeRemoved.addAll(block.unlink(normalSuccessorBlock, dominatorTree));
        instructionIterator.previous();
        Value nullValue = new Value(code.valueNumberGenerator.next(), TypeLatticeElement.NULL, null);
        ConstNumber constNumberInstruction = new ConstNumber(nullValue, 0L);
        constNumberInstruction.setPosition(this.options.debug ? instruction.getPosition() : Position.none());
        instructionIterator.add(constNumberInstruction);
        instructionIterator.next();
        Throw throwInstruction = new Throw(nullValue);
        for (Value inValue : instruction.inValues()) {
            if (!inValue.hasLocalInfo()) continue;
            throwInstruction.addDebugValue(inValue);
        }
        instructionIterator.replaceCurrentInstruction(throwInstruction);
        instructionIterator.next();
        instructionIterator.remove();
        if (block.hasCatchHandlers()) {
            CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
            catchHandlers.forEach((guard, target) -> {
                if (blocksToBeRemoved.contains(target)) {
                    return;
                }
                if (!this.appView.dexItemFactory().npeType.isSubtypeOf((DexType)guard, this.appView.appInfo())) {
                    DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
                    blocksToBeRemoved.addAll(block.unlink((BasicBlock)target, dominatorTree));
                }
            });
        }
    }

    private boolean isAlwaysNull(Value value) {
        if (value.hasLocalInfo()) {
            return false;
        }
        TypeLatticeElement typeLatticeElement = value.getTypeLattice();
        if (typeLatticeElement.isDefinitelyNull()) {
            return true;
        }
        if (typeLatticeElement.isClassType()) {
            return this.isAlwaysNull(typeLatticeElement.asClassTypeLatticeElement().getClassType());
        }
        return false;
    }

    private boolean isAlwaysNull(DexType type) {
        if (type.isClassType()) {
            DexClass clazz = this.appView.appInfo().definitionFor(type);
            return clazz != null && clazz.isProgramClass() && !this.appView.appInfo().isInstantiatedDirectlyOrIndirectly(type);
        }
        return false;
    }
}

