/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.ir.code.Dup;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.Match;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import com.android.tools.r8.ir.optimize.peepholes.Point;
import com.android.tools.r8.ir.optimize.peepholes.Wildcard;
import java.util.List;

public class StoreLoadToDupStorePeephole
implements BasicBlockPeephole {
    private final Point storeExp = new Point(PeepholeHelper.withoutLocalInfo(Instruction::isStore));
    private final Point loadExp = new Point(Instruction::isLoad);
    private final Wildcard dupsExp = new Wildcard(i -> i.isDup() || i.isDup2());
    private final PeepholeLayout layout = PeepholeLayout.lookForward(this.storeExp, this.loadExp, this.dupsExp);

    @Override
    public boolean match(InstructionListIterator it) {
        Match match = this.layout.test(it);
        if (match == null) {
            return false;
        }
        Store oldStore = this.storeExp.get(match).asStore();
        Load load = this.loadExp.get(match).asLoad();
        if (load.src() != oldStore.outValue() || oldStore.outValue().numberOfAllUsers() <= 1) {
            return false;
        }
        List<Instruction> dups = this.dupsExp.get(match);
        Instruction lastDup = dups.isEmpty() ? null : dups.get(dups.size() - 1);
        StackValue oldStoreSrc = (StackValue)oldStore.src();
        Value loadOut = load.swapOutValue(null);
        if (lastDup == null) {
            StackValue newStoreSrc = oldStoreSrc.duplicate(oldStoreSrc.getHeight() + 1);
            Dup dup = new Dup((StackValue)loadOut, newStoreSrc, oldStoreSrc);
            dup.setPosition(oldStore.getPosition());
            oldStore.replaceValue(0, (Value)newStoreSrc);
            it.add(dup);
            PeepholeHelper.resetPrevious(it, 2);
            it.removeOrReplaceByDebugLocalRead();
        } else {
            StackValue newTopAfterDups;
            Value storeOut = oldStore.swapOutValue(null);
            it.removeOrReplaceByDebugLocalRead();
            it.next();
            it.removeOrReplaceByDebugLocalRead();
            assert (dups.get(0).isDup() && dups.get(0).inValues().get(0) == loadOut);
            dups.get(0).replaceValue(0, (Value)oldStoreSrc);
            StackValues lastDupOut = (StackValues)lastDup.outValue();
            StackValue topAfterDups = lastDupOut.getStackValues()[lastDupOut.getStackValues().length - 1];
            lastDupOut.getStackValues()[lastDupOut.getStackValues().length - 1] = newTopAfterDups = topAfterDups.duplicate(topAfterDups.getHeight());
            newTopAfterDups.definition = lastDup;
            StackValue newStoreSrc = oldStoreSrc.duplicate(topAfterDups.getHeight() + 1);
            Dup newDup = new Dup(topAfterDups, newStoreSrc, newTopAfterDups);
            newDup.setPosition(lastDup.getPosition());
            PeepholeHelper.resetPrevious(it, dups.size());
            it.add(newDup);
            Store newStore = new Store(storeOut, newStoreSrc);
            newStore.setPosition(lastDup.getPosition());
            it.add(newStore);
        }
        return true;
    }

    @Override
    public boolean resetAfterMatch() {
        return false;
    }
}

