/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.InlineRule;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import com.android.tools.r8.shaking.ProguardKeepRuleModifiers;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import java.util.List;
import java.util.stream.Collectors;

public class ProguardIfRule
extends ProguardKeepRuleBase {
    final ProguardKeepRule subsequentRule;

    private ProguardIfRule(Origin origin, Position position, String source, ProguardTypeMatcher classAnnotation, ProguardAccessFlags classAccessFlags, ProguardAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, ProguardClassNameList classNames, ProguardTypeMatcher inheritanceAnnotation, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, List<ProguardMemberRule> memberRules, ProguardKeepRule subsequentRule) {
        super(origin, position, source, classAnnotation, classAccessFlags, negatedClassAccessFlags, classTypeNegated, classType, classNames, inheritanceAnnotation, inheritanceClassName, inheritanceIsExtends, memberRules, ProguardKeepRuleType.CONDITIONAL, ProguardKeepRuleModifiers.builder().build());
        this.subsequentRule = subsequentRule;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Iterable<ProguardWildcard> getWildcards() {
        return Iterables.concat(super.getWildcards(), this.subsequentRule.getWildcards());
    }

    protected ProguardIfRule materialize() {
        return new ProguardIfRule(Origin.unknown(), Position.UNKNOWN, null, this.getClassAnnotation() == null ? null : this.getClassAnnotation().materialize(), this.getClassAccessFlags(), this.getNegatedClassAccessFlags(), this.getClassTypeNegated(), this.getClassType(), this.getClassNames().materialize(), this.getInheritanceAnnotation() == null ? null : this.getInheritanceAnnotation().materialize(), this.getInheritanceClassName() == null ? null : this.getInheritanceClassName().materialize(), this.getInheritanceIsExtends(), this.getMemberRules() == null ? null : this.getMemberRules().stream().map(ProguardMemberRule::materialize).collect(Collectors.toList()), this.subsequentRule.materialize());
    }

    protected ClassInlineRule neverClassInlineRuleForCondition() {
        return new ClassInlineRule(Origin.unknown(), Position.UNKNOWN, null, this.getClassAnnotation() == null ? null : this.getClassAnnotation().materialize(), this.getClassAccessFlags(), this.getNegatedClassAccessFlags(), this.getClassTypeNegated(), this.getClassType(), this.getClassNames().materialize(), this.getInheritanceAnnotation() == null ? null : this.getInheritanceAnnotation().materialize(), this.getInheritanceClassName() == null ? null : this.getInheritanceClassName().materialize(), this.getInheritanceIsExtends(), ImmutableList.of(), ClassInlineRule.Type.NEVER);
    }

    protected InlineRule neverInlineRuleForCondition() {
        if (this.getMemberRules() == null || this.getMemberRules().isEmpty()) {
            return null;
        }
        return new InlineRule(Origin.unknown(), Position.UNKNOWN, null, this.getClassAnnotation() == null ? null : this.getClassAnnotation().materialize(), this.getClassAccessFlags(), this.getNegatedClassAccessFlags(), this.getClassTypeNegated(), this.getClassType(), this.getClassNames().materialize(), this.getInheritanceAnnotation() == null ? null : this.getInheritanceAnnotation().materialize(), this.getInheritanceClassName() == null ? null : this.getInheritanceClassName().materialize(), this.getInheritanceIsExtends(), this.getMemberRules().stream().filter(rule -> rule.getRuleType().includesMethods()).map(ProguardMemberRule::materialize).collect(Collectors.toList()), InlineRule.Type.NEVER);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ProguardIfRule)) {
            return false;
        }
        ProguardIfRule other = (ProguardIfRule)o;
        if (this.subsequentRule != other.subsequentRule) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 3 + this.subsequentRule.hashCode();
    }

    @Override
    String typeString() {
        return "if";
    }

    public static class Builder
    extends ProguardKeepRuleBase.Builder<ProguardIfRule, Builder> {
        ProguardKeepRule subsequentRule = null;

        protected Builder() {
        }

        @Override
        public Builder self() {
            return this;
        }

        public void setSubsequentRule(ProguardKeepRule rule) {
            this.subsequentRule = rule;
        }

        @Override
        public ProguardIfRule build() {
            assert (this.subsequentRule != null) : "Option -if without a subsequent rule.";
            return new ProguardIfRule(this.origin, this.getPosition(), this.source, this.classAnnotation, this.classAccessFlags, this.negatedClassAccessFlags, this.classTypeNegated, this.classType, this.classNames, this.inheritanceAnnotation, this.inheritanceClassName, this.inheritanceIsExtends, this.memberRules, this.subsequentRule);
        }
    }
}

