/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.GenerateMainDexListCommand;
import com.android.tools.r8.Keep;
import com.android.tools.r8.R8;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexClasses;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.WhyAreYouKeepingConsumer;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

@Keep
public class GenerateMainDexList {
    private final Timing timing = new Timing("maindex");
    private final InternalOptions options;

    private GenerateMainDexList(InternalOptions options) {
        this.options = options;
    }

    private List<String> run(AndroidApp app, ExecutorService executor) throws IOException {
        try {
            DirectMappedDexApplication application = new ApplicationReader(app, this.options, this.timing).read(executor).toDirect();
            AppView<AppInfoWithSubtyping> appView = new AppView<AppInfoWithSubtyping>(new AppInfoWithSubtyping(application), GraphLense.getIdentityLense(), this.options);
            RootSetBuilder.RootSet mainDexRootSet = new RootSetBuilder(appView, application, this.options.mainDexKeepRules, this.options).run(executor);
            GraphConsumer graphConsumer = this.options.mainDexKeptGraphConsumer;
            WhyAreYouKeepingConsumer whyAreYouKeepingConsumer = null;
            if (!mainDexRootSet.reasonAsked.isEmpty()) {
                whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(graphConsumer);
                graphConsumer = whyAreYouKeepingConsumer;
            }
            Enqueuer enqueuer = new Enqueuer(appView, this.options, graphConsumer, true);
            Enqueuer.AppInfoWithLiveness mainDexAppInfo = enqueuer.traceMainDex(mainDexRootSet, executor, this.timing);
            MainDexClasses mainDexClasses = new MainDexListBuilder(new HashSet<DexType>(mainDexAppInfo.liveTypes), application).run();
            List<String> result = mainDexClasses.getClasses().stream().map(c -> c.toSourceString().replace('.', '/') + ".class").sorted().collect(Collectors.toList());
            if (this.options.mainDexListConsumer != null) {
                this.options.mainDexListConsumer.accept(String.join((CharSequence)"\n", result), this.options.reporter);
            }
            if (whyAreYouKeepingConsumer != null) {
                for (DexDefinition definition : mainDexRootSet.reasonAsked) {
                    whyAreYouKeepingConsumer.printWhyAreYouKeeping(enqueuer.getGraphNode(definition), System.out);
                }
            }
            return result;
        }
        catch (ExecutionException e) {
            throw R8.unwrapExecutionException(e);
        }
    }

    public static List<String> run(GenerateMainDexListCommand command) throws CompilationFailedException {
        ExecutorService executorService = ThreadUtils.getExecutorService(command.getInternalOptions());
        try {
            List<String> list = GenerateMainDexList.run(command, executorService);
            return list;
        }
        finally {
            executorService.shutdown();
        }
    }

    public static List<String> run(GenerateMainDexListCommand command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ResultBox result = new ResultBox();
        ExceptionUtils.withMainDexListHandler(command.getReporter(), () -> {
            try {
                result.content = new GenerateMainDexList(options).run(app, executor);
            }
            finally {
                executor.shutdown();
            }
        });
        return result.content;
    }

    public static void main(String[] args) throws CompilationFailedException {
        GenerateMainDexListCommand.Builder builder = GenerateMainDexListCommand.parse(args);
        GenerateMainDexListCommand command = (GenerateMainDexListCommand)builder.build();
        if (command.isPrintHelp()) {
            System.out.println(GenerateMainDexListCommand.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("MainDexListGenerator 1.4.23");
            return;
        }
        List<String> result = GenerateMainDexList.run(command);
        if (command.getMainDexListConsumer() == null) {
            result.forEach(System.out::println);
        }
    }

    private static class ResultBox {
        List<String> content;

        private ResultBox() {
        }
    }
}

