/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;

public class TypeChecker {
    private final AppInfo appInfo;

    public TypeChecker(AppView<? extends AppInfo> appView) {
        this.appInfo = appView.appInfo();
    }

    public boolean check(IRCode code) {
        InstructionIterator instructionIterator = code.instructionIterator();
        while (instructionIterator.hasNext()) {
            Instruction instruction = (Instruction)instructionIterator.next();
            if (!(instruction.isInstancePut() ? !this.check(instruction.asInstancePut()) : (instruction.isStaticPut() ? !this.check(instruction.asStaticPut()) : instruction.isThrow() && !this.check(instruction.asThrow())))) continue;
            return false;
        }
        return true;
    }

    public boolean check(InstancePut instruction) {
        return this.checkFieldPut(instruction);
    }

    public boolean check(StaticPut instruction) {
        return this.checkFieldPut(instruction);
    }

    private boolean checkFieldPut(FieldInstruction instruction) {
        TypeLatticeElement fieldType;
        assert (instruction.isFieldPut());
        Value value = instruction.isInstancePut() ? instruction.asInstancePut().value() : instruction.asStaticPut().inValue();
        TypeLatticeElement valueType = value.getTypeLattice();
        if (this.isSubtypeOf(valueType, fieldType = TypeLatticeElement.fromDexType(instruction.getField().type, valueType.isNullable(), this.appInfo))) {
            return true;
        }
        if (valueType.isReference()) {
            DexClass clazz = this.appInfo.definitionFor(instruction.getField().type);
            return clazz != null && clazz.isInterface();
        }
        return false;
    }

    public boolean check(Throw instruction) {
        TypeLatticeElement valueType = instruction.exception().getTypeLattice();
        TypeLatticeElement throwableType = TypeLatticeElement.fromDexType(this.appInfo.dexItemFactory.throwableType, valueType.isNullable(), this.appInfo);
        return this.isSubtypeOf(valueType, throwableType);
    }

    private boolean isSubtypeOf(TypeLatticeElement expectedSubtype, TypeLatticeElement expectedSupertype) {
        return expectedSubtype.lessThanOrEqual(expectedSupertype, this.appInfo) || expectedSubtype.isBasedOnMissingClass(this.appInfo);
    }
}

