/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfArithmeticBinop;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfIinc;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Unop;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.util.function.Function;

public class Inc
extends Unop {
    private final int increment;

    public Inc(Value dest, Value source, int increment) {
        super(dest, source);
        assert (source.outType() == ValueType.INT);
        this.increment = increment;
    }

    @Override
    protected void addInValue(Value value) {
        assert (!value.hasUsersInfo());
        this.inValues.add(value);
    }

    @Override
    public boolean canBeFolded() {
        return this.source().isConstant();
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other instanceof Inc;
    }

    @Override
    public int maxInValueRegister() {
        return 65535;
    }

    @Override
    public int maxOutValueRegister() {
        return 65535;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable("The Inc instruction is not intended for Dex code.");
    }

    @Override
    public LatticeElement evaluate(IRCode code, Function<Value, LatticeElement> getLatticeElement) {
        throw new Unreachable();
    }

    @Override
    public void buildCf(CfBuilder builder) {
        int outRegister;
        Value inValue = (Value)this.inValues.get(0);
        int inRegister = builder.getLocalRegister(inValue);
        if (inRegister == (outRegister = builder.getLocalRegister(this.outValue))) {
            builder.add(new CfIinc(inRegister, this.increment));
        } else {
            assert (inValue.outType() == ValueType.INT);
            builder.add(new CfLoad(ValueType.INT, inRegister));
            builder.add(new CfConstNumber(this.increment, ValueType.INT));
            builder.add(new CfArithmeticBinop(CfArithmeticBinop.Opcode.Add, NumericType.INT));
            builder.add(new CfStore(ValueType.INT, outRegister));
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.increment;
    }
}

