/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.OptimizationInfo;
import com.android.tools.r8.graph.ParameterUsagesInfo;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionOrPhi;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.classinliner.FieldValueHelper;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class InlineCandidateProcessor {
    private static final ImmutableSet<If.Type> ALLOWED_ZERO_TEST_TYPES = ImmutableSet.of(If.Type.EQ, If.Type.NE);
    private final DexItemFactory factory;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final LambdaRewriter lambdaRewriter;
    private final Inliner inliner;
    private final Predicate<DexClass> isClassEligible;
    private final Predicate<DexEncodedMethod> isProcessedConcurrently;
    private final DexEncodedMethod method;
    private final Instruction root;
    private Value eligibleInstance;
    private DexType eligibleClass;
    private DexClass eligibleClassDefinition;
    private boolean isDesugaredLambda;
    private final Map<InvokeMethod, Inliner.InliningInfo> methodCallsOnInstance = new IdentityHashMap<InvokeMethod, Inliner.InliningInfo>();
    private final Map<InvokeMethod, Inliner.InliningInfo> extraMethodCalls = new IdentityHashMap<InvokeMethod, Inliner.InliningInfo>();
    private final List<Pair<InvokeMethod, Integer>> unusedArguments = new ArrayList<Pair<InvokeMethod, Integer>>();
    private int estimatedCombinedSizeForInlining = 0;

    InlineCandidateProcessor(DexItemFactory factory, Enqueuer.AppInfoWithLiveness appInfo, LambdaRewriter lambdaRewriter, Inliner inliner, Predicate<DexClass> isClassEligible, Predicate<DexEncodedMethod> isProcessedConcurrently, DexEncodedMethod method, Instruction root) {
        this.factory = factory;
        this.lambdaRewriter = lambdaRewriter;
        this.inliner = inliner;
        this.isClassEligible = isClassEligible;
        this.method = method;
        this.root = root;
        this.appInfo = appInfo;
        this.isProcessedConcurrently = isProcessedConcurrently;
    }

    int getEstimatedCombinedSizeForInlining() {
        return this.estimatedCombinedSizeForInlining;
    }

    boolean isInstanceEligible() {
        this.eligibleInstance = this.root.outValue();
        if (this.eligibleInstance == null) {
            return false;
        }
        this.eligibleClass = this.root.isNewInstance() ? this.root.asNewInstance().clazz : this.root.asStaticGet().getField().type;
        this.eligibleClassDefinition = this.appInfo.definitionFor(this.eligibleClass);
        if (this.eligibleClassDefinition == null && this.lambdaRewriter != null) {
            this.eligibleClassDefinition = this.lambdaRewriter.getLambdaClass(this.eligibleClass);
            this.isDesugaredLambda = this.eligibleClassDefinition != null;
        }
        return this.eligibleClassDefinition != null;
    }

    boolean isClassAndUsageEligible() {
        if (!this.isClassEligible.test(this.eligibleClassDefinition)) {
            return false;
        }
        if (this.root.isNewInstance()) {
            return !this.eligibleClassDefinition.hasClassInitializer();
        }
        assert (this.root.isStaticGet());
        if (this.isDesugaredLambda) {
            return true;
        }
        if (this.eligibleClassDefinition.instanceFields().length > 0) {
            return false;
        }
        if (this.eligibleClassDefinition.type.hasSubtypes()) {
            assert (!this.eligibleClassDefinition.accessFlags.isFinal());
            return false;
        }
        DexEncodedMethod classInitializer = this.eligibleClassDefinition.getClassInitializer();
        if (classInitializer == null || this.isProcessedConcurrently.test(classInitializer)) {
            return false;
        }
        DexEncodedMethod.TrivialInitializer info = classInitializer.getOptimizationInfo().getTrivialInitializerInfo();
        assert (info == null || info instanceof DexEncodedMethod.TrivialInitializer.TrivialClassInitializer);
        DexField instanceField = this.root.asStaticGet().getField();
        return info != null && ((DexEncodedMethod.TrivialInitializer.TrivialClassInitializer)info).field == instanceField && !this.appInfo.isPinned(this.eligibleClassDefinition.lookupStaticField((DexField)instanceField).field);
    }

    protected InstructionOrPhi areInstanceUsersEligible(Supplier<InliningOracle> defaultOracle) {
        if (this.eligibleInstance.numberOfPhiUsers() > 0) {
            return this.eligibleInstance.firstPhiUser();
        }
        Set<Instruction> currentUsers = this.eligibleInstance.uniqueUsers();
        while (!currentUsers.isEmpty()) {
            HashSet<Instruction> indirectUsers = new HashSet<Instruction>();
            for (Instruction user : currentUsers) {
                if (user.isInstanceGet() || user.isInstancePut() && user.asInstancePut().value() != this.eligibleInstance) {
                    DexField field = user.asFieldInstruction().getField();
                    if (field.clazz == this.eligibleClass && this.eligibleClassDefinition.lookupInstanceField(field) != null) continue;
                    return user;
                }
                if (user.isInvokeMethod()) {
                    Inliner.InliningInfo inliningInfo;
                    InvokeMethodWithReceiver invoke;
                    InvokeMethod invokeMethod = user.asInvokeMethod();
                    DexEncodedMethod singleTarget = this.findSingleTarget(invokeMethod);
                    if (!this.isEligibleSingleTarget(singleTarget)) {
                        return user;
                    }
                    if (user.isInvokeDirect() && this.factory.isConstructor((invoke = user.asInvokeDirect()).getInvokedMethod())) {
                        Inliner.InliningInfo inliningInfo2;
                        boolean isCorrespondingConstructorCall;
                        boolean bl = isCorrespondingConstructorCall = this.root.isNewInstance() && !invoke.inValues().isEmpty() && this.root.outValue() == invoke.inValues().get(0);
                        if (isCorrespondingConstructorCall && (inliningInfo2 = this.isEligibleConstructorCall(user.asInvokeDirect(), singleTarget, defaultOracle)) != null) {
                            this.methodCallsOnInstance.put(user.asInvokeDirect(), inliningInfo2);
                            continue;
                        }
                    }
                    if ((user.isInvokeVirtual() || user.isInvokeInterface()) && (inliningInfo = this.isEligibleDirectVirtualMethodCall(invoke = user.asInvokeMethodWithReceiver(), singleTarget, indirectUsers)) != null) {
                        this.methodCallsOnInstance.put(invoke, inliningInfo);
                        continue;
                    }
                    if (this.isExtraMethodCall(invokeMethod)) {
                        assert (!invokeMethod.isInvokeSuper());
                        assert (!invokeMethod.isInvokePolymorphic());
                        if (this.isExtraMethodCallEligible(invokeMethod, singleTarget, defaultOracle)) continue;
                    }
                    return user;
                }
                if (user.isIf()) {
                    If ifInsn = user.asIf();
                    If.Type type = ifInsn.getType();
                    if (ifInsn.isZeroTest() && (type == If.Type.EQ || type == If.Type.NE)) continue;
                }
                return user;
            }
            currentUsers = indirectUsers;
        }
        return null;
    }

    boolean processInlining(IRCode code, Supplier<InliningOracle> defaultOracle) {
        this.replaceUsagesAsUnusedArgument(code);
        boolean anyInlinedMethods = this.forceInlineExtraMethodInvocations(code);
        if (anyInlinedMethods) {
            this.methodCallsOnInstance.clear();
            this.extraMethodCalls.clear();
            this.unusedArguments.clear();
            this.estimatedCombinedSizeForInlining = 0;
            InstructionOrPhi ineligibleUser = this.areInstanceUsersEligible(defaultOracle);
            if (ineligibleUser != null) {
                return true;
            }
            assert (this.extraMethodCalls.isEmpty());
            assert (this.unusedArguments.isEmpty());
        }
        this.removeMiscUsages(code);
        this.removeFieldReads(code);
        this.removeFieldWrites();
        this.removeInstruction(this.root);
        return anyInlinedMethods |= this.forceInlineDirectMethodInvocations(code);
    }

    private void replaceUsagesAsUnusedArgument(IRCode code) {
        for (Pair<InvokeMethod, Integer> unusedArgument : this.unusedArguments) {
            InvokeMethod invoke = unusedArgument.getFirst();
            BasicBlock block = invoke.getBlock();
            ConstNumber nullValue = code.createConstNull();
            nullValue.setPosition(invoke.getPosition());
            LinkedList<Instruction> instructions = block.getInstructions();
            instructions.add(instructions.indexOf(invoke), nullValue);
            nullValue.setBlock(block);
            int argIndex = unusedArgument.getSecond() + (invoke.isInvokeMethodWithReceiver() ? 1 : 0);
            invoke.replaceValue(argIndex, nullValue.outValue());
        }
        this.unusedArguments.clear();
    }

    private boolean forceInlineExtraMethodInvocations(IRCode code) {
        if (this.extraMethodCalls.isEmpty()) {
            return false;
        }
        this.inliner.performForcedInlining(this.method, code, this.extraMethodCalls);
        return true;
    }

    private boolean forceInlineDirectMethodInvocations(IRCode code) {
        if (this.methodCallsOnInstance.isEmpty()) {
            return false;
        }
        this.inliner.performForcedInlining(this.method, code, this.methodCallsOnInstance);
        return true;
    }

    private void removeMiscUsages(IRCode code) {
        boolean needToRemoveUnreachableBlocks = false;
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (this.root.isNewInstance() && user.isInvokeDirect() && this.factory.isConstructor(user.asInvokeDirect().getInvokedMethod()) && user.asInvokeDirect().getInvokedMethod().holder == this.eligibleClassDefinition.superType) {
                this.removeInstruction(user);
                continue;
            }
            if (user.isIf()) {
                BasicBlock blockToRemove;
                If ifInsn = user.asIf();
                assert (ifInsn.isZeroTest()) : "Unexpected usage in non-zero-test IF instruction: " + user;
                BasicBlock block = user.getBlock();
                If.Type type = ifInsn.getType();
                assert (type == If.Type.EQ || type == If.Type.NE) : "Unexpected type in zero-test IF instruction: " + user;
                BasicBlock newBlock = type == If.Type.EQ ? ifInsn.fallthroughBlock() : ifInsn.getTrueTarget();
                BasicBlock basicBlock = blockToRemove = type == If.Type.EQ ? ifInsn.getTrueTarget() : ifInsn.fallthroughBlock();
                assert (newBlock != blockToRemove);
                block.replaceSuccessor(blockToRemove, newBlock);
                blockToRemove.removePredecessor(block);
                assert (block.exit().isGoto());
                assert (block.exit().asGoto().getTarget() == newBlock);
                needToRemoveUnreachableBlocks = true;
                continue;
            }
            if (user.isInstanceGet() || user.isInstancePut()) continue;
            throw new Unreachable("Unexpected usage left in method `" + this.method.method.toSourceString() + "` after inlining: " + user);
        }
        if (needToRemoveUnreachableBlocks) {
            code.removeUnreachableBlocks();
        }
    }

    private void removeFieldReads(IRCode code) {
        IdentityHashMap<DexField, FieldValueHelper> fieldHelpers = new IdentityHashMap<DexField, FieldValueHelper>();
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (user.isInstanceGet()) {
                this.replaceFieldRead(code, user.asInstanceGet(), fieldHelpers);
                continue;
            }
            if (user.isInstancePut()) continue;
            throw new Unreachable("Unexpected usage left in method `" + this.method.method.toSourceString() + "` after inlining: " + user);
        }
    }

    private void replaceFieldRead(IRCode code, InstanceGet fieldRead, Map<DexField, FieldValueHelper> fieldHelpers) {
        Value value = fieldRead.outValue();
        if (value != null) {
            FieldValueHelper helper = fieldHelpers.computeIfAbsent(fieldRead.getField(), field -> new FieldValueHelper((DexField)field, code, this.root, this.appInfo));
            Value newValue = helper.getValueForFieldRead(fieldRead.getBlock(), fieldRead);
            value.replaceUsers(newValue);
            for (FieldValueHelper fieldValueHelper : fieldHelpers.values()) {
                fieldValueHelper.replaceValue(value, newValue);
            }
            assert (value.numberOfAllUsers() == 0);
            new TypeAnalysis(this.appInfo, code.method).widening(code.method, code);
        }
        this.removeInstruction(fieldRead);
    }

    private void removeFieldWrites() {
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (!user.isInstancePut()) {
                throw new Unreachable("Unexpected usage left in method `" + this.method.method.toSourceString() + "` after field reads removed: " + user);
            }
            if (user.asInstancePut().getField().clazz != this.eligibleClass) {
                throw new Unreachable("Unexpected field write left in method `" + this.method.method.toSourceString() + "` after field reads removed: " + user);
            }
            this.removeInstruction(user);
        }
    }

    private Inliner.InliningInfo isEligibleConstructorCall(InvokeDirect invoke, DexEncodedMethod singleTarget, Supplier<InliningOracle> defaultOracle) {
        DexEncodedMethod.TrivialInitializer info;
        assert (this.factory.isConstructor(invoke.getInvokedMethod()));
        assert (this.isEligibleSingleTarget(singleTarget));
        if (invoke.inValues().lastIndexOf(this.eligibleInstance) != 0) {
            return null;
        }
        DexMethod init = invoke.getInvokedMethod();
        if (init.holder != this.eligibleClass) {
            return null;
        }
        ParameterUsagesInfo.ParameterUsage parameterUsage = singleTarget.getOptimizationInfo().getParameterUsages(0);
        if (!this.isEligibleParameterUsage(parameterUsage, invoke, defaultOracle)) {
            return null;
        }
        if (this.isDesugaredLambda) {
            this.markSizeForInlining(singleTarget);
            return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
        }
        if (this.eligibleClassDefinition.superType != this.factory.objectType && !((info = singleTarget.getOptimizationInfo().getTrivialInitializerInfo()) instanceof DexEncodedMethod.TrivialInitializer.TrivialInstanceInitializer)) {
            return null;
        }
        return singleTarget.getOptimizationInfo().getClassInlinerEligibility() != null ? new Inliner.InliningInfo(singleTarget, this.eligibleClass) : null;
    }

    private static boolean isEligibleInvokeWithAllUsersAsReceivers(DexEncodedMethod.ClassInlinerEligibility eligibility, InvokeMethodWithReceiver invoke, Set<Instruction> indirectUsers) {
        if (!eligibility.returnsReceiver || invoke.outValue() == null || invoke.outValue().numberOfAllUsers() == 0) {
            return true;
        }
        if (invoke.outValue().numberOfPhiUsers() > 0) {
            return false;
        }
        for (Instruction instruction : invoke.outValue().uniqueUsers()) {
            if (!instruction.isInvokeMethodWithReceiver()) {
                return false;
            }
            InvokeMethodWithReceiver user = instruction.asInvokeMethodWithReceiver();
            if (user.getReceiver() != invoke.outValue()) {
                return false;
            }
            int uses = 0;
            for (Value value : user.inValues()) {
                if (value != invoke.outValue() || ++uses <= 1) continue;
                return false;
            }
        }
        indirectUsers.addAll(invoke.outValue().uniqueUsers());
        return true;
    }

    private Inliner.InliningInfo isEligibleDirectVirtualMethodCall(InvokeMethodWithReceiver invoke, DexEncodedMethod singleTarget, Set<Instruction> indirectUsers) {
        assert (this.isEligibleSingleTarget(singleTarget));
        if (invoke.inValues().lastIndexOf(this.eligibleInstance) > 0) {
            return null;
        }
        return this.isEligibleVirtualMethodCall(!invoke.getBlock().hasCatchHandlers(), invoke.getInvokedMethod(), singleTarget, eligibility -> InlineCandidateProcessor.isEligibleInvokeWithAllUsersAsReceivers(eligibility, invoke, indirectUsers));
    }

    private Inliner.InliningInfo isEligibleIndirectVirtualMethodCall(DexMethod callee) {
        DexEncodedMethod singleTarget = this.eligibleClassDefinition.lookupVirtualMethod(callee);
        if (this.isEligibleSingleTarget(singleTarget)) {
            return this.isEligibleVirtualMethodCall(false, callee, singleTarget, eligibility -> !eligibility.returnsReceiver);
        }
        return null;
    }

    private Inliner.InliningInfo isEligibleVirtualMethodCall(boolean allowMethodsWithoutNormalReturns, DexMethod callee, DexEncodedMethod singleTarget, Predicate<DexEncodedMethod.ClassInlinerEligibility> eligibilityAcceptanceCheck) {
        assert (this.isEligibleSingleTarget(singleTarget));
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(callee.holder, callee);
        if (resolutionResult.hasSingleTarget() && !resolutionResult.asSingleTarget().isVirtualMethod()) {
            return null;
        }
        if (!singleTarget.isVirtualMethod()) {
            return null;
        }
        if (this.method == singleTarget) {
            return null;
        }
        if (this.isDesugaredLambda) {
            this.markSizeForInlining(singleTarget);
            return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
        }
        OptimizationInfo optimizationInfo = singleTarget.getOptimizationInfo();
        DexEncodedMethod.ClassInlinerEligibility eligibility = optimizationInfo.getClassInlinerEligibility();
        if (eligibility == null) {
            return null;
        }
        if (!eligibilityAcceptanceCheck.test(eligibility)) {
            return null;
        }
        this.markSizeForInlining(singleTarget);
        return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
    }

    private boolean isExtraMethodCall(InvokeMethod invoke) {
        if (invoke.isInvokeDirect() && this.factory.isConstructor(invoke.getInvokedMethod())) {
            return false;
        }
        if (invoke.isInvokeMethodWithReceiver() && invoke.asInvokeMethodWithReceiver().getReceiver() == this.eligibleInstance) {
            return false;
        }
        if (invoke.isInvokeSuper()) {
            return false;
        }
        return !invoke.isInvokePolymorphic();
    }

    private boolean isExtraMethodCallEligible(InvokeMethod invoke, DexEncodedMethod singleTarget, Supplier<InliningOracle> defaultOracle) {
        assert (this.isExtraMethodCall(invoke));
        assert (this.isEligibleSingleTarget(singleTarget));
        ArrayList<Value> arguments = Lists.newArrayList(invoke.inValues());
        if (invoke.isInvokeMethodWithReceiver() && arguments.get(0) == this.eligibleInstance) {
            return false;
        }
        OptimizationInfo optimizationInfo = singleTarget.getOptimizationInfo();
        if (!this.isEligibleParameterUsages(invoke, arguments, singleTarget, defaultOracle)) {
            return false;
        }
        for (int argIndex = 0; argIndex < arguments.size(); ++argIndex) {
            Value argument = (Value)arguments.get(argIndex);
            if (argument != this.eligibleInstance || !optimizationInfo.getParameterUsages(argIndex).notUsed()) continue;
            this.unusedArguments.add(new Pair<InvokeMethod, Integer>(invoke, argIndex));
        }
        this.extraMethodCalls.put(invoke, new Inliner.InliningInfo(singleTarget, null));
        this.markSizeForInlining(singleTarget);
        return true;
    }

    private boolean isEligibleParameterUsages(InvokeMethod invoke, List<Value> arguments, DexEncodedMethod singleTarget, Supplier<InliningOracle> defaultOracle) {
        for (int argIndex = 0; argIndex < arguments.size(); ++argIndex) {
            OptimizationInfo optimizationInfo;
            ParameterUsagesInfo.ParameterUsage parameterUsage;
            Value argument = arguments.get(argIndex);
            if (argument != this.eligibleInstance || this.isEligibleParameterUsage(parameterUsage = (optimizationInfo = singleTarget.getOptimizationInfo()).getParameterUsages(argIndex), invoke, defaultOracle)) continue;
            return false;
        }
        return true;
    }

    private boolean isEligibleParameterUsage(ParameterUsagesInfo.ParameterUsage parameterUsage, InvokeMethod invoke, Supplier<InliningOracle> defaultOracle) {
        if (parameterUsage == null) {
            return false;
        }
        if (parameterUsage.notUsed()) {
            return true;
        }
        if (parameterUsage.isAssignedToField) {
            return false;
        }
        if (parameterUsage.isReturned && invoke.outValue() != null && invoke.outValue().numberOfAllUsers() != 0) {
            return false;
        }
        if (!Sets.difference(parameterUsage.ifZeroTest, ALLOWED_ZERO_TEST_TYPES).isEmpty()) {
            return false;
        }
        for (Pair<Invoke.Type, DexMethod> call : parameterUsage.callsReceiver) {
            Inliner.InlineAction inlineAction;
            Invoke.Type type = call.getFirst();
            DexMethod target = call.getSecond();
            if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
                Inliner.InliningInfo potentialInliningInfo = this.isEligibleIndirectVirtualMethodCall(target);
                if (potentialInliningInfo == null) {
                    return false;
                }
            } else if (type == Invoke.Type.DIRECT) {
                if (!this.isTrivialInitializer(target)) {
                    return false;
                }
            } else {
                return false;
            }
            if ((inlineAction = invoke.computeInlining(defaultOracle.get(), this.method.method.holder)) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isTrivialInitializer(DexMethod method) {
        if (method == this.appInfo.dexItemFactory.objectMethods.constructor) {
            return true;
        }
        DexEncodedMethod encodedMethod = this.appInfo.definitionFor(method);
        return encodedMethod != null && encodedMethod.getOptimizationInfo().getTrivialInitializerInfo() != null;
    }

    private boolean exemptFromInstructionLimit(DexEncodedMethod inlinee) {
        DexType inlineeHolder = inlinee.method.holder;
        if (this.isDesugaredLambda && inlineeHolder == this.eligibleClass) {
            return true;
        }
        if (this.appInfo.isPinned(inlineeHolder)) {
            return false;
        }
        DexClass inlineeClass = this.appInfo.definitionFor(inlineeHolder);
        assert (inlineeClass != null);
        KotlinInfo kotlinInfo = inlineeClass.getKotlinInfo();
        return kotlinInfo != null && kotlinInfo.isSyntheticClass() && kotlinInfo.asSyntheticClass().isLambda();
    }

    private void markSizeForInlining(DexEncodedMethod inlinee) {
        if (!this.exemptFromInstructionLimit(inlinee)) {
            this.estimatedCombinedSizeForInlining += inlinee.getCode().estimatedSizeForInlining();
        }
    }

    private DexEncodedMethod findSingleTarget(InvokeMethod invoke) {
        if (this.isExtraMethodCall(invoke)) {
            DexType invocationContext = this.method.method.holder;
            return invoke.lookupSingleTarget(this.appInfo, invocationContext);
        }
        return invoke.isInvokeDirect() ? this.eligibleClassDefinition.lookupDirectMethod(invoke.getInvokedMethod()) : this.eligibleClassDefinition.lookupVirtualMethod(invoke.getInvokedMethod());
    }

    private boolean isEligibleSingleTarget(DexEncodedMethod singleTarget) {
        if (singleTarget == null) {
            return false;
        }
        if (this.isProcessedConcurrently.test(singleTarget)) {
            return false;
        }
        if (this.isDesugaredLambda && !singleTarget.accessFlags.isBridge()) {
            return true;
        }
        return singleTarget.isInliningCandidate(this.method, Inliner.Reason.SIMPLE, (AppInfoWithSubtyping)this.appInfo);
    }

    private void removeInstruction(Instruction instruction) {
        instruction.inValues().forEach(v -> v.removeUser(instruction));
        instruction.getBlock().removeInstruction(instruction);
    }
}

