/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.HashBasedTable;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Table;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class NamingState<ProtoType extends CachedHashValueDexItem, KeyType> {
    private final NamingState<ProtoType, KeyType> parent;
    private final Map<KeyType, InternalState> usedNames = new HashMap<KeyType, InternalState>();
    private final DexItemFactory itemFactory;
    private final List<String> dictionary;
    private final Function<ProtoType, KeyType> keyTransform;
    private final boolean useUniqueMemberNames;

    static <S, T extends CachedHashValueDexItem> NamingState<T, S> createRoot(DexItemFactory itemFactory, List<String> dictionary, Function<T, S> keyTransform, boolean useUniqueMemberNames) {
        return new NamingState<T, S>(null, itemFactory, dictionary, keyTransform, useUniqueMemberNames);
    }

    private NamingState(NamingState<ProtoType, KeyType> parent, DexItemFactory itemFactory, List<String> dictionary, Function<ProtoType, KeyType> keyTransform, boolean useUniqueMemberNames) {
        this.parent = parent;
        this.itemFactory = itemFactory;
        this.dictionary = dictionary;
        this.keyTransform = keyTransform;
        this.useUniqueMemberNames = useUniqueMemberNames;
    }

    public NamingState<ProtoType, KeyType> createChild() {
        return new NamingState<ProtoType, KeyType>(this, this.itemFactory, this.dictionary, this.keyTransform, this.useUniqueMemberNames);
    }

    private InternalState findInternalStateFor(KeyType key) {
        InternalState result = this.usedNames.get(key);
        if (result == null && this.parent != null) {
            result = super.findInternalStateFor(key);
        }
        return result;
    }

    private InternalState getOrCreateInternalStateFor(KeyType key) {
        InternalState result = this.usedNames.get(key);
        if (result == null) {
            if (this.parent != null) {
                InternalState parentState = super.getOrCreateInternalStateFor(key);
                result = parentState.createChild();
            } else {
                result = new InternalState(this.itemFactory, null, this.dictionary);
            }
            this.usedNames.put(key, result);
        }
        return result;
    }

    private DexString getAssignedNameFor(DexString name, KeyType key) {
        InternalState state = this.findInternalStateFor(key);
        if (state == null) {
            return null;
        }
        return state.getAssignedNameFor(name, key);
    }

    public DexString assignNewNameFor(DexString original, ProtoType proto, boolean markAsUsed) {
        KeyType key = this.keyTransform.apply(proto);
        DexString result = this.getAssignedNameFor(original, key);
        if (result == null) {
            InternalState state = this.getOrCreateInternalStateFor(key);
            result = state.getNameFor(original, key, markAsUsed);
        }
        return result;
    }

    public void reserveName(DexString name, ProtoType proto) {
        KeyType key = this.keyTransform.apply(proto);
        InternalState state = this.getOrCreateInternalStateFor(key);
        state.reserveName(name);
    }

    public boolean isReserved(DexString name, ProtoType proto) {
        KeyType key = this.keyTransform.apply(proto);
        InternalState state = this.findInternalStateFor(key);
        if (state == null) {
            return false;
        }
        return state.isReserved(name);
    }

    public boolean isAvailable(DexString original, ProtoType proto, DexString candidate) {
        KeyType key = this.keyTransform.apply(proto);
        InternalState state = this.findInternalStateFor(key);
        if (state == null) {
            return true;
        }
        assert (!this.useUniqueMemberNames || NamingState.isNullOrEqualTo(state.getAssignedNameFor(original, key), candidate));
        return state.isAvailable(candidate);
    }

    private static <T> boolean isNullOrEqualTo(T a, T b) {
        return a == null || a == b;
    }

    public void addRenaming(DexString original, ProtoType proto, DexString newName) {
        KeyType key = this.keyTransform.apply(proto);
        InternalState state = this.getOrCreateInternalStateFor(key);
        state.addRenaming(original, key, newName);
    }

    private class InternalState {
        private static final int INITIAL_NAME_COUNT = 1;
        private final char[] EMPTY_CHAR_ARRAY = new char[0];
        protected final DexItemFactory itemFactory;
        private final InternalState parentInternalState;
        private Set<DexString> reservedNames = null;
        private Table<DexString, KeyType, DexString> renamings = null;
        private int nameCount;
        private final Iterator<String> dictionaryIterator;

        private InternalState(DexItemFactory itemFactory, InternalState parentInternalState, Iterator<String> dictionaryIterator) {
            this.itemFactory = itemFactory;
            this.parentInternalState = parentInternalState;
            this.nameCount = parentInternalState == null ? 1 : parentInternalState.nameCount;
            this.dictionaryIterator = dictionaryIterator;
        }

        private InternalState(DexItemFactory itemFactory, InternalState parentInternalState, List<String> dictionary) {
            this(itemFactory, parentInternalState, dictionary.iterator());
        }

        private boolean isReserved(DexString name) {
            return this.reservedNames != null && this.reservedNames.contains(name) || this.parentInternalState != null && this.parentInternalState.isReserved(name);
        }

        private boolean isAvailable(DexString name) {
            return !(this.renamings != null && this.renamings.containsValue(name) || this.reservedNames != null && this.reservedNames.contains(name) || this.parentInternalState != null && !this.parentInternalState.isAvailable(name));
        }

        InternalState createChild() {
            return new InternalState(this.itemFactory, this, this.dictionaryIterator);
        }

        void reserveName(DexString name) {
            if (this.reservedNames == null) {
                this.reservedNames = Sets.newIdentityHashSet();
            }
            this.reservedNames.add(name);
        }

        DexString getAssignedNameFor(DexString original, KeyType proto) {
            DexString result = null;
            if (this.renamings != null) {
                if (NamingState.this.useUniqueMemberNames) {
                    Map row = this.renamings.row(original);
                    if (row != null) {
                        HashSet<DexString> renamedNames = Sets.newHashSet(row.values());
                        assert (renamedNames.size() <= 1);
                        result = Iterables.getOnlyElement(renamedNames, null);
                    }
                } else {
                    result = this.renamings.get(original, proto);
                }
            }
            if (result == null && this.parentInternalState != null) {
                result = this.parentInternalState.getAssignedNameFor(original, proto);
            }
            return result;
        }

        DexString getNameFor(DexString original, KeyType proto, boolean markAsUsed) {
            DexString name = this.getAssignedNameFor(original, proto);
            if (name != null) {
                return name;
            }
            while (!this.isAvailable(name = this.itemFactory.createString(this.nextSuggestedName()))) {
            }
            if (markAsUsed) {
                this.addRenaming(original, proto, name);
            }
            return name;
        }

        void addRenaming(DexString original, KeyType proto, DexString newName) {
            if (this.renamings == null) {
                this.renamings = HashBasedTable.create();
            }
            this.renamings.put(original, proto, newName);
        }

        String nextSuggestedName() {
            if (this.dictionaryIterator.hasNext()) {
                return this.dictionaryIterator.next();
            }
            return StringUtils.numberToIdentifier(this.EMPTY_CHAR_ARRAY, this.nameCount++, false);
        }
    }
}

