/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.Keep;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.references.TypeReference;

@Keep
public abstract class PrimitiveReference
implements TypeReference {
    static final PrimitiveReference BOOL = new PrimitiveReference(){

        @Override
        public String getDescriptor() {
            return "Z";
        }
    };
    static final PrimitiveReference BYTE = new PrimitiveReference(){

        @Override
        public String getDescriptor() {
            return "B";
        }
    };
    static final PrimitiveReference CHAR = new PrimitiveReference(){

        @Override
        public String getDescriptor() {
            return "C";
        }
    };
    static final PrimitiveReference SHORT = new PrimitiveReference(){

        @Override
        public String getDescriptor() {
            return "S";
        }
    };
    static final PrimitiveReference INT = new PrimitiveReference(){

        @Override
        public String getDescriptor() {
            return "I";
        }
    };
    static final PrimitiveReference FLOAT = new PrimitiveReference(){

        @Override
        public String getDescriptor() {
            return "F";
        }
    };
    static final PrimitiveReference LONG = new PrimitiveReference(){

        @Override
        public String getDescriptor() {
            return "J";
        }
    };
    static final PrimitiveReference DOUBLE = new PrimitiveReference(){

        @Override
        public String getDescriptor() {
            return "D";
        }
    };

    private PrimitiveReference() {
    }

    static PrimitiveReference fromDescriptor(String descriptor) {
        assert (descriptor.length() == 1);
        switch (descriptor.charAt(0)) {
            case 'Z': {
                return BOOL;
            }
            case 'B': {
                return BYTE;
            }
            case 'C': {
                return CHAR;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
        }
        throw new Unreachable("Invalid primitive descriptor: " + descriptor);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public abstract String getDescriptor();

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }
}

