/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.DexMethod;

public class MethodSignatureEquivalence
extends Equivalence<DexMethod> {
    private static final MethodSignatureEquivalence INSTANCE = new MethodSignatureEquivalence(false);
    private static final MethodSignatureEquivalence INSTANCE_IGNORE_NAME = new MethodSignatureEquivalence(true);
    private final boolean ignoreName;

    private MethodSignatureEquivalence(boolean ignoreName) {
        this.ignoreName = ignoreName;
    }

    public static MethodSignatureEquivalence get() {
        return INSTANCE;
    }

    public static MethodSignatureEquivalence getEquivalenceIgnoreName() {
        return INSTANCE_IGNORE_NAME;
    }

    @Override
    protected boolean doEquivalent(DexMethod a, DexMethod b) {
        if (this.ignoreName) {
            return a.proto.equals(b.proto);
        }
        return a.name.equals(b.name) && a.proto.equals(b.proto);
    }

    @Override
    protected int doHash(DexMethod method) {
        if (this.ignoreName) {
            return method.proto.hashCode();
        }
        return method.name.hashCode() * 31 + method.proto.hashCode();
    }
}

