/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.utils.InternalOptions;

public class MoveException
extends Instruction {
    private final DexType exceptionType;
    private final InternalOptions options;

    public MoveException(Value dest, DexType exceptionType, InternalOptions options) {
        super(dest);
        this.exceptionType = exceptionType;
        this.options = options;
        dest.markNeverNull();
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.MoveException(dest));
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "MoveException has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isMoveException()) {
            return false;
        }
        if (this.options.canHaveExceptionTypeBug()) {
            return other.asMoveException().exceptionType == this.exceptionType;
        }
        return true;
    }

    @Override
    public boolean isMoveException() {
        return true;
    }

    @Override
    public MoveException asMoveException() {
        return this;
    }

    @Override
    public boolean canBeDeadCode(AppInfo appInfo, IRCode code) {
        return !code.options.debug && !code.method.getOptimizationInfo().isReachabilitySensitive() && code.options.isGeneratingDex();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forMoveException();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.exceptionType;
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(this.exceptionType, false, appInfo);
    }

    public DexType getExceptionType() {
        return this.exceptionType;
    }
}

