/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.jetbrains.kotlinx.metadata.InconsistentKotlinMetadataException;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.kotlin.KotlinClass;
import com.android.tools.r8.kotlin.KotlinClassFacade;
import com.android.tools.r8.kotlin.KotlinClassPart;
import com.android.tools.r8.kotlin.KotlinFile;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.kotlin.KotlinSyntheticClass;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.IdentityHashMap;

final class KotlinClassMetadataReader {
    KotlinClassMetadataReader() {
    }

    static KotlinInfo getKotlinInfo(Kotlin kotlin, DexClass clazz, DiagnosticsHandler reporter) {
        if (clazz.annotations.isEmpty()) {
            return null;
        }
        DexAnnotation meta = clazz.annotations.getFirstMatching(kotlin.metadata.kotlinMetadataType);
        if (meta != null) {
            try {
                return KotlinClassMetadataReader.createKotlinInfo(kotlin, clazz, meta);
            }
            catch (InconsistentKotlinMetadataException | MetadataError | ClassCastException e) {
                reporter.info(new StringDiagnostic("Class " + clazz.type.toSourceString() + " has malformed kotlin.Metadata: " + e.getMessage()));
            }
            catch (Throwable e) {
                reporter.info(new StringDiagnostic("Unexpected error while reading " + clazz.type.toSourceString() + "'s kotlin.Metadata: " + e.getMessage()));
            }
        }
        return null;
    }

    private static KotlinInfo createKotlinInfo(Kotlin kotlin, DexClass clazz, DexAnnotation meta) {
        DexAnnotationElement extraInt;
        Integer xi;
        DexAnnotationElement packageName;
        String pn;
        DexAnnotationElement extraString;
        String xs;
        DexAnnotationElement data2;
        String[] d2;
        DexAnnotationElement data1;
        String[] d1;
        DexAnnotationElement bytecodeVersion;
        int[] bv;
        DexAnnotationElement metadataVersion;
        int[] mv;
        IdentityHashMap<DexString, DexAnnotationElement> elementMap = new IdentityHashMap<DexString, DexAnnotationElement>();
        for (DexAnnotationElement element : meta.annotation.elements) {
            elementMap.put(element.name, element);
        }
        DexAnnotationElement kind = (DexAnnotationElement)elementMap.get(kotlin.metadata.kind);
        if (kind == null) {
            throw new MetadataError("element 'k' is missing.");
        }
        Integer k = (Integer)kind.value.getBoxedValue();
        KotlinClassHeader header = new KotlinClassHeader(k, mv = (metadataVersion = (DexAnnotationElement)elementMap.get(kotlin.metadata.metadataVersion)) == null ? null : KotlinClassMetadataReader.getUnboxedIntArray(metadataVersion.value, "mv"), bv = (bytecodeVersion = (DexAnnotationElement)elementMap.get(kotlin.metadata.bytecodeVersion)) == null ? null : KotlinClassMetadataReader.getUnboxedIntArray(bytecodeVersion.value, "bv"), d1 = (data1 = (DexAnnotationElement)elementMap.get(kotlin.metadata.data1)) == null ? null : KotlinClassMetadataReader.getUnboxedStringArray(data1.value, "d1"), d2 = (data2 = (DexAnnotationElement)elementMap.get(kotlin.metadata.data2)) == null ? null : KotlinClassMetadataReader.getUnboxedStringArray(data2.value, "d2"), xs = (extraString = (DexAnnotationElement)elementMap.get(kotlin.metadata.extraString)) == null ? null : KotlinClassMetadataReader.getUnboxedString(extraString.value, "xs"), pn = (packageName = (DexAnnotationElement)elementMap.get(kotlin.metadata.packageName)) == null ? null : KotlinClassMetadataReader.getUnboxedString(packageName.value, "pn"), xi = (extraInt = (DexAnnotationElement)elementMap.get(kotlin.metadata.extraInt)) == null ? null : (Integer)extraInt.value.getBoxedValue());
        KotlinClassMetadata kMetadata = KotlinClassMetadata.read(header);
        if (kMetadata instanceof KotlinClassMetadata.Class) {
            return KotlinClass.fromKotlinClassMetadata(kMetadata, clazz);
        }
        if (kMetadata instanceof KotlinClassMetadata.FileFacade) {
            return KotlinFile.fromKotlinClassMetadata(kMetadata);
        }
        if (kMetadata instanceof KotlinClassMetadata.MultiFileClassFacade) {
            return KotlinClassFacade.fromKotlinClassMetadata(kMetadata);
        }
        if (kMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
            return KotlinClassPart.fromKotlinClassMetdata(kMetadata);
        }
        if (kMetadata instanceof KotlinClassMetadata.SyntheticClass) {
            return KotlinSyntheticClass.fromKotlinClassMetadata(kMetadata, kotlin, clazz);
        }
        throw new MetadataError("unsupported 'k' value: " + k);
    }

    private static int[] getUnboxedIntArray(DexValue v, String elementName) {
        if (!(v instanceof DexValue.DexValueArray)) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        DexValue.DexValueArray intArrayValue = (DexValue.DexValueArray)v;
        DexValue[] values2 = intArrayValue.getValues();
        int[] result = new int[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            result[i] = (Integer)values2[i].getBoxedValue();
        }
        return result;
    }

    private static String[] getUnboxedStringArray(DexValue v, String elementName) {
        if (!(v instanceof DexValue.DexValueArray)) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        DexValue.DexValueArray stringArrayValue = (DexValue.DexValueArray)v;
        DexValue[] values2 = stringArrayValue.getValues();
        String[] result = new String[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            result[i] = KotlinClassMetadataReader.getUnboxedString(values2[i], elementName + "[" + i + "]");
        }
        return result;
    }

    private static String getUnboxedString(DexValue v, String elementName) {
        if (!(v instanceof DexValue.DexValueString)) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        return ((DexString)((DexValue.DexValueString)v).getValue()).toString();
    }

    private static class MetadataError
    extends RuntimeException {
        MetadataError(String cause) {
            super(cause);
        }
    }
}

