/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugEventBuilder;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexDebugPositionState;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class LineNumberOptimizer {
    public static ClassNameMapper run(DexApplication application, GraphLense graphLense, NamingLens namingLens, boolean identityMapping) {
        ClassNameMapper.Builder classNameMapperBuilder = ClassNameMapper.builder();
        for (DexProgramClass clazz : application.classes()) {
            IdentityHashMap<DexString, List<DexEncodedMethod>> methodsByRenamedName = LineNumberOptimizer.groupMethodsByRenamedName(namingLens, clazz);
            DexType originalType = graphLense.getOriginalType(clazz.type);
            DexString renamedClassName = namingLens.lookupDescriptor(clazz.getType());
            com.android.tools.r8.com.google.common.base.Supplier<ClassNaming.Builder> onDemandClassNamingBuilder = Suppliers.memoize(() -> classNameMapperBuilder.classNamingBuilder(DescriptorUtils.descriptorToJavaType(renamedClassName.toString()), originalType.toSourceString()));
            LineNumberOptimizer.addClassToClassNaming(originalType, renamedClassName, onDemandClassNamingBuilder);
            LineNumberOptimizer.addFieldsToClassNaming(graphLense, namingLens, clazz, onDemandClassNamingBuilder);
            ArrayList<DexString> renamedMethodNames = new ArrayList<DexString>(methodsByRenamedName.keySet());
            renamedMethodNames.sort(DexString::slowCompareTo);
            for (DexString methodName : renamedMethodNames) {
                List<DexEncodedMethod> methods = methodsByRenamedName.get(methodName);
                if (methods.size() > 1) {
                    LineNumberOptimizer.sortMethods(methods);
                }
                PositionRemapper positionRemapper = identityMapping ? new IdentityPositionRemapper() : new OptimizingPositionRemapper();
                for (DexEncodedMethod method : methods) {
                    ArrayList<MappedPosition> mappedPositions = new ArrayList<MappedPosition>();
                    Code code = method.getCode();
                    if (code != null) {
                        if (code.isDexCode() && LineNumberOptimizer.doesContainPositions(code.asDexCode())) {
                            LineNumberOptimizer.optimizeDexCodePositions(method, application, positionRemapper, mappedPositions, identityMapping);
                        } else if (code.isCfCode() && LineNumberOptimizer.doesContainPositions(code.asCfCode())) {
                            LineNumberOptimizer.optimizeCfCodePositions(method, positionRemapper, mappedPositions);
                        }
                    }
                    DexMethod originalMethod = graphLense.getOriginalMethodSignature(method.method);
                    MemberNaming.MethodSignature originalSignature = MemberNaming.MethodSignature.fromDexMethod(originalMethod, originalMethod.holder != clazz.type);
                    DexString obfuscatedNameDexString = namingLens.lookupName(method.method);
                    String obfuscatedName = obfuscatedNameDexString.toString();
                    if (mappedPositions.isEmpty()) {
                        if (obfuscatedNameDexString == originalMethod.name && originalMethod.holder == clazz.type) continue;
                        ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMappedRange(null, originalSignature, null, obfuscatedName);
                        continue;
                    }
                    IdentityHashMap<DexMethod, MemberNaming.MethodSignature> signatures = new IdentityHashMap<DexMethod, MemberNaming.MethodSignature>();
                    signatures.put(originalMethod, originalSignature);
                    Function<DexMethod, MemberNaming.MethodSignature> getOriginalMethodSignature = m -> {
                        DexMethod original = graphLense.getOriginalMethodSignature((DexMethod)m);
                        return signatures.computeIfAbsent(original, key -> MemberNaming.MethodSignature.fromDexMethod(original, original.holder != clazz.getType()));
                    };
                    MemberNaming memberNaming = new MemberNaming(originalSignature, obfuscatedName);
                    ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
                    int i = 0;
                    while (i < mappedPositions.size()) {
                        MappedPosition mp;
                        int j;
                        MappedPosition firstPosition = (MappedPosition)mappedPositions.get(i);
                        MappedPosition lastPosition = firstPosition;
                        for (j = i + 1; j < mappedPositions.size() && (mp = (MappedPosition)mappedPositions.get(j)).method == lastPosition.method && mp.originalLine - lastPosition.originalLine == mp.obfuscatedLine - lastPosition.obfuscatedLine && Objects.equals(mp.caller, lastPosition.caller); ++j) {
                            lastPosition = mp;
                        }
                        Range obfuscatedRange = new Range(firstPosition.obfuscatedLine, lastPosition.obfuscatedLine);
                        Range originalRange = new Range(firstPosition.originalLine, lastPosition.originalLine);
                        ClassNaming.Builder classNamingBuilder = (ClassNaming.Builder)onDemandClassNamingBuilder.get();
                        classNamingBuilder.addMappedRange(obfuscatedRange, getOriginalMethodSignature.apply(firstPosition.method), originalRange, obfuscatedName);
                        Position caller = firstPosition.caller;
                        while (caller != null) {
                            classNamingBuilder.addMappedRange(obfuscatedRange, getOriginalMethodSignature.apply(caller.method), Math.max(caller.line, 0), obfuscatedName);
                            caller = caller.callerPosition;
                        }
                        i = j;
                    }
                }
            }
        }
        return classNameMapperBuilder.build();
    }

    private static int getMethodStartLine(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null) {
            return 0;
        }
        if (code.isDexCode()) {
            DexDebugInfo dexDebugInfo = code.asDexCode().getDebugInfo();
            return dexDebugInfo == null ? 0 : dexDebugInfo.startLine;
        }
        if (code.isCfCode()) {
            List<CfInstruction> instructions = code.asCfCode().getInstructions();
            for (CfInstruction instruction : instructions) {
                if (!(instruction instanceof CfPosition)) continue;
                return ((CfPosition)instruction).getPosition().line;
            }
        }
        return 0;
    }

    private static void sortMethods(List<DexEncodedMethod> methods) {
        methods.sort((lhs, rhs) -> {
            int rhsStartLine;
            int lhsStartLine = LineNumberOptimizer.getMethodStartLine(lhs);
            int startLineDiff = lhsStartLine - (rhsStartLine = LineNumberOptimizer.getMethodStartLine(rhs));
            if (startLineDiff != 0) {
                return startLineDiff;
            }
            return DexEncodedMethod.slowCompare(lhs, rhs);
        });
    }

    private static void addClassToClassNaming(DexType originalType, DexString renamedClassName, Supplier<ClassNaming.Builder> onDemandClassNamingBuilder) {
        if (originalType.descriptor != renamedClassName) {
            onDemandClassNamingBuilder.get();
        }
    }

    private static void addFieldsToClassNaming(GraphLense graphLense, NamingLens namingLens, DexProgramClass clazz, Supplier<ClassNaming.Builder> onDemandClassNamingBuilder) {
        clazz.forEachField(dexEncodedField -> {
            DexField dexField = dexEncodedField.field;
            DexField originalField = graphLense.getOriginalFieldSignature(dexField);
            DexString renamedName = namingLens.lookupName(dexField);
            if (renamedName != originalField.name || originalField.clazz != clazz.type) {
                MemberNaming.FieldSignature originalSignature = MemberNaming.FieldSignature.fromDexField(originalField, originalField.clazz != clazz.type);
                MemberNaming memberNaming = new MemberNaming(originalSignature, renamedName.toString());
                ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
            }
        });
    }

    private static IdentityHashMap<DexString, List<DexEncodedMethod>> groupMethodsByRenamedName(NamingLens namingLens, DexProgramClass clazz) {
        IdentityHashMap<DexString, List<DexEncodedMethod>> methodsByRenamedName = new IdentityHashMap<DexString, List<DexEncodedMethod>>(clazz.directMethods().length + clazz.virtualMethods().length);
        for (DexEncodedMethod method : clazz.methods()) {
            DexString renamedName = namingLens.lookupName(method.method);
            if (renamedName == method.method.name && !LineNumberOptimizer.doesContainPositions(method)) continue;
            methodsByRenamedName.computeIfAbsent(renamedName, key -> new ArrayList()).add(method);
        }
        return methodsByRenamedName;
    }

    private static boolean doesContainPositions(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null) {
            return false;
        }
        if (code.isDexCode()) {
            return LineNumberOptimizer.doesContainPositions(code.asDexCode());
        }
        if (code.isCfCode()) {
            return LineNumberOptimizer.doesContainPositions(code.asCfCode());
        }
        return false;
    }

    private static boolean doesContainPositions(DexCode dexCode) {
        DexDebugInfo debugInfo = dexCode.getDebugInfo();
        if (debugInfo == null) {
            return false;
        }
        for (DexDebugEvent event : debugInfo.events) {
            if (!(event instanceof DexDebugEvent.Default)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesContainPositions(CfCode cfCode) {
        List<CfInstruction> instructions = cfCode.getInstructions();
        for (CfInstruction instruction : instructions) {
            if (!(instruction instanceof CfPosition)) continue;
            return true;
        }
        return false;
    }

    private static void optimizeDexCodePositions(DexEncodedMethod method, DexApplication application, final PositionRemapper positionRemapper, final List<MappedPosition> mappedPositions, boolean identityMapping) {
        DexCode dexCode = method.getCode().asDexCode();
        DexDebugInfo debugInfo = dexCode.getDebugInfo();
        final ArrayList processedEvents = new ArrayList();
        final PositionEventEmitter positionEventEmitter = new PositionEventEmitter(application.dexItemFactory, method.method, processedEvents);
        DexDebugPositionState visitor = new DexDebugPositionState(debugInfo.startLine, method.method){
            private int emittedPc;
            {
                super(startLine, method);
                this.emittedPc = 0;
            }

            private void flushPc() {
                if (this.emittedPc != this.getCurrentPc()) {
                    positionEventEmitter.emitAdvancePc(this.getCurrentPc());
                    this.emittedPc = this.getCurrentPc();
                }
            }

            @Override
            public void visit(DexDebugEvent.Default defaultEvent) {
                super.visit(defaultEvent);
                assert (this.getCurrentLine() >= 0);
                Position position = positionRemapper.createRemappedPosition(this.getCurrentLine(), this.getCurrentFile(), this.getCurrentMethod(), this.getCurrentCallerPosition());
                mappedPositions.add(new MappedPosition(this.getCurrentMethod(), this.getCurrentLine(), this.getCurrentCallerPosition(), position.line));
                positionEventEmitter.emitPositionEvents(this.getCurrentPc(), position);
                this.emittedPc = this.getCurrentPc();
            }

            @Override
            public void visit(DexDebugEvent.SetFile setFile) {
                processedEvents.add(setFile);
            }

            @Override
            public void visit(DexDebugEvent.SetPrologueEnd setPrologueEnd) {
                processedEvents.add(setPrologueEnd);
            }

            @Override
            public void visit(DexDebugEvent.SetEpilogueBegin setEpilogueBegin) {
                processedEvents.add(setEpilogueBegin);
            }

            @Override
            public void visit(DexDebugEvent.StartLocal startLocal) {
                this.flushPc();
                processedEvents.add(startLocal);
            }

            @Override
            public void visit(DexDebugEvent.EndLocal endLocal) {
                this.flushPc();
                processedEvents.add(endLocal);
            }

            @Override
            public void visit(DexDebugEvent.RestartLocal restartLocal) {
                this.flushPc();
                processedEvents.add(restartLocal);
            }
        };
        for (DexDebugEvent event : debugInfo.events) {
            event.accept(visitor);
        }
        DexDebugInfo optimizedDebugInfo = new DexDebugInfo(positionEventEmitter.getStartLine(), debugInfo.parameters, processedEvents.toArray(new DexDebugEvent[processedEvents.size()]));
        if (identityMapping) {
            assert (optimizedDebugInfo.startLine == debugInfo.startLine);
            assert (optimizedDebugInfo.events.length == debugInfo.events.length);
            for (int i = 0; i < debugInfo.events.length; ++i) {
                assert (optimizedDebugInfo.events[i].equals(debugInfo.events[i]));
            }
        }
        dexCode.setDebugInfo(optimizedDebugInfo);
    }

    private static void optimizeCfCodePositions(DexEncodedMethod method, PositionRemapper positionRemapper, List<MappedPosition> mappedPositions) {
        CfCode oldCode = method.getCode().asCfCode();
        List<CfInstruction> oldInstructions = oldCode.getInstructions();
        ArrayList<CfInstruction> newInstructions = new ArrayList<CfInstruction>(oldInstructions.size());
        for (int i = 0; i < oldInstructions.size(); ++i) {
            CfInstruction newInstruction;
            CfInstruction oldInstruction = oldInstructions.get(i);
            if (oldInstruction instanceof CfPosition) {
                CfPosition cfPosition = (CfPosition)oldInstruction;
                Position oldPosition = cfPosition.getPosition();
                Position newPosition = positionRemapper.createRemappedPosition(oldPosition.line, oldPosition.file, oldPosition.method, oldPosition.callerPosition);
                mappedPositions.add(new MappedPosition(oldPosition.method, oldPosition.line, oldPosition.callerPosition, newPosition.line));
                newInstruction = new CfPosition(cfPosition.getLabel(), newPosition);
            } else {
                newInstruction = oldInstruction;
            }
            newInstructions.add(newInstruction);
        }
        method.setCode(new CfCode(oldCode.getMethod(), oldCode.getMaxStack(), oldCode.getMaxLocals(), newInstructions, oldCode.getTryCatchRanges(), oldCode.getLocalVariables()));
    }

    private static class MappedPosition {
        private final DexMethod method;
        private final int originalLine;
        private final Position caller;
        private final int obfuscatedLine;

        private MappedPosition(DexMethod method, int originalLine, Position caller, int obfuscatedLine) {
            this.method = method;
            this.originalLine = originalLine;
            this.caller = caller;
            this.obfuscatedLine = obfuscatedLine;
        }
    }

    private static class PositionEventEmitter {
        private final DexItemFactory dexItemFactory;
        private int startLine = -1;
        private final DexMethod method;
        private int previousPc = 0;
        private Position previousPosition = null;
        private final List<DexDebugEvent> processedEvents;

        private PositionEventEmitter(DexItemFactory dexItemFactory, DexMethod method, List<DexDebugEvent> processedEvents) {
            this.dexItemFactory = dexItemFactory;
            this.method = method;
            this.processedEvents = processedEvents;
        }

        private void emitAdvancePc(int pc) {
            this.processedEvents.add(new DexDebugEvent.AdvancePC(pc - this.previousPc));
            this.previousPc = pc;
        }

        private void emitPositionEvents(int currentPc, Position currentPosition) {
            if (this.previousPosition == null) {
                this.startLine = currentPosition.line;
                this.previousPosition = new Position(this.startLine, null, this.method, null);
            }
            DexDebugEventBuilder.emitAdvancementEvents(this.previousPc, this.previousPosition, currentPc, currentPosition, this.processedEvents, this.dexItemFactory);
            this.previousPc = currentPc;
            this.previousPosition = currentPosition;
        }

        private int getStartLine() {
            assert (this.startLine >= 0);
            return this.startLine;
        }
    }

    private static class OptimizingPositionRemapper
    implements PositionRemapper {
        private int nextLineNumber = 1;

        private OptimizingPositionRemapper() {
        }

        @Override
        public Position createRemappedPosition(int line, DexString file, DexMethod method, Position callerPosition) {
            Position newPosition = new Position(this.nextLineNumber, file, method, null);
            ++this.nextLineNumber;
            return newPosition;
        }
    }

    private static class IdentityPositionRemapper
    implements PositionRemapper {
        private IdentityPositionRemapper() {
        }

        @Override
        public Position createRemappedPosition(int line, DexString file, DexMethod method, Position callerPosition) {
            return new Position(line, file, method, callerPosition);
        }
    }

    private static interface PositionRemapper {
        public Position createRemappedPosition(int var1, DexString var2, DexMethod var3, Position var4);
    }
}

